/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.downsampling.changing;

import java.time.LocalDate;
import java.util.Objects;
import org.apache.iotdb.db.pipe.processor.downsampling.changing.ChangingValueSamplingProcessor;
import org.apache.iotdb.pipe.api.type.Binary;

public class ChangingValueFilter<T> {
    private final ChangingValueSamplingProcessor processor;
    private long lastStoredTimestamp;
    private T lastStoredValue;

    public ChangingValueFilter(ChangingValueSamplingProcessor processor, long firstTimestamp, T firstValue) {
        this.processor = processor;
        this.init(firstTimestamp, firstValue);
    }

    private void init(long firstTimestamp, T firstValue) {
        this.lastStoredTimestamp = firstTimestamp;
        this.lastStoredValue = firstValue;
    }

    public boolean filter(long timestamp, T value) {
        try {
            return this.tryFilter(timestamp, value);
        }
        catch (Exception e) {
            this.init(timestamp, value);
            return true;
        }
    }

    private boolean tryFilter(long timestamp, T value) {
        long timeDiff = Math.abs(timestamp - this.lastStoredTimestamp);
        if (timeDiff <= this.processor.getCompressionMinTimeInterval()) {
            return false;
        }
        if (timeDiff >= this.processor.getCompressionMaxTimeInterval()) {
            this.reset(timestamp, value);
            return true;
        }
        if (value instanceof Boolean || value instanceof String || value instanceof Binary || value instanceof LocalDate) {
            if (Objects.equals(this.lastStoredValue, value)) {
                return false;
            }
            this.reset(timestamp, value);
            return true;
        }
        if (Math.abs(Double.parseDouble(this.lastStoredValue.toString()) - Double.parseDouble(value.toString())) > this.processor.getCompressionDeviation()) {
            this.reset(timestamp, value);
            return true;
        }
        return false;
    }

    private void reset(long timestamp, T value) {
        this.lastStoredTimestamp = timestamp;
        this.lastStoredValue = value;
    }
}

