/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.pipeconsensus;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.container.PipeConsensusClientMgrContainer;
import org.apache.iotdb.commons.client.sync.SyncPipeConsensusServiceClient;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.connector.payload.pipeconsensus.response.PipeConsensusTransferFilePieceResp;
import org.apache.iotdb.commons.pipe.connector.protocol.IoTDBConnector;
import org.apache.iotdb.consensus.pipe.thrift.TCommitId;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusBatchTransferReq;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusBatchTransferResp;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferReq;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferResp;
import org.apache.iotdb.db.pipe.connector.protocol.pipeconsensus.payload.builder.PipeConsensusSyncBatchReqBuilder;
import org.apache.iotdb.db.pipe.connector.protocol.pipeconsensus.payload.request.PipeConsensusDeleteNodeReq;
import org.apache.iotdb.db.pipe.connector.protocol.pipeconsensus.payload.request.PipeConsensusTabletBinaryReq;
import org.apache.iotdb.db.pipe.connector.protocol.pipeconsensus.payload.request.PipeConsensusTabletInsertNodeReq;
import org.apache.iotdb.db.pipe.connector.protocol.pipeconsensus.payload.request.PipeConsensusTsFilePieceReq;
import org.apache.iotdb.db.pipe.connector.protocol.pipeconsensus.payload.request.PipeConsensusTsFilePieceWithModReq;
import org.apache.iotdb.db.pipe.connector.protocol.pipeconsensus.payload.request.PipeConsensusTsFileSealReq;
import org.apache.iotdb.db.pipe.connector.protocol.pipeconsensus.payload.request.PipeConsensusTsFileSealWithModReq;
import org.apache.iotdb.db.pipe.consensus.metric.PipeConsensusConnectorMetrics;
import org.apache.iotdb.db.pipe.event.common.deletion.PipeDeleteDataNodeEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.pipe.api.annotation.TableModel;
import org.apache.iotdb.pipe.api.annotation.TreeModel;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TreeModel
@TableModel
public class PipeConsensusSyncConnector
extends IoTDBConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConsensusSyncConnector.class);
    private static final String PIPE_CONSENSUS_SYNC_CONNECTION_FAILED_FORMAT = "PipeConsensus: syncClient connection to %s:%s failed when %s, because: %s";
    private static final String TABLET_INSERTION_NODE_SCENARIO = "transfer insertionNode tablet";
    private static final String TSFILE_SCENARIO = "transfer tsfile";
    private static final String TABLET_BATCH_SCENARIO = "transfer tablet batch";
    private static final String DELETION_SCENARIO = "transfer deletion";
    private final IClientManager<TEndPoint, SyncPipeConsensusServiceClient> syncRetryClientManager;
    private final List<TEndPoint> peers;
    private final int thisDataNodeId;
    private final int consensusGroupId;
    private final PipeConsensusConnectorMetrics pipeConsensusConnectorMetrics;
    private PipeConsensusSyncBatchReqBuilder tabletBatchBuilder;

    public PipeConsensusSyncConnector(List<TEndPoint> peers, int consensusGroupId, int thisDataNodeId, PipeConsensusConnectorMetrics pipeConsensusConnectorMetrics) {
        this.peers = peers;
        this.consensusGroupId = consensusGroupId;
        this.thisDataNodeId = thisDataNodeId;
        this.syncRetryClientManager = PipeConsensusClientMgrContainer.getInstance().newSyncClientManager();
        this.pipeConsensusConnectorMetrics = pipeConsensusConnectorMetrics;
    }

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        super.customize(parameters, configuration);
        if (this.isTabletBatchModeEnabled) {
            this.tabletBatchBuilder = new PipeConsensusSyncBatchReqBuilder(parameters, new TConsensusGroupId(TConsensusGroupType.DataRegion, this.consensusGroupId), this.thisDataNodeId);
        }
        this.isTabletBatchModeEnabled = false;
    }

    public void handshake() throws Exception {
    }

    public void heartbeat() throws Exception {
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        try {
            if (this.isTabletBatchModeEnabled) {
                if (this.tabletBatchBuilder.onEvent(tabletInsertionEvent)) {
                    this.doTransfer();
                }
            } else {
                long startTime = System.nanoTime();
                this.doTransferWrapper((PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent);
                long duration = System.nanoTime() - startTime;
                this.pipeConsensusConnectorMetrics.recordRetryWALTransferTimer(duration);
            }
        }
        catch (Exception e) {
            throw new PipeConnectionException(String.format("Failed to transfer tablet insertion event %s, because %s.", tabletInsertionEvent, e.getMessage()), (Throwable)e);
        }
    }

    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        try {
            long startTime = System.nanoTime();
            if (this.isTabletBatchModeEnabled && !this.tabletBatchBuilder.isEmpty()) {
                this.doTransfer();
            }
            this.doTransfer((PipeTsFileInsertionEvent)tsFileInsertionEvent);
            long duration = System.nanoTime() - startTime;
            this.pipeConsensusConnectorMetrics.recordRetryTsFileTransferTimer(duration);
        }
        catch (Exception e) {
            throw new PipeConnectionException(String.format("Failed to transfer tsfile insertion event %s, because %s.", tsFileInsertionEvent, e.getMessage()), (Throwable)e);
        }
    }

    public void transfer(Event event) throws Exception {
        if (this.isTabletBatchModeEnabled && !this.tabletBatchBuilder.isEmpty()) {
            this.doTransfer();
        }
        this.doTransferWrapper((PipeDeleteDataNodeEvent)event);
    }

    private void doTransfer() {
        try (SyncPipeConsensusServiceClient syncPipeConsensusServiceClient = (SyncPipeConsensusServiceClient)this.syncRetryClientManager.borrowClient((Object)this.getFollowerUrl());){
            TPipeConsensusBatchTransferResp resp = syncPipeConsensusServiceClient.pipeConsensusBatchTransfer((TPipeConsensusBatchTransferReq)this.tabletBatchBuilder.toTPipeConsensusBatchTransferReq());
            List statusList = resp.getBatchResps().stream().map(TPipeConsensusTransferResp::getStatus).collect(Collectors.toList());
            this.tabletBatchBuilder.onSuccess();
        }
        catch (Exception e) {
            throw new PipeConnectionException(String.format(PIPE_CONSENSUS_SYNC_CONNECTION_FAILED_FORMAT, this.getFollowerUrl().getIp(), this.getFollowerUrl().getPort(), TABLET_BATCH_SCENARIO, e.getMessage()), (Throwable)e);
        }
    }

    private void doTransferWrapper(PipeDeleteDataNodeEvent pipeDeleteDataNodeEvent) throws PipeException {
        if (!pipeDeleteDataNodeEvent.increaseReferenceCount(PipeConsensusSyncConnector.class.getName())) {
            return;
        }
        try {
            this.doTransfer(pipeDeleteDataNodeEvent);
        }
        finally {
            pipeDeleteDataNodeEvent.decreaseReferenceCount(PipeConsensusSyncConnector.class.getName(), false);
        }
    }

    private void doTransfer(PipeDeleteDataNodeEvent pipeDeleteDataNodeEvent) throws PipeException {
        TPipeConsensusTransferResp resp;
        TCommitId tCommitId = new TCommitId(pipeDeleteDataNodeEvent.getReplicateIndexForIoTV2(), pipeDeleteDataNodeEvent.getRebootTimes());
        TConsensusGroupId tConsensusGroupId = new TConsensusGroupId(TConsensusGroupType.DataRegion, this.consensusGroupId);
        try (SyncPipeConsensusServiceClient syncPipeConsensusServiceClient = (SyncPipeConsensusServiceClient)this.syncRetryClientManager.borrowClient((Object)this.getFollowerUrl());){
            ProgressIndex progressIndex = pipeDeleteDataNodeEvent.getProgressIndex();
            resp = syncPipeConsensusServiceClient.pipeConsensusTransfer((TPipeConsensusTransferReq)PipeConsensusDeleteNodeReq.toTPipeConsensusTransferReq(pipeDeleteDataNodeEvent.getDeleteDataNode(), tCommitId, tConsensusGroupId, progressIndex, this.thisDataNodeId));
        }
        catch (Exception e) {
            throw new PipeConnectionException(String.format(PIPE_CONSENSUS_SYNC_CONNECTION_FAILED_FORMAT, this.getFollowerUrl().getIp(), this.getFollowerUrl().getPort(), DELETION_SCENARIO, e.getMessage()), (Throwable)e);
        }
        TSStatus status = resp.getStatus();
        if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && resp.getStatus().getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            this.receiverStatusHandler.handle(status, String.format("PipeConsensus transfer DeletionEvent %s error, result status %s.", pipeDeleteDataNodeEvent.getDeletionResource(), status), pipeDeleteDataNodeEvent.getDeleteDataNode().toString());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully transferred deletion event {}.", (Object)pipeDeleteDataNodeEvent.getDeletionResource());
        }
    }

    private void doTransferWrapper(PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent) throws PipeException {
        if (!pipeInsertNodeTabletInsertionEvent.increaseReferenceCount(PipeConsensusSyncConnector.class.getName())) {
            return;
        }
        try {
            this.doTransfer(pipeInsertNodeTabletInsertionEvent);
        }
        finally {
            pipeInsertNodeTabletInsertionEvent.decreaseReferenceCount(PipeConsensusSyncConnector.class.getName(), false);
        }
    }

    private void doTransfer(PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent) throws PipeException {
        TPipeConsensusTransferResp resp;
        TCommitId tCommitId = new TCommitId(pipeInsertNodeTabletInsertionEvent.getReplicateIndexForIoTV2(), pipeInsertNodeTabletInsertionEvent.getRebootTimes());
        TConsensusGroupId tConsensusGroupId = new TConsensusGroupId(TConsensusGroupType.DataRegion, this.consensusGroupId);
        try (SyncPipeConsensusServiceClient syncPipeConsensusServiceClient = (SyncPipeConsensusServiceClient)this.syncRetryClientManager.borrowClient((Object)this.getFollowerUrl());){
            InsertNode insertNode = pipeInsertNodeTabletInsertionEvent.getInsertNodeViaCacheIfPossible();
            ProgressIndex progressIndex = pipeInsertNodeTabletInsertionEvent.getProgressIndex();
            resp = insertNode != null ? syncPipeConsensusServiceClient.pipeConsensusTransfer((TPipeConsensusTransferReq)PipeConsensusTabletInsertNodeReq.toTPipeConsensusTransferReq(insertNode, tCommitId, tConsensusGroupId, progressIndex, this.thisDataNodeId)) : syncPipeConsensusServiceClient.pipeConsensusTransfer((TPipeConsensusTransferReq)PipeConsensusTabletBinaryReq.toTPipeConsensusTransferReq(pipeInsertNodeTabletInsertionEvent.getByteBuffer(), tCommitId, tConsensusGroupId, progressIndex, this.thisDataNodeId));
        }
        catch (Exception e) {
            throw new PipeConnectionException(String.format(PIPE_CONSENSUS_SYNC_CONNECTION_FAILED_FORMAT, this.getFollowerUrl().getIp(), this.getFollowerUrl().getPort(), TABLET_INSERTION_NODE_SCENARIO, e.getMessage()), (Throwable)e);
        }
        TSStatus status = resp.getStatus();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            this.receiverStatusHandler.handle(status, String.format("PipeConsensus transfer PipeInsertNodeTabletInsertionEvent %s error, result status %s", pipeInsertNodeTabletInsertionEvent, status), pipeInsertNodeTabletInsertionEvent.toString());
        }
    }

    private void doTransfer(PipeTsFileInsertionEvent pipeTsFileInsertionEvent) throws PipeException {
        TPipeConsensusTransferResp resp;
        File tsFile = pipeTsFileInsertionEvent.getTsFile();
        File modFile = pipeTsFileInsertionEvent.getModFile();
        try (SyncPipeConsensusServiceClient syncPipeConsensusServiceClient = (SyncPipeConsensusServiceClient)this.syncRetryClientManager.borrowClient((Object)this.getFollowerUrl());){
            TCommitId tCommitId = new TCommitId(pipeTsFileInsertionEvent.getReplicateIndexForIoTV2(), pipeTsFileInsertionEvent.getRebootTimes());
            TConsensusGroupId tConsensusGroupId = new TConsensusGroupId(TConsensusGroupType.DataRegion, this.consensusGroupId);
            if (pipeTsFileInsertionEvent.isWithMod()) {
                this.transferFilePieces(modFile, syncPipeConsensusServiceClient, true, tCommitId, tConsensusGroupId);
                this.transferFilePieces(tsFile, syncPipeConsensusServiceClient, true, tCommitId, tConsensusGroupId);
                resp = syncPipeConsensusServiceClient.pipeConsensusTransfer((TPipeConsensusTransferReq)PipeConsensusTsFileSealWithModReq.toTPipeConsensusTransferReq(modFile.getName(), modFile.length(), tsFile.getName(), tsFile.length(), pipeTsFileInsertionEvent.getFlushPointCount(), tCommitId, tConsensusGroupId, pipeTsFileInsertionEvent.getProgressIndex(), this.thisDataNodeId));
            } else {
                this.transferFilePieces(tsFile, syncPipeConsensusServiceClient, false, tCommitId, tConsensusGroupId);
                resp = syncPipeConsensusServiceClient.pipeConsensusTransfer((TPipeConsensusTransferReq)PipeConsensusTsFileSealReq.toTPipeConsensusTransferReq(tsFile.getName(), tsFile.length(), pipeTsFileInsertionEvent.getFlushPointCount(), tCommitId, tConsensusGroupId, pipeTsFileInsertionEvent.getProgressIndex(), this.thisDataNodeId));
            }
        }
        catch (Exception e) {
            throw new PipeConnectionException(String.format(PIPE_CONSENSUS_SYNC_CONNECTION_FAILED_FORMAT, this.getFollowerUrl().getIp(), this.getFollowerUrl().getPort(), TSFILE_SCENARIO, e.getMessage()), (Throwable)e);
        }
        TSStatus status = resp.getStatus();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            this.receiverStatusHandler.handle(resp.getStatus(), String.format("Seal file %s error, result status %s.", tsFile, resp.getStatus()), tsFile.getName());
        }
        LOGGER.info("Successfully transferred file {}.", (Object)tsFile);
    }

    protected void transferFilePieces(File file, SyncPipeConsensusServiceClient syncPipeConsensusServiceClient, boolean isMultiFile, TCommitId tCommitId, TConsensusGroupId tConsensusGroupId) throws PipeException, IOException {
        int readFileBufferSize = PipeConfig.getInstance().getPipeConnectorReadFileBufferSize();
        byte[] readBuffer = new byte[readFileBufferSize];
        long position = 0L;
        try (RandomAccessFile reader = new RandomAccessFile(file, "r");){
            int readLength;
            while ((readLength = reader.read(readBuffer)) != -1) {
                PipeConsensusTransferFilePieceResp resp;
                byte[] payLoad = readLength == readFileBufferSize ? readBuffer : Arrays.copyOfRange(readBuffer, 0, readLength);
                try {
                    resp = PipeConsensusTransferFilePieceResp.fromTPipeConsensusTransferResp((TPipeConsensusTransferResp)syncPipeConsensusServiceClient.pipeConsensusTransfer((TPipeConsensusTransferReq)(isMultiFile ? PipeConsensusTsFilePieceWithModReq.toTPipeConsensusTransferReq(file.getName(), position, payLoad, tCommitId, tConsensusGroupId, this.thisDataNodeId) : PipeConsensusTsFilePieceReq.toTPipeConsensusTransferReq(file.getName(), position, payLoad, tCommitId, tConsensusGroupId, this.thisDataNodeId))));
                }
                catch (Exception e) {
                    throw new PipeConnectionException(String.format("Network error when transfer file %s, because %s.", file, e.getMessage()), (Throwable)e);
                }
                position += (long)readLength;
                TSStatus status = resp.getStatus();
                if (status.getCode() == TSStatusCode.PIPE_CONSENSUS_TRANSFER_FILE_OFFSET_RESET.getStatusCode()) {
                    position = resp.getEndWritingOffset();
                    reader.seek(position);
                    LOGGER.info("Redirect file position to {}.", (Object)position);
                    continue;
                }
                if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || status.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) continue;
                this.receiverStatusHandler.handle(resp.getStatus(), String.format("Transfer file %s error, result status %s.", file, resp.getStatus()), file.getName());
            }
        }
    }

    private TEndPoint getFollowerUrl() {
        return this.peers.get(0);
    }

    public synchronized void close() {
        super.close();
        if (this.syncRetryClientManager != null) {
            this.syncRetryClientManager.close();
        }
        if (this.tabletBatchBuilder != null) {
            this.tabletBatchBuilder.close();
        }
    }
}

