/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.scheduler.Expirable;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttVersion;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;

public interface ISessionsRepository {
    public Collection<SessionData> list();

    public void saveSession(SessionData var1);

    public void delete(SessionData var1);

    public void listSessionsWill(BiConsumer<String, Will> var1);

    public void saveWill(String var1, Will var2);

    public void deleteWill(String var1);

    public static final class Will
    implements Expirable {
        public final String topic;
        public final byte[] payload;
        public final MqttQoS qos;
        public final boolean retained;
        public final int delayInterval;
        public final WillOptions properties;
        private Instant expireAt = null;

        public Will(String topic, byte[] payload, MqttQoS qos, boolean retained, int delayInterval) {
            this.topic = topic;
            this.payload = payload;
            this.qos = qos;
            this.retained = retained;
            this.delayInterval = delayInterval;
            this.properties = WillOptions.empty();
        }

        public Will(Will orig, Instant expireAt) {
            this(orig.topic, orig.payload, orig.qos, orig.retained, orig.delayInterval, orig.properties);
            this.expireAt = expireAt;
        }

        public Will(Will orig, WillOptions properties) {
            this.topic = orig.topic;
            this.payload = orig.payload;
            this.qos = orig.qos;
            this.retained = orig.retained;
            this.delayInterval = orig.delayInterval;
            this.expireAt = orig.expireAt;
            this.properties = properties;
        }

        private Will(String topic, byte[] payload, MqttQoS qos, boolean retained, int delayInterval, WillOptions properties) {
            this.topic = topic;
            this.payload = payload;
            this.qos = qos;
            this.retained = retained;
            this.delayInterval = delayInterval;
            this.properties = properties;
        }

        @Override
        public Optional<Instant> expireAt() {
            return Optional.ofNullable(this.expireAt);
        }

        public Will withExpirationComputed(int executionInterval, Clock clock) {
            return new Will(this, clock.instant().plusSeconds(executionInterval));
        }
    }

    public static final class WillOptions {
        private final Duration messageExpiry;
        private final String contentType;
        private final String responseTopic;
        private final byte[] correlationData;
        private final Map<String, String> userProperties;
        private final boolean empty;

        private WillOptions(Duration messageExpiry, String contentType, String responseTopic, byte[] correlationData, Map<String, String> userProperties, boolean empty) {
            this.messageExpiry = messageExpiry;
            this.contentType = contentType;
            this.responseTopic = responseTopic;
            this.correlationData = correlationData;
            this.userProperties = userProperties;
            this.empty = empty;
        }

        public static WillOptions empty() {
            return new WillOptions(null, null, null, null, null, true);
        }

        public WillOptions withMessageExpiry(Duration interval) {
            Objects.requireNonNull(interval, "A valid interval duration must be provided");
            return new WillOptions(interval, this.contentType, this.responseTopic, this.correlationData, this.userProperties, true);
        }

        public WillOptions withContentType(String contentType) {
            Objects.requireNonNull(contentType, "A valid contentType string must be provided");
            return new WillOptions(this.messageExpiry, contentType, this.responseTopic, this.correlationData, this.userProperties, true);
        }

        public WillOptions withResponseTopic(String responseTopic) {
            Objects.requireNonNull(responseTopic, "A valid responseTopic string must be provided");
            return new WillOptions(this.messageExpiry, this.contentType, responseTopic, this.correlationData, this.userProperties, true);
        }

        public WillOptions withCorrelationData(byte[] correlationData) {
            Objects.requireNonNull(correlationData, "A valid correlationData string must be provided");
            return new WillOptions(this.messageExpiry, this.contentType, this.responseTopic, correlationData, this.userProperties, true);
        }

        public WillOptions withUserProperties(Map<String, String> properties) {
            Objects.requireNonNull(properties, "A valid properties Map must be provided");
            return new WillOptions(this.messageExpiry, this.contentType, this.responseTopic, this.correlationData, properties, true);
        }

        public Optional<Duration> messageExpiry() {
            return Optional.ofNullable(this.messageExpiry);
        }

        public Optional<String> contentType() {
            return Optional.ofNullable(this.contentType);
        }

        public Optional<String> responseTopic() {
            return Optional.ofNullable(this.responseTopic);
        }

        public Optional<byte[]> correlationData() {
            return Optional.ofNullable(this.correlationData);
        }

        public Optional<Map<String, String>> userProperties() {
            return Optional.ofNullable(this.userProperties);
        }

        public boolean notEmpty() {
            return this.empty;
        }
    }

    public static final class SessionData
    implements Expirable {
        private final String clientId;
        private Instant expireAt = null;
        final MqttVersion version;
        final Optional<Will> will;
        private final int expiryInterval;
        private final transient Clock clock;

        public SessionData(String clientId, MqttVersion version, int expiryInterval, Clock clock) {
            this.clientId = clientId;
            this.clock = clock;
            this.expiryInterval = expiryInterval;
            this.version = version;
            this.will = Optional.empty();
        }

        public SessionData(String clientId, MqttVersion version, Will will, int expiryInterval, Clock clock) {
            this.clientId = clientId;
            this.clock = clock;
            this.expiryInterval = expiryInterval;
            this.version = version;
            this.will = Optional.of(will);
        }

        public SessionData(String clientId, Instant expireAt, MqttVersion version, int expiryInterval, Clock clock) {
            Objects.requireNonNull(expireAt, "An expiration time is requested");
            this.clock = clock;
            this.clientId = clientId;
            this.expireAt = expireAt;
            this.expiryInterval = expiryInterval;
            this.version = version;
            this.will = Optional.empty();
        }

        public SessionData(String clientId, Instant expireAt, MqttVersion version, Will will, int expiryInterval, Clock clock) {
            Objects.requireNonNull(expireAt, "An expiration time is requested");
            this.clock = clock;
            this.clientId = clientId;
            this.expireAt = expireAt;
            this.expiryInterval = expiryInterval;
            this.version = version;
            this.will = Optional.of(will);
        }

        private SessionData(String clientId, Instant expireAt, MqttVersion version, Optional<Will> will, int expiryInterval, Clock clock) {
            Objects.requireNonNull(expireAt, "An expiration time is requested");
            this.clock = clock;
            this.clientId = clientId;
            this.expireAt = expireAt;
            this.expiryInterval = expiryInterval;
            this.version = version;
            this.will = will;
        }

        public String clientId() {
            return this.clientId;
        }

        public MqttVersion protocolVersion() {
            return this.version;
        }

        @Override
        public Optional<Instant> expireAt() {
            return Optional.ofNullable(this.expireAt);
        }

        public Optional<Long> expiryInstant() {
            return this.expireAt().map(Instant::toEpochMilli);
        }

        public int expiryInterval() {
            return this.expiryInterval;
        }

        public SessionData withExpirationComputed() {
            Instant expiresAt = this.clock.instant().plusSeconds(this.expiryInterval);
            if (this.hasWill()) {
                return new SessionData(this.clientId, expiresAt, this.version, this.will, this.expiryInterval, this.clock);
            }
            return new SessionData(this.clientId, expiresAt, this.version, this.expiryInterval, this.clock);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SessionData that = (SessionData)o;
            return this.clientId.equals(that.clientId);
        }

        public int hashCode() {
            return Objects.hash(this.clientId);
        }

        public String toString() {
            return "SessionData{clientId='" + this.clientId + '\'' + ", expireAt=" + this.expireAt + ", version=" + this.version + ", expiryInterval=" + this.expiryInterval + '}';
        }

        public boolean hasWill() {
            return this.will.isPresent();
        }

        public Will will() throws IllegalArgumentException {
            return this.will.orElseThrow(() -> new IllegalArgumentException("Session's will is not available"));
        }

        public SessionData withWill(Will will) {
            if (this.expireAt != null) {
                return new SessionData(this.clientId, this.expireAt, this.version, will, this.expiryInterval, this.clock);
            }
            return new SessionData(this.clientId, this.version, will, this.expiryInterval, this.clock);
        }

        public SessionData withoutWill() {
            if (this.expireAt != null) {
                return new SessionData(this.clientId, this.expireAt, this.version, this.expiryInterval, this.clock);
            }
            return new SessionData(this.clientId, this.version, this.expiryInterval, this.clock);
        }
    }
}

