/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.event;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.SerializableEvent;
import org.apache.iotdb.commons.pipe.resource.snapshot.PipeSnapshotResourceManager;

public abstract class PipeSnapshotEvent
extends EnrichedEvent
implements SerializableEvent {
    protected final PipeSnapshotResourceManager resourceManager;
    protected ProgressIndex progressIndex;
    protected Set<Short> transferredTypes;

    protected PipeSnapshotEvent(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, PipeSnapshotResourceManager resourceManager) {
        super(pipeName, creationTime, pipeTaskMeta, treePattern, tablePattern, Long.MIN_VALUE, Long.MAX_VALUE);
        this.resourceManager = resourceManager;
    }

    @Override
    public void bindProgressIndex(ProgressIndex progressIndex) {
        this.progressIndex = progressIndex;
    }

    @Override
    public ProgressIndex getProgressIndex() {
        return this.progressIndex;
    }

    @Override
    public boolean isGeneratedByPipe() {
        return false;
    }

    @Override
    public boolean mayEventTimeOverlappedWithTimeRange() {
        return true;
    }

    @Override
    public boolean mayEventPathsOverlappedWithPattern() {
        return true;
    }

    public String toSealTypeString() {
        return String.join((CharSequence)",", this.transferredTypes.stream().map(type -> Short.toString(type)).collect(Collectors.toSet()));
    }

    @Override
    public String toString() {
        return String.format("PipeSnapshotEvent{progressIndex=%s, transferredTypes=%s}", this.progressIndex, this.transferredTypes) + " - " + super.toString();
    }

    @Override
    public String coreReportMessage() {
        return String.format("PipeSnapshotEvent{progressIndex=%s, transferredTypes=%s}", this.progressIndex, this.transferredTypes) + " - " + super.coreReportMessage();
    }
}

