/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.binaryallocator.utils;

import org.apache.iotdb.commons.binaryallocator.config.AllocatorConfig;

public final class SizeClasses {
    private static final int INTEGER_SIZE_MINUS_ONE = 31;
    private final int[] sizeIdx2sizeTab;
    private final int log2MinSize;
    private final int log2SizeClassGroup;

    public SizeClasses(AllocatorConfig allocatorConfig) {
        this.log2SizeClassGroup = allocatorConfig.log2ClassSizeGroup;
        this.log2MinSize = SizeClasses.log2(allocatorConfig.minAllocateSize);
        int maxSize = allocatorConfig.maxAllocateSize;
        int sizeClassGroupCount = SizeClasses.log2(maxSize) - this.log2MinSize;
        this.sizeIdx2sizeTab = new int[(sizeClassGroupCount << this.log2SizeClassGroup) + 1];
        this.initializeSizeClasses(allocatorConfig.minAllocateSize, maxSize);
    }

    public int sizeIdx2size(int sizeIdx) {
        return this.sizeIdx2sizeTab[sizeIdx];
    }

    public int size2SizeIdx(int size) {
        int log2Size = SizeClasses.log2((size << 1) - 1);
        int shift = log2Size - this.log2MinSize - 1;
        int group = shift << this.log2SizeClassGroup;
        int log2Delta = log2Size - 1 - this.log2SizeClassGroup;
        int mod = size - 1 >> log2Delta & (1 << this.log2SizeClassGroup) - 1;
        return group + mod + 1;
    }

    public int getSizeClassNum() {
        return this.sizeIdx2sizeTab.length;
    }

    private static int calculateSize(int log2Group, int delta, int log2Delta) {
        return (1 << log2Group) + (delta << log2Delta);
    }

    private static int log2(int val) {
        return 31 - Integer.numberOfLeadingZeros(val);
    }

    private void initializeSizeClasses(int minSize, int maxSize) {
        int nDeltaLimit = 1 << this.log2SizeClassGroup;
        int log2Group = this.log2MinSize;
        int log2Delta = this.log2MinSize - this.log2SizeClassGroup;
        int sizeCount = 0;
        int size = SizeClasses.calculateSize(log2Group, 0, log2Delta);
        this.sizeIdx2sizeTab[sizeCount++] = size;
        while (size < maxSize) {
            for (int nDelta = 1; nDelta <= nDeltaLimit && size <= maxSize; ++nDelta) {
                size = SizeClasses.calculateSize(log2Group, nDelta, log2Delta);
                this.sizeIdx2sizeTab[sizeCount++] = size;
            }
            ++log2Group;
            ++log2Delta;
        }
    }
}

