/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.query.dataset;

import java.io.IOException;
import java.util.List;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.Field;
import org.apache.tsfile.read.common.RowRecord;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.query.dataset.AbstractResultSet;
import org.apache.tsfile.read.reader.IPointReader;
import org.apache.tsfile.read.reader.block.TsBlockReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableResultSet
extends AbstractResultSet {
    private static final Logger LOG = LoggerFactory.getLogger(TableResultSet.class);
    private TsBlockReader tsBlockReader;
    private IPointReader tsBlockPointReader;
    private List<String> columnNameList;
    private List<TSDataType> dataTypeList;

    public TableResultSet(TsBlockReader tsBlockReader, List<String> columnNameList, List<TSDataType> dataTypeList) {
        super(columnNameList, dataTypeList);
        this.tsBlockReader = tsBlockReader;
        this.columnNameList = columnNameList;
        this.dataTypeList = dataTypeList;
    }

    @Override
    public boolean next() throws IOException {
        while ((this.tsBlockPointReader == null || !this.tsBlockPointReader.hasNextTimeValuePair()) && this.tsBlockReader.hasNext()) {
            TsBlock currentTsBlock = this.tsBlockReader.next();
            this.tsBlockPointReader = currentTsBlock.getTsBlockAlignedRowIterator();
        }
        if (this.tsBlockPointReader == null || !this.tsBlockPointReader.hasNextTimeValuePair()) {
            return false;
        }
        TimeValuePair currentTimeValuePair = this.tsBlockPointReader.nextTimeValuePair();
        this.currentRow = this.convertTimeValuePairToRowRecord(currentTimeValuePair);
        return true;
    }

    private RowRecord convertTimeValuePairToRowRecord(TimeValuePair timeValuePair) {
        RowRecord rowRecord = new RowRecord(timeValuePair.getValues().length);
        rowRecord.setTimestamp(timeValuePair.getTimestamp());
        for (int i = 0; i < timeValuePair.getValues().length; ++i) {
            Object value = timeValuePair.getValues()[i];
            rowRecord.addField(Field.getField(value, this.dataTypeList.get(i)));
        }
        return rowRecord;
    }

    @Override
    public void close() {
        if (this.tsBlockReader == null) {
            return;
        }
        try {
            this.tsBlockReader.close();
        }
        catch (Exception e) {
            LOG.error("Failed to close tsBlockReader");
        }
    }
}

