/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.response;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.db.subscription.event.SubscriptionCommitContextSupplier;
import org.apache.iotdb.db.subscription.event.SubscriptionEvent;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeTabletEventBatch;
import org.apache.iotdb.db.subscription.event.cache.CachedSubscriptionPollResponse;
import org.apache.iotdb.db.subscription.event.response.SubscriptionEventExtendableResponse;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponseType;
import org.apache.iotdb.rpc.subscription.payload.poll.TabletsPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionEventTabletResponse
extends SubscriptionEventExtendableResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionEventTabletResponse.class);
    private static final long READ_TABLET_BUFFER_SIZE = SubscriptionConfig.getInstance().getSubscriptionReadTabletBufferSize();
    private static final long PREFETCH_TABLET_BUFFER_SIZE = SubscriptionConfig.getInstance().getSubscriptionPrefetchTabletBatchMaxSizeInBytes();
    private final SubscriptionPipeTabletEventBatch batch;
    private final SubscriptionCommitContext commitContext;
    private final SubscriptionCommitContextSupplier commitContextSupplier;
    private volatile int totalTablets;
    private final AtomicInteger nextOffset = new AtomicInteger(0);
    private volatile long totalBufferSize;
    private volatile boolean availableForNext = false;

    public SubscriptionEventTabletResponse(SubscriptionPipeTabletEventBatch batch, SubscriptionCommitContext commitContext, SubscriptionCommitContextSupplier commitContextSupplier) {
        this.batch = batch;
        this.commitContext = commitContext;
        this.commitContextSupplier = commitContextSupplier;
        this.init();
    }

    @Override
    public void prefetchRemainingResponses() {
    }

    @Override
    public void fetchNextResponse(long offset) {
        this.offer(this.generateNextTabletResponse());
        if (Objects.isNull((Object)this.poll())) {
            LOGGER.warn("SubscriptionEventTabletResponse {} is empty when fetching next response (broken invariant)", (Object)this);
        }
    }

    @Override
    public synchronized void ack(Consumer<SubscriptionEvent> onCommittedHook) {
        if (this.availableForNext) {
            onCommittedHook.accept(new SubscriptionEvent(this.batch, this.commitContextSupplier));
        }
    }

    @Override
    public synchronized void nack() {
        if (this.nextOffset.get() == 1) {
            return;
        }
        this.cleanUp();
        this.batch.resetIterator();
        this.init();
    }

    @Override
    public synchronized void cleanUp() {
        super.cleanUp();
        this.totalTablets = 0;
        this.nextOffset.set(0);
        this.totalBufferSize = 0L;
        this.availableForNext = false;
    }

    @Override
    public boolean isCommittable() {
        return (this.availableForNext || this.hasNoMore) && this.size() == 1;
    }

    private void init() {
        if (!this.isEmpty()) {
            LOGGER.warn("SubscriptionEventTabletResponse {} is not empty when initializing (broken invariant)", (Object)this);
            return;
        }
        this.offer(this.generateNextTabletResponse());
    }

    private synchronized CachedSubscriptionPollResponse generateNextTabletResponse() {
        CachedSubscriptionPollResponse response;
        if (this.availableForNext) {
            return new CachedSubscriptionPollResponse(SubscriptionPollResponseType.TABLETS.getType(), (SubscriptionPollPayload)new TabletsPayload(Collections.emptyList(), -this.totalTablets), this.commitContext);
        }
        ArrayList currentTablets = new ArrayList();
        long currentBufferSize = 0L;
        while (this.batch.hasNext()) {
            Object tablets = this.batch.next();
            if (Objects.isNull(tablets)) continue;
            currentTablets.addAll(tablets);
            long bufferSize = tablets.stream().map(PipeMemoryWeightUtil::calculateTabletSizeInBytes).reduce(Long::sum).orElse(0L);
            this.totalTablets += tablets.size();
            this.totalBufferSize += bufferSize;
            if (bufferSize > READ_TABLET_BUFFER_SIZE) {
                LOGGER.warn("Detect large tablets with {} byte(s).", (Object)bufferSize);
                return new CachedSubscriptionPollResponse(SubscriptionPollResponseType.TABLETS.getType(), (SubscriptionPollPayload)new TabletsPayload(new ArrayList(currentTablets), this.nextOffset.incrementAndGet()), this.commitContext);
            }
            if (currentBufferSize + bufferSize > READ_TABLET_BUFFER_SIZE) {
                return new CachedSubscriptionPollResponse(SubscriptionPollResponseType.TABLETS.getType(), (SubscriptionPollPayload)new TabletsPayload(new ArrayList(currentTablets), this.nextOffset.incrementAndGet()), this.commitContext);
            }
            currentBufferSize += bufferSize;
            if (this.totalBufferSize <= PREFETCH_TABLET_BUFFER_SIZE || !this.batch.hasNext()) continue;
            this.availableForNext = true;
            break;
        }
        if (currentTablets.isEmpty()) {
            response = new CachedSubscriptionPollResponse(SubscriptionPollResponseType.TABLETS.getType(), (SubscriptionPollPayload)new TabletsPayload(Collections.emptyList(), -this.totalTablets), this.commitContext);
            this.hasNoMore = true;
        } else {
            response = new CachedSubscriptionPollResponse(SubscriptionPollResponseType.TABLETS.getType(), (SubscriptionPollPayload)new TabletsPayload(new ArrayList(currentTablets), this.nextOffset.incrementAndGet()), this.commitContext);
        }
        return response;
    }
}

