/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.response;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.iotdb.db.subscription.event.cache.CachedSubscriptionPollResponse;
import org.apache.iotdb.db.subscription.event.cache.SubscriptionPollResponseCache;
import org.apache.iotdb.db.subscription.event.response.SubscriptionEventResponse;

public abstract class SubscriptionEventExtendableResponse
implements SubscriptionEventResponse<CachedSubscriptionPollResponse> {
    private final Deque<CachedSubscriptionPollResponse> responses = new ConcurrentLinkedDeque<CachedSubscriptionPollResponse>();
    protected volatile boolean hasNoMore = false;

    protected SubscriptionEventExtendableResponse() {
    }

    @Override
    public CachedSubscriptionPollResponse getCurrentResponse() {
        return this.peekFirst();
    }

    @Override
    public void trySerializeCurrentResponse() {
        SubscriptionPollResponseCache.getInstance().trySerialize(this.getCurrentResponse());
    }

    @Override
    public void trySerializeRemainingResponses() {
        this.responses.stream().skip(1L).filter(response -> Objects.isNull(response.getByteBuffer())).findFirst().ifPresent(response -> SubscriptionPollResponseCache.getInstance().trySerialize((CachedSubscriptionPollResponse)((Object)response)));
    }

    @Override
    public ByteBuffer getCurrentResponseByteBuffer() throws IOException {
        return SubscriptionPollResponseCache.getInstance().serialize(this.getCurrentResponse());
    }

    @Override
    public void invalidateCurrentResponseByteBuffer() {
        SubscriptionPollResponseCache.getInstance().invalidate(this.getCurrentResponse());
    }

    @Override
    public void cleanUp() {
        CachedSubscriptionPollResponse response;
        while (Objects.nonNull((Object)(response = this.poll()))) {
            SubscriptionPollResponseCache.getInstance().invalidate(response);
        }
        this.hasNoMore = false;
    }

    @Override
    public boolean isCommittable() {
        return this.hasNoMore && this.size() == 1;
    }

    protected void offer(CachedSubscriptionPollResponse response) {
        this.responses.addLast(response);
    }

    protected CachedSubscriptionPollResponse poll() {
        return this.responses.isEmpty() ? null : this.responses.removeFirst();
    }

    protected CachedSubscriptionPollResponse peekFirst() {
        return this.responses.isEmpty() ? null : this.responses.getFirst();
    }

    protected CachedSubscriptionPollResponse peekLast() {
        return this.responses.isEmpty() ? null : this.responses.getLast();
    }

    protected int size() {
        return this.responses.size();
    }

    protected boolean isEmpty() {
        return this.responses.isEmpty();
    }

    public String toString() {
        return "SubscriptionEventExtendableResponse" + this.coreReportMessage();
    }

    protected Map<String, String> coreReportMessage() {
        HashMap<String, String> result = new HashMap<String, String>();
        CachedSubscriptionPollResponse currentResponse = this.getCurrentResponse();
        result.put("currentResponse", Objects.nonNull((Object)currentResponse) ? currentResponse.toString() : "<unknown>");
        result.put("hasNoMore", String.valueOf(this.hasNoMore));
        return result;
    }
}

