/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.batch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingQueue;
import org.apache.iotdb.db.subscription.event.SubscriptionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SubscriptionPipeEventBatch {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPipeEventBatch.class);
    private final int regionId;
    protected final SubscriptionPrefetchingQueue prefetchingQueue;
    protected final int maxDelayInMs;
    protected final long maxBatchSizeInBytes;
    protected volatile List<SubscriptionEvent> events = null;
    protected final List<EnrichedEvent> enrichedEvents = new ArrayList<EnrichedEvent>();

    protected SubscriptionPipeEventBatch(int regionId, SubscriptionPrefetchingQueue prefetchingQueue, int maxDelayInMs, long maxBatchSizeInBytes) {
        this.regionId = regionId;
        this.prefetchingQueue = prefetchingQueue;
        this.maxDelayInMs = maxDelayInMs;
        this.maxBatchSizeInBytes = maxBatchSizeInBytes;
    }

    public abstract void ack();

    public abstract void cleanUp();

    protected synchronized boolean onEvent(Consumer<SubscriptionEvent> consumer) throws Exception {
        if (this.shouldEmit() && !this.enrichedEvents.isEmpty()) {
            if (Objects.isNull(this.events)) {
                this.events = this.generateSubscriptionEvents();
            }
            if (Objects.nonNull(this.events)) {
                this.events.forEach(consumer);
                return true;
            }
            return false;
        }
        return false;
    }

    protected synchronized boolean onEvent(@NonNull EnrichedEvent event, Consumer<SubscriptionEvent> consumer) throws Exception {
        if (event instanceof TabletInsertionEvent) {
            this.onTabletInsertionEvent((TabletInsertionEvent)event);
            this.enrichedEvents.add(event);
        } else if (event instanceof TsFileInsertionEvent) {
            this.onTsFileInsertionEvent((TsFileInsertionEvent)event);
            this.enrichedEvents.add(event);
        } else {
            LOGGER.warn("SubscriptionPipeEventBatch {} ignore EnrichedEvent {} when batching.", (Object)this, (Object)event);
        }
        return this.onEvent(consumer);
    }

    protected abstract void onTabletInsertionEvent(TabletInsertionEvent var1);

    protected abstract void onTsFileInsertionEvent(TsFileInsertionEvent var1);

    protected abstract boolean shouldEmit();

    protected abstract List<SubscriptionEvent> generateSubscriptionEvents() throws Exception;

    protected Map<String, String> coreReportMessage() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("regionId", String.valueOf(this.regionId));
        result.put("prefetchingQueue", this.prefetchingQueue.coreReportMessage().toString());
        result.put("maxDelayInMs", String.valueOf(this.maxDelayInMs));
        result.put("maxBatchSizeInBytes", String.valueOf(this.maxBatchSizeInBytes));
        result.put("enrichedEvents", SubscriptionPipeEventBatch.formatEnrichedEvents(this.enrichedEvents, 4));
        return result;
    }

    private static String formatEnrichedEvents(List<EnrichedEvent> enrichedEvents, int threshold) {
        List eventMessageList = enrichedEvents.stream().limit(threshold).map(EnrichedEvent::coreReportMessage).collect(Collectors.toList());
        if (eventMessageList.size() > threshold) {
            eventMessageList.add(String.format("omit the remaining %s event(s)...", eventMessageList.size() - threshold));
        }
        return eventMessageList.toString();
    }

    public int getPipeEventCount() {
        return this.enrichedEvents.size();
    }
}

