/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.converter;

import java.io.File;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBTreePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletRawReq;
import org.apache.iotdb.db.pipe.event.common.tsfile.parser.scan.TsFileInsertionEventScanParser;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.storageengine.load.converter.LoadConvertedInsertTabletStatement;
import org.apache.iotdb.db.storageengine.load.converter.LoadTsFileDataTypeConverter;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTreeStatementDataTypeConvertExecutionVisitor
extends StatementVisitor<Optional<TSStatus>, Void> {
    private final StatementExecutor statementExecutor;
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTreeStatementDataTypeConvertExecutionVisitor.class);

    public LoadTreeStatementDataTypeConvertExecutionVisitor(StatementExecutor statementExecutor) {
        this.statementExecutor = statementExecutor;
    }

    @Override
    public Optional<TSStatus> visitNode(StatementNode statementNode, Void v) {
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<TSStatus> visitLoadFile(LoadTsFileStatement loadTsFileStatement, Void v) {
        LOGGER.info("Start data type conversion for LoadTsFileStatement: {}", (Object)loadTsFileStatement);
        for (File file : loadTsFileStatement.getTsFiles()) {
            try (TsFileInsertionEventScanParser parser = new TsFileInsertionEventScanParser(file, (TreePattern)new IoTDBTreePattern(null), Long.MIN_VALUE, Long.MAX_VALUE, null, null);){
                for (Pair<Tablet, Boolean> tabletWithIsAligned : parser.toTabletWithIsAligneds()) {
                    TSStatus result;
                    LoadConvertedInsertTabletStatement statement = new LoadConvertedInsertTabletStatement(PipeTransferTabletRawReq.toTPipeTransferRawReq((Tablet)tabletWithIsAligned.getLeft(), (Boolean)tabletWithIsAligned.getRight()).constructStatement(), loadTsFileStatement.isConvertOnTypeMismatch());
                    try {
                        result = statement.accept(LoadTsFileDataTypeConverter.STATEMENT_STATUS_VISITOR, this.statementExecutor.execute(statement));
                        for (int i = 0; i < 5 && result.getCode() == TSStatusCode.LOAD_TEMPORARY_UNAVAILABLE_EXCEPTION.getStatusCode(); ++i) {
                            Thread.sleep(100L * (long)(i + 1));
                            result = statement.accept(LoadTsFileDataTypeConverter.STATEMENT_STATUS_VISITOR, this.statementExecutor.execute(statement));
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        result = statement.accept(LoadTsFileDataTypeConverter.STATEMENT_EXCEPTION_VISITOR, e);
                    }
                    if (result.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode() || result.getCode() == TSStatusCode.LOAD_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()) continue;
                    Optional<TSStatus> optional = Optional.empty();
                    return optional;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to convert data type for LoadTsFileStatement: {}.", (Object)loadTsFileStatement, (Object)e);
                return Optional.empty();
            }
        }
        if (loadTsFileStatement.isDeleteAfterLoad()) {
            loadTsFileStatement.getTsFiles().forEach(FileUtils::deleteQuietly);
        }
        LOGGER.info("Data type conversion for LoadTsFileStatement {} is successful.", (Object)loadTsFileStatement);
        return Optional.of(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
    }

    @FunctionalInterface
    public static interface StatementExecutor {
        public TSStatus execute(Statement var1);
    }
}

