/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.utils;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALInputStream;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.WALNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALInsertNodeCache;
import org.apache.tsfile.utils.Pair;

public class WALEntryPosition {
    private volatile String identifier = "";
    private volatile long walFileVersionId = -1L;
    private volatile long position;
    private volatile int size;
    private WALNode walNode = null;
    private File walFile = null;
    private WALInsertNodeCache cache = null;
    private static final String ENTRY_NOT_READY_MESSAGE = "This entry isn't ready for read.";

    public WALEntryPosition() {
    }

    public WALEntryPosition(String identifier, long walFileVersionId, long position, int size) {
        this.identifier = identifier;
        this.walFileVersionId = walFileVersionId;
        this.position = position;
        this.size = size;
    }

    public Pair<ByteBuffer, InsertNode> readByteBufferOrInsertNodeViaCacheDirectly() {
        return this.cache.getByteBufferOrInsertNode(this);
    }

    public InsertNode readInsertNodeViaCacheAfterCanRead() throws IOException {
        if (!this.canRead()) {
            throw new IOException(ENTRY_NOT_READY_MESSAGE);
        }
        return this.cache.getInsertNode(this);
    }

    public ByteBuffer readByteBufferViaCacheAfterCanRead() throws IOException {
        if (!this.canRead()) {
            throw new IOException(ENTRY_NOT_READY_MESSAGE);
        }
        return this.cache.getByteBuffer(this);
    }

    ByteBuffer read() throws IOException {
        if (!this.canRead()) {
            throw new IOException("Target file hasn't been specified.");
        }
        try (WALInputStream is = this.openReadFileStream();){
            is.skipToGivenLogicalPosition(this.position);
            ByteBuffer buffer = ByteBuffer.allocate(this.size);
            is.read(buffer);
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }

    public FileChannel openReadFileChannel() throws IOException {
        if (this.isInSealedFile()) {
            this.walFile = this.walNode.getWALFile(this.walFileVersionId);
            return FileChannel.open(this.walFile.toPath(), StandardOpenOption.READ);
        }
        try {
            this.walFile = this.walNode.getWALFile(this.walFileVersionId);
            return FileChannel.open(this.walFile.toPath(), StandardOpenOption.READ);
        }
        catch (IOException e) {
            if (this.isInSealedFile()) {
                this.walFile = this.walNode.getWALFile(this.walFileVersionId);
                return FileChannel.open(this.walFile.toPath(), StandardOpenOption.READ);
            }
            throw e;
        }
    }

    public WALInputStream openReadFileStream() throws IOException {
        if (this.isInSealedFile()) {
            this.walFile = this.walNode.getWALFile(this.walFileVersionId);
            return new WALInputStream(this.walFile);
        }
        try {
            this.walFile = this.walNode.getWALFile(this.walFileVersionId);
            return new WALInputStream(this.walFile);
        }
        catch (IOException e) {
            if (this.isInSealedFile()) {
                this.walFile = this.walNode.getWALFile(this.walFileVersionId);
                return new WALInputStream(this.walFile);
            }
            throw e;
        }
    }

    public File getWalFile() {
        return this.walFile;
    }

    public boolean canRead() {
        return this.walFileVersionId >= 0L;
    }

    public boolean isInSealedFile() {
        if (this.walNode == null || !this.canRead()) {
            throw new RuntimeException(ENTRY_NOT_READY_MESSAGE);
        }
        return this.walFileVersionId < this.walNode.getCurrentWALFileVersion();
    }

    public void setWalNode(WALNode walNode, long memTableId) {
        this.walNode = walNode;
        this.identifier = walNode.getIdentifier();
        this.cache = WALInsertNodeCache.getInstance(walNode.getRegionId(memTableId));
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setEntryPosition(long walFileVersionId, long position, WALEntryValue value) {
        this.position = position;
        this.walFileVersionId = walFileVersionId;
        if (this.cache != null && value instanceof InsertNode) {
            this.cache.cacheInsertNodeIfNeeded(this, (InsertNode)((Object)value));
        }
    }

    public long getPosition() {
        return this.position;
    }

    public long getWalFileVersionId() {
        return this.walFileVersionId;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.walFileVersionId, this.position);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WALEntryPosition that = (WALEntryPosition)o;
        return this.identifier.equals(that.identifier) && this.walFileVersionId == that.walFileVersionId && this.position == that.position;
    }
}

