/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.exception.load.PartitionViolationException;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ArrayDeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.PlainDeviceTimeIndex;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.fileSystem.FSFactoryProducer;
import org.apache.tsfile.utils.FilePathUtils;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTimeIndex
implements ITimeIndex {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(FileTimeIndex.class);
    private static final Logger logger = LoggerFactory.getLogger(FileTimeIndex.class);
    protected long startTime;
    protected long endTime;

    public FileTimeIndex() {
        this.startTime = Long.MAX_VALUE;
        this.endTime = Long.MIN_VALUE;
    }

    public FileTimeIndex(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileTimeIndex deserialize(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileTimeIndex deserialize(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
    }

    @Override
    public Set<IDeviceID> getDevices(String tsFilePath, TsFileResource tsFileResource) {
        tsFileResource.readLock();
        try {
            Set<IDeviceID> set;
            block18: {
                BufferedInputStream inputStream;
                block16: {
                    Set<IDeviceID> set2;
                    block17: {
                        inputStream = FSFactoryProducer.getFSFactory().getBufferedInputStream(tsFilePath + ".resource");
                        try {
                            byte[] bytes = ReadWriteIOUtils.readBytes((InputStream)inputStream, (int)2);
                            if (bytes[1] != 3) break block16;
                            set2 = ArrayDeviceTimeIndex.getDevices(inputStream);
                            if (inputStream == null) break block17;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (inputStream != null) {
                                    try {
                                        ((InputStream)inputStream).close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (NoSuchFileException e) {
                                if (tsFileResource.isDeleted()) {
                                    Set<IDeviceID> set3 = Collections.emptySet();
                                    return set3;
                                }
                                logger.error("Can't read file {} from disk ", (Object)(tsFilePath + ".resource"), (Object)e);
                                throw new RuntimeException("Can't read file " + tsFilePath + ".resource" + " from disk");
                            }
                            catch (Exception e) {
                                logger.error("Failed to get devices from tsfile: {}", (Object)(tsFilePath + ".resource"), (Object)e);
                                throw new RuntimeException("Failed to get devices from tsfile: " + tsFilePath + ".resource");
                            }
                        }
                        ((InputStream)inputStream).close();
                    }
                    return set2;
                }
                set = PlainDeviceTimeIndex.getDevices(inputStream);
                if (inputStream == null) break block18;
                ((InputStream)inputStream).close();
            }
            return set;
        }
        finally {
            tsFileResource.readUnlock();
        }
    }

    @Override
    public boolean endTimeEmpty() {
        return this.endTime == Long.MIN_VALUE;
    }

    @Override
    public boolean stillLives(long ttlLowerBound) {
        if (ttlLowerBound == Long.MAX_VALUE) {
            return true;
        }
        return this.endTime >= ttlLowerBound;
    }

    @Override
    public long calculateRamSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public long getTimePartition(String tsFilePath) {
        try {
            String[] filePathSplits = FilePathUtils.splitTsFilePath((String)tsFilePath);
            return Long.parseLong(filePathSplits[filePathSplits.length - 2]);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public long getTimePartitionWithCheck(String tsFilePath) throws PartitionViolationException {
        long endPartitionId;
        long startPartitionId = TimePartitionUtils.getTimePartitionId((long)this.startTime);
        if (startPartitionId == (endPartitionId = TimePartitionUtils.getTimePartitionId((long)this.endTime))) {
            return startPartitionId;
        }
        throw new PartitionViolationException(tsFilePath);
    }

    @Override
    public boolean isSpanMultiTimePartitions() {
        return TimePartitionUtils.getTimePartitionId((long)this.startTime) != TimePartitionUtils.getTimePartitionId((long)this.endTime);
    }

    @Override
    public void updateStartTime(IDeviceID deviceId, long time) {
        if (this.startTime > time) {
            this.startTime = time;
        }
    }

    @Override
    public void updateEndTime(IDeviceID deviceId, long time) {
        if (this.endTime < time) {
            this.endTime = time;
        }
    }

    @Override
    public void putStartTime(IDeviceID deviceId, long time) {
        this.startTime = time;
    }

    @Override
    public void putEndTime(IDeviceID deviceId, long time) {
        this.endTime = time;
    }

    @Override
    public long getStartTime(IDeviceID deviceId) {
        return this.startTime;
    }

    @Override
    public long getMinStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime(IDeviceID deviceId) {
        return this.endTime;
    }

    @Override
    public long getMaxEndTime() {
        return this.endTime;
    }

    @Override
    public boolean checkDeviceIdExist(IDeviceID deviceId) {
        return true;
    }

    @Override
    public int compareDegradePriority(ITimeIndex timeIndex) {
        if (timeIndex instanceof ArrayDeviceTimeIndex) {
            return 1;
        }
        if (timeIndex instanceof FileTimeIndex) {
            return Long.compare(this.startTime, timeIndex.getMinStartTime());
        }
        logger.error("Wrong timeIndex type {}", (Object)timeIndex.getClass().getName());
        throw new RuntimeException("Wrong timeIndex type " + timeIndex.getClass().getName());
    }

    @Override
    public boolean definitelyNotContains(IDeviceID device) {
        return false;
    }

    @Override
    public boolean isDeviceAlive(IDeviceID device, long ttl) {
        return this.endTime >= CommonDateTimeUtils.currentTime() - ttl;
    }

    @Override
    public long[] getStartAndEndTime(IDeviceID deviceId) {
        return new long[]{this.startTime, this.endTime};
    }

    @Override
    public Pair<Long, Long> getPossibleStartTimeAndEndTime(PartialPath devicePattern, Set<IDeviceID> deviceMatchInfo) {
        return new Pair((Object)this.startTime, (Object)this.endTime);
    }

    @Override
    public byte getTimeIndexType() {
        return 2;
    }

    public String toString() {
        return " StartTime = " + this.startTime + " EndTime = " + this.endTime;
    }
}

