/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.modification;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.service.metrics.FileMetrics;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.TreeDeletionEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.v1.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.v1.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.v1.ModificationFileV1;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModificationFile
implements AutoCloseable {
    public static final String FILE_SUFFIX = ".mods2";
    public static final String COMPACTION_FILE_SUFFIX = ".compaction.mods2";
    public static final String COMPACT_SUFFIX = ".settle";
    private static final Logger LOGGER = LoggerFactory.getLogger(ModificationFile.class);
    private final File file;
    private FileChannel channel;
    private OutputStream fileOutputStream;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final long COMPACT_THRESHOLD = 0x100000L;
    private boolean hasCompacted = false;
    private boolean fileExists = false;
    private final boolean updateMetrics;
    private Set<ModificationFile> cascadeFiles = null;

    public ModificationFile(String filePath, boolean updateModMetrics) {
        this(new File(filePath), updateModMetrics);
    }

    public ModificationFile(File file, boolean updateModMetrics) {
        this.file = file;
        this.fileExists = file.length() > 0L;
        this.updateMetrics = updateModMetrics;
        if (this.fileExists) {
            this.updateModFileMetric(1, file.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ModEntry entry) throws IOException {
        int updateFileNum = 0;
        this.lock.writeLock().lock();
        long size = 0L;
        try {
            if (this.fileOutputStream == null) {
                this.fileOutputStream = new BufferedOutputStream(Files.newOutputStream(this.file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND));
                this.channel = FileChannel.open(this.file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            size += entry.serialize(this.fileOutputStream);
            this.fileOutputStream.flush();
            if (this.cascadeFiles != null) {
                for (ModificationFile cascadeFile : this.cascadeFiles) {
                    cascadeFile.write(entry);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (!this.fileExists) {
            this.fileExists = true;
            updateFileNum = 1;
        }
        this.updateModFileMetric(updateFileNum, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Collection<? extends ModEntry> entries) throws IOException {
        int updateFileNum = 0;
        this.lock.writeLock().lock();
        long size = 0L;
        try {
            if (this.fileOutputStream == null) {
                this.fileOutputStream = new BufferedOutputStream(Files.newOutputStream(this.file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND));
                this.channel = FileChannel.open(this.file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            for (ModEntry modEntry : entries) {
                size += modEntry.serialize(this.fileOutputStream);
            }
            this.fileOutputStream.flush();
            if (this.cascadeFiles != null) {
                for (ModificationFile modificationFile : this.cascadeFiles) {
                    modificationFile.write(entries);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (!this.fileExists) {
            updateFileNum = 1;
            this.fileExists = true;
        }
        this.updateModFileMetric(updateFileNum, size);
    }

    private void updateModFileMetric(int num, long size) {
        if (this.updateMetrics) {
            FileMetrics.getInstance().increaseModFileNum(num);
            FileMetrics.getInstance().increaseModFileSize(size);
        }
    }

    public Iterator<ModEntry> getModIterator(long offset) throws IOException {
        return new ModIterator(offset);
    }

    public List<ModEntry> getAllMods() throws IOException {
        return this.getAllMods(0L);
    }

    public List<ModEntry> getAllMods(long offset) throws IOException {
        ArrayList<ModEntry> allMods = new ArrayList<ModEntry>();
        this.getModIterator(offset).forEachRemaining(allMods::add);
        return allMods;
    }

    @Override
    public void close() throws IOException {
        this.lock.writeLock().lock();
        try {
            if (this.fileOutputStream == null) {
                return;
            }
            this.fileOutputStream.close();
            this.fileOutputStream = null;
            this.channel.force(true);
            this.channel.close();
            this.channel = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public File getFile() {
        return this.file;
    }

    public long getFileLength() {
        this.lock.readLock().lock();
        try {
            long l = this.file.length();
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static String composeFileName(long levelNum, long modFileNum) {
        return levelNum + "-" + modFileNum + FILE_SUFFIX;
    }

    public static long[] parseFileName(String name) {
        name = name.substring(0, name.lastIndexOf(FILE_SUFFIX));
        String[] split = name.split("-");
        long levelNum = Long.parseLong(split[0]);
        long modNum = Long.parseLong(split[1]);
        return new long[]{levelNum, modNum};
    }

    public static List<ModEntry> readAllModifications(File tsfile, boolean readOldModFileIfNewModFileNotExists) throws IOException {
        try (ModificationFile modificationFile = new ModificationFile(ModificationFile.getExclusiveMods(tsfile), false);){
            if (modificationFile.exists()) {
                List<ModEntry> list = modificationFile.getAllMods();
                return list;
            }
        }
        if (!readOldModFileIfNewModFileNotExists) {
            return Collections.emptyList();
        }
        ArrayList<ModEntry> result = new ArrayList<ModEntry>();
        try (ModificationFileV1 modificationFileV1 = new ModificationFileV1(ModificationFileV1.getNormalMods(tsfile).getPath());){
            if (!modificationFileV1.exists()) {
                List<ModEntry> list = Collections.emptyList();
                return list;
            }
            for (Modification modification : modificationFileV1.getModificationsIter()) {
                if (!(modification instanceof Deletion)) continue;
                result.add(new TreeDeletionEntry((Deletion)modification));
            }
        }
        return result;
    }

    public boolean exists() {
        return this.fileExists;
    }

    public void remove() throws IOException {
        this.close();
        FileUtils.deleteFileOrDirectory((File)this.file);
        if (this.fileExists) {
            this.updateModFileMetric(-1, -this.getFileLength());
        }
        this.fileExists = false;
    }

    public static ModificationFile getExclusiveMods(TsFileResource tsFileResource) {
        String tsFilePath = tsFileResource.getTsFilePath();
        tsFilePath = tsFilePath.replace(".inner", ".tsfile");
        tsFilePath = tsFilePath.replace(".cross", ".tsfile");
        return new ModificationFile(tsFilePath + FILE_SUFFIX, true);
    }

    public static File getExclusiveMods(File tsFile) {
        return new File(tsFile.getPath() + FILE_SUFFIX);
    }

    public static ModificationFile getCompactionMods(TsFileResource tsFileResource) {
        return new ModificationFile(new File(tsFileResource.getTsFilePath() + COMPACTION_FILE_SUFFIX), true);
    }

    public static File getCompactionMods(File tsFile) {
        return new File(tsFile.getPath() + COMPACTION_FILE_SUFFIX);
    }

    public void truncate(long size) throws IOException {
        this.lock.writeLock().lock();
        try {
            if (this.channel != null) {
                this.channel.truncate(size);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String toString() {
        return "ModificationFile{file=" + this.file + '}';
    }

    public void compact() throws IOException {
        long originFileSize = this.getFileLength();
        if (originFileSize > 0x100000L && !this.hasCompacted) {
            try {
                Map<PartialPath, List<ModEntry>> pathModificationMap = this.getAllMods().stream().collect(Collectors.groupingBy(ModEntry::keyOfPatternTree));
                String newModsFileName = this.getFile().getPath() + COMPACT_SUFFIX;
                ArrayList<ModEntry> allSettledModifications = new ArrayList<ModEntry>();
                try (ModificationFile compactedModificationFile = new ModificationFile(newModsFileName, false);){
                    Set<Map.Entry<PartialPath, List<ModEntry>>> modificationsEntrySet = pathModificationMap.entrySet();
                    for (Map.Entry<PartialPath, List<ModEntry>> modificationEntry : modificationsEntrySet) {
                        List<ModEntry> settledModifications = ModificationUtils.sortAndMerge(modificationEntry.getValue());
                        compactedModificationFile.write(settledModifications);
                        allSettledModifications.addAll(settledModifications);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("compact mods file exception of {}", (Object)this.file, (Object)e);
                }
                this.remove();
                this.fileExists = true;
                Files.move(new File(newModsFileName).toPath(), this.file.toPath(), new CopyOption[0]);
                LOGGER.info("{} settle successful", (Object)this.file);
                if (this.getFileLength() > 0x100000L) {
                    LOGGER.warn("After the mod file is settled, the file size is still greater than 1M,the size of the file before settle is {},after settled the file size is {}", (Object)originFileSize, (Object)this.getFileLength());
                }
            }
            catch (IOException e) {
                LOGGER.error("remove origin file or rename new mods file error.", (Throwable)e);
            }
            this.hasCompacted = true;
        }
    }

    public void setCascadeFile(Set<ModificationFile> cascadeFiles) {
        this.lock.writeLock().lock();
        try {
            this.cascadeFiles = cascadeFiles;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public class ModIterator
    implements Iterator<ModEntry>,
    AutoCloseable {
        private InputStream inputStream;
        private ModEntry nextEntry;

        public ModIterator(long offset) throws IOException {
            if (!ModificationFile.this.fileExists) {
                return;
            }
            this.inputStream = new BufferedInputStream(Files.newInputStream(ModificationFile.this.file.toPath(), new OpenOption[0]), 65536);
            long skipped = this.inputStream.skip(offset);
            if (skipped != offset) {
                LOGGER.warn("Fail to read Mod file {}, expecting offset {}, actually skipped {}", new Object[]{ModificationFile.this.file, offset, skipped});
            }
        }

        @Override
        public void close() {
            if (this.inputStream == null) {
                return;
            }
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                LOGGER.info("Cannot close mod file input stream of {}", (Object)ModificationFile.this.file, (Object)e);
            }
            finally {
                this.inputStream = null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.inputStream == null) {
                return false;
            }
            if (this.nextEntry == null) {
                try {
                    if (this.inputStream.available() == 0) {
                        this.close();
                        return false;
                    }
                    this.nextEntry = ModEntry.createFrom(this.inputStream);
                }
                catch (EOFException e) {
                    this.close();
                }
                catch (IOException e) {
                    LOGGER.info("Cannot read mod file input stream of {}", (Object)ModificationFile.this.file, (Object)e);
                    this.close();
                }
            }
            return this.nextEntry != null;
        }

        @Override
        public ModEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ModEntry ret = this.nextEntry;
            this.nextEntry = null;
            return ret;
        }
    }
}

