/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import java.time.ZoneId;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar.AbstractCastFunctionColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeEnum;

public class TryCastFunctionColumnTransformer
extends AbstractCastFunctionColumnTransformer {
    public TryCastFunctionColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, ZoneId zoneId) {
        super(returnType, childColumnTransformer, zoneId);
    }

    @Override
    protected void transform(Column column, ColumnBuilder columnBuilder, TypeEnum sourceType, Type childType, int i) {
        try {
            switch (sourceType) {
                case INT32: {
                    this.cast(columnBuilder, childType.getInt(column, i));
                    break;
                }
                case DATE: {
                    this.castDate(columnBuilder, childType.getInt(column, i));
                    break;
                }
                case INT64: {
                    this.cast(columnBuilder, childType.getLong(column, i));
                    break;
                }
                case TIMESTAMP: {
                    this.castTimestamp(columnBuilder, childType.getLong(column, i));
                    break;
                }
                case FLOAT: {
                    this.cast(columnBuilder, childType.getFloat(column, i));
                    break;
                }
                case DOUBLE: {
                    this.cast(columnBuilder, childType.getDouble(column, i));
                    break;
                }
                case BOOLEAN: {
                    this.cast(columnBuilder, childType.getBoolean(column, i));
                    break;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    this.cast(columnBuilder, childType.getBinary(column, i));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported source dataType: %s", this.childColumnTransformer.getType().getTypeEnum()));
                }
            }
        }
        catch (IoTDBRuntimeException e) {
            columnBuilder.appendNull();
        }
    }
}

