/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata.template;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.Pair;

public class BatchActivateTemplateStatement
extends Statement {
    private final List<PartialPath> devicePathList;

    public BatchActivateTemplateStatement(List<PartialPath> devicePathList) {
        this.devicePathList = devicePathList;
        this.statementType = StatementType.BATCH_ACTIVATE_TEMPLATE;
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        List<PartialPath> checkedPaths = this.getPaths();
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkPatternPermission(userName, checkedPaths, PrivilegeType.WRITE_SCHEMA.ordinal()), checkedPaths, PrivilegeType.WRITE_SCHEMA);
    }

    public List<PartialPath> getPaths() {
        ClusterTemplateManager clusterTemplateManager = ClusterTemplateManager.getInstance();
        ArrayList<String> templatePaths = new ArrayList<String>();
        for (PartialPath path2 : this.devicePathList) {
            Pair<Template, PartialPath> templateSetInfo = clusterTemplateManager.checkTemplateSetInfo(path2);
            if (templateSetInfo == null) continue;
            templatePaths.addAll(((Template)templateSetInfo.left).getSchemaMap().keySet());
        }
        return this.devicePathList.stream().flatMap(path -> templatePaths.stream().map(arg_0 -> ((PartialPath)path).concatAsMeasurementPath(arg_0))).collect(Collectors.toList());
    }

    public List<PartialPath> getDevicePathList() {
        return this.devicePathList;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitBatchActivateTemplate(this, context);
    }
}

