/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Property;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class SetProperties
extends Statement {
    private final Type type;
    private final QualifiedName name;
    private final List<Property> properties;
    private final boolean ifExists;

    public SetProperties(Type type, QualifiedName name, List<Property> properties, boolean ifExists) {
        super(null);
        this.type = Objects.requireNonNull(type, "type is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.properties = ImmutableList.copyOf((Collection)Objects.requireNonNull(properties, "properties is null"));
        this.ifExists = ifExists;
    }

    public SetProperties(@Nonnull NodeLocation location, Type type, QualifiedName name, List<Property> properties, boolean ifExists) {
        super(Objects.requireNonNull(location, "location is null"));
        this.type = Objects.requireNonNull(type, "type is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.properties = ImmutableList.copyOf((Collection)Objects.requireNonNull(properties, "properties is null"));
        this.ifExists = ifExists;
    }

    public Type getType() {
        return this.type;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSetProperties(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.properties, this.ifExists});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SetProperties o = (SetProperties)obj;
        return this.type == o.type && this.ifExists == o.ifExists && Objects.equals(this.name, o.name) && Objects.equals(this.properties, o.properties);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("name", (Object)this.name).add("properties", this.properties).add("ifExists", this.ifExists).toString();
    }

    public static enum Type {
        TABLE,
        MATERIALIZED_VIEW;

    }
}

