/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Table;
import org.apache.iotdb.db.storageengine.dataregion.modification.TableDeletionEntry;

public class Delete
extends Statement {
    private final Table table;
    @Nullable
    private final Expression where;
    private List<TableDeletionEntry> tableDeletionEntries;
    private String databaseName;
    private Collection<TRegionReplicaSet> replicaSets;

    public Delete(NodeLocation location, Table table) {
        super(Objects.requireNonNull(location, "location is null"));
        this.table = Objects.requireNonNull(table, "table is null");
        this.where = null;
    }

    public Delete(NodeLocation location, Table table, Expression where) {
        super(Objects.requireNonNull(location, "location is null"));
        this.table = Objects.requireNonNull(table, "table is null");
        this.where = Objects.requireNonNull(where, "where is null");
    }

    public Table getTable() {
        return this.table;
    }

    public Optional<Expression> getWhere() {
        return Optional.ofNullable(this.where);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDelete(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.add((Object)this.table);
        if (this.where != null) {
            nodes.add((Object)this.where);
        }
        return nodes.build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.where);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Delete o = (Delete)obj;
        return Objects.equals(this.table, o.table) && Objects.equals(this.where, o.where);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table.getName()).add("where", (Object)this.where).toString();
    }

    public List<TableDeletionEntry> getTableDeletionEntries() {
        return this.tableDeletionEntries;
    }

    public void setTableDeletionEntries(List<TableDeletionEntry> tableDeletionEntries) {
        this.tableDeletionEntries = tableDeletionEntries;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public Collection<TRegionReplicaSet> getReplicaSets() {
        return this.replicaSets;
    }

    public void setReplicaSets(Collection<TRegionReplicaSet> replicaSets) {
        this.replicaSets = replicaSets;
    }
}

