/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.planner.IrTypeAnalyzer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlannerContext;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.IterativeOptimizer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.RuleStatsRecorder;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.CanonicalizeExpressions;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.InlineProjections;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.MergeFilters;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.MergeLimitOverProjectWithSort;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.MergeLimitWithSort;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.MergeLimits;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneAggregationColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneAggregationSourceColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneCorrelatedJoinColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneCorrelatedJoinCorrelation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneDistinctAggregation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneEnforceSingleRowColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneFillColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneFilterColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneGapFillColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneJoinChildrenColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneJoinColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneLimitColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneOffsetColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneOutputSourceColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneProjectColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneSortColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneTableScanColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PruneTopKColumns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PushLimitThroughOffset;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PushLimitThroughProject;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.RemoveDuplicateConditions;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.RemoveRedundantEnforceSingleRowNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.RemoveRedundantIdentityProjections;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.RemoveTrivialFilters;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.SimplifyExpressions;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.TransformUncorrelatedSubqueryToJoin;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.CheckSubqueryNodesAreRewritten;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PlanOptimizer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PushAggregationIntoTableScan;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PushLimitOffsetIntoTableScan;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PushPredicateIntoTableScan;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.TransformAggregationToStreamable;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.TransformSortToStreamSort;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.UnaliasSymbolReferences;

public class LogicalOptimizeFactory {
    private final List<PlanOptimizer> planOptimizers;

    public LogicalOptimizeFactory(PlannerContext plannerContext) {
        IrTypeAnalyzer typeAnalyzer = new IrTypeAnalyzer(plannerContext);
        Metadata metadata = plannerContext.getMetadata();
        RuleStatsRecorder ruleStats = new RuleStatsRecorder();
        ImmutableSet columnPruningRules = ImmutableSet.of((Object)new PruneAggregationColumns(), (Object)new PruneAggregationSourceColumns(), (Object)new PruneCorrelatedJoinColumns(), (Object)new PruneCorrelatedJoinCorrelation(), (Object)new PruneEnforceSingleRowColumns(), (Object)new PruneFilterColumns(), (Object[])new Rule[]{new PruneGapFillColumns(), new PruneFillColumns(), new PruneLimitColumns(), new PruneOffsetColumns(), new PruneOutputSourceColumns(), new PruneProjectColumns(), new PruneSortColumns(), new PruneTableScanColumns(plannerContext.getMetadata()), new PruneTopKColumns(), new PruneJoinColumns(), new PruneJoinChildrenColumns()});
        IterativeOptimizer columnPruningOptimizer = new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)columnPruningRules);
        IterativeOptimizer inlineProjectionLimitFiltersOptimizer = new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)ImmutableSet.of((Object)new InlineProjections(plannerContext), (Object)new RemoveRedundantIdentityProjections(), (Object)new MergeFilters(), (Object)new MergeLimits()));
        ImmutableSet simplifyOptimizerRules = ImmutableSet.builder().addAll(new SimplifyExpressions(plannerContext, typeAnalyzer).rules()).addAll(new RemoveDuplicateConditions(metadata).rules()).addAll(new CanonicalizeExpressions(plannerContext, typeAnalyzer).rules()).add((Object)new RemoveTrivialFilters()).build();
        IterativeOptimizer simplifyOptimizer = new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)simplifyOptimizerRules);
        ImmutableSet limitPushdownRules = ImmutableSet.of((Object)new PushLimitThroughOffset(), (Object)new PushLimitThroughProject());
        ImmutableList.Builder optimizerBuilder = ImmutableList.builder();
        optimizerBuilder.add((Object[])new PlanOptimizer[]{new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)columnPruningRules).addAll((Iterable)ImmutableSet.of((Object)new MergeFilters(), (Object)new InlineProjections(plannerContext), (Object)new RemoveRedundantIdentityProjections(), (Object)new MergeLimits(), (Object)new RemoveTrivialFilters(), (Object)new RemoveRedundantEnforceSingleRowNode(), (Object[])new Rule[0])).build()), new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)columnPruningRules).addAll((Iterable)limitPushdownRules).addAll((Iterable)ImmutableSet.of((Object)new MergeFilters(), (Object)new RemoveTrivialFilters(), (Object)new MergeLimits(), (Object)new InlineProjections(plannerContext), (Object)new RemoveRedundantIdentityProjections())).build()), simplifyOptimizer, new UnaliasSymbolReferences(plannerContext.getMetadata()), columnPruningOptimizer, inlineProjectionLimitFiltersOptimizer, new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantEnforceSingleRowNode(), (Object)new TransformUncorrelatedSubqueryToJoin())), new CheckSubqueryNodesAreRewritten(), new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)ImmutableSet.of((Object)new PruneDistinctAggregation())), simplifyOptimizer, new PushPredicateIntoTableScan(), columnPruningOptimizer, inlineProjectionLimitFiltersOptimizer, new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)limitPushdownRules), new PushLimitOffsetIntoTableScan(), new TransformAggregationToStreamable(), new PushAggregationIntoTableScan(), new TransformSortToStreamSort(), new IterativeOptimizer(plannerContext, ruleStats, (Set<Rule<?>>)ImmutableSet.of((Object)new MergeLimitWithSort(), (Object)new MergeLimitOverProjectWithSort()))});
        this.planOptimizers = optimizerBuilder.build();
    }

    public List<PlanOptimizer> getPlanOptimizers() {
        return this.planOptimizers;
    }
}

