/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Lookup;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ApplyNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.CorrelatedJoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.EnforceSingleRowNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FilterNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.GapFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.LimitNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.MergeSortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.OffsetNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.OutputNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TopKNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Property;

public final class Patterns {
    private Patterns() {
    }

    public static Pattern<AggregationNode> aggregation() {
        return Pattern.typeOf(AggregationNode.class);
    }

    public static Pattern<ApplyNode> applyNode() {
        return Pattern.typeOf(ApplyNode.class);
    }

    public static Pattern<EnforceSingleRowNode> enforceSingleRow() {
        return Pattern.typeOf(EnforceSingleRowNode.class);
    }

    public static Pattern<FilterNode> filter() {
        return Pattern.typeOf(FilterNode.class);
    }

    public static Pattern<JoinNode> join() {
        return Pattern.typeOf(JoinNode.class);
    }

    public static Pattern<CorrelatedJoinNode> correlatedJoin() {
        return Pattern.typeOf(CorrelatedJoinNode.class);
    }

    public static Pattern<OffsetNode> offset() {
        return Pattern.typeOf(OffsetNode.class);
    }

    public static Pattern<LimitNode> limit() {
        return Pattern.typeOf(LimitNode.class);
    }

    public static Pattern<OutputNode> output() {
        return Pattern.typeOf(OutputNode.class);
    }

    public static Pattern<ProjectNode> project() {
        return Pattern.typeOf(ProjectNode.class);
    }

    public static Pattern<GapFillNode> gapFill() {
        return Pattern.typeOf(GapFillNode.class);
    }

    public static Pattern<FillNode> fill() {
        return Pattern.typeOf(FillNode.class);
    }

    public static Pattern<SortNode> sort() {
        return Pattern.typeOf(SortNode.class);
    }

    public static Pattern<MergeSortNode> mergeSort() {
        return Pattern.typeOf(MergeSortNode.class);
    }

    public static Pattern<TableScanNode> tableScan() {
        return Pattern.typeOf(TableScanNode.class);
    }

    public static Pattern<TopKNode> topK() {
        return Pattern.typeOf(TopKNode.class);
    }

    public static Property<PlanNode, Lookup, PlanNode> source() {
        return Property.optionalProperty("source", (node, lookup) -> {
            if (node.getChildren().size() == 1) {
                PlanNode source = (PlanNode)Iterables.getOnlyElement(node.getChildren());
                return Optional.of(lookup.resolve(source));
            }
            return Optional.empty();
        });
    }

    public static Property<PlanNode, Lookup, List<PlanNode>> sources() {
        return Property.property("sources", (node, lookup) -> (List)node.getChildren().stream().map(lookup::resolve).collect(ImmutableList.toImmutableList()));
    }

    public static final class Limit {
        public static Property<LimitNode, Lookup, Long> count() {
            return Property.property("count", LimitNode::getCount);
        }

        public static Property<LimitNode, Lookup, Boolean> requiresPreSortedInputs() {
            return Property.property("requiresPreSortedInputs", LimitNode::requiresPreSortedInputs);
        }
    }

    public static final class CorrelatedJoin {
        public static Property<CorrelatedJoinNode, Lookup, List<Symbol>> correlation() {
            return Property.property("correlation", CorrelatedJoinNode::getCorrelation);
        }

        public static Property<CorrelatedJoinNode, Lookup, PlanNode> subquery() {
            return Property.property("subquery", (node, context) -> context.resolve(node.getSubquery()));
        }

        public static Property<CorrelatedJoinNode, Lookup, Expression> filter() {
            return Property.property("filter", CorrelatedJoinNode::getFilter);
        }

        public static Property<CorrelatedJoinNode, Lookup, JoinNode.JoinType> type() {
            return Property.property("type", CorrelatedJoinNode::getJoinType);
        }
    }

    public static final class Join {
        public static Property<JoinNode, Lookup, JoinNode.JoinType> type() {
            return Property.property("type", JoinNode::getJoinType);
        }

        public static Property<JoinNode, Lookup, PlanNode> left() {
            return Property.property("left", (joinNode, lookup) -> lookup.resolve(joinNode.getLeftChild()));
        }

        public static Property<JoinNode, Lookup, PlanNode> right() {
            return Property.property("right", (joinNode, lookup) -> lookup.resolve(joinNode.getRightChild()));
        }
    }

    public static final class Apply {
        public static Property<ApplyNode, Lookup, List<Symbol>> correlation() {
            return Property.property("correlation", ApplyNode::getCorrelation);
        }
    }
}

