/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.distribute;

import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.NodeDistribution;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.NodeDistributionType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.read.TableDeviceSourceNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.distribute.TableDistributedPlanGenerator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ExchangeNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ExplainAnalyzeNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceFetchNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceQueryCountNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceQueryScanNode;

public class AddExchangeNodes
extends PlanVisitor<PlanNode, TableDistributedPlanGenerator.PlanContext> {
    private final MPPQueryContext queryContext;

    public AddExchangeNodes(MPPQueryContext queryContext) {
        this.queryContext = queryContext;
    }

    public PlanNode addExchangeNodes(PlanNode node, TableDistributedPlanGenerator.PlanContext context) {
        return node.accept(this, context);
    }

    @Override
    public PlanNode visitPlan(PlanNode node, TableDistributedPlanGenerator.PlanContext context) {
        if (node instanceof WritePlanNode) {
            return node;
        }
        PlanNode newNode = node.clone();
        if (node.getChildren().size() == 1) {
            newNode.addChild(node.getChildren().get(0).accept(this, context));
            context.nodeDistributionMap.put(node.getPlanNodeId(), new NodeDistribution(NodeDistributionType.SAME_WITH_ALL_CHILDREN, context.nodeDistributionMap.get(node.getChildren().get(0).getPlanNodeId()).getRegion()));
            return newNode;
        }
        for (PlanNode child : node.getChildren()) {
            PlanNode rewriteNode = child.accept(this, context);
            TRegionReplicaSet region = context.nodeDistributionMap.get(rewriteNode.getPlanNodeId()).getRegion();
            if (!region.equals(context.mostUsedRegion)) {
                ExchangeNode exchangeNode = new ExchangeNode(this.queryContext.getQueryId().genPlanNodeId());
                exchangeNode.addChild(rewriteNode);
                exchangeNode.setOutputSymbols(rewriteNode.getOutputSymbols());
                newNode.addChild(exchangeNode);
                context.hasExchangeNode = true;
                continue;
            }
            newNode.addChild(rewriteNode);
        }
        context.nodeDistributionMap.put(node.getPlanNodeId(), new NodeDistribution(NodeDistributionType.SAME_WITH_SOME_CHILD, context.mostUsedRegion));
        return newNode;
    }

    @Override
    public PlanNode visitTableScan(TableScanNode node, TableDistributedPlanGenerator.PlanContext context) {
        context.nodeDistributionMap.put(node.getPlanNodeId(), new NodeDistribution(NodeDistributionType.SAME_WITH_ALL_CHILDREN, node.getRegionReplicaSet()));
        return node;
    }

    @Override
    public PlanNode visitTableDeviceFetch(TableDeviceFetchNode node, TableDistributedPlanGenerator.PlanContext context) {
        return this.processTableDeviceSourceNode(node, context);
    }

    @Override
    public PlanNode visitTableDeviceQueryScan(TableDeviceQueryScanNode node, TableDistributedPlanGenerator.PlanContext context) {
        return this.processTableDeviceSourceNode(node, context);
    }

    @Override
    public PlanNode visitTableDeviceQueryCount(TableDeviceQueryCountNode node, TableDistributedPlanGenerator.PlanContext context) {
        return this.processTableDeviceSourceNode(node, context);
    }

    @Override
    public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, TableDistributedPlanGenerator.PlanContext context) {
        ExplainAnalyzeNode newNode = (ExplainAnalyzeNode)node.clone();
        PlanNode child = newNode.getChild();
        child = child.accept(this, context);
        ExchangeNode exchangeNode = new ExchangeNode(this.queryContext.getQueryId().genPlanNodeId());
        exchangeNode.setChild(child);
        exchangeNode.setOutputSymbols(child.getOutputSymbols());
        newNode.setChild(exchangeNode);
        context.nodeDistributionMap.put(newNode.getPlanNodeId(), new NodeDistribution(NodeDistributionType.DIFFERENT_FROM_ALL_CHILDREN, DataPartition.NOT_ASSIGNED));
        context.hasExchangeNode = true;
        return newNode;
    }

    private PlanNode processTableDeviceSourceNode(TableDeviceSourceNode node, TableDistributedPlanGenerator.PlanContext context) {
        context.nodeDistributionMap.put(node.getPlanNodeId(), new NodeDistribution(NodeDistributionType.SAME_WITH_ALL_CHILDREN, node.getRegionReplicaSet()));
        return node;
    }
}

