/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.AttributeColumnSchema;
import org.apache.iotdb.commons.schema.table.column.FieldColumnSchema;
import org.apache.iotdb.commons.schema.table.column.TagColumnSchema;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.load.LoadAnalyzeTableColumnDisorderException;
import org.apache.iotdb.db.exception.sql.ColumnCreationFailException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.lock.DataNodeSchemaLockManager;
import org.apache.iotdb.db.queryengine.plan.analyze.lock.SchemaLockType;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.ClusterConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.AlterTableAddColumnTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.CreateTableTask;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableMetadataImpl;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema;
import org.apache.iotdb.db.queryengine.plan.relational.type.InternalTypeManager;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.iotdb.db.schemaengine.table.InformationSchemaUtils;
import org.apache.iotdb.db.utils.EncodingInferenceUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.type.StringType;
import org.apache.tsfile.read.common.type.TypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableHeaderSchemaValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableHeaderSchemaValidator.class);
    private final ClusterConfigTaskExecutor configTaskExecutor = ClusterConfigTaskExecutor.getInstance();

    private TableHeaderSchemaValidator() {
    }

    public static TableHeaderSchemaValidator getInstance() {
        return TableHeaderSchemaValidatorHolder.INSTANCE;
    }

    public Optional<TableSchema> validateTableHeaderSchema(String database, TableSchema tableSchema, MPPQueryContext context, boolean allowCreateTable, boolean isStrictIdColumn) throws LoadAnalyzeTableColumnDisorderException {
        InformationSchemaUtils.checkDBNameInWrite(database);
        DataNodeSchemaLockManager.getInstance().takeReadLock(context, SchemaLockType.VALIDATE_VS_DELETION);
        List<ColumnSchema> inputColumnList = tableSchema.getColumns();
        if (inputColumnList == null || inputColumnList.isEmpty()) {
            throw new IllegalArgumentException("No column other than Time present, please check the request");
        }
        TsTable table = DataNodeTableCache.getInstance().getTableInWrite(database, tableSchema.getTableName());
        ArrayList<ColumnSchema> missingColumnList = new ArrayList<ColumnSchema>();
        boolean isAutoCreateSchemaEnabled = IoTDBDescriptor.getInstance().getConfig().isAutoCreateSchemaEnabled();
        if (table == null) {
            if (allowCreateTable && isAutoCreateSchemaEnabled) {
                this.autoCreateTable(database, tableSchema);
                table = DataNodeTableCache.getInstance().getTable(database, tableSchema.getTableName());
                if (table == null) {
                    throw new IllegalStateException("auto create table succeed, but cannot get table schema in current node's DataNodeTableCache, may be caused by concurrently auto creating table");
                }
            } else {
                TableMetadataImpl.throwTableNotExistsException(database, tableSchema.getTableName());
            }
        } else if (isStrictIdColumn) {
            String idName;
            List realIdColumns = table.getIdColumnSchemaList();
            List<ColumnSchema> incomingIdColumns = tableSchema.getIdColumns();
            if (realIdColumns.size() <= incomingIdColumns.size()) {
                for (int indexReal = 0; indexReal < realIdColumns.size(); ++indexReal) {
                    idName = ((TsTableColumnSchema)realIdColumns.get(indexReal)).getColumnName();
                    int indexIncoming = tableSchema.getIndexAmongIdColumns(idName);
                    if (indexIncoming == indexReal) continue;
                    throw new LoadAnalyzeTableColumnDisorderException(String.format("Can not create table because incoming table has no less id columns than existing table, and the existing id columns are not the prefix of the incoming id columns. Existing id column: %s, index in existing table: %s, index in incoming table: %s", idName, indexReal, indexIncoming));
                }
            } else {
                for (int indexIncoming = 0; indexIncoming < incomingIdColumns.size(); ++indexIncoming) {
                    idName = ((ColumnSchema)incomingIdColumns.get(indexIncoming)).getName();
                    int indexReal = table.getIdColumnOrdinal(idName);
                    if (indexReal == indexIncoming) continue;
                    throw new LoadAnalyzeTableColumnDisorderException(String.format("Can not create table because existing table has more id columns than incoming table, and the incoming id columns are not the prefix of the existing id columns. Incoming id column: %s, index in existing table: %s, index in incoming table: %s", idName, indexReal, indexIncoming));
                }
            }
        }
        boolean refreshed = false;
        for (ColumnSchema columnSchema : inputColumnList) {
            TsTableColumnSchema existingColumn = table.getColumnSchema(columnSchema.getName());
            if (Objects.isNull(existingColumn)) {
                if (!refreshed) {
                    refreshed = true;
                    table = DataNodeTableCache.getInstance().getTable(database, tableSchema.getTableName());
                    existingColumn = table.getColumnSchema(columnSchema.getName());
                }
                if (!Objects.isNull(existingColumn)) continue;
                if (columnSchema.getColumnCategory() == null) {
                    throw new SemanticException(String.format("Unknown column category for %s. Cannot auto create column.", columnSchema.getName()), TSStatusCode.COLUMN_NOT_EXISTS.getStatusCode());
                }
                if (columnSchema.getType() == null) {
                    throw new SemanticException(String.format("Unknown column data type for %s. Cannot auto create column.", columnSchema.getName()), TSStatusCode.COLUMN_NOT_EXISTS.getStatusCode());
                }
                missingColumnList.add(columnSchema);
                continue;
            }
            if (columnSchema.getColumnCategory() == null || existingColumn.getColumnCategory().equals((Object)columnSchema.getColumnCategory())) continue;
            throw new SemanticException(String.format("Wrong category at column %s.", columnSchema.getName()), TSStatusCode.COLUMN_CATEGORY_MISMATCH.getStatusCode());
        }
        ArrayList<ColumnSchema> resultColumnList = new ArrayList<ColumnSchema>();
        if (!missingColumnList.isEmpty() && isAutoCreateSchemaEnabled) {
            this.autoCreateColumn(database, tableSchema.getTableName(), missingColumnList, context);
            table = DataNodeTableCache.getInstance().getTable(database, tableSchema.getTableName());
        } else if (!missingColumnList.isEmpty() && !IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
            throw new SemanticException(String.format("Missing columns %s.", missingColumnList.stream().map(ColumnSchema::getName).collect(Collectors.toList())), TSStatusCode.COLUMN_NOT_EXISTS.getStatusCode());
        }
        table.getColumnList().forEach(o -> resultColumnList.add(new ColumnSchema(o.getColumnName(), TypeFactory.getType((TSDataType)o.getDataType()), false, o.getColumnCategory())));
        return Optional.of(new TableSchema(tableSchema.getTableName(), resultColumnList));
    }

    private void autoCreateTable(String database, TableSchema tableSchema) {
        TsTable tsTable = new TsTable(tableSchema.getTableName());
        this.addColumnSchema(tableSchema.getColumns(), tsTable);
        CreateTableTask createTableTask = new CreateTableTask(tsTable, database, true);
        try {
            ListenableFuture<ConfigTaskResult> future = createTableTask.execute(this.configTaskExecutor);
            ConfigTaskResult result = (ConfigTaskResult)future.get();
            if (result.getStatusCode().getStatusCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new RuntimeException(new IoTDBException("Auto create table column failed.", result.getStatusCode().getStatusCode()));
            }
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void addColumnSchema(List<ColumnSchema> columnSchemas, TsTable tsTable) {
        for (ColumnSchema columnSchema : columnSchemas) {
            TsTableColumnCategory category = columnSchema.getColumnCategory();
            if (category == null) {
                throw new ColumnCreationFailException("Cannot create column " + columnSchema.getName() + " category is not provided");
            }
            String columnName = columnSchema.getName();
            if (tsTable.getColumnSchema(columnName) != null) {
                throw new SemanticException(String.format("Columns in table shall not share the same name %s.", columnName));
            }
            TSDataType dataType = InternalTypeManager.getTSDataType(columnSchema.getType());
            if (dataType == null) {
                throw new ColumnCreationFailException("Cannot create column " + columnSchema.getName() + " datatype is not provided");
            }
            tsTable.addColumnSchema(TableHeaderSchemaValidator.generateColumnSchema(category, columnName, dataType));
        }
    }

    public static TsTableColumnSchema generateColumnSchema(TsTableColumnCategory category, String columnName, TSDataType dataType) {
        switch (category) {
            case TAG: {
                if (!TSDataType.STRING.equals((Object)dataType)) {
                    throw new SemanticException("DataType of TAG Column should only be STRING, current is " + dataType);
                }
                return new TagColumnSchema(columnName, dataType);
            }
            case ATTRIBUTE: {
                if (!TSDataType.STRING.equals((Object)dataType)) {
                    throw new SemanticException("DataType of ATTRIBUTE Column should only be STRING, current is " + dataType);
                }
                return new AttributeColumnSchema(columnName, dataType);
            }
            case TIME: {
                throw new SemanticException("Create table or add column statement shall not specify column category TIME");
            }
            case FIELD: {
                return new FieldColumnSchema(columnName, dataType, EncodingInferenceUtils.getDefaultEncoding(dataType), TSFileDescriptor.getInstance().getConfig().getCompressor());
            }
        }
        throw new IllegalArgumentException();
    }

    private void autoCreateColumn(String database, String tableName, List<ColumnSchema> inputColumnList, MPPQueryContext context) {
        AlterTableAddColumnTask task = new AlterTableAddColumnTask(database, tableName, this.parseInputColumnSchema(inputColumnList), context.getQueryId().getId(), true, true);
        try {
            ListenableFuture<ConfigTaskResult> future = task.execute(this.configTaskExecutor);
            ConfigTaskResult result = (ConfigTaskResult)future.get();
            if (result.getStatusCode().getStatusCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new RuntimeException(new IoTDBException(String.format("Auto add table column failed: %s.%s, %s", database, tableName, inputColumnList), result.getStatusCode().getStatusCode()));
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.warn("Auto add table column failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private List<TsTableColumnSchema> parseInputColumnSchema(List<ColumnSchema> inputColumnList) {
        ArrayList<TsTableColumnSchema> columnSchemaList = new ArrayList<TsTableColumnSchema>(inputColumnList.size());
        block6: for (ColumnSchema inputColumn : inputColumnList) {
            switch (inputColumn.getColumnCategory()) {
                case TAG: {
                    if (!inputColumn.getType().equals(StringType.STRING)) {
                        throw new SemanticException("Tag column only support data type STRING.");
                    }
                    columnSchemaList.add((TsTableColumnSchema)new TagColumnSchema(inputColumn.getName(), TSDataType.STRING));
                    continue block6;
                }
                case ATTRIBUTE: {
                    if (!inputColumn.getType().equals(StringType.STRING)) {
                        throw new SemanticException("Attribute column only support data type STRING.");
                    }
                    columnSchemaList.add((TsTableColumnSchema)new AttributeColumnSchema(inputColumn.getName(), TSDataType.STRING));
                    continue block6;
                }
                case FIELD: {
                    TSDataType dataType = InternalTypeManager.getTSDataType(inputColumn.getType());
                    columnSchemaList.add((TsTableColumnSchema)new FieldColumnSchema(inputColumn.getName(), dataType, EncodingInferenceUtils.getDefaultEncoding(dataType), TSFileDescriptor.getInstance().getConfig().getCompressor()));
                    continue block6;
                }
                case TIME: {
                    throw new SemanticException("Adding column for column category " + inputColumn.getColumnCategory() + " is not supported");
                }
            }
            throw new IllegalStateException("Unknown ColumnCategory for adding column: " + inputColumn.getColumnCategory());
        }
        return columnSchemaList;
    }

    private static class TableHeaderSchemaValidatorHolder {
        private static final TableHeaderSchemaValidator INSTANCE = new TableHeaderSchemaValidator();

        private TableHeaderSchemaValidatorHolder() {
        }
    }
}

