/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.write;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.runtime.SerializationRunTimeException;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.AbstractDeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteNodeType;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALWriteUtils;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.factory.TimeFilterApi;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteDataNode
extends AbstractDeleteDataNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteDataNode.class);
    private static final int FIXED_SERIALIZED_SIZE = 30;
    private final List<MeasurementPath> pathList;
    private final long deleteStartTime;
    private final long deleteEndTime;

    public DeleteDataNode(PlanNodeId id, List<MeasurementPath> pathList, long deleteStartTime, long deleteEndTime) {
        super(id);
        this.pathList = pathList;
        this.deleteStartTime = deleteStartTime;
        this.deleteEndTime = deleteEndTime;
    }

    public DeleteDataNode(PlanNodeId id, List<MeasurementPath> pathList, long deleteStartTime, long deleteEndTime, ProgressIndex progressIndex) {
        super(id);
        this.pathList = pathList;
        this.deleteStartTime = deleteStartTime;
        this.deleteEndTime = deleteEndTime;
        this.progressIndex = progressIndex;
    }

    public DeleteDataNode(PlanNodeId id, List<MeasurementPath> pathList, long deleteStartTime, long deleteEndTime, TRegionReplicaSet regionReplicaSet) {
        super(id);
        this.pathList = pathList;
        this.deleteStartTime = deleteStartTime;
        this.deleteEndTime = deleteEndTime;
        this.regionReplicaSet = regionReplicaSet;
    }

    public static DeleteDataNode deserializeFromWAL(DataInputStream stream) throws IOException {
        long searchIndex = stream.readLong();
        int size = stream.readInt();
        ArrayList<MeasurementPath> pathList = new ArrayList<MeasurementPath>(size);
        for (int i = 0; i < size; ++i) {
            try {
                pathList.add(new MeasurementPath(ReadWriteIOUtils.readString((InputStream)stream)));
                continue;
            }
            catch (IllegalPathException e) {
                throw new IllegalArgumentException("Cannot deserialize InsertRowNode", e);
            }
        }
        long deleteStartTime = stream.readLong();
        long deleteEndTime = stream.readLong();
        DeleteDataNode deleteDataNode = new DeleteDataNode(new PlanNodeId(""), pathList, deleteStartTime, deleteEndTime);
        deleteDataNode.setSearchIndex(searchIndex);
        return deleteDataNode;
    }

    public static DeleteDataNode deserializeFromWAL(ByteBuffer buffer) {
        long searchIndex = buffer.getLong();
        int size = buffer.getInt();
        ArrayList<MeasurementPath> pathList = new ArrayList<MeasurementPath>(size);
        for (int i = 0; i < size; ++i) {
            try {
                pathList.add(new MeasurementPath(ReadWriteIOUtils.readString((ByteBuffer)buffer)));
                continue;
            }
            catch (IllegalPathException e) {
                throw new IllegalArgumentException("Cannot deserialize InsertRowNode", e);
            }
        }
        long deleteStartTime = buffer.getLong();
        long deleteEndTime = buffer.getLong();
        DeleteDataNode deleteDataNode = new DeleteDataNode(new PlanNodeId(""), pathList, deleteStartTime, deleteEndTime);
        deleteDataNode.setSearchIndex(searchIndex);
        return deleteDataNode;
    }

    public static DeleteDataNode deserialize(ByteBuffer byteBuffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<MeasurementPath> pathList = new ArrayList<MeasurementPath>(size);
        for (int i = 0; i < size; ++i) {
            pathList.add((MeasurementPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer));
        }
        long deleteStartTime = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        long deleteEndTime = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        int ignoredChildrenSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        return new DeleteDataNode(planNodeId, pathList, deleteStartTime, deleteEndTime);
    }

    public static DeleteDataNode deserializeFromDAL(ByteBuffer byteBuffer) {
        short nodeType = byteBuffer.getShort();
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<MeasurementPath> pathList = new ArrayList<MeasurementPath>(size);
        for (int i = 0; i < size; ++i) {
            pathList.add((MeasurementPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer));
        }
        long deleteStartTime = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        long deleteEndTime = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        ProgressIndex deserializedIndex = ProgressIndexType.deserializeFrom((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        int ignoredChildrenSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        return new DeleteDataNode(planNodeId, pathList, deleteStartTime, deleteEndTime, deserializedIndex);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ByteBuffer serializeToDAL() {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            ByteBuffer byteBuffer;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                DeleteNodeType.TREE_DELETE_NODE.serialize(outputStream);
                this.serializeAttributes(outputStream);
                this.progressIndex.serialize((OutputStream)outputStream);
                this.id.serialize(outputStream);
                ReadWriteIOUtils.write((int)0, (OutputStream)outputStream);
                byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            }
            return byteBuffer;
        }
        catch (IOException e) {
            LOGGER.error("Unexpected error occurs when serializing deleteDataNode.", (Throwable)e);
            throw new SerializationRunTimeException((Throwable)e);
        }
    }

    public List<MeasurementPath> getPathList() {
        return this.pathList;
    }

    public long getDeleteStartTime() {
        return this.deleteStartTime;
    }

    public long getDeleteEndTime() {
        return this.deleteEndTime;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.DELETE_DATA;
    }

    @Override
    public PlanNode clone() {
        return new DeleteDataNode(this.getPlanNodeId(), this.pathList, this.deleteStartTime, this.deleteEndTime);
    }

    @Override
    public int serializedSize() {
        int size = 30;
        for (PartialPath partialPath : this.pathList) {
            size += ReadWriteIOUtils.sizeToWrite((String)partialPath.getFullPath());
        }
        return size;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        buffer.putShort(PlanNodeType.DELETE_DATA.getNodeType());
        buffer.putLong(this.searchIndex);
        buffer.putInt(this.pathList.size());
        for (PartialPath partialPath : this.pathList) {
            WALWriteUtils.write(partialPath.getFullPath(), buffer);
        }
        buffer.putLong(this.deleteStartTime);
        buffer.putLong(this.deleteEndTime);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.DELETE_DATA.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.pathList.size(), (ByteBuffer)byteBuffer);
        for (PartialPath partialPath : this.pathList) {
            partialPath.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((long)this.deleteStartTime, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.deleteEndTime, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.DELETE_DATA.serialize(stream);
        ReadWriteIOUtils.write((int)this.pathList.size(), (OutputStream)stream);
        for (PartialPath partialPath : this.pathList) {
            partialPath.serialize((OutputStream)stream);
        }
        ReadWriteIOUtils.write((long)this.deleteStartTime, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.deleteEndTime, (OutputStream)stream);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitDeleteData(this, context);
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DeleteDataNode that = (DeleteDataNode)obj;
        return this.getPlanNodeId().equals(that.getPlanNodeId()) && Objects.equals(this.pathList, that.pathList) && Objects.equals(this.deleteStartTime, that.deleteStartTime) && Objects.equals(this.deleteEndTime, that.deleteEndTime) && Objects.equals(this.progressIndex, that.progressIndex);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getPlanNodeId(), this.pathList, this.deleteStartTime, this.deleteEndTime, this.progressIndex);
    }

    public String toString() {
        return String.format("DeleteDataNode-%s[ Paths: %s, Region: %s, ProgressIndex: %s]", this.getPlanNodeId(), this.pathList, this.regionReplicaSet == null ? "Not Assigned" : this.regionReplicaSet.getRegionId(), this.progressIndex == null ? "Not Assigned" : this.progressIndex);
    }

    @Override
    public List<WritePlanNode> splitByPartition(IAnalysis analysis) {
        ISchemaTree schemaTree = ((Analysis)analysis).getSchemaTree();
        DataPartition dataPartition = analysis.getDataPartitionInfo();
        HashMap<TRegionReplicaSet, List<MeasurementPath>> regionToPatternMap = new HashMap<TRegionReplicaSet, List<MeasurementPath>>();
        for (MeasurementPath pathPattern : this.pathList) {
            if (pathPattern.getTailNode().equals("**")) {
                this.splitPathPatternByDevice((PartialPath)pathPattern, pathPattern, schemaTree, dataPartition, regionToPatternMap);
            }
            this.splitPathPatternByDevice(pathPattern.getDevicePath(), pathPattern, schemaTree, dataPartition, regionToPatternMap);
        }
        return regionToPatternMap.keySet().stream().map(o -> new DeleteDataNode(this.getPlanNodeId(), (List<MeasurementPath>)(this.pathList.size() < ((List)regionToPatternMap.get(o)).size() ? this.pathList : (List)regionToPatternMap.get(o)), this.deleteStartTime, this.deleteEndTime, (TRegionReplicaSet)o)).collect(Collectors.toList());
    }

    private void splitPathPatternByDevice(PartialPath devicePattern, MeasurementPath pathPattern, ISchemaTree schemaTree, DataPartition dataPartition, Map<TRegionReplicaSet, List<MeasurementPath>> regionToPatternMap) {
        for (DeviceSchemaInfo deviceSchemaInfo : schemaTree.getMatchedDevices(devicePattern)) {
            PartialPath devicePath = deviceSchemaInfo.getDevicePath();
            dataPartition.getDataRegionReplicaSetWithTimeFilter(devicePath.getIDeviceIDAsFullDevice(), (Filter)TimeFilterApi.between((long)this.deleteStartTime, (long)this.deleteEndTime)).stream().filter(regionReplicaSet -> regionReplicaSet.getRegionId() != null).forEach(regionReplicaSet -> regionToPatternMap.computeIfAbsent((TRegionReplicaSet)regionReplicaSet, o -> new ArrayList()).addAll(pathPattern.alterPrefixPath(devicePath).stream().map(d -> (MeasurementPath)d).collect(Collectors.toList())));
        }
    }
}

