/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe.PipeFunctionSupport;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AlterPipe;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.AlterPipeStatement;

public class AlterPipeTask
implements IConfigTask {
    private final AlterPipeStatement alterPipeStatement;

    public AlterPipeTask(AlterPipeStatement alterPipeStatement) {
        this.applyNowFunctionToExtractorAttributes(alterPipeStatement.getExtractorAttributes());
        this.alterPipeStatement = alterPipeStatement;
    }

    public AlterPipeTask(AlterPipe node) {
        this.alterPipeStatement = new AlterPipeStatement(StatementType.ALTER_PIPE);
        this.alterPipeStatement.setPipeName(node.getPipeName());
        this.alterPipeStatement.setIfExists(node.hasIfExistsCondition());
        this.applyNowFunctionToExtractorAttributes(node.getExtractorAttributes());
        this.alterPipeStatement.setExtractorAttributes(node.getExtractorAttributes());
        this.alterPipeStatement.setProcessorAttributes(node.getProcessorAttributes());
        this.alterPipeStatement.setConnectorAttributes(node.getConnectorAttributes());
        this.alterPipeStatement.setReplaceAllExtractorAttributes(node.isReplaceAllExtractorAttributes());
        this.alterPipeStatement.setReplaceAllProcessorAttributes(node.isReplaceAllProcessorAttributes());
        this.alterPipeStatement.setReplaceAllConnectorAttributes(node.isReplaceAllConnectorAttributes());
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.alterPipe(this.alterPipeStatement);
    }

    private void applyNowFunctionToExtractorAttributes(Map<String, String> attributes) {
        long currentTime = CommonDateTimeUtils.convertMilliTimeWithPrecision((long)System.currentTimeMillis(), (String)CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
        PipeFunctionSupport.applyNowFunctionToExtractorAttributes(attributes, "source.start-time", "extractor.start-time", currentTime);
        PipeFunctionSupport.applyNowFunctionToExtractorAttributes(attributes, "source.end-time", "extractor.end-time", currentTime);
        PipeFunctionSupport.applyNowFunctionToExtractorAttributes(attributes, "source.history.start-time", "extractor.history.start-time", currentTime);
        PipeFunctionSupport.applyNowFunctionToExtractorAttributes(attributes, "source.history.end-time", "extractor.history.end-time", currentTime);
    }
}

