/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.load;

import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.exception.load.LoadAnalyzeException;
import org.apache.iotdb.db.exception.load.LoadAnalyzeTypeMismatchException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LoadTsFile;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.load.converter.LoadTsFileDataTypeConverter;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoadTsFileAnalyzer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFileAnalyzer.class);
    private final LoadTsFileStatement loadTsFileTreeStatement;
    private final LoadTsFile loadTsFileTableStatement;
    private final boolean isTableModelStatement;
    private final boolean isGeneratedByPipe;
    protected final List<File> tsFiles;
    protected final String statementString;
    protected final boolean isVerifySchema;
    protected final boolean isDeleteAfterLoad;
    protected final boolean isConvertOnTypeMismatch;
    protected final boolean isAutoCreateDatabase;
    protected final int databaseLevel;
    protected final String database;
    final MPPQueryContext context;
    final IPartitionFetcher partitionFetcher = ClusterPartitionFetcher.getInstance();
    final ISchemaFetcher schemaFetcher = ClusterSchemaFetcher.getInstance();

    LoadTsFileAnalyzer(LoadTsFileStatement loadTsFileStatement, boolean isGeneratedByPipe, MPPQueryContext context) {
        this.loadTsFileTreeStatement = loadTsFileStatement;
        this.tsFiles = loadTsFileStatement.getTsFiles();
        this.statementString = loadTsFileStatement.toString();
        this.isVerifySchema = loadTsFileStatement.isVerifySchema();
        this.isDeleteAfterLoad = loadTsFileStatement.isDeleteAfterLoad();
        this.isConvertOnTypeMismatch = loadTsFileStatement.isConvertOnTypeMismatch();
        this.isAutoCreateDatabase = loadTsFileStatement.isAutoCreateDatabase();
        this.databaseLevel = loadTsFileStatement.getDatabaseLevel();
        this.database = loadTsFileStatement.getDatabase();
        this.loadTsFileTableStatement = null;
        this.isTableModelStatement = false;
        this.isGeneratedByPipe = isGeneratedByPipe;
        this.context = context;
    }

    LoadTsFileAnalyzer(LoadTsFile loadTsFileTableStatement, boolean isGeneratedByPipe, MPPQueryContext context) {
        this.loadTsFileTableStatement = loadTsFileTableStatement;
        this.tsFiles = loadTsFileTableStatement.getTsFiles();
        this.statementString = loadTsFileTableStatement.toString();
        this.isVerifySchema = true;
        this.isDeleteAfterLoad = loadTsFileTableStatement.isDeleteAfterLoad();
        this.isConvertOnTypeMismatch = loadTsFileTableStatement.isConvertOnTypeMismatch();
        this.isAutoCreateDatabase = loadTsFileTableStatement.isAutoCreateDatabase();
        this.databaseLevel = loadTsFileTableStatement.getDatabaseLevel();
        this.database = loadTsFileTableStatement.getDatabase();
        this.loadTsFileTreeStatement = null;
        this.isTableModelStatement = true;
        this.isGeneratedByPipe = isGeneratedByPipe;
        this.context = context;
    }

    public abstract IAnalysis analyzeFileByFile(IAnalysis var1);

    protected boolean doAnalyzeFileByFile(IAnalysis analysis) {
        int tsfileNum = this.tsFiles.size();
        for (int i = 0; i < tsfileNum; ++i) {
            File tsFile = this.tsFiles.get(i);
            if (tsFile.length() == 0L) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("TsFile {} is empty.", (Object)tsFile.getPath());
                }
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Load - Analysis Stage: {}/{} tsfiles have been analyzed, progress: {}%", new Object[]{i + 1, tsfileNum, String.format("%.3f", (double)(i + 1) * 100.0 / (double)tsfileNum)});
                continue;
            }
            try {
                this.analyzeSingleTsFile(tsFile);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Load - Analysis Stage: {}/{} tsfiles have been analyzed, progress: {}%", new Object[]{i + 1, tsfileNum, String.format("%.3f", (double)(i + 1) * 100.0 / (double)tsfileNum)});
                continue;
            }
            catch (AuthException e) {
                this.setFailAnalysisForAuthException(analysis, e);
                return false;
            }
            catch (LoadAnalyzeException e) {
                this.executeTabletConversion(analysis, e);
                return false;
            }
            catch (BufferUnderflowException e) {
                LOGGER.warn("The file {} is not a valid tsfile. Please check the input file.", (Object)tsFile.getPath(), (Object)e);
                throw new SemanticException(String.format("The file %s is not a valid tsfile. Please check the input file.", tsFile.getPath()));
            }
            catch (Exception e) {
                String exceptionMessage = String.format("Loading file %s failed. Detail: %s", tsFile.getPath(), e.getMessage() == null ? e.getClass().getName() : e.getMessage());
                LOGGER.warn(exceptionMessage, (Throwable)e);
                analysis.setFinishQueryAfterAnalyze(true);
                analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.LOAD_FILE_ERROR, (String)exceptionMessage));
                return false;
            }
        }
        return true;
    }

    protected abstract void analyzeSingleTsFile(File var1) throws IOException, AuthException, LoadAnalyzeException;

    protected void executeTabletConversion(IAnalysis analysis, LoadAnalyzeException e) {
        TSStatus status;
        LoadTsFileDataTypeConverter loadTsFileDataTypeConverter = new LoadTsFileDataTypeConverter(this.isGeneratedByPipe);
        TSStatus tSStatus = !(e instanceof LoadAnalyzeTypeMismatchException) || this.isConvertOnTypeMismatch ? (this.isTableModelStatement ? (TSStatus)loadTsFileDataTypeConverter.convertForTableModel(this.loadTsFileTableStatement).orElse(null) : (TSStatus)loadTsFileDataTypeConverter.convertForTreeModel(this.loadTsFileTreeStatement).orElse(null)) : (status = null);
        if (status == null) {
            analysis.setFailStatus(new TSStatus(TSStatusCode.LOAD_FILE_ERROR.getStatusCode()).setMessage(e.getMessage()));
        } else if (!loadTsFileDataTypeConverter.isSuccessful(status)) {
            analysis.setFailStatus(status);
        }
        analysis.setFinishQueryAfterAnalyze(true);
        this.setRealStatement(analysis);
    }

    protected void setRealStatement(IAnalysis analysis) {
        if (!this.isTableModelStatement) {
            analysis.setRealStatement(this.loadTsFileTreeStatement);
        }
    }

    protected String getStatementString() {
        return this.statementString;
    }

    protected TsFileResource constructTsFileResource(TsFileSequenceReader reader, File tsFile) throws IOException {
        TsFileResource tsFileResource = new TsFileResource(tsFile);
        if (!tsFileResource.resourceFileExists()) {
            tsFileResource.updatePlanIndexes(reader.getMinPlanIndex());
            tsFileResource.updatePlanIndexes(reader.getMaxPlanIndex());
        } else {
            tsFileResource.deserialize();
        }
        return tsFileResource;
    }

    protected void addTsFileResource(TsFileResource tsFileResource) {
        if (this.isTableModelStatement) {
            this.loadTsFileTableStatement.addTsFileResource(tsFileResource);
        } else {
            this.loadTsFileTreeStatement.addTsFileResource(tsFileResource);
        }
    }

    protected void addWritePointCount(long writePointCount) {
        if (this.isTableModelStatement) {
            this.loadTsFileTableStatement.addWritePointCount(writePointCount);
        } else {
            this.loadTsFileTreeStatement.addWritePointCount(writePointCount);
        }
    }

    protected boolean isVerifySchema() {
        return this.isVerifySchema;
    }

    protected boolean isConvertOnTypeMismatch() {
        return this.isConvertOnTypeMismatch;
    }

    protected boolean isAutoCreateDatabase() {
        return this.isAutoCreateDatabase;
    }

    protected int getDatabaseLevel() {
        return this.databaseLevel;
    }

    protected long getWritePointCount(Map<IDeviceID, List<TimeseriesMetadata>> device2TimeseriesMetadata) {
        return device2TimeseriesMetadata.values().stream().flatMap(Collection::stream).mapToLong(t -> t.getStatistics().getCount()).sum();
    }

    protected void setFailAnalysisForAuthException(IAnalysis analysis, AuthException e) {
        analysis.setFinishQueryAfterAnalyze(true);
        analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)e.getCode(), (String)e.getMessage()));
    }

    protected void checkBeforeAnalyzeFileByFile(IAnalysis analysis) {
        if (TSFileDescriptor.getInstance().getConfig().getEncryptFlag()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.LOAD_FILE_ERROR, (String)"TSFile encryption is enabled, and the Load TSFile function is disabled"));
            return;
        }
        if (CommonDescriptor.getInstance().getConfig().isReadOnly()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SYSTEM_READ_ONLY, (String)"Current system mode is read only, does not support load file"));
            return;
        }
    }
}

