/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.partition;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.commons.partition.SeriesPartitionTable;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchemaResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetDatabaseReq;
import org.apache.iotdb.confignode.rpc.thrift.TRegionRouteMapResp;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.partition.DatabaseCacheResult;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.MetaUtils;
import org.apache.iotdb.db.service.metrics.CacheMetrics;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionCache {
    private static final Logger logger = LoggerFactory.getLogger(PartitionCache.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final List<String> ROOT_PATH = Arrays.asList("root", "**");
    private final String seriesSlotExecutorName = config.getSeriesPartitionExecutorClass();
    private final int seriesPartitionSlotNum = config.getSeriesPartitionSlotNum();
    private final SeriesPartitionExecutor partitionExecutor;
    private final Set<String> databaseCache = new HashSet<String>();
    private final Cache<String, SchemaPartitionTable> schemaPartitionCache;
    private final Cache<String, DataPartitionTable> dataPartitionCache;
    private final AtomicLong latestUpdateTime = new AtomicLong(0L);
    private final Map<TConsensusGroupId, TRegionReplicaSet> groupIdToReplicaSetMap = new HashMap<TConsensusGroupId, TRegionReplicaSet>();
    private final ReentrantReadWriteLock databaseCacheLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock schemaPartitionCacheLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock dataPartitionCacheLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock regionReplicaSetLock = new ReentrantReadWriteLock();
    private final IClientManager<ConfigRegionId, ConfigNodeClient> configNodeClientManager = ConfigNodeClientManager.getInstance();
    private final CacheMetrics cacheMetrics;

    public PartitionCache() {
        this.schemaPartitionCache = Caffeine.newBuilder().maximumSize((long)config.getPartitionCacheSize()).build();
        this.dataPartitionCache = Caffeine.newBuilder().maximumSize((long)config.getPartitionCacheSize()).build();
        this.partitionExecutor = SeriesPartitionExecutor.getSeriesPartitionExecutor((String)this.seriesSlotExecutorName, (int)this.seriesPartitionSlotNum);
        this.cacheMetrics = new CacheMetrics();
    }

    public Map<String, List<IDeviceID>> getDatabaseToDevice(List<IDeviceID> deviceIDs, boolean tryToFetch, boolean isAutoCreate, String userName) {
        DatabaseCacheResult<String, List<IDeviceID>> result = new DatabaseCacheResult<String, List<IDeviceID>>(){

            @Override
            public void put(IDeviceID device, String databaseName) {
                this.map.computeIfAbsent(databaseName, k -> new ArrayList()).add(device);
            }
        };
        this.getDatabaseCacheResult(result, deviceIDs, tryToFetch, isAutoCreate, userName);
        return result.getMap();
    }

    public Map<IDeviceID, String> getDeviceToDatabase(List<IDeviceID> deviceIDs, boolean tryToFetch, boolean isAutoCreate, String userName) {
        DatabaseCacheResult<IDeviceID, String> result = new DatabaseCacheResult<IDeviceID, String>(){

            @Override
            public void put(IDeviceID device, String databaseName) {
                this.map.put(device, databaseName);
            }
        };
        this.getDatabaseCacheResult(result, deviceIDs, tryToFetch, isAutoCreate, userName);
        return result.getMap();
    }

    private String getDatabaseName(IDeviceID deviceID) {
        for (String database : this.databaseCache) {
            if (!PathUtils.isStartWith((IDeviceID)deviceID, (String)database)) continue;
            return database;
        }
        return null;
    }

    private boolean containsDatabase(String database) {
        try {
            this.databaseCacheLock.readLock().lock();
            boolean bl = this.databaseCache.contains(database);
            return bl;
        }
        finally {
            this.databaseCacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchDatabaseAndUpdateCache(DatabaseCacheResult<?, ?> result, List<IDeviceID> deviceIDs) throws ClientManagerException, TException {
        this.databaseCacheLock.writeLock().lock();
        try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetDatabaseReq req;
            TDatabaseSchemaResp databaseSchemaResp;
            result.reset();
            this.getDatabaseMap(result, deviceIDs, true);
            if (!result.isSuccess() && (databaseSchemaResp = client.getMatchedDatabaseSchemas(req = new TGetDatabaseReq(ROOT_PATH, SchemaConstant.ALL_MATCH_SCOPE_BINARY).setIsTableModel(false))).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                this.updateDatabaseCache(databaseSchemaResp.getDatabaseSchemaMap().keySet());
                this.getDatabaseMap(result, deviceIDs, true);
            }
        }
        finally {
            this.databaseCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchDatabaseAndUpdateCache() throws ClientManagerException, TException {
        this.databaseCacheLock.writeLock().lock();
        try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetDatabaseReq req = new TGetDatabaseReq(ROOT_PATH, SchemaConstant.ALL_MATCH_SCOPE_BINARY).setIsTableModel(true);
            TDatabaseSchemaResp databaseSchemaResp = client.getMatchedDatabaseSchemas(req);
            if (databaseSchemaResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                this.updateDatabaseCache(databaseSchemaResp.getDatabaseSchemaMap().keySet());
            }
        }
        finally {
            this.databaseCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDatabaseAndUpdateCache(DatabaseCacheResult<?, ?> result, List<IDeviceID> deviceIDs, String userName) throws ClientManagerException, MetadataException, TException {
        block17: {
            this.databaseCacheLock.writeLock().lock();
            try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                result.reset();
                this.getDatabaseMap(result, deviceIDs, false);
                if (result.isSuccess()) break block17;
                HashSet<String> databaseNamesNeedCreated = new HashSet<String>();
                for (IDeviceID deviceID : result.getMissedDevices()) {
                    if (PathUtils.isStartWith((IDeviceID)deviceID, (String)"root.__system")) {
                        databaseNamesNeedCreated.add("root.__system");
                        continue;
                    }
                    PartialPath databaseNameNeedCreated = MetaUtils.getDatabasePathByLevel(new PartialPath(deviceID), config.getDefaultStorageGroupLevel());
                    databaseNamesNeedCreated.add(databaseNameNeedCreated.getFullPath());
                }
                HashSet<String> successFullyCreatedDatabase = new HashSet<String>();
                for (String databaseName : databaseNamesNeedCreated) {
                    long startTime = System.nanoTime();
                    try {
                        TSStatus status;
                        if (!AuthorityChecker.SUPER_USER.equals(userName) && (status = AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.MANAGE_DATABASE.ordinal()), PrivilegeType.MANAGE_DATABASE)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            throw new RuntimeException(new IoTDBException(status.getMessage(), status.getCode()));
                        }
                    }
                    finally {
                        PerformanceOverviewMetrics.getInstance().recordAuthCost(System.nanoTime() - startTime);
                    }
                    TDatabaseSchema databaseSchema = new TDatabaseSchema();
                    databaseSchema.setName(databaseName);
                    databaseSchema.setIsTableModel(false);
                    TSStatus tsStatus = client.setDatabase(databaseSchema);
                    if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == tsStatus.getCode() || TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode() == tsStatus.getCode()) {
                        successFullyCreatedDatabase.add(databaseName);
                        continue;
                    }
                    if (TSStatusCode.DATABASE_CONFLICT.getStatusCode() == tsStatus.getCode()) continue;
                    this.updateDatabaseCache(successFullyCreatedDatabase);
                    logger.warn("[{} Cache] failed to create database {}", (Object)"Database", (Object)databaseName);
                    throw new RuntimeException(new IoTDBException(tsStatus.message, tsStatus.code));
                }
                this.updateDatabaseCache(successFullyCreatedDatabase);
                this.getDatabaseMap(result, deviceIDs, false);
            }
            finally {
                this.databaseCacheLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDatabaseAndUpdateCache(String database, String userName) throws ClientManagerException, TException {
        block15: {
            this.databaseCacheLock.writeLock().lock();
            try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                long startTime = System.nanoTime();
                try {
                    TSStatus status;
                    if (!AuthorityChecker.SUPER_USER.equals(userName) && (status = AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.MANAGE_DATABASE.ordinal()), PrivilegeType.MANAGE_DATABASE)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        throw new RuntimeException(new IoTDBException(status.getMessage(), status.getCode()));
                    }
                }
                finally {
                    PerformanceOverviewMetrics.getInstance().recordAuthCost(System.nanoTime() - startTime);
                }
                TDatabaseSchema databaseSchema = new TDatabaseSchema();
                databaseSchema.setName(database);
                databaseSchema.setIsTableModel(true);
                TSStatus tsStatus = client.setDatabase(databaseSchema);
                if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == tsStatus.getCode() || TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode() == tsStatus.getCode()) {
                    this.updateDatabaseCache(Collections.singleton(database));
                    break block15;
                }
                logger.warn("[{} Cache] failed to create database {}", (Object)"Database", (Object)database);
                throw new RuntimeException(new IoTDBException(tsStatus.message, tsStatus.code));
            }
            finally {
                this.databaseCacheLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDatabaseMap(DatabaseCacheResult<?, ?> result, List<IDeviceID> deviceIDs, boolean failFast) {
        try {
            this.databaseCacheLock.readLock().lock();
            result.reset();
            boolean status = true;
            for (IDeviceID devicePath : deviceIDs) {
                String databaseName = this.getDatabaseName(devicePath);
                if (null == databaseName) {
                    logger.debug("[{} Cache] miss when search device {}", (Object)"Database", (Object)devicePath);
                    status = false;
                    if (failFast) break;
                    result.addMissedDevice(devicePath);
                    continue;
                }
                result.put(devicePath, databaseName);
            }
            if (!status) {
                result.setFailed();
            }
            logger.debug("[{} Cache] hit when search device {}", (Object)"Database", deviceIDs);
            this.cacheMetrics.record(status, "Database");
        }
        finally {
            this.databaseCacheLock.readLock().unlock();
        }
    }

    private void getDatabaseCacheResult(DatabaseCacheResult<?, ?> result, List<IDeviceID> deviceIDs, boolean tryToFetch, boolean isAutoCreate, String userName) {
        if (!isAutoCreate) {
            for (IDeviceID deviceID : deviceIDs) {
                for (int i = 0; i < deviceID.segmentNum(); ++i) {
                    if (!((String)deviceID.segment(i)).contains("*")) continue;
                    return;
                }
            }
        }
        this.getDatabaseMap(result, deviceIDs, true);
        if (!result.isSuccess() && tryToFetch) {
            try {
                this.fetchDatabaseAndUpdateCache(result, deviceIDs);
                if (!result.isSuccess() && isAutoCreate) {
                    this.createDatabaseAndUpdateCache(result, deviceIDs, userName);
                    if (!result.isSuccess()) {
                        throw new StatementAnalyzeException("Failed to get database Map");
                    }
                }
            }
            catch (ClientManagerException | MetadataException | TException e) {
                throw new StatementAnalyzeException("An error occurred when executing getDeviceToDatabase():" + e.getMessage(), e);
            }
        }
    }

    public void checkAndAutoCreateDatabase(String database, boolean isAutoCreate, String userName) {
        boolean isExisted = this.containsDatabase(database);
        if (!isExisted) {
            try {
                this.fetchDatabaseAndUpdateCache();
                isExisted = this.containsDatabase(database);
                if (!isExisted && isAutoCreate) {
                    this.createDatabaseAndUpdateCache(database, userName);
                }
            }
            catch (ClientManagerException | TException e) {
                throw new StatementAnalyzeException("An error occurred when executing getDeviceToDatabase():" + e.getMessage());
            }
        }
    }

    public void updateDatabaseCache(Set<String> databaseNames) {
        this.databaseCacheLock.writeLock().lock();
        try {
            this.databaseCache.addAll(databaseNames);
        }
        finally {
            this.databaseCacheLock.writeLock().unlock();
        }
    }

    public void removeFromDatabaseCache() {
        this.databaseCacheLock.writeLock().lock();
        try {
            this.databaseCache.clear();
        }
        finally {
            this.databaseCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRegionReplicaSet getRegionReplicaSet(TConsensusGroupId consensusGroupId) {
        TRegionReplicaSet result;
        this.regionReplicaSetLock.readLock().lock();
        try {
            result = this.groupIdToReplicaSetMap.get(consensusGroupId);
        }
        finally {
            this.regionReplicaSetLock.readLock().unlock();
        }
        if (result == null) {
            this.regionReplicaSetLock.writeLock().lock();
            try {
                if (!this.groupIdToReplicaSetMap.containsKey(consensusGroupId)) {
                    try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                        TRegionRouteMapResp resp = client.getLatestRegionRouteMap();
                        if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == resp.getStatus().getCode()) {
                            this.updateGroupIdToReplicaSetMap(resp.getTimestamp(), resp.getRegionRouteMap());
                        }
                        if (!this.groupIdToReplicaSetMap.containsKey(consensusGroupId)) {
                            throw new RuntimeException("Failed to get replicaSet of consensus group[id= " + consensusGroupId + "]");
                        }
                    }
                    catch (ClientManagerException | TException e) {
                        throw new StatementAnalyzeException("An error occurred when executing getRegionReplicaSet():" + e.getMessage());
                    }
                }
                result = this.groupIdToReplicaSetMap.get(consensusGroupId);
            }
            finally {
                this.regionReplicaSetLock.writeLock().unlock();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateGroupIdToReplicaSetMap(long timestamp, Map<TConsensusGroupId, TRegionReplicaSet> map) {
        this.regionReplicaSetLock.writeLock().lock();
        try {
            boolean result;
            boolean bl = result = timestamp == this.latestUpdateTime.accumulateAndGet(timestamp, Math::max);
            if (result) {
                this.groupIdToReplicaSetMap.clear();
                this.groupIdToReplicaSetMap.putAll(map);
            }
            boolean bl2 = result;
            return bl2;
        }
        finally {
            this.regionReplicaSetLock.writeLock().unlock();
        }
    }

    public void invalidReplicaSetCache() {
        this.regionReplicaSetLock.writeLock().lock();
        try {
            this.groupIdToReplicaSetMap.clear();
        }
        finally {
            this.regionReplicaSetLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaPartition getSchemaPartition(Map<String, List<IDeviceID>> databaseToDeviceMap) {
        this.schemaPartitionCacheLock.readLock().lock();
        try {
            if (databaseToDeviceMap.isEmpty()) {
                this.cacheMetrics.record(false, "SchemaPartition");
                SchemaPartition schemaPartition = null;
                return schemaPartition;
            }
            HashMap<String, Map> schemaPartitionMap = new HashMap<String, Map>();
            for (Map.Entry<String, List<IDeviceID>> entry : databaseToDeviceMap.entrySet()) {
                String databaseName = entry.getKey();
                Map regionReplicaSetMap = schemaPartitionMap.computeIfAbsent(databaseName, k -> new HashMap());
                SchemaPartitionTable schemaPartitionTable = (SchemaPartitionTable)this.schemaPartitionCache.getIfPresent((Object)databaseName);
                if (null == schemaPartitionTable) {
                    logger.debug("[{} Cache] miss when search database {}", (Object)"SchemaPartition", (Object)databaseName);
                    this.cacheMetrics.record(false, "SchemaPartition");
                    SchemaPartition schemaPartition = null;
                    return schemaPartition;
                }
                Map map = schemaPartitionTable.getSchemaPartitionMap();
                for (IDeviceID device : entry.getValue()) {
                    TSeriesPartitionSlot seriesPartitionSlot = this.partitionExecutor.getSeriesPartitionSlot(device);
                    if (!map.containsKey(seriesPartitionSlot)) {
                        logger.debug("[{} Cache] miss when search device {}", (Object)"SchemaPartition", (Object)device);
                        this.cacheMetrics.record(false, "SchemaPartition");
                        SchemaPartition schemaPartition = null;
                        return schemaPartition;
                    }
                    TConsensusGroupId consensusGroupId = (TConsensusGroupId)map.get(seriesPartitionSlot);
                    TRegionReplicaSet regionReplicaSet = this.getRegionReplicaSet(consensusGroupId);
                    regionReplicaSetMap.put(seriesPartitionSlot, regionReplicaSet);
                }
            }
            logger.debug("[{} Cache] hit", (Object)"SchemaPartition");
            this.cacheMetrics.record(true, "SchemaPartition");
            SchemaPartition schemaPartition = new SchemaPartition(schemaPartitionMap, this.seriesSlotExecutorName, this.seriesPartitionSlotNum);
            return schemaPartition;
        }
        finally {
            this.schemaPartitionCacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaPartition getSchemaPartition(String database) {
        this.schemaPartitionCacheLock.readLock().lock();
        try {
            SchemaPartitionTable schemaPartitionTable = (SchemaPartitionTable)this.schemaPartitionCache.getIfPresent((Object)database);
            if (null == schemaPartitionTable) {
                logger.debug("[{} Cache] miss when search database {}", (Object)"SchemaPartition", (Object)database);
                this.cacheMetrics.record(false, "SchemaPartition");
                SchemaPartition schemaPartition = null;
                return schemaPartition;
            }
            HashMap<String, Map> schemaPartitionMap = new HashMap<String, Map>();
            Map regionReplicaSetMap = schemaPartitionMap.computeIfAbsent(database, k -> new HashMap());
            for (Map.Entry entry : schemaPartitionTable.getSchemaPartitionMap().entrySet()) {
                regionReplicaSetMap.put((TSeriesPartitionSlot)entry.getKey(), this.getRegionReplicaSet((TConsensusGroupId)entry.getValue()));
            }
            logger.debug("[{} Cache] hit", (Object)"SchemaPartition");
            this.cacheMetrics.record(true, "SchemaPartition");
            SchemaPartition schemaPartition = new SchemaPartition(schemaPartitionMap, this.seriesSlotExecutorName, this.seriesPartitionSlotNum);
            return schemaPartition;
        }
        finally {
            this.schemaPartitionCacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSchemaPartitionCache(Map<String, Map<TSeriesPartitionSlot, TConsensusGroupId>> schemaPartitionTable) {
        this.schemaPartitionCacheLock.writeLock().lock();
        try {
            for (Map.Entry<String, Map<TSeriesPartitionSlot, TConsensusGroupId>> entry1 : schemaPartitionTable.entrySet()) {
                String databaseName = entry1.getKey();
                SchemaPartitionTable result = (SchemaPartitionTable)this.schemaPartitionCache.getIfPresent((Object)databaseName);
                if (null == result) {
                    result = new SchemaPartitionTable();
                    this.schemaPartitionCache.put((Object)databaseName, (Object)result);
                }
                Map seriesPartitionSlotTConsensusGroupIdMap = result.getSchemaPartitionMap();
                seriesPartitionSlotTConsensusGroupIdMap.putAll(entry1.getValue());
            }
        }
        finally {
            this.schemaPartitionCacheLock.writeLock().unlock();
        }
    }

    public void invalidAllSchemaPartitionCache() {
        this.schemaPartitionCacheLock.writeLock().lock();
        try {
            this.schemaPartitionCache.invalidateAll();
        }
        finally {
            this.schemaPartitionCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataPartition getDataPartition(Map<String, List<DataPartitionQueryParam>> databaseToQueryParamsMap) {
        this.dataPartitionCacheLock.readLock().lock();
        try {
            if (databaseToQueryParamsMap.isEmpty()) {
                this.cacheMetrics.record(false, "DataPartition");
                DataPartition dataPartition = null;
                return dataPartition;
            }
            HashMap<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TRegionReplicaSet>>>> dataPartitionMap = new HashMap<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TRegionReplicaSet>>>>();
            for (Map.Entry<String, List<DataPartitionQueryParam>> entry : databaseToQueryParamsMap.entrySet()) {
                if (null != entry.getValue() && !entry.getValue().isEmpty() && this.getDatabaseDataPartition(dataPartitionMap, entry.getKey(), entry.getValue())) continue;
                this.cacheMetrics.record(false, "DataPartition");
                DataPartition dataPartition = null;
                return dataPartition;
            }
            logger.debug("[{} Cache] hit", (Object)"DataPartition");
            this.cacheMetrics.record(true, "DataPartition");
            DataPartition dataPartition = new DataPartition(dataPartitionMap, this.seriesSlotExecutorName, this.seriesPartitionSlotNum);
            return dataPartition;
        }
        finally {
            this.dataPartitionCacheLock.readLock().unlock();
        }
    }

    private boolean getDatabaseDataPartition(Map<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TRegionReplicaSet>>>> dataPartitionMap, String databaseName, List<DataPartitionQueryParam> dataPartitionQueryParams) {
        DataPartitionTable dataPartitionTable = (DataPartitionTable)this.dataPartitionCache.getIfPresent((Object)databaseName);
        if (null == dataPartitionTable) {
            logger.debug("[{} Cache] miss when search database {}", (Object)"DataPartition", (Object)databaseName);
            return false;
        }
        Map cachedDatabasePartitionMap = dataPartitionTable.getDataPartitionMap();
        Map seriesSlotToTimePartitionMap = dataPartitionMap.computeIfAbsent(databaseName, k -> new HashMap());
        for (DataPartitionQueryParam dataPartitionQueryParam : dataPartitionQueryParams) {
            if (this.getDeviceDataPartition(seriesSlotToTimePartitionMap, dataPartitionQueryParam, cachedDatabasePartitionMap)) continue;
            return false;
        }
        return true;
    }

    private boolean getDeviceDataPartition(Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TRegionReplicaSet>>> seriesSlotToTimePartitionMap, DataPartitionQueryParam dataPartitionQueryParam, Map<TSeriesPartitionSlot, SeriesPartitionTable> cachedDatabasePartitionMap) {
        if (null == dataPartitionQueryParam.getDeviceID()) {
            return false;
        }
        TSeriesPartitionSlot seriesPartitionSlot = this.partitionExecutor.getSeriesPartitionSlot(dataPartitionQueryParam.getDeviceID());
        SeriesPartitionTable cachedSeriesPartitionTable = cachedDatabasePartitionMap.get(seriesPartitionSlot);
        if (null == cachedSeriesPartitionTable) {
            if (logger.isDebugEnabled()) {
                logger.debug("[{} Cache] miss when search device {}", (Object)"DataPartition", (Object)dataPartitionQueryParam.getDeviceID());
            }
            return false;
        }
        Map cachedTimePartitionSlot = cachedSeriesPartitionTable.getSeriesPartitionMap();
        Map timePartitionSlotListMap = seriesSlotToTimePartitionMap.computeIfAbsent(seriesPartitionSlot, k -> new HashMap());
        if (dataPartitionQueryParam.getTimePartitionSlotList().isEmpty()) {
            return false;
        }
        for (TTimePartitionSlot timePartitionSlot : dataPartitionQueryParam.getTimePartitionSlotList()) {
            if (this.getTimeSlotDataPartition(timePartitionSlotListMap, timePartitionSlot, cachedTimePartitionSlot)) continue;
            return false;
        }
        return true;
    }

    private boolean getTimeSlotDataPartition(Map<TTimePartitionSlot, List<TRegionReplicaSet>> timePartitionSlotListMap, TTimePartitionSlot timePartitionSlot, Map<TTimePartitionSlot, List<TConsensusGroupId>> cachedTimePartitionSlot) {
        List<TConsensusGroupId> cacheConsensusGroupId = cachedTimePartitionSlot.get(timePartitionSlot);
        if (null == cacheConsensusGroupId || cacheConsensusGroupId.isEmpty() || null == timePartitionSlot) {
            logger.debug("[{} Cache] miss when search time partition {}", (Object)"DataPartition", (Object)timePartitionSlot);
            return false;
        }
        LinkedList<TRegionReplicaSet> regionReplicaSets = new LinkedList<TRegionReplicaSet>();
        for (TConsensusGroupId consensusGroupId : cacheConsensusGroupId) {
            regionReplicaSets.add(this.getRegionReplicaSet(consensusGroupId));
        }
        timePartitionSlotListMap.put(timePartitionSlot, regionReplicaSets);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDataPartitionCache(Map<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TConsensusGroupId>>>> dataPartitionTable) {
        this.dataPartitionCacheLock.writeLock().lock();
        try {
            for (Map.Entry<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TConsensusGroupId>>>> entry1 : dataPartitionTable.entrySet()) {
                boolean needToUpdateCache;
                String databaseName = entry1.getKey();
                if (null == databaseName) continue;
                DataPartitionTable result = (DataPartitionTable)this.dataPartitionCache.getIfPresent((Object)databaseName);
                boolean bl = needToUpdateCache = null == result;
                if (needToUpdateCache) {
                    result = new DataPartitionTable();
                }
                Map seriesPartitionSlotSeriesPartitionTableMap = result.getDataPartitionMap();
                for (Map.Entry<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TConsensusGroupId>>> entry2 : entry1.getValue().entrySet()) {
                    SeriesPartitionTable seriesPartitionTable;
                    TSeriesPartitionSlot seriesPartitionSlot = entry2.getKey();
                    if (null == seriesPartitionSlot) continue;
                    if (!seriesPartitionSlotSeriesPartitionTableMap.containsKey(seriesPartitionSlot)) {
                        seriesPartitionTable = new SeriesPartitionTable(entry2.getValue());
                        seriesPartitionSlotSeriesPartitionTableMap.put(seriesPartitionSlot, seriesPartitionTable);
                        continue;
                    }
                    seriesPartitionTable = (SeriesPartitionTable)seriesPartitionSlotSeriesPartitionTableMap.get(seriesPartitionSlot);
                    Map result3 = seriesPartitionTable.getSeriesPartitionMap();
                    result3.putAll(entry2.getValue());
                }
                if (!needToUpdateCache) continue;
                this.dataPartitionCache.put((Object)databaseName, (Object)result);
            }
        }
        finally {
            this.dataPartitionCacheLock.writeLock().unlock();
        }
    }

    public void invalidAllDataPartitionCache() {
        this.dataPartitionCacheLock.writeLock().lock();
        try {
            this.dataPartitionCache.invalidateAll();
        }
        finally {
            this.dataPartitionCacheLock.writeLock().unlock();
        }
    }

    public void invalidAllCache() {
        logger.debug("[Partition Cache] invalid");
        this.removeFromDatabaseCache();
        this.invalidAllDataPartitionCache();
        this.invalidAllSchemaPartitionCache();
        this.invalidReplicaSetCache();
        logger.debug("[Partition Cache] is invalid:{}", (Object)this);
    }

    public String toString() {
        return "PartitionCache{, databaseCache=" + this.databaseCache + ", replicaSetCache=" + this.groupIdToReplicaSetMap + ", schemaPartitionCache=" + this.schemaPartitionCache + ", dataPartitionCache=" + this.dataPartitionCache + '}';
    }
}

