/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.GroupedAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.BinaryBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.BooleanBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.DoubleBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.FloatBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.IntBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.LongBigArray;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class GroupedFirstByAccumulator
implements GroupedAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(GroupedFirstByAccumulator.class);
    private final TSDataType xDataType;
    private final TSDataType yDataType;
    private final LongBigArray yFirstTimes = new LongBigArray(Long.MAX_VALUE);
    private final BooleanBigArray inits = new BooleanBigArray();
    private LongBigArray xLongValues;
    private IntBigArray xIntValues;
    private FloatBigArray xFloatValues;
    private DoubleBigArray xDoubleValues;
    private BinaryBigArray xBinaryValues;
    private BooleanBigArray xBooleanValues;
    private final BooleanBigArray xNulls = new BooleanBigArray(true);

    public GroupedFirstByAccumulator(TSDataType xDataType, TSDataType yDataType) {
        this.xDataType = xDataType;
        this.yDataType = yDataType;
        switch (xDataType) {
            case INT32: 
            case DATE: {
                this.xIntValues = new IntBigArray();
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.xLongValues = new LongBigArray();
                break;
            }
            case FLOAT: {
                this.xFloatValues = new FloatBigArray();
                break;
            }
            case DOUBLE: {
                this.xDoubleValues = new DoubleBigArray();
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                this.xBinaryValues = new BinaryBigArray();
                break;
            }
            case BOOLEAN: {
                this.xBooleanValues = new BooleanBigArray();
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type : %s", xDataType));
            }
        }
    }

    @Override
    public long getEstimatedSize() {
        long valuesSize = 0L;
        switch (this.xDataType) {
            case INT32: 
            case DATE: {
                valuesSize += this.xIntValues.sizeOf();
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                valuesSize += this.xLongValues.sizeOf();
                break;
            }
            case FLOAT: {
                valuesSize += this.xFloatValues.sizeOf();
                break;
            }
            case DOUBLE: {
                valuesSize += this.xDoubleValues.sizeOf();
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                valuesSize += this.xBinaryValues.sizeOf();
                break;
            }
            case BOOLEAN: {
                valuesSize += this.xBooleanValues.sizeOf();
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in : %s", this.xDataType));
            }
        }
        return INSTANCE_SIZE + valuesSize + this.yFirstTimes.sizeOf() + this.inits.sizeOf() + this.xNulls.sizeOf();
    }

    @Override
    public void setGroupCount(long groupCount) {
        this.yFirstTimes.ensureCapacity(groupCount);
        this.inits.ensureCapacity(groupCount);
        this.xNulls.ensureCapacity(groupCount);
        switch (this.xDataType) {
            case INT32: 
            case DATE: {
                this.xIntValues.ensureCapacity(groupCount);
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.xLongValues.ensureCapacity(groupCount);
                return;
            }
            case FLOAT: {
                this.xFloatValues.ensureCapacity(groupCount);
                return;
            }
            case DOUBLE: {
                this.xDoubleValues.ensureCapacity(groupCount);
                return;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                this.xBinaryValues.ensureCapacity(groupCount);
                return;
            }
            case BOOLEAN: {
                this.xBooleanValues.ensureCapacity(groupCount);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in : %s", this.xDataType));
    }

    @Override
    public void prepareFinal() {
    }

    @Override
    public void reset() {
        this.yFirstTimes.reset();
        this.inits.reset();
        this.xNulls.reset();
        switch (this.xDataType) {
            case INT32: 
            case DATE: {
                this.xIntValues.reset();
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.xLongValues.reset();
                break;
            }
            case FLOAT: {
                this.xFloatValues.reset();
                break;
            }
            case DOUBLE: {
                this.xDoubleValues.reset();
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                this.xBinaryValues.reset();
                break;
            }
            case BOOLEAN: {
                this.xBooleanValues.reset();
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type : %s", this.xDataType));
            }
        }
    }

    @Override
    public void addInput(int[] groupIds, Column[] arguments) {
        Preconditions.checkArgument((arguments.length == 3 ? 1 : 0) != 0, (Object)"Length of input Column[] for LastBy/FirstBy should be 3");
        switch (this.xDataType) {
            case INT32: 
            case DATE: {
                this.addIntInput(groupIds, arguments[0], arguments[1], arguments[2]);
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.addLongInput(groupIds, arguments[0], arguments[1], arguments[2]);
                return;
            }
            case FLOAT: {
                this.addFloatInput(groupIds, arguments[0], arguments[1], arguments[2]);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(groupIds, arguments[0], arguments[1], arguments[2]);
                return;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                this.addBinaryInput(groupIds, arguments[0], arguments[1], arguments[2]);
                return;
            }
            case BOOLEAN: {
                this.addBooleanInput(groupIds, arguments[0], arguments[1], arguments[2]);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in LastBy: %s", this.xDataType));
    }

    @Override
    public void addIntermediate(int[] groupIds, Column argument) {
        Preconditions.checkArgument((argument instanceof BinaryColumn || argument instanceof RunLengthEncodedColumn && ((RunLengthEncodedColumn)argument).getValue() instanceof BinaryColumn ? 1 : 0) != 0, (Object)"intermediate input and output of FirstBy should be BinaryColumn");
        block8: for (int i = 0; i < argument.getPositionCount(); ++i) {
            if (argument.isNull(i)) continue;
            byte[] bytes = argument.getBinary(i).getValues();
            long curTime = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)0);
            int offset = 8;
            boolean isXNull = BytesUtils.bytesToBool((byte[])bytes, (int)offset);
            ++offset;
            int groupId = groupIds[i];
            if (isXNull) {
                if (this.inits.get(groupId) && curTime >= this.yFirstTimes.get(groupId)) continue;
                this.inits.set(groupId, true);
                this.yFirstTimes.set(groupId, curTime);
                this.xNulls.set(groupId, true);
                continue;
            }
            switch (this.xDataType) {
                case INT32: 
                case DATE: {
                    int xIntVal = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                    this.updateIntLastValue(groupId, xIntVal, curTime);
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    long longVal = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)offset);
                    this.updateLongLastValue(groupId, longVal, curTime);
                    continue block8;
                }
                case FLOAT: {
                    float floatVal = BytesUtils.bytesToFloat((byte[])bytes, (int)offset);
                    this.updateFloatLastValue(groupId, floatVal, curTime);
                    continue block8;
                }
                case DOUBLE: {
                    double doubleVal = BytesUtils.bytesToDouble((byte[])bytes, (int)offset);
                    this.updateDoubleLastValue(groupId, doubleVal, curTime);
                    continue block8;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    int length = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                    Binary binaryVal = new Binary(BytesUtils.subBytes((byte[])bytes, (int)(offset += 4), (int)length));
                    this.updateBinaryLastValue(groupId, binaryVal, curTime);
                    continue block8;
                }
                case BOOLEAN: {
                    boolean boolVal = BytesUtils.bytesToBool((byte[])bytes, (int)offset);
                    this.updateBooleanLastValue(groupId, boolVal, curTime);
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type in Aggregation: %s", this.xDataType));
                }
            }
        }
    }

    @Override
    public void evaluateIntermediate(int groupId, ColumnBuilder columnBuilder) {
        Preconditions.checkArgument((boolean)(columnBuilder instanceof BinaryColumnBuilder), (Object)"intermediate input and output of FirstBy should be BinaryColumn");
        if (!this.inits.get(groupId)) {
            columnBuilder.appendNull();
        } else {
            columnBuilder.writeBinary(new Binary(this.serializeTimeWithValue(groupId)));
        }
    }

    private byte[] serializeTimeWithValue(int groupId) {
        boolean xNull = this.xNulls.get(groupId);
        int length = 9 + (xNull ? 0 : this.calculateValueLength(groupId));
        byte[] bytes = new byte[length];
        BytesUtils.longToBytes((long)this.yFirstTimes.get(groupId), (byte[])bytes, (int)0);
        BytesUtils.boolToBytes((boolean)this.xNulls.get(groupId), (byte[])bytes, (int)8);
        if (!xNull) {
            switch (this.xDataType) {
                case INT32: 
                case DATE: {
                    BytesUtils.intToBytes((int)this.xIntValues.get(groupId), (byte[])bytes, (int)9);
                    return bytes;
                }
                case INT64: 
                case TIMESTAMP: {
                    BytesUtils.longToBytes((long)this.xLongValues.get(groupId), (byte[])bytes, (int)9);
                    return bytes;
                }
                case FLOAT: {
                    BytesUtils.floatToBytes((float)this.xFloatValues.get(groupId), (byte[])bytes, (int)9);
                    return bytes;
                }
                case DOUBLE: {
                    BytesUtils.doubleToBytes((double)this.xDoubleValues.get(groupId), (byte[])bytes, (int)9);
                    return bytes;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    byte[] values = this.xBinaryValues.get(groupId).getValues();
                    BytesUtils.intToBytes((int)values.length, (byte[])bytes, (int)9);
                    System.arraycopy(values, 0, bytes, length - values.length, values.length);
                    return bytes;
                }
                case BOOLEAN: {
                    BytesUtils.boolToBytes((boolean)this.xBooleanValues.get(groupId), (byte[])bytes, (int)9);
                    return bytes;
                }
            }
            throw new UnSupportedDataTypeException(String.format("Unsupported data type: %s", this.yDataType));
        }
        return bytes;
    }

    private int calculateValueLength(int groupId) {
        switch (this.xDataType) {
            case INT32: 
            case DATE: {
                return 4;
            }
            case INT64: 
            case TIMESTAMP: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
            case DOUBLE: {
                return 8;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                return 4 + this.xBinaryValues.get(groupId).getValues().length;
            }
            case BOOLEAN: {
                return 1;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type: %s", this.xDataType));
    }

    @Override
    public void evaluateFinal(int groupId, ColumnBuilder columnBuilder) {
        if (!this.inits.get(groupId) || this.xNulls.get(groupId)) {
            columnBuilder.appendNull();
            return;
        }
        switch (this.xDataType) {
            case INT32: 
            case DATE: {
                columnBuilder.writeInt(this.xIntValues.get(groupId));
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                columnBuilder.writeLong(this.xLongValues.get(groupId));
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(this.xFloatValues.get(groupId));
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(this.xDoubleValues.get(groupId));
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                columnBuilder.writeBinary(this.xBinaryValues.get(groupId));
                break;
            }
            case BOOLEAN: {
                columnBuilder.writeBoolean(this.xBooleanValues.get(groupId));
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in LastBy: %s", this.xDataType));
            }
        }
    }

    private void addIntInput(int[] groupIds, Column xColumn, Column yColumn, Column timeColumn) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (yColumn.isNull(i)) continue;
            this.updateIntLastValue(groupIds[i], xColumn, i, timeColumn.getLong(i));
        }
    }

    protected void updateIntLastValue(int groupId, Column xColumn, int xIdx, long curTime) {
        if (!this.inits.get(groupId) || curTime < this.yFirstTimes.get(groupId)) {
            this.inits.set(groupId, true);
            this.yFirstTimes.set(groupId, curTime);
            if (xColumn.isNull(xIdx)) {
                this.xNulls.set(groupId, true);
            } else {
                this.xNulls.set(groupId, false);
                this.xIntValues.set(groupId, xColumn.getInt(xIdx));
            }
        }
    }

    protected void updateIntLastValue(int groupId, int val, long curTime) {
        if (!this.inits.get(groupId) || curTime < this.yFirstTimes.get(groupId)) {
            this.inits.set(groupId, true);
            this.yFirstTimes.set(groupId, curTime);
            this.xNulls.set(groupId, false);
            this.xIntValues.set(groupId, val);
        }
    }

    private void addLongInput(int[] groupIds, Column xColumn, Column yColumn, Column timeColumn) {
        for (int i = 0; i < yColumn.getPositionCount(); ++i) {
            if (yColumn.isNull(i)) continue;
            this.updateLongLastValue(groupIds[i], xColumn, i, timeColumn.getLong(i));
        }
    }

    protected void updateLongLastValue(int groupId, Column xColumn, int xIdx, long curTime) {
        if (!this.inits.get(groupId) || curTime < this.yFirstTimes.get(groupId)) {
            this.inits.set(groupId, true);
            this.yFirstTimes.set(groupId, curTime);
            if (xColumn.isNull(xIdx)) {
                this.xNulls.set(groupId, true);
            } else {
                this.xNulls.set(groupId, false);
                this.xLongValues.set(groupId, xColumn.getLong(xIdx));
            }
        }
    }

    protected void updateLongLastValue(int groupId, long val, long curTime) {
        if (!this.inits.get(groupId) || curTime < this.yFirstTimes.get(groupId)) {
            this.inits.set(groupId, true);
            this.yFirstTimes.set(groupId, curTime);
            this.xNulls.set(groupId, false);
            this.xLongValues.set(groupId, val);
        }
    }

    private void addFloatInput(int[] groupIds, Column xColumn, Column yColumn, Column timeColumn) {
        for (int i = 0; i < yColumn.getPositionCount(); ++i) {
            if (yColumn.isNull(i)) continue;
            this.updateFloatLastValue(groupIds[i], xColumn, i, timeColumn.getLong(i));
        }
    }

    protected void updateFloatLastValue(int groupId, Column xColumn, int xIdx, long curTime) {
        if (!this.inits.get(groupId) || curTime < this.yFirstTimes.get(groupId)) {
            this.inits.set(groupId, true);
            this.yFirstTimes.set(groupId, curTime);
            if (xColumn.isNull(xIdx)) {
                this.xNulls.set(groupId, true);
            } else {
                this.xNulls.set(groupId, false);
                this.xFloatValues.set(groupId, xColumn.getFloat(xIdx));
            }
        }
    }

    protected void updateFloatLastValue(int groupId, float val, long curTime) {
        if (!this.inits.get(groupId) || curTime < this.yFirstTimes.get(groupId)) {
            this.inits.set(groupId, true);
            this.yFirstTimes.set(groupId, curTime);
            this.xNulls.set(groupId, false);
            this.xFloatValues.set(groupId, val);
        }
    }

    private void addDoubleInput(int[] groupIds, Column xColumn, Column yColumn, Column timeColumn) {
        for (int i = 0; i < yColumn.getPositionCount(); ++i) {
            if (yColumn.isNull(i)) continue;
            this.updateDoubleLastValue(groupIds[i], xColumn, i, timeColumn.getLong(i));
        }
    }

    protected void updateDoubleLastValue(int groupId, Column xColumn, int xIdx, long curTime) {
        if (!this.inits.get(groupId) || curTime < this.yFirstTimes.get(groupId)) {
            this.inits.set(groupId, true);
            this.yFirstTimes.set(groupId, curTime);
            if (xColumn.isNull(xIdx)) {
                this.xNulls.set(groupId, true);
            } else {
                this.xNulls.set(groupId, false);
                this.xDoubleValues.set(groupId, xColumn.getDouble(xIdx));
            }
        }
    }

    protected void updateDoubleLastValue(int groupId, double val, long curTime) {
        if (!this.inits.get(groupId) || curTime < this.yFirstTimes.get(groupId)) {
            this.inits.set(groupId, true);
            this.yFirstTimes.set(groupId, curTime);
            this.xNulls.set(groupId, false);
            this.xDoubleValues.set(groupId, val);
        }
    }

    private void addBinaryInput(int[] groupIds, Column xColumn, Column yColumn, Column timeColumn) {
        for (int i = 0; i < yColumn.getPositionCount(); ++i) {
            if (yColumn.isNull(i)) continue;
            this.updateBinaryLastValue(groupIds[i], xColumn, i, timeColumn.getLong(i));
        }
    }

    protected void updateBinaryLastValue(int groupId, Column xColumn, int xIdx, long curTime) {
        if (!this.inits.get(groupId) || curTime < this.yFirstTimes.get(groupId)) {
            this.inits.set(groupId, true);
            this.yFirstTimes.set(groupId, curTime);
            if (xColumn.isNull(xIdx)) {
                this.xNulls.set(groupId, true);
            } else {
                this.xNulls.set(groupId, false);
                this.xIntValues.set(groupId, xColumn.getInt(xIdx));
            }
        }
    }

    protected void updateBinaryLastValue(int groupId, Binary val, long curTime) {
        if (!this.inits.get(groupId) || curTime < this.yFirstTimes.get(groupId)) {
            this.inits.set(groupId, true);
            this.yFirstTimes.set(groupId, curTime);
            this.xNulls.set(groupId, false);
            this.xBinaryValues.set(groupId, val);
        }
    }

    private void addBooleanInput(int[] groupIds, Column xColumn, Column yColumn, Column timeColumn) {
        for (int i = 0; i < yColumn.getPositionCount(); ++i) {
            if (yColumn.isNull(i)) continue;
            this.updateBooleanLastValue(groupIds[i], xColumn, i, timeColumn.getLong(i));
        }
    }

    protected void updateBooleanLastValue(int groupId, Column xColumn, int xIdx, long curTime) {
        if (!this.inits.get(groupId) || curTime < this.yFirstTimes.get(groupId)) {
            this.inits.set(groupId, true);
            this.yFirstTimes.set(groupId, curTime);
            if (xColumn.isNull(xIdx)) {
                this.xNulls.set(groupId, true);
            } else {
                this.xNulls.set(groupId, false);
                this.xBooleanValues.set(groupId, xColumn.getBoolean(xIdx));
            }
        }
    }

    protected void updateBooleanLastValue(int groupId, boolean val, long curTime) {
        if (!this.inits.get(groupId) || curTime < this.yFirstTimes.get(groupId)) {
            this.inits.set(groupId, true);
            this.yFirstTimes.set(groupId, curTime);
            this.xNulls.set(groupId, false);
            this.xBooleanValues.set(groupId, val);
        }
    }
}

