/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational;

import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.table.InformationSchema;
import org.apache.iotdb.commons.schema.table.TableNodeStatus;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.TsTableInternalRPCUtil;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseInfo;
import org.apache.iotdb.confignode.rpc.thrift.TDescTable4InformationSchemaResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetDatabaseReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowDatabaseResp;
import org.apache.iotdb.confignode.rpc.thrift.TTableColumnInfo;
import org.apache.iotdb.confignode.rpc.thrift.TTableInfo;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.schemaengine.table.InformationSchemaUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.Pair;

public class InformationSchemaContentSupplierFactory {
    private InformationSchemaContentSupplierFactory() {
    }

    public static Iterator<TsBlock> getSupplier(String tableName, List<TSDataType> dataTypes, String userName) {
        switch (tableName) {
            case "queries": {
                return new QueriesSupplier(dataTypes);
            }
            case "databases": {
                return new DatabaseSupplier(dataTypes, userName);
            }
            case "tables": {
                return new TableSupplier(dataTypes, userName);
            }
            case "columns": {
                return new ColumnSupplier(dataTypes, userName);
            }
        }
        throw new UnsupportedOperationException("Unknown table: " + tableName);
    }

    private static boolean canShowDB(String userName, String dbName) {
        try {
            Coordinator.getInstance().getAccessControl().checkCanShowOrUseDatabase(userName, dbName);
        }
        catch (AccessControlException e) {
            return false;
        }
        return true;
    }

    private static class QueriesSupplier
    extends TsBlockSupplier {
        private final long currTime = System.currentTimeMillis();
        protected int totalSize;
        protected int nextConsumedIndex;
        private final List<IQueryExecution> queryExecutions = Coordinator.getInstance().getAllQueryExecutions();

        private QueriesSupplier(List<TSDataType> dataTypes) {
            super(dataTypes);
            this.totalSize = this.queryExecutions.size();
        }

        @Override
        protected void constructLine() {
            IQueryExecution queryExecution = this.queryExecutions.get(this.nextConsumedIndex);
            if (queryExecution.getSQLDialect().equals((Object)IClientSession.SqlDialect.TABLE)) {
                String[] splits = queryExecution.getQueryId().split("_");
                int dataNodeId = Integer.parseInt(splits[splits.length - 1]);
                this.columnBuilders[0].writeBinary(BytesUtils.valueOf((String)queryExecution.getQueryId()));
                this.columnBuilders[1].writeLong(queryExecution.getStartExecutionTime());
                this.columnBuilders[2].writeInt(dataNodeId);
                this.columnBuilders[3].writeFloat((float)(this.currTime - queryExecution.getStartExecutionTime()) / 1000.0f);
                this.columnBuilders[4].writeBinary(BytesUtils.valueOf((String)queryExecution.getExecuteSQL().orElse("UNKNOWN")));
                this.resultBuilder.declarePosition();
            }
            ++this.nextConsumedIndex;
        }

        @Override
        public boolean hasNext() {
            return this.nextConsumedIndex < this.totalSize;
        }
    }

    private static class DatabaseSupplier
    extends TsBlockSupplier {
        private Iterator<Map.Entry<String, TDatabaseInfo>> iterator;
        private TDatabaseInfo currentDatabase;
        private final String userName;
        private boolean hasShownInformationSchema;

        private DatabaseSupplier(List<TSDataType> dataTypes, String userName) {
            super(dataTypes);
            this.userName = userName;
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                TShowDatabaseResp resp = client.showDatabase(new TGetDatabaseReq(Arrays.asList(SchemaConstant.ALL_RESULT_NODES), SchemaConstant.ALL_MATCH_SCOPE.serialize()).setIsTableModel(true));
                this.iterator = resp.getDatabaseInfoMap().entrySet().iterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            if (!this.hasShownInformationSchema) {
                InformationSchemaUtils.buildDatabaseTsBlock(s -> true, this.resultBuilder, true, false);
                this.hasShownInformationSchema = true;
                return;
            }
            this.columnBuilders[0].writeBinary(new Binary(this.currentDatabase.getName(), TSFileConfig.STRING_CHARSET));
            if (Long.MAX_VALUE == this.currentDatabase.getTTL()) {
                this.columnBuilders[1].writeBinary(new Binary("INF", TSFileConfig.STRING_CHARSET));
            } else {
                this.columnBuilders[1].writeBinary(new Binary(String.valueOf(this.currentDatabase.getTTL()), TSFileConfig.STRING_CHARSET));
            }
            this.columnBuilders[2].writeInt(this.currentDatabase.getSchemaReplicationFactor());
            this.columnBuilders[3].writeInt(this.currentDatabase.getDataReplicationFactor());
            this.columnBuilders[4].writeLong(this.currentDatabase.getTimePartitionInterval());
            this.columnBuilders[5].writeInt(this.currentDatabase.getSchemaRegionNum());
            this.columnBuilders[6].writeInt(this.currentDatabase.getDataRegionNum());
            this.resultBuilder.declarePosition();
            this.currentDatabase = null;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasShownInformationSchema) {
                if (!InformationSchemaContentSupplierFactory.canShowDB(this.userName, "information_schema")) {
                    this.hasShownInformationSchema = true;
                } else {
                    return true;
                }
            }
            while (this.iterator.hasNext()) {
                Map.Entry<String, TDatabaseInfo> result = this.iterator.next();
                if (!InformationSchemaContentSupplierFactory.canShowDB(this.userName, result.getKey())) continue;
                this.currentDatabase = result.getValue();
                break;
            }
            return Objects.nonNull(this.currentDatabase);
        }
    }

    private static class TableSupplier
    extends TsBlockSupplier {
        private Iterator<Map.Entry<String, List<TTableInfo>>> dbIterator;
        private Iterator<TTableInfo> tableInfoIterator = null;
        private String dbName;
        private final String userName;

        private TableSupplier(List<TSDataType> dataTypes, String userName) {
            super(dataTypes);
            this.userName = userName;
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                Map databaseTableInfoMap = client.showTables4InformationSchema().getDatabaseTableInfoMap();
                databaseTableInfoMap.put("information_schema", InformationSchema.getSchemaTables().values().stream().map(table -> {
                    TTableInfo info = new TTableInfo(table.getTableName(), table.getPropValue("ttl").orElse("INF"));
                    info.setState(TableNodeStatus.USING.ordinal());
                    return info;
                }).collect(Collectors.toList()));
                this.dbIterator = databaseTableInfoMap.entrySet().iterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            TTableInfo info = this.tableInfoIterator.next();
            this.columnBuilders[0].writeBinary(new Binary(this.dbName, TSFileConfig.STRING_CHARSET));
            this.columnBuilders[1].writeBinary(new Binary(info.getTableName(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[2].writeBinary(new Binary(info.getTTL(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[3].writeBinary(new Binary(TableNodeStatus.values()[info.getState()].toString(), TSFileConfig.STRING_CHARSET));
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            while (Objects.isNull(this.tableInfoIterator) || !this.tableInfoIterator.hasNext()) {
                if (!this.dbIterator.hasNext()) {
                    return false;
                }
                Map.Entry<String, List<TTableInfo>> entry = this.dbIterator.next();
                this.dbName = entry.getKey();
                if (!InformationSchemaContentSupplierFactory.canShowDB(this.userName, this.dbName)) continue;
                this.tableInfoIterator = entry.getValue().iterator();
            }
            return true;
        }
    }

    private static class ColumnSupplier
    extends TsBlockSupplier {
        private Iterator<Map.Entry<String, Map<String, Pair<TsTable, Set<String>>>>> dbIterator;
        private Iterator<Map.Entry<String, Pair<TsTable, Set<String>>>> tableInfoIterator;
        private Iterator<TsTableColumnSchema> columnSchemaIterator;
        private String dbName;
        private String tableName;
        private Set<String> preDeletedColumns;
        private final String userName;

        private ColumnSupplier(List<TSDataType> dataTypes, String userName) {
            super(dataTypes);
            this.userName = userName;
            try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                TDescTable4InformationSchemaResp resp = client.descTables4InformationSchema();
                Map<String, Map> resultMap = resp.getTableColumnInfoMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, tableEntry -> new Pair((Object)TsTableInternalRPCUtil.deserializeSingleTsTable((byte[])((TTableColumnInfo)tableEntry.getValue()).getTableInfo()), (Object)((TTableColumnInfo)tableEntry.getValue()).getPreDeletedColumns())))));
                resultMap.put("information_schema", InformationSchema.getSchemaTables().values().stream().collect(Collectors.toMap(TsTable::getTableName, table -> new Pair(table, Collections.emptySet()))));
                this.dbIterator = resultMap.entrySet().iterator();
            }
            catch (Exception e) {
                this.lastException = e;
            }
        }

        @Override
        protected void constructLine() {
            TsTableColumnSchema schema = this.columnSchemaIterator.next();
            this.columnBuilders[0].writeBinary(new Binary(this.dbName, TSFileConfig.STRING_CHARSET));
            this.columnBuilders[1].writeBinary(new Binary(this.tableName, TSFileConfig.STRING_CHARSET));
            this.columnBuilders[2].writeBinary(new Binary(schema.getColumnName(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[3].writeBinary(new Binary(schema.getDataType().name(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[4].writeBinary(new Binary(schema.getColumnCategory().name(), TSFileConfig.STRING_CHARSET));
            this.columnBuilders[5].writeBinary(new Binary(this.preDeletedColumns.contains(schema.getColumnName()) ? "PRE_DELETE" : "USING", TSFileConfig.STRING_CHARSET));
            this.resultBuilder.declarePosition();
        }

        @Override
        public boolean hasNext() {
            while (Objects.isNull(this.columnSchemaIterator) || !this.columnSchemaIterator.hasNext()) {
                while (Objects.isNull(this.tableInfoIterator) || !this.tableInfoIterator.hasNext()) {
                    if (!this.dbIterator.hasNext()) {
                        return false;
                    }
                    Map.Entry<String, Map<String, Pair<TsTable, Set<String>>>> entry = this.dbIterator.next();
                    this.dbName = entry.getKey();
                    if (!InformationSchemaContentSupplierFactory.canShowDB(this.userName, this.dbName)) continue;
                    this.tableInfoIterator = entry.getValue().entrySet().iterator();
                }
                Map.Entry<String, Pair<TsTable, Set<String>>> tableEntry = this.tableInfoIterator.next();
                this.tableName = tableEntry.getKey();
                this.preDeletedColumns = (Set)tableEntry.getValue().getRight();
                this.columnSchemaIterator = ((TsTable)tableEntry.getValue().getLeft()).getColumnList().iterator();
            }
            return true;
        }
    }

    private static abstract class TsBlockSupplier
    implements Iterator<TsBlock> {
        protected final TsBlockBuilder resultBuilder;
        protected final ColumnBuilder[] columnBuilders;
        protected Exception lastException;

        private TsBlockSupplier(List<TSDataType> dataTypes) {
            this.resultBuilder = new TsBlockBuilder(dataTypes);
            this.columnBuilders = this.resultBuilder.getValueColumnBuilders();
        }

        @Override
        public TsBlock next() {
            if (Objects.nonNull(this.lastException)) {
                throw new NoSuchElementException(this.lastException.getMessage());
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            while (this.hasNext() && !this.resultBuilder.isFull()) {
                this.constructLine();
            }
            TsBlock result = this.resultBuilder.build((Column)new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, this.resultBuilder.getPositionCount()));
            this.resultBuilder.reset();
            return result;
        }

        protected abstract void constructLine();
    }
}

