/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.AlignedFullPath;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.AbstractSeriesScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.AlignedSeriesScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.AlignedSeriesScanUtil;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.type.InternalTypeManager;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.IQueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.LongColumn;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public abstract class AbstractTableScanOperator
extends AbstractSeriesScanOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TableScanOperator.class);
    public static final String CURRENT_DEVICE_INDEX_STRING = "CurrentDeviceIndex";
    public static final LongColumn TIME_COLUMN_TEMPLATE = new LongColumn(1, Optional.empty(), new long[]{0L});
    private final List<ColumnSchema> columnSchemas;
    private final int[] columnsIndexArray;
    private final List<DeviceEntry> deviceEntries;
    private final int deviceCount;
    private final Ordering scanOrder;
    private final SeriesScanOptions seriesScanOptions;
    private final List<String> measurementColumnNames;
    private final Set<String> allSensors;
    private final List<IMeasurementSchema> measurementSchemas;
    private final List<TSDataType> measurementColumnTSDataTypes;
    private TsBlockBuilder measurementDataBuilder;
    private final int maxTsBlockLineNum;
    private TsBlock measurementDataBlock;
    private QueryDataSource queryDataSource;
    private int currentDeviceIndex;

    public AbstractTableScanOperator(AbstractTableScanOperatorParameter parameter) {
        this.sourceId = parameter.sourceId;
        this.operatorContext = parameter.context;
        this.operatorContext.recordSpecifiedInfo("DeviceNumber", Integer.toString(parameter.deviceEntries.size()));
        this.columnSchemas = parameter.columnSchemas;
        this.columnsIndexArray = parameter.columnsIndexArray;
        this.deviceEntries = parameter.deviceEntries;
        this.deviceCount = parameter.deviceEntries.size();
        this.scanOrder = parameter.scanOrder;
        this.seriesScanOptions = parameter.seriesScanOptions;
        this.measurementColumnNames = parameter.measurementColumnNames;
        this.allSensors = parameter.allSensors;
        this.measurementSchemas = parameter.measurementSchemas;
        this.measurementColumnTSDataTypes = parameter.measurementSchemas.stream().map(IMeasurementSchema::getType).collect(Collectors.toList());
        this.currentDeviceIndex = 0;
        this.operatorContext.recordSpecifiedInfo(CURRENT_DEVICE_INDEX_STRING, Integer.toString(0));
        this.maxReturnSize = Math.min(this.maxReturnSize, (1L + (long)parameter.columnsIndexArray.length) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte());
        this.maxTsBlockLineNum = parameter.maxTsBlockLineNum;
        this.constructAlignedSeriesScanUtil();
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.retainedTsBlock != null) {
            return this.getResultFromRetainedTsBlock();
        }
        try {
            long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
            long start = System.nanoTime();
            boolean currentDeviceNoMoreData = false;
            do {
                if (this.readPageData() || this.readChunkData() || this.readFileData()) continue;
                currentDeviceNoMoreData = true;
                break;
            } while (System.nanoTime() - start < maxRuntime && !this.measurementDataBuilder.isFull() && this.measurementDataBlock == null);
            if (this.measurementDataBuilder.isEmpty() && this.measurementDataBlock == null && currentDeviceNoMoreData) {
                ++this.currentDeviceIndex;
                this.prepareForNextDevice();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error happened while scanning the file", e);
        }
        if (!this.measurementDataBuilder.isEmpty()) {
            this.measurementDataBlock = this.measurementDataBuilder.build();
            this.measurementDataBuilder.reset();
        }
        if (this.isEmpty(this.measurementDataBlock)) {
            return null;
        }
        this.constructResultTsBlock();
        this.measurementDataBlock = null;
        return this.checkTsBlockSizeAndGetResult();
    }

    @Override
    protected void appendToBuilder(TsBlock tsBlock) {
        if (this.measurementDataBuilder.isEmpty() && tsBlock.getPositionCount() >= this.measurementDataBuilder.getMaxTsBlockLineNumber()) {
            this.measurementDataBlock = tsBlock;
            return;
        }
        AlignedSeriesScanOperator.appendDataIntoBuilder(tsBlock, this.measurementDataBuilder);
    }

    @Override
    protected void buildResult(TsBlock tsBlock) {
        throw new UnsupportedOperationException();
    }

    private void constructResultTsBlock() {
        int positionCount = this.measurementDataBlock.getPositionCount();
        DeviceEntry currentDeviceEntry = this.deviceEntries.get(this.currentDeviceIndex);
        Column[] valueColumns = new Column[this.columnsIndexArray.length];
        block6: for (int i = 0; i < this.columnsIndexArray.length; ++i) {
            switch (this.columnSchemas.get(i).getColumnCategory()) {
                case TAG: {
                    String idColumnValue = this.getNthIdColumnValue(currentDeviceEntry, this.columnsIndexArray[i]);
                    valueColumns[i] = this.getIdOrAttributeValueColumn(idColumnValue == null ? null : new Binary(idColumnValue, TSFileConfig.STRING_CHARSET), positionCount);
                    continue block6;
                }
                case ATTRIBUTE: {
                    Binary attributeColumnValue = currentDeviceEntry.getAttributeColumnValues().get(this.columnsIndexArray[i]);
                    valueColumns[i] = this.getIdOrAttributeValueColumn(attributeColumnValue, positionCount);
                    continue block6;
                }
                case FIELD: {
                    valueColumns[i] = this.measurementDataBlock.getColumn(this.columnsIndexArray[i]);
                    continue block6;
                }
                case TIME: {
                    valueColumns[i] = this.measurementDataBlock.getTimeColumn();
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected column category: " + this.columnSchemas.get(i).getColumnCategory());
                }
            }
        }
        this.resultTsBlock = new TsBlock(positionCount, (Column)new RunLengthEncodedColumn((Column)TIME_COLUMN_TEMPLATE, positionCount), valueColumns);
    }

    abstract String getNthIdColumnValue(DeviceEntry var1, int var2);

    private RunLengthEncodedColumn getIdOrAttributeValueColumn(Binary value, int positionCount) {
        if (value == null) {
            return new RunLengthEncodedColumn((Column)new BinaryColumn(1, Optional.of(new boolean[]{true}), new Binary[]{null}), positionCount);
        }
        return new RunLengthEncodedColumn((Column)new BinaryColumn(1, Optional.empty(), new Binary[]{value}), positionCount);
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.isFinished();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.retainedTsBlock == null && (this.currentDeviceIndex >= this.deviceCount || this.seriesScanOptions.limitConsumedUp());
    }

    @Override
    public long calculateMaxPeekMemory() {
        return (1L + (long)this.columnsIndexArray.length) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
    }

    @Override
    public List<TSDataType> getResultDataTypes() {
        ArrayList<TSDataType> resultDataTypes = new ArrayList<TSDataType>(this.columnSchemas.size());
        for (ColumnSchema columnSchema : this.columnSchemas) {
            resultDataTypes.add(InternalTypeManager.getTSDataType(columnSchema.getType()));
        }
        return resultDataTypes;
    }

    @Override
    public void initQueryDataSource(IQueryDataSource dataSource) {
        this.queryDataSource = (QueryDataSource)dataSource;
        if (this.seriesScanUtil != null) {
            this.seriesScanUtil.initQueryDataSource(this.queryDataSource);
        }
        this.resultTsBlockBuilder = new TsBlockBuilder(this.getResultDataTypes());
        this.resultTsBlockBuilder.setMaxTsBlockLineNumber(this.maxTsBlockLineNum);
        this.measurementDataBuilder = new TsBlockBuilder(this.measurementColumnTSDataTypes);
        this.measurementDataBuilder.setMaxTsBlockLineNumber(this.maxTsBlockLineNum);
    }

    private void prepareForNextDevice() {
        if (this.currentDeviceIndex < this.deviceCount) {
            this.constructAlignedSeriesScanUtil();
            this.queryDataSource.reset();
            this.seriesScanUtil.initQueryDataSource(this.queryDataSource);
            this.operatorContext.recordSpecifiedInfo(CURRENT_DEVICE_INDEX_STRING, Integer.toString(this.currentDeviceIndex));
        }
    }

    private void constructAlignedSeriesScanUtil() {
        if (this.deviceEntries.isEmpty()) {
            return;
        }
        if (this.deviceEntries.get(this.currentDeviceIndex) == null) {
            throw new IllegalStateException("Device entries of index " + this.currentDeviceIndex + " in TableScanOperator is empty");
        }
        DeviceEntry deviceEntry = this.deviceEntries.get(this.currentDeviceIndex);
        AlignedFullPath alignedPath = AbstractTableScanOperator.constructAlignedPath(deviceEntry, this.measurementColumnNames, this.measurementSchemas, this.allSensors);
        this.seriesScanUtil = new AlignedSeriesScanUtil(alignedPath, this.scanOrder, this.seriesScanOptions, this.operatorContext.getInstanceContext(), true, this.measurementColumnTSDataTypes);
    }

    public static AlignedFullPath constructAlignedPath(DeviceEntry deviceEntry, List<String> measurementColumnNames, List<IMeasurementSchema> measurementSchemas, Set<String> allSensors) {
        return new AlignedFullPath(deviceEntry.getDeviceID(), measurementColumnNames, measurementSchemas, allSensors);
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.seriesScanUtil) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.sourceId) + (this.resultTsBlockBuilder == null ? 0L : this.resultTsBlockBuilder.getRetainedSizeInBytes()) + RamUsageEstimator.sizeOfCollection(this.deviceEntries);
    }

    public static class AbstractTableScanOperatorParameter {
        public final OperatorContext context;
        public final PlanNodeId sourceId;
        public final List<ColumnSchema> columnSchemas;
        public final int[] columnsIndexArray;
        public final List<DeviceEntry> deviceEntries;
        public final Ordering scanOrder;
        public final SeriesScanOptions seriesScanOptions;
        public final List<String> measurementColumnNames;
        public final Set<String> allSensors;
        public final List<IMeasurementSchema> measurementSchemas;
        public final int maxTsBlockLineNum;

        public AbstractTableScanOperatorParameter(Set<String> allSensors, OperatorContext context, PlanNodeId sourceId, List<ColumnSchema> columnSchemas, int[] columnsIndexArray, List<DeviceEntry> deviceEntries, Ordering scanOrder, SeriesScanOptions seriesScanOptions, List<String> measurementColumnNames, List<IMeasurementSchema> measurementSchemas, int maxTsBlockLineNum) {
            this.allSensors = allSensors;
            this.context = context;
            this.sourceId = sourceId;
            this.columnSchemas = columnSchemas;
            this.columnsIndexArray = columnsIndexArray;
            this.deviceEntries = deviceEntries;
            this.scanOrder = scanOrder;
            this.seriesScanOptions = seriesScanOptions;
            this.measurementColumnNames = measurementColumnNames;
            this.measurementSchemas = measurementSchemas;
            this.maxTsBlockLineNum = maxTsBlockLineNum;
        }
    }
}

