/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.twostage.plugin;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.StateProgressIndex;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskProcessorRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.watermark.PipeWatermarkEvent;
import org.apache.iotdb.db.pipe.processor.twostage.combiner.PipeCombineHandlerManager;
import org.apache.iotdb.db.pipe.processor.twostage.exchange.payload.CombineRequest;
import org.apache.iotdb.db.pipe.processor.twostage.exchange.payload.FetchCombineResultRequest;
import org.apache.iotdb.db.pipe.processor.twostage.exchange.payload.FetchCombineResultResponse;
import org.apache.iotdb.db.pipe.processor.twostage.exchange.sender.TwoStageAggregateSender;
import org.apache.iotdb.db.pipe.processor.twostage.operator.CountOperator;
import org.apache.iotdb.db.pipe.processor.twostage.state.CountState;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeProcessorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.pipe.api.exception.PipeParameterNotValidException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoStageCountProcessor
implements PipeProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TwoStageCountProcessor.class);
    private String pipeName;
    private long creationTime;
    private int regionId;
    private PipeTaskMeta pipeTaskMeta;
    private PartialPath outputSeries;
    private static final String LOCAL_COUNT_STATE_KEY = "count";
    private final AtomicLong localCount = new AtomicLong(0L);
    private final AtomicReference<ProgressIndex> localCommitProgressIndex = new AtomicReference<MinimumProgressIndex>(MinimumProgressIndex.INSTANCE);
    private final Queue<Pair<long[], ProgressIndex>> localRequestQueue = new ConcurrentLinkedQueue<Pair<long[], ProgressIndex>>();
    private final Queue<Pair<long[], ProgressIndex>> localCommitQueue = new ConcurrentLinkedQueue<Pair<long[], ProgressIndex>>();
    private TwoStageAggregateSender twoStageAggregateSender;
    private final Queue<Pair<Long, Long>> globalCountQueue = new ConcurrentLinkedQueue<Pair<Long, Long>>();

    public void validate(PipeParameterValidator validator) throws Exception {
        this.checkInvalidParameters(validator);
        String rawOutputSeries = validator.getParameters().getStringByKeys(new String[]{"processor.output.series", "processor.output-series"});
        try {
            PathUtils.isLegalPath((String)Objects.requireNonNull(rawOutputSeries));
        }
        catch (Exception e) {
            throw new PipeParameterNotValidException("Illegal output series path: " + rawOutputSeries);
        }
    }

    private void checkInvalidParameters(PipeParameterValidator validator) {
        validator.validateSynonymAttributes(Collections.singletonList("processor.output.series"), Collections.singletonList("processor.output-series"), true);
    }

    public void customize(PipeParameters parameters, PipeProcessorRuntimeConfiguration configuration) throws Exception {
        PipeTaskProcessorRuntimeEnvironment runtimeEnvironment = (PipeTaskProcessorRuntimeEnvironment)configuration.getRuntimeEnvironment();
        this.pipeName = runtimeEnvironment.getPipeName();
        this.creationTime = runtimeEnvironment.getCreationTime();
        this.regionId = runtimeEnvironment.getRegionId();
        this.pipeTaskMeta = runtimeEnvironment.getPipeTaskMeta();
        this.outputSeries = new PartialPath(parameters.getString("processor.output-series"));
        if (Objects.nonNull(this.pipeTaskMeta) && Objects.nonNull(this.pipeTaskMeta.getProgressIndex())) {
            if (this.pipeTaskMeta.getProgressIndex() instanceof MinimumProgressIndex) {
                this.pipeTaskMeta.updateProgressIndex((ProgressIndex)new StateProgressIndex(Long.MIN_VALUE, new HashMap(), (ProgressIndex)MinimumProgressIndex.INSTANCE));
            }
            StateProgressIndex stateProgressIndex = (StateProgressIndex)this.pipeTaskMeta.getProgressIndex();
            this.localCommitProgressIndex.set(stateProgressIndex.getInnerProgressIndex());
            Binary localCountState = (Binary)stateProgressIndex.getState().get(LOCAL_COUNT_STATE_KEY);
            this.localCount.set(Objects.isNull(localCountState) ? 0L : Long.parseLong(localCountState.toString()));
        }
        LOGGER.info("TwoStageCountProcessor customized by thread {}: pipeName={}, creationTime={}, regionId={}, outputSeries={}, localCommitProgressIndex={}, localCount={}", new Object[]{Thread.currentThread().getName(), this.pipeName, this.creationTime, this.regionId, this.outputSeries, this.localCommitProgressIndex.get(), this.localCount.get()});
        PipeCombineHandlerManager.getInstance().register(this.pipeName, this.creationTime, combineId -> new CountOperator((String)combineId, this.globalCountQueue));
        this.twoStageAggregateSender = new TwoStageAggregateSender(this.pipeName, this.creationTime);
    }

    public void process(TabletInsertionEvent tabletInsertionEvent, EventCollector eventCollector) throws Exception {
        if (!(tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) && !(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) {
            LOGGER.warn("Ignored TabletInsertionEvent is not an instance of PipeInsertNodeTabletInsertionEvent or PipeRawTabletInsertionEvent: {}", (Object)tabletInsertionEvent);
            return;
        }
        EnrichedEvent event = (EnrichedEvent)tabletInsertionEvent;
        event.skipReportOnCommit();
        long count = event instanceof PipeInsertNodeTabletInsertionEvent ? ((PipeInsertNodeTabletInsertionEvent)event).count() : ((PipeRawTabletInsertionEvent)event).count();
        this.localCount.accumulateAndGet(count, Long::sum);
        this.localCommitProgressIndex.updateAndGet(index -> index.updateToMinimumEqualOrIsAfterProgressIndex(event.getProgressIndex()));
    }

    public void process(TsFileInsertionEvent tsFileInsertionEvent, EventCollector eventCollector) throws Exception {
        if (!(tsFileInsertionEvent instanceof PipeTsFileInsertionEvent)) {
            LOGGER.warn("Ignored TsFileInsertionEvent is not an instance of PipeTsFileInsertionEvent: {}", (Object)tsFileInsertionEvent);
            return;
        }
        PipeTsFileInsertionEvent event = (PipeTsFileInsertionEvent)tsFileInsertionEvent;
        event.skipReportOnCommit();
        if (!event.waitForTsFileClose()) {
            LOGGER.warn("Ignored TsFileInsertionEvent is empty: {}", (Object)event);
            return;
        }
        long count = event.count(true);
        this.localCount.accumulateAndGet(count, Long::sum);
        this.localCommitProgressIndex.updateAndGet(index -> index.updateToMinimumEqualOrIsAfterProgressIndex(event.getProgressIndex()));
    }

    public void process(Event event, EventCollector eventCollector) throws Exception {
        if (event instanceof PipeHeartbeatEvent) {
            this.collectGlobalCountIfNecessary(eventCollector);
            this.commitLocalProgressIndexIfNecessary();
            this.triggerCombineIfNecessary();
            eventCollector.collect(event);
            return;
        }
        if (event instanceof PipeWatermarkEvent) {
            this.triggerCombine((Pair<long[], ProgressIndex>)new Pair((Object)new long[]{((PipeWatermarkEvent)event).getWatermark(), this.localCount.get()}, (Object)this.localCommitProgressIndex.get()));
        }
    }

    private void collectGlobalCountIfNecessary(EventCollector eventCollector) throws IOException {
        while (!this.globalCountQueue.isEmpty()) {
            Object lastCombinedValue = PipeCombineHandlerManager.getInstance().getLastCombinedValue(this.pipeName, this.creationTime);
            Pair lastCollectedTimestampCountPair = Objects.isNull(lastCombinedValue) ? new Pair((Object)Long.MIN_VALUE, (Object)0L) : (Pair)lastCombinedValue;
            Pair<Long, Long> timestampCountPair = this.globalCountQueue.poll();
            if ((Long)timestampCountPair.right < (Long)lastCollectedTimestampCountPair.right) {
                timestampCountPair.right = lastCollectedTimestampCountPair.right;
                LOGGER.warn("Global count is less than the last collected count: timestamp={}, count={}", timestampCountPair.left, timestampCountPair.right);
            }
            Tablet tablet = new Tablet(this.outputSeries.getIDeviceID().toString(), Collections.singletonList(new MeasurementSchema(this.outputSeries.getMeasurement(), TSDataType.INT64)), 1);
            tablet.addTimestamp(0, ((Long)timestampCountPair.left).longValue());
            tablet.addValue(this.outputSeries.getMeasurement(), 0, timestampCountPair.right);
            eventCollector.collect((Event)new PipeRawTabletInsertionEvent(null, null, tablet, false, null, 0L, null, null, false));
            PipeCombineHandlerManager.getInstance().updateLastCombinedValue(this.pipeName, this.creationTime, timestampCountPair);
        }
    }

    private void commitLocalProgressIndexIfNecessary() {
        Pair<long[], ProgressIndex> pair;
        int currentQueueSize = this.localCommitQueue.size();
        for (int i = 0; i < currentQueueSize && !Objects.isNull(pair = this.localCommitQueue.poll()); ++i) {
            try {
                FetchCombineResultResponse fetchCombineResultResponse = FetchCombineResultResponse.fromTPipeTransferResp(this.twoStageAggregateSender.request(((long[])pair.left)[0], FetchCombineResultRequest.toTPipeTransferReq(this.pipeName, this.creationTime, Collections.singletonList(Long.toString(((long[])pair.left)[0])))));
                if (fetchCombineResultResponse.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    throw new PipeException("Failed to fetch combine result: " + fetchCombineResultResponse.getStatus().getMessage());
                }
                block8: for (Map.Entry<String, FetchCombineResultResponse.CombineResultType> entry : fetchCombineResultResponse.getCombineId2ResultType().entrySet()) {
                    String combineId = entry.getKey();
                    FetchCombineResultResponse.CombineResultType resultType = entry.getValue();
                    switch (resultType) {
                        case OUTDATED: {
                            LOGGER.warn("Two stage combine (region id = {}, combine id = {}) outdated: timestamp={}, count={}, progressIndex={}", new Object[]{this.regionId, combineId, ((long[])pair.left)[0], ((long[])pair.left)[1], pair.right});
                            continue block8;
                        }
                        case INCOMPLETE: {
                            LOGGER.info("Two stage combine (region id = {}, combine id = {}) incomplete: timestamp={}, count={}, progressIndex={}", new Object[]{this.regionId, combineId, ((long[])pair.left)[0], ((long[])pair.left)[1], pair.right});
                            this.localCommitQueue.add(pair);
                            continue block8;
                        }
                        case SUCCESS: {
                            HashMap<String, Binary> state = new HashMap<String, Binary>();
                            state.put(LOCAL_COUNT_STATE_KEY, new Binary(Long.toString(((long[])pair.left)[1]).getBytes()));
                            this.pipeTaskMeta.updateProgressIndex((ProgressIndex)new StateProgressIndex(((long[])pair.left)[0], state, (ProgressIndex)pair.right));
                            LOGGER.info("Two stage combine (region id = {}, combine id = {}) success: timestamp={}, count={}, progressIndex={}, committed progressIndex={}", new Object[]{this.regionId, combineId, ((long[])pair.left)[0], ((long[])pair.left)[1], pair.right, this.pipeTaskMeta.getProgressIndex()});
                            continue block8;
                        }
                    }
                    throw new PipeException("Unknown combine result type: " + (Object)((Object)resultType));
                }
                continue;
            }
            catch (Exception e) {
                this.localCommitQueue.add(pair);
                LOGGER.warn("Failure occurred when trying to commit progress index. timestamp={}, count={}, progressIndex={}", new Object[]{((long[])pair.left)[0], ((long[])pair.left)[1], pair.right, e});
                return;
            }
        }
    }

    private void triggerCombineIfNecessary() {
        while (!this.localRequestQueue.isEmpty()) {
            if (this.triggerCombine(this.localRequestQueue.poll())) continue;
            return;
        }
    }

    private boolean triggerCombine(Pair<long[], ProgressIndex> pair) {
        long watermark = ((long[])pair.getLeft())[0];
        long count = ((long[])pair.getLeft())[1];
        ProgressIndex progressIndex = (ProgressIndex)pair.getRight();
        try {
            TPipeTransferResp resp = this.twoStageAggregateSender.request(watermark, CombineRequest.toTPipeTransferReq(this.pipeName, this.creationTime, this.regionId, Long.toString(watermark), new CountState(count)));
            if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new PipeException("Failed to combine count: " + resp.getStatus().getMessage());
            }
            this.localCommitQueue.add(pair);
            return true;
        }
        catch (Exception e) {
            this.localRequestQueue.add(pair);
            LOGGER.warn("Failed to trigger combine. watermark={}, count={}, progressIndex={}", new Object[]{watermark, count, progressIndex, e});
            return false;
        }
    }

    public void close() throws Exception {
        if (Objects.nonNull(this.twoStageAggregateSender)) {
            this.twoStageAggregateSender.close();
        }
        PipeCombineHandlerManager.getInstance().deregister(this.pipeName, this.creationTime);
    }
}

