/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tablet;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.resource.ref.PipePhantomReferenceManager;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.pipe.event.ReferenceTrackableEvent;
import org.apache.iotdb.db.pipe.event.common.PipeInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.parser.TabletInsertionEventParser;
import org.apache.iotdb.db.pipe.event.common.tablet.parser.TabletInsertionEventTablePatternParser;
import org.apache.iotdb.db.pipe.event.common.tablet.parser.TabletInsertionEventTreePatternParser;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.metric.PipeDataNodeRemainingEventAndTimeMetrics;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.db.pipe.resource.memory.PipeTabletMemoryBlock;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.record.Tablet;

public class PipeRawTabletInsertionEvent
extends PipeInsertionEvent
implements TabletInsertionEvent,
ReferenceTrackableEvent {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(PipeRawTabletInsertionEvent.class);
    private Tablet tablet;
    private String deviceId;
    private final boolean isAligned;
    private final EnrichedEvent sourceEvent;
    private boolean needToReport;
    private PipeTabletMemoryBlock allocatedMemoryBlock;
    private TabletInsertionEventParser eventParser;
    private volatile ProgressIndex overridingProgressIndex;

    private PipeRawTabletInsertionEvent(Boolean isTableModelEvent, String databaseName, Tablet tablet, boolean isAligned, EnrichedEvent sourceEvent, boolean needToReport, String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, long startTime, long endTime) {
        super(pipeName, creationTime, pipeTaskMeta, treePattern, tablePattern, startTime, endTime, isTableModelEvent, databaseName);
        this.tablet = Objects.requireNonNull(tablet);
        this.isAligned = isAligned;
        this.sourceEvent = sourceEvent;
        this.needToReport = needToReport;
    }

    public PipeRawTabletInsertionEvent(Boolean isTableModelEvent, String databaseName, Tablet tablet, boolean isAligned, String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent, boolean needToReport) {
        this(isTableModelEvent, databaseName, tablet, isAligned, sourceEvent, needToReport, pipeName, creationTime, pipeTaskMeta, null, null, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @TestOnly
    public PipeRawTabletInsertionEvent(Tablet tablet, boolean isAligned) {
        this(null, null, tablet, isAligned, null, false, null, 0L, null, null, null, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @TestOnly
    public PipeRawTabletInsertionEvent(Tablet tablet, boolean isAligned, TreePattern treePattern) {
        this(null, null, tablet, isAligned, null, false, null, 0L, null, treePattern, null, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @TestOnly
    public PipeRawTabletInsertionEvent(Tablet tablet, long startTime, long endTime) {
        this(null, null, tablet, false, null, false, null, 0L, null, null, null, startTime, endTime);
    }

    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().forceAllocateForTabletWithRetry(PipeMemoryWeightUtil.calculateTabletSizeInBytes(this.tablet) + INSTANCE_SIZE);
        if (Objects.nonNull(this.pipeName)) {
            PipeDataNodeRemainingEventAndTimeMetrics.getInstance().increaseTabletEventCount(this.pipeName, this.creationTime);
        }
        return true;
    }

    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        if (Objects.nonNull(this.pipeName)) {
            PipeDataNodeRemainingEventAndTimeMetrics.getInstance().decreaseTabletEventCount(this.pipeName, this.creationTime);
        }
        this.allocatedMemoryBlock.close();
        this.deviceId = this.tablet.getDeviceId();
        this.tablet = null;
        this.eventParser = null;
        return true;
    }

    protected void reportProgress() {
        if (this.needToReport) {
            super.reportProgress();
            if (this.sourceEvent instanceof PipeTsFileInsertionEvent) {
                ((PipeTsFileInsertionEvent)this.sourceEvent).eliminateProgressIndex();
            }
        }
    }

    public void bindProgressIndex(ProgressIndex overridingProgressIndex) {
        if (Objects.nonNull(overridingProgressIndex)) {
            this.markAsNeedToReport();
        }
        this.overridingProgressIndex = overridingProgressIndex;
    }

    public ProgressIndex getProgressIndex() {
        if (Objects.nonNull(this.overridingProgressIndex)) {
            return this.overridingProgressIndex;
        }
        return this.sourceEvent != null ? this.sourceEvent.getProgressIndex() : MinimumProgressIndex.INSTANCE;
    }

    public EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, long startTime, long endTime) {
        return new PipeRawTabletInsertionEvent(this.getRawIsTableModelEvent(), this.getTreeModelDatabaseName(), this.tablet, this.isAligned, this.sourceEvent, this.needToReport, pipeName, creationTime, pipeTaskMeta, treePattern, tablePattern, startTime, endTime);
    }

    public boolean isGeneratedByPipe() {
        throw new UnsupportedOperationException("isGeneratedByPipe() is not supported!");
    }

    public boolean mayEventTimeOverlappedWithTimeRange() {
        long[] timestamps = this.tablet.getTimestamps();
        if (Objects.isNull(timestamps) || timestamps.length == 0) {
            return false;
        }
        return this.startTime <= timestamps[timestamps.length - 1] && timestamps[0] <= this.endTime;
    }

    public boolean mayEventPathsOverlappedWithPattern() {
        return this.sourceEvent == null || this.sourceEvent.mayEventPathsOverlappedWithPattern();
    }

    public void markAsNeedToReport() {
        this.needToReport = true;
    }

    public String getDeviceId() {
        return Objects.nonNull(this.tablet) ? this.tablet.getDeviceId() : this.deviceId;
    }

    public EnrichedEvent getSourceEvent() {
        return this.sourceEvent;
    }

    public Iterable<TabletInsertionEvent> processRowByRow(BiConsumer<Row, RowCollector> consumer) {
        return this.initEventParser().processRowByRow(consumer);
    }

    public Iterable<TabletInsertionEvent> processTablet(BiConsumer<Tablet, RowCollector> consumer) {
        return this.initEventParser().processTablet(consumer);
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public Tablet convertToTablet() {
        if (!this.shouldParseTimeOrPattern()) {
            return this.tablet;
        }
        return this.initEventParser().convertToTablet();
    }

    private TabletInsertionEventParser initEventParser() {
        if (this.eventParser == null) {
            this.eventParser = this.tablet.getDeviceId().startsWith("root.") ? new TabletInsertionEventTreePatternParser(this.pipeTaskMeta, this, this.tablet, this.isAligned, this.treePattern) : new TabletInsertionEventTablePatternParser(this.pipeTaskMeta, this, this.tablet, this.isAligned, this.tablePattern);
        }
        return this.eventParser;
    }

    public long count() {
        Tablet covertedTablet = this.shouldParseTimeOrPattern() ? this.convertToTablet() : this.tablet;
        return (long)covertedTablet.getRowSize() * (long)covertedTablet.getSchemas().size();
    }

    public PipeRawTabletInsertionEvent parseEventWithPatternOrTime() {
        return new PipeRawTabletInsertionEvent(this.getRawIsTableModelEvent(), this.getTreeModelDatabaseName(), this.convertToTablet(), this.isAligned, this.pipeName, this.creationTime, this.pipeTaskMeta, this, this.needToReport);
    }

    public boolean hasNoNeedParsingAndIsEmpty() {
        return !this.shouldParseTimeOrPattern() && PipeRawTabletInsertionEvent.isTabletEmpty(this.tablet);
    }

    public static boolean isTabletEmpty(Tablet tablet) {
        return Objects.isNull(tablet) || tablet.getRowSize() == 0 || Objects.isNull(tablet.getSchemas()) || tablet.getSchemas().isEmpty();
    }

    public String toString() {
        return String.format("PipeRawTabletInsertionEvent{tablet=%s, isAligned=%s, sourceEvent=%s, needToReport=%s, allocatedMemoryBlock=%s, eventParser=%s}", this.tablet, this.isAligned, this.sourceEvent, this.needToReport, this.allocatedMemoryBlock, this.eventParser) + " - " + super.toString();
    }

    public String coreReportMessage() {
        return String.format("PipeRawTabletInsertionEvent{tablet=%s, isAligned=%s, sourceEvent=%s, needToReport=%s, allocatedMemoryBlock=%s}", this.tablet, this.isAligned, this.sourceEvent == null ? "null" : this.sourceEvent.coreReportMessage(), this.needToReport, this.allocatedMemoryBlock) + " - " + super.coreReportMessage();
    }

    protected void trackResource() {
        PipeDataNodeResourceManager.ref().trackPipeEventResource((EnrichedEvent)this, this.eventResourceBuilder());
    }

    @Override
    public PipePhantomReferenceManager.PipeEventResource eventResourceBuilder() {
        return new PipeRawTabletInsertionEventResource(this.isReleased, this.referenceCount, this.allocatedMemoryBlock);
    }

    private static class PipeRawTabletInsertionEventResource
    extends PipePhantomReferenceManager.PipeEventResource {
        private final PipeTabletMemoryBlock allocatedMemoryBlock;

        private PipeRawTabletInsertionEventResource(AtomicBoolean isReleased, AtomicInteger referenceCount, PipeTabletMemoryBlock allocatedMemoryBlock) {
            super(isReleased, referenceCount);
            this.allocatedMemoryBlock = allocatedMemoryBlock;
        }

        protected void finalizeResource() {
            this.allocatedMemoryBlock.close();
        }
    }
}

