/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.row;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.PipeInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.row.PipeBinaryTransformer;
import org.apache.iotdb.db.pipe.event.common.row.PipeResetTabletRow;
import org.apache.iotdb.db.pipe.event.common.row.PipeRow;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.pipe.api.type.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class PipeRowCollector
implements RowCollector {
    private final List<TabletInsertionEvent> tabletInsertionEventList = new ArrayList<TabletInsertionEvent>();
    private Tablet tablet = null;
    private boolean isAligned = false;
    private final PipeTaskMeta pipeTaskMeta;
    private final EnrichedEvent sourceEvent;

    public PipeRowCollector(PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent) {
        this.pipeTaskMeta = pipeTaskMeta;
        this.sourceEvent = sourceEvent;
    }

    public void collectRow(Row row) {
        if (!(row instanceof PipeRow)) {
            throw new PipeException("Row can not be customized");
        }
        PipeRow pipeRow = (PipeRow)row;
        IMeasurementSchema[] measurementSchemaArray = pipeRow.getMeasurementSchemaList();
        if (row instanceof PipeResetTabletRow) {
            this.collectTabletInsertionEvent();
        }
        if (this.tablet == null) {
            String deviceId = pipeRow.getDeviceId();
            ArrayList<IMeasurementSchema> measurementSchemaList = new ArrayList<IMeasurementSchema>(Arrays.asList(measurementSchemaArray));
            Pair<Integer, Integer> rowCountAndMemorySize = PipeMemoryWeightUtil.calculateTabletRowCountAndMemory(pipeRow);
            this.tablet = new Tablet(deviceId, measurementSchemaList, ((Integer)rowCountAndMemorySize.getLeft()).intValue());
            this.tablet.initBitMaps();
            this.isAligned = pipeRow.isAligned();
        }
        int rowIndex = this.tablet.getRowSize();
        this.tablet.addTimestamp(rowIndex, row.getTime());
        for (int i = 0; i < row.size(); ++i) {
            Object value = row.getObject(i);
            if (value instanceof Binary) {
                this.tablet.addValue(measurementSchemaArray[i].getMeasurementName(), rowIndex, (Object)PipeBinaryTransformer.transformToBinary((Binary)value));
            } else {
                this.tablet.addValue(measurementSchemaArray[i].getMeasurementName(), rowIndex, value);
            }
            if (!row.isNull(i)) continue;
            this.tablet.getBitMaps()[i].mark(rowIndex);
        }
        if (this.tablet.getRowSize() == this.tablet.getMaxRowNumber()) {
            this.collectTabletInsertionEvent();
        }
    }

    private void collectTabletInsertionEvent() {
        if (this.tablet != null) {
            PipeInsertionEvent pipeInsertionEvent = this.sourceEvent instanceof PipeInsertionEvent ? (PipeInsertionEvent)this.sourceEvent : null;
            this.tabletInsertionEventList.add(new PipeRawTabletInsertionEvent(pipeInsertionEvent == null ? null : Boolean.valueOf(pipeInsertionEvent.isTableModelEvent()), pipeInsertionEvent == null ? null : pipeInsertionEvent.getTreeModelDatabaseName(), this.tablet, this.isAligned, this.sourceEvent == null ? null : this.sourceEvent.getPipeName(), this.sourceEvent == null ? 0L : this.sourceEvent.getCreationTime(), this.pipeTaskMeta, this.sourceEvent, false));
        }
        this.tablet = null;
    }

    public List<TabletInsertionEvent> convertToTabletInsertionEvents(boolean shouldReport) {
        this.collectTabletInsertionEvent();
        int eventListSize = this.tabletInsertionEventList.size();
        if (eventListSize > 0 && shouldReport) {
            ((PipeRawTabletInsertionEvent)this.tabletInsertionEventList.get(eventListSize - 1)).markAsNeedToReport();
        }
        return this.tabletInsertionEventList;
    }
}

