/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common;

import javax.validation.constraints.NotNull;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.utils.PathUtils;

public abstract class PipeInsertionEvent
extends EnrichedEvent {
    private Boolean isTableModelEvent;
    private String treeModelDatabaseName;
    private String tableModelDatabaseName;

    protected PipeInsertionEvent(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, long startTime, long endTime, Boolean isTableModelEvent, String treeModelDatabaseName, String tableModelDatabaseName) {
        super(pipeName, creationTime, pipeTaskMeta, treePattern, tablePattern, startTime, endTime);
        this.isTableModelEvent = isTableModelEvent;
        this.treeModelDatabaseName = treeModelDatabaseName;
        if (tableModelDatabaseName != null) {
            this.tableModelDatabaseName = tableModelDatabaseName.toLowerCase();
        }
    }

    protected PipeInsertionEvent(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, long startTime, long endTime, Boolean isTableModelEvent, String databaseNameFromDataRegion) {
        this(pipeName, creationTime, pipeTaskMeta, treePattern, tablePattern, startTime, endTime, isTableModelEvent, databaseNameFromDataRegion, null);
    }

    public void markAsTableModelEvent() {
        this.isTableModelEvent = Boolean.TRUE;
    }

    public void markAsTreeModelEvent() {
        this.isTableModelEvent = Boolean.FALSE;
    }

    public boolean isTableModelEvent() {
        if (this.isTableModelEvent == null) {
            throw new IllegalStateException("isTableModelEvent is not initialized");
        }
        return this.isTableModelEvent;
    }

    protected Boolean getRawIsTableModelEvent() {
        return this.isTableModelEvent;
    }

    public String getTreeModelDatabaseName() {
        return this.treeModelDatabaseName;
    }

    public String getTableModelDatabaseName() {
        return this.tableModelDatabaseName == null ? (this.tableModelDatabaseName = PathUtils.unQualifyDatabaseName((String)this.treeModelDatabaseName)) : this.tableModelDatabaseName;
    }

    public void renameTableModelDatabase(@NotNull String tableModelDatabaseName) {
        this.tableModelDatabaseName = tableModelDatabaseName.toLowerCase();
        this.treeModelDatabaseName = "root." + tableModelDatabaseName;
    }
}

