/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.consensus.deletion;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.SimpleProgressIndex;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.consensus.pipe.PipeConsensus;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.pipe.consensus.ProgressIndexDataNodeManager;
import org.apache.iotdb.db.pipe.consensus.deletion.DeletionResource;
import org.apache.iotdb.db.pipe.consensus.deletion.persist.DeletionBuffer;
import org.apache.iotdb.db.pipe.consensus.deletion.persist.PageCacheDeletionBuffer;
import org.apache.iotdb.db.pipe.consensus.deletion.recover.DeletionReader;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.AbstractDeleteDataNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletionResourceManager
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeletionResourceManager.class);
    public static final String DELETION_FILE_SUFFIX = ".deletion";
    public static final String MAGIC_VERSION_V1 = "DELETION_V1";
    private static final String REBOOT_TIME = "rebootTime";
    private static final String MEM_TABLE_FLUSH_ORDER = "memTableFlushOrderId";
    private static final String DELETION_FILE_NAME_PATTERN = String.format("^_(?<%s>\\d+)-(?<%s>\\d+)\\%s$", "rebootTime", "memTableFlushOrderId", ".deletion");
    private final String dataRegionId;
    private final DeletionBuffer deletionBuffer;
    private final File storageDir;
    private final Map<AbstractDeleteDataNode, DeletionResource> deleteNode2ResourcesMap = new ConcurrentHashMap<AbstractDeleteDataNode, DeletionResource>();
    private final Lock recoverLock = new ReentrantLock();
    private final Condition recoveryReadyCondition = this.recoverLock.newCondition();
    private volatile boolean hasCompletedRecovery = false;

    private DeletionResourceManager(String dataRegionId) throws IOException {
        this.dataRegionId = dataRegionId;
        this.storageDir = new File(IoTDBDescriptor.getInstance().getConfig().getIotConsensusV2DeletionFileDir() + File.separator + dataRegionId);
        this.deletionBuffer = new PageCacheDeletionBuffer(dataRegionId, this.storageDir.getAbsolutePath());
        this.initAndRecover();
        this.deletionBuffer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAndRecover() throws IOException {
        this.recoverLock.lock();
        try {
            if (!this.storageDir.exists() && !this.storageDir.mkdirs()) {
                LOGGER.warn("Unable to create pipeConsensus deletion dir at {}", (Object)this.storageDir);
                throw new IOException(String.format("Unable to create pipeConsensus deletion dir at %s", this.storageDir));
            }
            try (Stream<Path> pathStream = Files.walk(Paths.get(this.storageDir.getPath(), new String[0]), 1, new FileVisitOption[0]);){
                Path[] deletionPaths;
                for (Path path2 : deletionPaths = (Path[])pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().matches(DELETION_FILE_NAME_PATTERN)).toArray(Path[]::new)) {
                    try (DeletionReader deletionReader = new DeletionReader(path2.toFile(), this.dataRegionId, this::removeDeletionResource);){
                        deletionReader.readAllDeletions().forEach(deletion -> this.deleteNode2ResourcesMap.computeIfAbsent(deletion.getDeleteDataNode(), key -> deletion));
                    }
                    catch (IOException e) {
                        LOGGER.warn("Detect file corrupted when recover DAL-{}, discard all subsequent DALs...", (Object)path2.getFileName());
                        break;
                    }
                }
                this.hasCompletedRecovery = true;
                this.recoveryReadyCondition.signalAll();
            }
        }
        finally {
            this.recoverLock.unlock();
        }
    }

    @Override
    public void close() {
        LOGGER.info("Closing deletion resource manager for {}...", (Object)this.dataRegionId);
        this.deleteNode2ResourcesMap.clear();
        this.deletionBuffer.close();
        LOGGER.info("Deletion resource manager for {} has been successfully closed!", (Object)this.dataRegionId);
    }

    public DeletionResource registerDeletionResource(AbstractDeleteDataNode deleteDataNode) {
        DeletionResource deletionResource = this.deleteNode2ResourcesMap.computeIfAbsent(deleteDataNode, key -> new DeletionResource(deleteDataNode, this::removeDeletionResource, this.dataRegionId));
        this.deletionBuffer.registerDeletionResource(deletionResource);
        return deletionResource;
    }

    public DeletionResource getDeletionResource(AbstractDeleteDataNode deleteDataNode) {
        return this.deleteNode2ResourcesMap.get(deleteDataNode);
    }

    public List<DeletionResource> getAllDeletionResources() {
        this.recoverLock.lock();
        try {
            if (!this.hasCompletedRecovery) {
                this.recoveryReadyCondition.await();
            }
            List list = (List)this.deleteNode2ResourcesMap.values().stream().collect(ImmutableList.toImmutableList());
            return list;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("DeletionManager-{}: current waiting is interrupted. May because current application is down. ", (Object)this.dataRegionId, (Object)e);
            List list = (List)this.deleteNode2ResourcesMap.values().stream().collect(ImmutableList.toImmutableList());
            return list;
        }
        finally {
            this.recoverLock.unlock();
        }
    }

    private synchronized void removeDeletionResource(DeletionResource deletionResource) {
        this.deleteNode2ResourcesMap.remove(deletionResource.getDeleteDataNode());
        ProgressIndex currentProgressIndex = ProgressIndexDataNodeManager.extractLocalSimpleProgressIndex(deletionResource.getProgressIndex());
        try (Stream<Path> pathStream = Files.walk(Paths.get(this.storageDir.getPath(), new String[0]), 1, new FileVisitOption[0]);){
            Path[] deletionPaths = (Path[])pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().matches(DELETION_FILE_NAME_PATTERN)).filter(path -> this.isFileProgressCoveredByGivenProgress(path.getFileName().toString(), currentProgressIndex)).sorted(this::compareFileProgressIndex).toArray(Path[]::new);
            for (int i = 0; i < deletionPaths.length - 1; ++i) {
                File fileToDelete = deletionPaths[i].toFile();
                FileUtils.deleteFileOrDirectory((File)fileToDelete);
                LOGGER.info("DeletionManager-{} delete deletion file in {} dir...", (Object)this.dataRegionId, (Object)fileToDelete);
            }
        }
        catch (IOException e) {
            LOGGER.warn("DeletionManager-{} failed to delete file in {} dir, please manually check!", (Object)this.dataRegionId, (Object)this.storageDir);
        }
    }

    private int compareFileProgressIndex(Path file1, Path file2) {
        Pattern pattern = Pattern.compile(DELETION_FILE_NAME_PATTERN);
        String fileName1 = file1.getFileName().toString();
        String fileName2 = file2.getFileName().toString();
        Matcher matcher1 = pattern.matcher(fileName1);
        Matcher matcher2 = pattern.matcher(fileName2);
        if (matcher1.matches() && matcher2.matches()) {
            int fileRebootTimes1 = Integer.parseInt(matcher1.group(REBOOT_TIME));
            long fileMemTableFlushOrderId1 = Long.parseLong(matcher1.group(MEM_TABLE_FLUSH_ORDER));
            int fileRebootTimes2 = Integer.parseInt(matcher2.group(REBOOT_TIME));
            long fileMemTableFlushOrderId2 = Long.parseLong(matcher2.group(MEM_TABLE_FLUSH_ORDER));
            int rebootCompareRes = Integer.compare(fileRebootTimes1, fileRebootTimes2);
            return rebootCompareRes == 0 ? Long.compare(fileMemTableFlushOrderId1, fileMemTableFlushOrderId2) : rebootCompareRes;
        }
        return 0;
    }

    private boolean isFileProgressCoveredByGivenProgress(String fileName, ProgressIndex currentProgressIndex) {
        if (currentProgressIndex instanceof SimpleProgressIndex) {
            SimpleProgressIndex simpleProgressIndex = (SimpleProgressIndex)currentProgressIndex;
            int curRebootTimes = simpleProgressIndex.getRebootTimes();
            long curMemTableFlushOrderId = simpleProgressIndex.getMemTableFlushOrderId();
            Pattern pattern = Pattern.compile(DELETION_FILE_NAME_PATTERN);
            Matcher matcher = pattern.matcher(fileName);
            if (matcher.matches()) {
                int fileRebootTimes = Integer.parseInt(matcher.group(REBOOT_TIME));
                long fileMemTableFlushOrderId = Long.parseLong(matcher.group(MEM_TABLE_FLUSH_ORDER));
                return fileRebootTimes == curRebootTimes ? fileMemTableFlushOrderId <= curMemTableFlushOrderId : fileRebootTimes < curRebootTimes;
            }
        }
        return false;
    }

    public static DeletionResourceManager getInstance(String groupId) {
        if (DeletionResourceManagerHolder.CONSENSU_GROUP_ID_2_INSTANCE_MAP == null) {
            return null;
        }
        return DeletionResourceManagerHolder.CONSENSU_GROUP_ID_2_INSTANCE_MAP.computeIfAbsent(groupId, key -> {
            try {
                return new DeletionResourceManager(groupId);
            }
            catch (IOException e) {
                LOGGER.error("Failed to initialize DeletionResourceManager", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    public static void build() {
        if (DataRegionConsensusImpl.getInstance() instanceof PipeConsensus) {
            DeletionResourceManagerHolder.build();
        }
    }

    public static void exit() {
        if (DeletionResourceManagerHolder.CONSENSU_GROUP_ID_2_INSTANCE_MAP == null) {
            return;
        }
        DeletionResourceManagerHolder.CONSENSU_GROUP_ID_2_INSTANCE_MAP.forEach((groupId, resourceManager) -> resourceManager.close());
    }

    @TestOnly
    public static void buildForTest() {
        DeletionResourceManagerHolder.build();
    }

    @TestOnly
    public void recoverForTest() {
        try (Stream<Path> pathStream = Files.walk(Paths.get(this.storageDir.getPath(), new String[0]), 1, new FileVisitOption[0]);){
            Path[] deletionPaths;
            for (Path path2 : deletionPaths = (Path[])pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().matches(DELETION_FILE_NAME_PATTERN)).toArray(Path[]::new)) {
                try (DeletionReader deletionReader = new DeletionReader(path2.toFile(), this.dataRegionId, this::removeDeletionResource);){
                    deletionReader.readAllDeletions().forEach(deletion -> this.deleteNode2ResourcesMap.computeIfAbsent(deletion.getDeleteDataNode(), key -> deletion));
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to recover DeletionResourceManager", (Throwable)e);
        }
    }

    private static class DeletionResourceManagerHolder {
        private static Map<String, DeletionResourceManager> CONSENSU_GROUP_ID_2_INSTANCE_MAP;

        private DeletionResourceManagerHolder() {
        }

        public static void build() {
            if (CONSENSU_GROUP_ID_2_INSTANCE_MAP == null) {
                CONSENSU_GROUP_ID_2_INSTANCE_MAP = new ConcurrentHashMap<String, DeletionResourceManager>();
            }
        }
    }
}

