/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task.connection;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.agent.task.progress.PipeEventCommitManager;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.ProgressReportEvent;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.event.common.deletion.PipeDeleteDataNodeEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeEventCollector
implements EventCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeEventCollector.class);
    private final UnboundedBlockingPendingQueue<Event> pendingQueue;
    private final long creationTime;
    private final int regionId;
    private final boolean forceTabletFormat;
    private final AtomicInteger collectInvocationCount = new AtomicInteger(0);
    private boolean hasNoGeneratedEvent = true;
    private boolean isFailedToIncreaseReferenceCount = false;

    public PipeEventCollector(UnboundedBlockingPendingQueue<Event> pendingQueue, long creationTime, int regionId, boolean forceTabletFormat) {
        this.pendingQueue = pendingQueue;
        this.creationTime = creationTime;
        this.regionId = regionId;
        this.forceTabletFormat = forceTabletFormat;
    }

    public void collect(Event event) {
        try {
            if (event instanceof PipeInsertNodeTabletInsertionEvent) {
                this.parseAndCollectEvent((PipeInsertNodeTabletInsertionEvent)event);
            } else if (event instanceof PipeRawTabletInsertionEvent) {
                this.parseAndCollectEvent((PipeRawTabletInsertionEvent)event);
            } else if (event instanceof PipeTsFileInsertionEvent) {
                this.parseAndCollectEvent((PipeTsFileInsertionEvent)event);
            } else if (event instanceof PipeDeleteDataNodeEvent) {
                this.collectEvent(event);
            } else if (!(event instanceof ProgressReportEvent)) {
                this.collectEvent(event);
            }
        }
        catch (PipeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PipeException("Error occurred when collecting events from processor.", (Throwable)e);
        }
    }

    private void parseAndCollectEvent(PipeInsertNodeTabletInsertionEvent sourceEvent) {
        if (sourceEvent.shouldParseTimeOrPattern()) {
            for (PipeRawTabletInsertionEvent parsedEvent : sourceEvent.toRawTabletInsertionEvents()) {
                this.collectParsedRawTableEvent(parsedEvent);
            }
        } else {
            this.collectEvent((Event)sourceEvent);
        }
    }

    private void parseAndCollectEvent(PipeRawTabletInsertionEvent sourceEvent) {
        this.collectParsedRawTableEvent(sourceEvent.shouldParseTimeOrPattern() ? sourceEvent.parseEventWithPatternOrTime() : sourceEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAndCollectEvent(PipeTsFileInsertionEvent sourceEvent) throws Exception {
        if (!sourceEvent.waitForTsFileClose()) {
            LOGGER.warn("Pipe skipping temporary TsFile which shouldn't be transferred: {}", (Object)sourceEvent.getTsFile());
            return;
        }
        if (!(this.forceTabletFormat || sourceEvent.shouldParseTimeOrPattern() && (!sourceEvent.isTableModelEvent() || sourceEvent.getTablePattern() != null && sourceEvent.getTablePattern().hasTablePattern() || sourceEvent.shouldParseTime()))) {
            this.collectEvent((Event)sourceEvent);
            return;
        }
        try {
            for (TabletInsertionEvent parsedEvent : sourceEvent.toTabletInsertionEvents()) {
                this.collectParsedRawTableEvent((PipeRawTabletInsertionEvent)parsedEvent);
            }
        }
        finally {
            sourceEvent.close();
        }
    }

    private void collectParsedRawTableEvent(PipeRawTabletInsertionEvent parsedEvent) {
        if (!parsedEvent.hasNoNeedParsingAndIsEmpty()) {
            this.hasNoGeneratedEvent = false;
            this.collectEvent((Event)parsedEvent);
        }
    }

    private void collectEvent(Event event) {
        if (event instanceof EnrichedEvent) {
            if (!((EnrichedEvent)event).increaseReferenceCount(PipeEventCollector.class.getName())) {
                LOGGER.warn("PipeEventCollector: The event {} is already released, skipping it.", (Object)event);
                this.isFailedToIncreaseReferenceCount = true;
                return;
            }
            PipeEventCommitManager.getInstance().enrichWithCommitterKeyAndCommitId((EnrichedEvent)event, this.creationTime, this.regionId);
            ((EnrichedEvent)event).setRebootTimes(PipeDataNodeAgent.runtime().getRebootTimes());
        }
        if (event instanceof PipeHeartbeatEvent) {
            ((PipeHeartbeatEvent)event).recordConnectorQueueSize(this.pendingQueue);
        }
        this.pendingQueue.directOffer(event);
        this.collectInvocationCount.incrementAndGet();
    }

    public void resetFlags() {
        this.collectInvocationCount.set(0);
        this.hasNoGeneratedEvent = true;
        this.isFailedToIncreaseReferenceCount = false;
    }

    public long getCollectInvocationCount() {
        return this.collectInvocationCount.get();
    }

    public boolean hasNoCollectInvocationAfterReset() {
        return this.collectInvocationCount.get() == 0;
    }

    public boolean hasNoGeneratedEvent() {
        return this.hasNoGeneratedEvent;
    }

    public boolean isFailedToIncreaseReferenceCount() {
        return this.isFailedToIncreaseReferenceCount;
    }
}

