/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.pipe;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeTsFileEventBatch;
import org.apache.iotdb.db.subscription.event.pipe.SubscriptionPipeEvents;

public class SubscriptionPipeTsFileBatchEvents
implements SubscriptionPipeEvents {
    private final SubscriptionPipeTsFileEventBatch batch;
    private final AtomicInteger referenceCount;
    private final int count;

    public SubscriptionPipeTsFileBatchEvents(SubscriptionPipeTsFileEventBatch batch, AtomicInteger referenceCount) {
        this.batch = batch;
        this.referenceCount = referenceCount;
        this.count = Math.max(1, referenceCount.get());
    }

    @Override
    public void ack() {
        if (this.referenceCount.decrementAndGet() == 0) {
            this.batch.ack();
        }
    }

    @Override
    public void cleanUp() {
        if (this.referenceCount.decrementAndGet() == 0) {
            this.batch.cleanUp();
        }
    }

    public String toString() {
        return "SubscriptionPipeTsFileBatchEvents{batch=" + this.batch + ", referenceCount=" + this.referenceCount + "}";
    }

    @Override
    public int getPipeEventCount() {
        return (this.batch.getPipeEventCount() + this.count - 1) / this.count;
    }
}

