/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.cache;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.pipe.resource.memory.PipeFixedMemoryBlock;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponse;

public class CachedSubscriptionPollResponse
extends SubscriptionPollResponse {
    private volatile ByteBuffer byteBuffer;
    private volatile PipeFixedMemoryBlock memoryBlock;

    public CachedSubscriptionPollResponse(short responseType, SubscriptionPollPayload payload, SubscriptionCommitContext commitContext) {
        super(responseType, payload, commitContext);
    }

    public CachedSubscriptionPollResponse(SubscriptionPollResponse response) {
        super(response.getResponseType(), response.getPayload(), response.getCommitContext());
    }

    public void setMemoryBlock(PipeFixedMemoryBlock memoryBlock) {
        this.memoryBlock = memoryBlock;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public void invalidateByteBuffer() {
        this.byteBuffer = null;
        if (Objects.nonNull(this.memoryBlock)) {
            this.memoryBlock.close();
        }
    }

    public static ByteBuffer serialize(CachedSubscriptionPollResponse response) throws IOException {
        return response.serialize();
    }

    private ByteBuffer serialize() throws IOException {
        return Objects.nonNull(this.byteBuffer) ? this.byteBuffer : (this.byteBuffer = SubscriptionPollResponse.serialize((SubscriptionPollResponse)this));
    }

    public String toString() {
        return "CachedSubscriptionPollResponse" + this.coreReportMessage();
    }

    protected Map<String, String> coreReportMessage() {
        Map coreReportMessage = super.coreReportMessage();
        coreReportMessage.put("sizeof(byteBuffer)", Objects.isNull(this.byteBuffer) ? "<unknown>" : String.valueOf(this.byteBuffer.limit() - this.byteBuffer.position()));
        return coreReportMessage;
    }
}

