/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemAlignedPageReader;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.IChunkReader;
import org.apache.tsfile.read.reader.IPageReader;

public class MemAlignedChunkReader
implements IChunkReader {
    private final List<IPageReader> pageReaderList;

    public MemAlignedChunkReader(AlignedReadOnlyMemChunk readableChunk, Filter globalTimeFilter) {
        this.pageReaderList = Collections.singletonList(new MemAlignedPageReader(readableChunk.getTsBlock(), (AlignedChunkMetadata)readableChunk.getChunkMetaData(), globalTimeFilter));
    }

    public boolean hasNextSatisfiedPage() throws IOException {
        throw new IOException("mem chunk reader does not support this method");
    }

    public BatchData nextPageData() throws IOException {
        throw new IOException("mem chunk reader does not support this method");
    }

    public void close() {
    }

    public List<IPageReader> loadPageReaderList() {
        return this.pageReaderList;
    }
}

