/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemAlignedChunkLoader;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.controller.IChunkLoader;
import org.apache.tsfile.read.reader.IPointReader;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class AlignedReadOnlyMemChunk
extends ReadOnlyMemChunk {
    private final String timeChunkName;
    private final List<String> valueChunkNames;
    private final List<TSDataType> dataTypes;

    public AlignedReadOnlyMemChunk(QueryContext context, IMeasurementSchema schema, TVList tvList, List<TimeRange> timeColumnDeletion, List<List<TimeRange>> valueColumnsDeletionList) throws QueryProcessException {
        super(context);
        this.timeChunkName = schema.getMeasurementName();
        this.valueChunkNames = schema.getSubMeasurementsList();
        this.dataTypes = schema.getSubMeasurementsTSDataTypeList();
        int floatPrecision = TSFileDescriptor.getInstance().getConfig().getFloatPrecision();
        List encodingList = schema.getSubMeasurementsTSEncodingList();
        this.tsBlock = ((AlignedTVList)tvList).buildTsBlock(floatPrecision, encodingList, timeColumnDeletion, valueColumnsDeletionList, context.isIgnoreAllNullRows());
        this.initAlignedChunkMetaFromTsBlock();
    }

    private void initAlignedChunkMetaFromTsBlock() throws QueryProcessException {
        Statistics timeStatistics = Statistics.getStatsByType((TSDataType)TSDataType.VECTOR);
        ChunkMetadata timeChunkMetadata = new ChunkMetadata(this.timeChunkName, TSDataType.VECTOR, null, null, 0L, timeStatistics);
        ArrayList<ChunkMetadata> valueChunkMetadataList = new ArrayList<ChunkMetadata>();
        for (int row = 0; row < this.tsBlock.getPositionCount(); ++row) {
            timeStatistics.update(this.tsBlock.getTimeColumn().getLong(row));
        }
        timeStatistics.setEmpty(false);
        for (int column = 0; column < this.tsBlock.getValueColumnCount(); ++column) {
            Statistics valueStatistics = Statistics.getStatsByType((TSDataType)this.dataTypes.get(column));
            valueStatistics.setEmpty(true);
            switch (this.dataTypes.get(column)) {
                case BOOLEAN: {
                    long time;
                    int row;
                    for (row = 0; row < this.tsBlock.getPositionCount(); ++row) {
                        if (this.tsBlock.getColumn(column).isNull(row)) continue;
                        time = this.tsBlock.getTimeColumn().getLong(row);
                        valueStatistics.update(time, this.tsBlock.getColumn(column).getBoolean(row));
                    }
                    break;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    long time;
                    int row;
                    for (row = 0; row < this.tsBlock.getPositionCount(); ++row) {
                        if (this.tsBlock.getColumn(column).isNull(row)) continue;
                        time = this.tsBlock.getTimeColumn().getLong(row);
                        valueStatistics.update(time, this.tsBlock.getColumn(column).getBinary(row));
                    }
                    break;
                }
                case FLOAT: {
                    long time;
                    int row;
                    for (row = 0; row < this.tsBlock.getPositionCount(); ++row) {
                        if (this.tsBlock.getColumn(column).isNull(row)) continue;
                        time = this.tsBlock.getTimeColumn().getLong(row);
                        valueStatistics.update(time, this.tsBlock.getColumn(column).getFloat(row));
                    }
                    break;
                }
                case INT32: 
                case DATE: {
                    long time;
                    int row;
                    for (row = 0; row < this.tsBlock.getPositionCount(); ++row) {
                        if (this.tsBlock.getColumn(column).isNull(row)) continue;
                        time = this.tsBlock.getTimeColumn().getLong(row);
                        valueStatistics.update(time, this.tsBlock.getColumn(column).getInt(row));
                    }
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    long time;
                    int row;
                    for (row = 0; row < this.tsBlock.getPositionCount(); ++row) {
                        if (this.tsBlock.getColumn(column).isNull(row)) continue;
                        time = this.tsBlock.getTimeColumn().getLong(row);
                        valueStatistics.update(time, this.tsBlock.getColumn(column).getLong(row));
                    }
                    break;
                }
                case DOUBLE: {
                    long time;
                    int row;
                    for (row = 0; row < this.tsBlock.getPositionCount(); ++row) {
                        if (this.tsBlock.getColumn(column).isNull(row)) continue;
                        time = this.tsBlock.getTimeColumn().getLong(row);
                        valueStatistics.update(time, this.tsBlock.getColumn(column).getDouble(row));
                    }
                    break;
                }
                default: {
                    throw new QueryProcessException("Unsupported data type:" + this.dataTypes.get(column));
                }
            }
            if (valueStatistics.getCount() > 0) {
                ChunkMetadata valueChunkMetadata = new ChunkMetadata(this.valueChunkNames.get(column), this.dataTypes.get(column), null, null, 0L, valueStatistics);
                valueChunkMetadataList.add(valueChunkMetadata);
                valueStatistics.setEmpty(false);
                continue;
            }
            valueChunkMetadataList.add(null);
        }
        AlignedChunkMetadata alignedChunkMetadata = new AlignedChunkMetadata((IChunkMetadata)timeChunkMetadata, valueChunkMetadataList);
        alignedChunkMetadata.setChunkLoader((IChunkLoader)new MemAlignedChunkLoader(this.context, this));
        alignedChunkMetadata.setVersion(Long.MAX_VALUE);
        this.cachedMetaData = alignedChunkMetadata;
    }

    @Override
    public boolean isEmpty() {
        return this.tsBlock.isEmpty();
    }

    @Override
    public IPointReader getPointReader() {
        return this.tsBlock.getTsBlockAlignedRowIterator();
    }
}

