/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.ModifiedStatus;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.AlignedSeriesBatchCompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.SeriesCompactionExecutor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.AlignedPageElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.ChunkMetadataElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.FileElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.PageElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.reader.CompactionAlignedChunkReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.reader.CompactionChunkReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileReader;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.PatternTreeMapFactory;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.tsfile.write.chunk.IChunkWriter;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class FastAlignedSeriesCompactionExecutor
extends SeriesCompactionExecutor {
    protected final Map<String, Map<TsFileResource, Pair<Long, Long>>> timeseriesMetadataOffsetMap;
    protected final List<IMeasurementSchema> measurementSchemas;
    protected final IMeasurementSchema timeColumnMeasurementSchema;
    protected final Map<String, IMeasurementSchema> measurementSchemaMap;
    protected final boolean ignoreAllNullRows;

    public FastAlignedSeriesCompactionExecutor(AbstractCompactionWriter compactionWriter, Map<String, Map<TsFileResource, Pair<Long, Long>>> timeseriesMetadataOffsetMap, Map<TsFileResource, TsFileSequenceReader> readerCacheMap, Map<String, PatternTreeMap<ModEntry, PatternTreeMapFactory.ModsSerializer>> modificationCacheMap, List<TsFileResource> sortedSourceFiles, IDeviceID deviceId, int subTaskId, List<IMeasurementSchema> measurementSchemas, FastCompactionTaskSummary summary, boolean ignoreAllNullRows) {
        super(compactionWriter, readerCacheMap, modificationCacheMap, deviceId, true, subTaskId, summary);
        this.timeseriesMetadataOffsetMap = timeseriesMetadataOffsetMap;
        this.measurementSchemas = measurementSchemas;
        this.timeColumnMeasurementSchema = measurementSchemas.get(0);
        this.measurementSchemaMap = new HashMap<String, IMeasurementSchema>();
        this.measurementSchemas.forEach(schema -> this.measurementSchemaMap.put(schema.getMeasurementName(), (IMeasurementSchema)schema));
        this.ignoreAllNullRows = ignoreAllNullRows;
        sortedSourceFiles.forEach(x -> this.fileList.add(new FileElement((TsFileResource)x)));
    }

    @Override
    public void execute() throws PageException, IllegalPathException, IOException, WriteProcessException {
        this.compactionWriter.startMeasurement("", (IChunkWriter)new AlignedChunkWriterImpl(this.measurementSchemas.remove(0), this.measurementSchemas), this.subTaskId);
        this.compactFiles();
        this.compactionWriter.endMeasurement(this.subTaskId);
    }

    @Override
    protected void compactFiles() throws PageException, IOException, WriteProcessException, IllegalPathException {
        this.markStartOfAlignedSeries();
        while (!this.fileList.isEmpty()) {
            List<FileElement> overlappedFiles = this.findOverlapFiles((FileElement)this.fileList.get(0));
            this.deserializeFileIntoChunkMetadataQueue(overlappedFiles);
            this.compactChunks();
        }
        this.markEndOfAlignedSeries();
    }

    private void markStartOfAlignedSeries() {
        for (TsFileSequenceReader reader : this.readerCacheMap.values()) {
            if (!(reader instanceof CompactionTsFileReader)) continue;
            ((CompactionTsFileReader)reader).markStartOfAlignedSeries();
        }
    }

    private void markEndOfAlignedSeries() {
        for (TsFileSequenceReader reader : this.readerCacheMap.values()) {
            if (!(reader instanceof CompactionTsFileReader)) continue;
            ((CompactionTsFileReader)reader).markEndOfAlignedSeries();
        }
    }

    @Override
    void deserializeFileIntoChunkMetadataQueue(List<FileElement> fileElements) throws IOException, IllegalPathException {
        for (FileElement fileElement : fileElements) {
            TsFileResource resource = fileElement.resource;
            List<AlignedChunkMetadata> alignedChunkMetadataList = this.getAlignedChunkMetadataList(resource);
            if (alignedChunkMetadataList.isEmpty()) {
                this.removeFile(fileElement);
            }
            for (int i = 0; i < alignedChunkMetadataList.size(); ++i) {
                this.chunkMetadataQueue.add(new ChunkMetadataElement((IChunkMetadata)alignedChunkMetadataList.get(i), i == alignedChunkMetadataList.size() - 1, fileElement));
            }
        }
    }

    protected List<AlignedChunkMetadata> getAlignedChunkMetadataList(TsFileResource resource) throws IOException, IllegalPathException {
        List timeChunkMetadatas = null;
        ArrayList<List> valueChunkMetadatas = new ArrayList<List>();
        for (Map.Entry<String, Map<TsFileResource, Pair<Long, Long>>> entry : this.timeseriesMetadataOffsetMap.entrySet()) {
            String measurementID = entry.getKey();
            Pair<Long, Long> timeseriesOffsetInCurrentFile = entry.getValue().get(resource);
            if (measurementID.equals("")) {
                if (timeseriesOffsetInCurrentFile == null) {
                    timeChunkMetadatas = null;
                    break;
                }
                timeChunkMetadatas = ((TsFileSequenceReader)this.readerCacheMap.get(resource)).getChunkMetadataListByTimeseriesMetadataOffset(((Long)timeseriesOffsetInCurrentFile.left).longValue(), ((Long)timeseriesOffsetInCurrentFile.right).longValue());
                continue;
            }
            if (timeseriesOffsetInCurrentFile == null) {
                valueChunkMetadatas.add(null);
                continue;
            }
            List valueColumnChunkMetadataList = ((TsFileSequenceReader)this.readerCacheMap.get(resource)).getChunkMetadataListByTimeseriesMetadataOffset(((Long)timeseriesOffsetInCurrentFile.left).longValue(), ((Long)timeseriesOffsetInCurrentFile.right).longValue());
            if (this.isValueChunkDataTypeMatchSchema(valueColumnChunkMetadataList)) {
                valueChunkMetadatas.add(valueColumnChunkMetadataList);
                continue;
            }
            valueChunkMetadatas.add(null);
        }
        ArrayList<AlignedChunkMetadata> alignedChunkMetadataList = new ArrayList<AlignedChunkMetadata>();
        if (timeChunkMetadatas != null) {
            for (int i = 0; i < timeChunkMetadatas.size(); ++i) {
                ArrayList<IChunkMetadata> valueChunkMetadataList = new ArrayList<IChunkMetadata>();
                for (List chunkMetadata : valueChunkMetadatas) {
                    if (chunkMetadata == null) {
                        valueChunkMetadataList.add(null);
                        continue;
                    }
                    valueChunkMetadataList.add((IChunkMetadata)chunkMetadata.get(i));
                }
                AlignedChunkMetadata alignedChunkMetadata = new AlignedChunkMetadata((IChunkMetadata)timeChunkMetadatas.get(i), valueChunkMetadataList);
                alignedChunkMetadataList.add(alignedChunkMetadata);
            }
            List<ModEntry> timeModifications = this.getModificationsFromCache(resource, CompactionPathUtils.getPath(this.deviceId, ""));
            ArrayList<List<ModEntry>> valueModifications = new ArrayList<List<ModEntry>>();
            ((AlignedChunkMetadata)alignedChunkMetadataList.get(0)).getValueChunkMetadataList().forEach(x -> {
                try {
                    if (x == null) {
                        valueModifications.add(null);
                    } else {
                        valueModifications.add(this.getModificationsFromCache(resource, CompactionPathUtils.getPath(this.deviceId, x.getMeasurementUid())));
                    }
                }
                catch (IllegalPathException e) {
                    throw new RuntimeException(e);
                }
            });
            ModificationUtils.modifyAlignedChunkMetaData(alignedChunkMetadataList, timeModifications, valueModifications, this.ignoreAllNullRows);
        }
        return alignedChunkMetadataList;
    }

    private boolean isValueChunkDataTypeMatchSchema(List<IChunkMetadata> chunkMetadataListOfOneValueColumn) {
        for (IChunkMetadata chunkMetadata : chunkMetadataListOfOneValueColumn) {
            if (chunkMetadata == null) continue;
            String measurement = chunkMetadata.getMeasurementUid();
            IMeasurementSchema schema = this.measurementSchemaMap.get(measurement);
            return schema.getType() == chunkMetadata.getDataType();
        }
        return true;
    }

    @Override
    protected void deserializeChunkIntoPageQueue(ChunkMetadataElement chunkMetadataElement) throws IOException {
        int i;
        this.updateSummary(chunkMetadataElement, SeriesCompactionExecutor.ChunkStatus.DESERIALIZE_CHUNK);
        Chunk timeChunk = chunkMetadataElement.chunk;
        CompactionChunkReader chunkReader = new CompactionChunkReader(timeChunk);
        List<Pair<PageHeader, ByteBuffer>> timePages = chunkReader.readPageDataWithoutUncompressing();
        ArrayList<List<Pair<PageHeader, ByteBuffer>>> valuePagesList = new ArrayList<List<Pair<PageHeader, ByteBuffer>>>();
        List<Chunk> valueChunks = chunkMetadataElement.valueChunks;
        for (i = 0; i < valueChunks.size(); ++i) {
            Chunk valueChunk = valueChunks.get(i);
            if (valueChunk == null) {
                valuePagesList.add(null);
                continue;
            }
            chunkReader = new CompactionChunkReader(valueChunk);
            List<Pair<PageHeader, ByteBuffer>> valuesPages = chunkReader.readPageDataWithoutUncompressing();
            valuePagesList.add(valuesPages);
        }
        for (i = 0; i < timePages.size(); ++i) {
            ArrayList<PageHeader> alignedPageHeaders = new ArrayList<PageHeader>();
            ArrayList<ByteBuffer> alignedPageDatas = new ArrayList<ByteBuffer>();
            for (int j = 0; j < valuePagesList.size(); ++j) {
                if (valuePagesList.get(j) == null) {
                    alignedPageHeaders.add(null);
                    alignedPageDatas.add(null);
                    continue;
                }
                Pair valuePage = (Pair)((List)valuePagesList.get(j)).get(i);
                alignedPageHeaders.add(valuePage == null ? null : (PageHeader)valuePage.left);
                alignedPageDatas.add(valuePage == null ? null : (ByteBuffer)valuePage.right);
            }
            AlignedPageElement alignedPageElement = new AlignedPageElement((PageHeader)timePages.get((int)i).left, alignedPageHeaders, (ByteBuffer)timePages.get((int)i).right, alignedPageDatas, new CompactionAlignedChunkReader(timeChunk, valueChunks, this.ignoreAllNullRows), chunkMetadataElement, i == timePages.size() - 1, this.isBatchedCompaction);
            this.pageQueue.add(alignedPageElement);
        }
        chunkMetadataElement.clearChunks();
    }

    @Override
    void readChunk(ChunkMetadataElement chunkMetadataElement) throws IOException {
        this.updateSummary(chunkMetadataElement, SeriesCompactionExecutor.ChunkStatus.READ_IN);
        AlignedChunkMetadata alignedChunkMetadata = (AlignedChunkMetadata)chunkMetadataElement.chunkMetadata;
        TsFileSequenceReader reader = (TsFileSequenceReader)this.readerCacheMap.get(chunkMetadataElement.fileElement.resource);
        chunkMetadataElement.chunk = this.readChunk(reader, (ChunkMetadata)alignedChunkMetadata.getTimeChunkMetadata());
        ArrayList<Chunk> valueChunks = new ArrayList<Chunk>();
        for (IChunkMetadata valueChunkMetadata : alignedChunkMetadata.getValueChunkMetadataList()) {
            if (valueChunkMetadata == null || valueChunkMetadata.getStatistics().getCount() == 0) {
                valueChunks.add(null);
                continue;
            }
            valueChunks.add(this.readChunk(reader, (ChunkMetadata)valueChunkMetadata));
        }
        chunkMetadataElement.valueChunks = valueChunks;
        this.setForceDecoding(chunkMetadataElement);
    }

    protected Chunk readChunk(TsFileSequenceReader reader, ChunkMetadata chunkMetadata) throws IOException {
        return reader.readMemChunk(chunkMetadata);
    }

    @Override
    protected boolean flushChunkToCompactionWriter(ChunkMetadataElement chunkMetadataElement) throws IOException {
        return this.compactionWriter.flushAlignedChunk(chunkMetadataElement, this.subTaskId);
    }

    void setForceDecoding(ChunkMetadataElement chunkMetadataElement) {
        if (this.timeColumnMeasurementSchema.getCompressor() != chunkMetadataElement.chunk.getHeader().getCompressionType() || this.timeColumnMeasurementSchema.getEncodingType() != chunkMetadataElement.chunk.getHeader().getEncodingType()) {
            chunkMetadataElement.needForceDecodingPage = true;
            return;
        }
        for (Chunk chunk : chunkMetadataElement.valueChunks) {
            ChunkHeader header;
            String measurementId;
            IMeasurementSchema measurementSchema;
            if (chunk == null || (measurementSchema = this.measurementSchemaMap.get(measurementId = (header = chunk.getHeader()).getMeasurementID())) == null || measurementSchema.getCompressor() == header.getCompressionType() && measurementSchema.getEncodingType() == header.getEncodingType()) continue;
            chunkMetadataElement.needForceDecodingPage = true;
            return;
        }
    }

    @Override
    protected boolean flushPageToCompactionWriter(PageElement pageElement) throws PageException, IOException {
        AlignedPageElement alignedPageElement = (AlignedPageElement)pageElement;
        return this.compactionWriter.flushAlignedPage(alignedPageElement, this.subTaskId);
    }

    @Override
    protected ModifiedStatus isPageModified(PageElement pageElement) {
        long startTime = pageElement.getStartTime();
        long endTime = pageElement.getEndTime();
        AlignedChunkMetadata alignedChunkMetadata = (AlignedChunkMetadata)pageElement.getChunkMetadataElement().chunkMetadata;
        return AlignedSeriesBatchCompactionUtils.calculateAlignedPageModifiedStatus(startTime, endTime, alignedChunkMetadata, this.ignoreAllNullRows);
    }
}

