/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Phaser;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.FileMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionRecoverException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionValidationFailedException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionLogAnalyzer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.SimpleCompactionLogger;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.TsFileIdentifier;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.InsertionCrossCompactionTaskResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;

public class InsertionCrossSpaceCompactionTask
extends AbstractCompactionTask {
    private Phaser phaser;
    private boolean failToPassValidation = false;
    private TsFileResource unseqFileToInsert;
    private TsFileResource targetFile;
    private long timestamp;
    private List<TsFileResource> selectedSeqFiles;
    private List<TsFileResource> selectedUnseqFiles;
    private File logFile;
    protected List<TsFileResource> holdWriteLockList = new ArrayList<TsFileResource>();
    protected boolean needRecoverTaskInfoFromLogFile;

    public InsertionCrossSpaceCompactionTask(Phaser phaser, long timePartition, TsFileManager tsFileManager, InsertionCrossCompactionTaskResource taskResource, long serialId) {
        super(tsFileManager.getStorageGroupName(), tsFileManager.getDataRegionId(), timePartition, tsFileManager, serialId);
        this.phaser = phaser;
        this.selectedSeqFiles = new ArrayList<TsFileResource>();
        this.selectedUnseqFiles = new ArrayList<TsFileResource>();
        if (taskResource.prevSeqFile != null) {
            this.selectedSeqFiles.add(taskResource.prevSeqFile);
        }
        if (taskResource.nextSeqFile != null) {
            this.selectedSeqFiles.add(taskResource.nextSeqFile);
        }
        if (taskResource.firstUnSeqFileInParitition != null) {
            this.selectedUnseqFiles.add(taskResource.firstUnSeqFileInParitition);
        }
        if (!taskResource.toInsertUnSeqFile.equals(taskResource.firstUnSeqFileInParitition)) {
            this.selectedUnseqFiles.add(taskResource.toInsertUnSeqFile);
        }
        this.unseqFileToInsert = taskResource.toInsertUnSeqFile;
        this.timestamp = taskResource.targetFileTimestamp;
        this.createSummary();
    }

    public InsertionCrossSpaceCompactionTask(String databaseName, String dataRegionId, TsFileManager tsFileManager, File logFile) {
        super(databaseName, dataRegionId, 0L, tsFileManager, 0L);
        this.logFile = logFile;
        this.needRecoverTaskInfoFromLogFile = true;
        this.selectedSeqFiles = Collections.emptyList();
        this.selectedUnseqFiles = new ArrayList<TsFileResource>(1);
    }

    @Override
    public List<TsFileResource> getAllSourceTsFiles() {
        return Stream.concat(this.selectedSeqFiles.stream(), this.selectedUnseqFiles.stream()).collect(Collectors.toList());
    }

    @Override
    public void handleTaskCleanup() {
        if (this.phaser != null) {
            this.phaser.arrive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doCompaction() {
        long startTime = System.currentTimeMillis();
        this.recoverMemoryStatus = true;
        LOGGER.info("{}-{} [Compaction] InsertionCrossSpaceCompaction task starts with unseq file {}, nearest seq files are {}, target file name timestamp is {}, file size is {} MB.", new Object[]{this.storageGroupName, this.dataRegionId, this.unseqFileToInsert, this.selectedSeqFiles, this.timestamp, this.unseqFileToInsert.getTsFileSize() / 1024L / 1024L});
        boolean isSuccess = true;
        if (!this.tsFileManager.isAllowCompaction() || !IoTDBDescriptor.getInstance().getConfig().isEnableCrossSpaceCompaction()) {
            return true;
        }
        try {
            this.targetFile = new TsFileResource(this.generateTargetFile(), TsFileResourceStatus.COMPACTING);
        }
        catch (IOException e) {
            LOGGER.error("{}-{} [InsertionCrossSpaceCompactionTask] failed to generate target file name, source unseq file is {}", new Object[]{this.storageGroupName, this.dataRegionId, this.unseqFileToInsert});
            return false;
        }
        this.logFile = new File(this.targetFile.getTsFilePath() + ".insertion-compaction.log");
        try (SimpleCompactionLogger logger = new SimpleCompactionLogger(this.logFile);){
            logger.logSourceFile(this.unseqFileToInsert);
            logger.logTargetFile(this.targetFile);
            logger.force();
            this.prepareTargetFiles();
            this.validateCompactionResult(Collections.emptyList(), Collections.singletonList(this.unseqFileToInsert), Collections.singletonList(this.targetFile));
            this.replaceTsFileInMemory(Collections.singletonList(this.unseqFileToInsert), Collections.singletonList(this.targetFile));
            this.lockWrite(Collections.singletonList(this.unseqFileToInsert));
            CompactionUtils.deleteTsFileResourceWithoutLock(this.unseqFileToInsert);
            double costTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            LOGGER.info("{}-{} [Compaction] InsertionCrossSpaceCompaction task finishes successfully, target file is {},time cost is {} s.", new Object[]{this.storageGroupName, this.dataRegionId, this.targetFile, String.format("%.2f", costTime)});
        }
        catch (Exception e) {
            if (e instanceof CompactionValidationFailedException) {
                this.failToPassValidation = true;
            }
            isSuccess = false;
            this.handleException(LOGGER, e);
            this.recover();
        }
        finally {
            this.releaseAllLocks();
            try {
                Files.deleteIfExists(this.logFile.toPath());
            }
            catch (IOException e) {
                this.handleException(LOGGER, e);
            }
            if (this.targetFile != null && this.targetFile.tsFileExists()) {
                this.updateFileMetrics();
            }
            this.targetFile.setStatus(TsFileResourceStatus.NORMAL);
        }
        return isSuccess;
    }

    public File generateTargetFile() throws IOException {
        String path = this.unseqFileToInsert.getTsFile().getParentFile().getPath();
        int pos = path.lastIndexOf("unsequence");
        path = path.substring(0, pos) + "sequence" + path.substring(pos + "unsequence".length());
        TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName(this.unseqFileToInsert.getTsFile().getName());
        tsFileName.setTime(this.timestamp);
        String fileNameStr = String.format("%d-%d-%d-%d.tsfile", tsFileName.getTime(), tsFileName.getVersion(), tsFileName.getInnerCompactionCnt(), 0);
        File targetTsFile = new File(path + File.separator + fileNameStr);
        if (!targetTsFile.getParentFile().exists()) {
            targetTsFile.getParentFile().mkdirs();
        }
        return targetTsFile;
    }

    private void prepareTargetFiles() throws IOException {
        File sourceTsFile = this.unseqFileToInsert.getTsFile();
        File targetTsFile = this.targetFile.getTsFile();
        Files.createLink(targetTsFile.toPath(), sourceTsFile.toPath());
        Files.createLink(new File(targetTsFile.getPath() + ".resource").toPath(), new File(sourceTsFile.getPath() + ".resource").toPath());
        this.unseqFileToInsert.linkModFile(this.targetFile);
        this.targetFile.setProgressIndex(this.unseqFileToInsert.getMaxProgressIndexAfterClose());
        this.targetFile.deserialize();
        this.targetFile.setProgressIndex(this.unseqFileToInsert.getMaxProgressIndexAfterClose());
    }

    private boolean recoverTaskInfoFromLogFile() throws IOException {
        File targetTsFile;
        CompactionLogAnalyzer logAnalyzer = new CompactionLogAnalyzer(this.logFile);
        logAnalyzer.analyze();
        List<TsFileIdentifier> sourceFileIdentifiers = logAnalyzer.getSourceFileInfos();
        List<TsFileIdentifier> targetFileIdentifiers = logAnalyzer.getTargetFileInfos();
        if (sourceFileIdentifiers.isEmpty() || targetFileIdentifiers.isEmpty()) {
            return false;
        }
        File sourceTsFile = sourceFileIdentifiers.get(0).getFileFromDataDirsIfAnyAdjuvantFileExists();
        if (sourceTsFile != null) {
            this.unseqFileToInsert = new TsFileResource(sourceTsFile);
            this.selectedUnseqFiles.add(this.unseqFileToInsert);
        }
        if ((targetTsFile = targetFileIdentifiers.get(0).getFileFromDataDirsIfAnyAdjuvantFileExists()) != null) {
            this.targetFile = new TsFileResource(targetTsFile);
        }
        return true;
    }

    @Override
    public void recover() {
        try {
            boolean isValidLog;
            if (this.needRecoverTaskInfoFromLogFile && !(isValidLog = this.recoverTaskInfoFromLogFile())) {
                return;
            }
            if (!this.canRecover()) {
                throw new CompactionRecoverException("Can not recover InsertionCrossSpaceCompactionTask");
            }
            if (this.shouldRollback()) {
                this.rollback();
            } else {
                this.finishTask();
            }
        }
        catch (Exception e) {
            this.handleRecoverException(e);
        }
        finally {
            try {
                Files.deleteIfExists(this.logFile.toPath());
            }
            catch (IOException e) {
                this.handleException(LOGGER, e);
            }
        }
    }

    private boolean canRecover() {
        return this.unseqFileToInsert != null || this.targetFile != null;
    }

    private boolean shouldRollback() {
        return this.targetFile == null || !this.targetFile.tsFileExists() || !this.targetFile.resourceFileExists() || this.unseqFileToInsert != null && this.unseqFileToInsert.anyModFileExists() && !this.targetFile.anyModFileExists() || this.failToPassValidation;
    }

    private void rollback() throws IOException {
        if (this.recoverMemoryStatus) {
            this.replaceTsFileInMemory(Collections.singletonList(this.targetFile), Collections.singletonList(this.unseqFileToInsert));
        }
        this.deleteCompactionModsFile(Collections.singletonList(this.unseqFileToInsert));
        if (this.targetFile == null) {
            return;
        }
        if (!this.deleteTsFileOnDisk(this.targetFile)) {
            throw new CompactionRecoverException(String.format("failed to delete target file %s", this.targetFile));
        }
    }

    private void finishTask() throws IOException {
        if (this.unseqFileToInsert == null) {
            return;
        }
        if (!this.deleteTsFileOnDisk(this.unseqFileToInsert)) {
            throw new CompactionRecoverException("source files cannot be deleted successfully");
        }
        this.deleteCompactionModsFile(Collections.singletonList(this.unseqFileToInsert));
    }

    @Override
    public boolean equalsOtherTask(AbstractCompactionTask otherTask) {
        return false;
    }

    @Override
    public boolean isDiskSpaceCheckPassed() {
        return true;
    }

    @Override
    public long getEstimatedMemoryCost() {
        return 0L;
    }

    @Override
    public int getProcessedFileNum() {
        return 0;
    }

    @Override
    protected void createSummary() {
        this.summary = new CompactionTaskSummary();
    }

    @Override
    public CompactionTaskType getCompactionTaskType() {
        return CompactionTaskType.INSERTION;
    }

    private void releaseAllLocks() {
        for (TsFileResource tsFileResource : this.holdWriteLockList) {
            tsFileResource.writeUnlock();
        }
        this.holdWriteLockList.clear();
    }

    private void lockWrite(List<TsFileResource> tsFileResourceList) {
        for (TsFileResource tsFileResource : tsFileResourceList) {
            tsFileResource.writeLock();
            this.holdWriteLockList.add(tsFileResource);
        }
    }

    private void updateFileMetrics() {
        FileMetrics.getInstance().deleteTsFile(false, Collections.singletonList(this.targetFile));
        FileMetrics.getInstance().addTsFile(this.targetFile.getDatabaseName(), this.targetFile.getDataRegionId(), this.targetFile.getTsFileSize(), true, this.targetFile.getTsFile().getName());
    }

    @Override
    public long getSelectedFileSize() {
        return this.unseqFileToInsert.getTsFileSize();
    }
}

