/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.service.metrics.FileMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionRecoverException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICrossCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionLogAnalyzer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.SimpleCompactionLogger;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.TsFileIdentifier;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.tsfile.utils.TsFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossSpaceCompactionTask
extends AbstractCompactionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    protected List<TsFileResource> selectedSequenceFiles;
    protected List<TsFileResource> selectedUnsequenceFiles;
    private File logFile;
    protected List<TsFileResource> targetTsfileResourceList;
    private List<TsFileResource> emptyTargetTsFileResourceList;
    protected List<TsFileResource> holdWriteLockList = new ArrayList<TsFileResource>();
    protected double selectedSeqFileSize = 0.0;
    protected double selectedUnseqFileSize = 0.0;

    public CrossSpaceCompactionTask(long timePartition, TsFileManager tsFileManager, List<TsFileResource> selectedSequenceFiles, List<TsFileResource> selectedUnsequenceFiles, ICrossCompactionPerformer performer, long memoryCost, long serialId) {
        super(tsFileManager.getStorageGroupName(), tsFileManager.getDataRegionId(), timePartition, tsFileManager, serialId);
        this.selectedSequenceFiles = selectedSequenceFiles;
        this.selectedUnsequenceFiles = selectedUnsequenceFiles;
        for (TsFileResource resource : selectedSequenceFiles) {
            this.selectedSeqFileSize += (double)resource.getTsFileSize();
        }
        for (TsFileResource resource : selectedUnsequenceFiles) {
            this.selectedUnseqFileSize += (double)resource.getTsFileSize();
        }
        this.emptyTargetTsFileResourceList = new ArrayList<TsFileResource>();
        this.performer = performer;
        this.hashCode = this.toString().hashCode();
        this.memoryCost = memoryCost;
        this.createSummary();
    }

    public CrossSpaceCompactionTask(String databaseName, String dataRegionId, TsFileManager tsFileManager, File logFile) {
        super(databaseName, dataRegionId, 0L, tsFileManager, 0L);
        this.logFile = logFile;
        this.needRecoverTaskInfoFromLogFile = true;
    }

    private void recoverTaskInfoFromLogFile() throws IOException {
        CompactionLogAnalyzer logAnalyzer = new CompactionLogAnalyzer(this.logFile);
        logAnalyzer.analyze();
        List<TsFileIdentifier> sourceFileIdentifiers = logAnalyzer.getSourceFileInfos();
        this.selectedSequenceFiles = new ArrayList<TsFileResource>();
        sourceFileIdentifiers.stream().filter(TsFileIdentifier::isSequence).forEach(f -> this.selectedSequenceFiles.add(new TsFileResource(f.getFileFromDataDirs())));
        sourceFileIdentifiers.stream().filter(f -> !f.isSequence()).forEach(f -> this.selectedUnsequenceFiles.add(new TsFileResource(f.getFileFromDataDirs())));
        List<TsFileIdentifier> targetFileIdentifiers = logAnalyzer.getTargetFileInfos();
        List<TsFileIdentifier> deletedTargetFileIdentifiers = logAnalyzer.getDeletedTargetFileInfos();
        for (TsFileIdentifier f2 : targetFileIdentifiers) {
            File targetFileOnDisk = this.getRealTargetFile(f2, ".cross");
            TsFileResource targetTsFile = new TsFileResource(targetFileOnDisk);
            this.targetTsfileResourceList.add(targetTsFile);
            if (!deletedTargetFileIdentifiers.contains(f2)) continue;
            this.emptyTargetTsFileResourceList.add(targetTsFile);
        }
        this.taskStage = logAnalyzer.getTaskStage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doCompaction() {
        this.recoverMemoryStatus = true;
        boolean isSuccess = true;
        if (!this.tsFileManager.isAllowCompaction()) {
            return true;
        }
        if (!IoTDBDescriptor.getInstance().getConfig().isEnableCrossSpaceCompaction()) {
            return true;
        }
        if (this.compactionConfigVersion < CompactionTaskManager.getInstance().getCurrentCompactionConfigVersion()) {
            return true;
        }
        if (this.selectedSequenceFiles.isEmpty() || this.selectedUnsequenceFiles.isEmpty()) {
            LOGGER.info("{}-{} [Compaction] Cross space compaction file list is empty, end it", (Object)this.storageGroupName, (Object)this.dataRegionId);
            return true;
        }
        LOGGER.info("{}-{} [Compaction] CrossSpaceCompaction task starts with {} seq files and {} unsequence files. Sequence files : {}, unsequence files : {} . Sequence files size is {} MB, unsequence file size is {} MB, total size is {} MB", new Object[]{this.storageGroupName, this.dataRegionId, this.selectedSequenceFiles.size(), this.selectedUnsequenceFiles.size(), this.selectedSequenceFiles, this.selectedUnsequenceFiles, this.selectedSeqFileSize / 1024.0 / 1024.0, this.selectedUnseqFileSize / 1024.0 / 1024.0, (this.selectedSeqFileSize + this.selectedUnseqFileSize) / 1024.0 / 1024.0});
        try {
            long startTime = System.currentTimeMillis();
            this.targetTsfileResourceList = TsFileNameGenerator.getCrossCompactionTargetFileResources(this.selectedSequenceFiles);
            this.logFile = new File(this.selectedSequenceFiles.get(0).getTsFile().getParent() + File.separator + this.targetTsfileResourceList.get(0).getTsFile().getName() + ".cross-compaction.log");
            try (SimpleCompactionLogger compactionLogger = new SimpleCompactionLogger(this.logFile);){
                compactionLogger.logSourceFiles(this.selectedSequenceFiles);
                compactionLogger.logSourceFiles(this.selectedUnsequenceFiles);
                compactionLogger.logTargetFiles(this.targetTsfileResourceList);
                compactionLogger.force();
                CompactionUtils.prepareCompactionModFiles(this.targetTsfileResourceList, this.selectedSequenceFiles, this.selectedUnsequenceFiles);
                this.performer.setSourceFiles(this.selectedSequenceFiles, this.selectedUnsequenceFiles);
                this.performer.setTargetFiles(this.targetTsfileResourceList);
                this.performer.setSummary(this.summary);
                this.performer.perform();
                CompactionUtils.updateProgressIndex(this.targetTsfileResourceList, this.selectedSequenceFiles, this.selectedUnsequenceFiles);
                CompactionUtils.moveTargetFile(this.targetTsfileResourceList, CompactionTaskType.CROSS, this.storageGroupName + "-" + this.dataRegionId);
                CompactionUtils.combineModsInCrossCompaction(this.selectedSequenceFiles, this.selectedUnsequenceFiles, this.targetTsfileResourceList);
                this.validateCompactionResult(this.selectedSequenceFiles, this.selectedUnsequenceFiles, this.targetTsfileResourceList);
                this.tsFileManager.replace(this.selectedSequenceFiles, this.selectedUnsequenceFiles, this.targetTsfileResourceList, this.timePartition);
                for (TsFileResource targetResource : this.targetTsfileResourceList) {
                    if (!targetResource.isDeleted()) continue;
                    this.emptyTargetTsFileResourceList.add(targetResource);
                    compactionLogger.logEmptyTargetFile(targetResource);
                    compactionLogger.force();
                }
                this.lockWrite(this.selectedSequenceFiles);
                this.lockWrite(this.selectedUnsequenceFiles);
                CompactionUtils.deleteSourceTsFileAndUpdateFileMetrics(this.selectedSequenceFiles, this.selectedUnsequenceFiles);
                for (TsFileResource targetResource : this.targetTsfileResourceList) {
                    if (!targetResource.isDeleted()) {
                        CompactionUtils.addFilesToFileMetrics(targetResource);
                        continue;
                    }
                    targetResource.remove();
                }
                CompactionMetrics.getInstance().recordSummaryInfo(this.summary);
                double costTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                LOGGER.info("{}-{} [Compaction] CrossSpaceCompaction task finishes successfully, time cost is {} s, compaction speed is {} MB/s, {}", new Object[]{this.storageGroupName, this.dataRegionId, String.format("%.2f", costTime), String.format("%.2f", (this.selectedSeqFileSize + this.selectedUnseqFileSize) / 1024.0 / 1024.0 / costTime), this.summary});
            }
        }
        catch (Exception e) {
            isSuccess = false;
            this.handleException(LOGGER, e);
            this.recover();
        }
        finally {
            this.releaseAllLocks();
            try {
                if (this.logFile != null) {
                    Files.deleteIfExists(this.logFile.toPath());
                }
            }
            catch (IOException e) {
                this.handleException(LOGGER, e);
            }
            for (TsFileResource resource : this.targetTsfileResourceList) {
                resource.setStatus(TsFileResourceStatus.NORMAL);
            }
        }
        return isSuccess;
    }

    @Override
    public void recover() {
        try {
            if (this.needRecoverTaskInfoFromLogFile) {
                this.recoverTaskInfoFromLogFile();
            }
            if (this.shouldRollback()) {
                this.rollback();
            } else {
                this.finishTask();
            }
        }
        catch (Exception e) {
            this.handleRecoverException(e);
        }
    }

    private boolean shouldRollback() {
        return this.checkAllSourceFileExists(this.selectedSequenceFiles) && this.checkAllSourceFileExists(this.selectedUnsequenceFiles);
    }

    private void rollback() throws IOException {
        List<Object> list = this.targetTsfileResourceList = this.targetTsfileResourceList == null ? Collections.emptyList() : this.targetTsfileResourceList;
        if (this.recoverMemoryStatus) {
            this.replaceTsFileInMemory(this.targetTsfileResourceList, Stream.concat(this.selectedSequenceFiles.stream(), this.selectedUnsequenceFiles.stream()).collect(Collectors.toList()));
        }
        this.deleteCompactionModsFile(this.selectedSequenceFiles);
        this.deleteCompactionModsFile(this.selectedUnsequenceFiles);
        if (this.targetTsfileResourceList != null && !this.deleteTsFilesOnDisk(this.targetTsfileResourceList)) {
            throw new CompactionRecoverException("failed to delete target file %s");
        }
    }

    private void finishTask() throws IOException {
        for (TsFileResource target : this.targetTsfileResourceList) {
            if (target.isDeleted() || this.emptyTargetTsFileResourceList.contains(target)) {
                if (target.remove()) continue;
                throw new CompactionRecoverException(String.format("failed to delete empty target file %s", target));
            }
            File targetFile = target.getTsFile();
            if (targetFile == null || !TsFileUtils.isTsFileComplete((File)target.getTsFile())) {
                throw new CompactionRecoverException(String.format("Target file is not completed. %s", targetFile));
            }
            if (!this.recoverMemoryStatus) continue;
            target.setStatus(TsFileResourceStatus.NORMAL);
        }
        if (!this.deleteTsFilesOnDisk(this.selectedSequenceFiles) || !this.deleteTsFilesOnDisk(this.selectedUnsequenceFiles)) {
            throw new CompactionRecoverException("source files cannot be deleted successfully");
        }
        if (this.recoverMemoryStatus) {
            FileMetrics.getInstance().deleteTsFile(true, this.selectedSequenceFiles);
            FileMetrics.getInstance().deleteTsFile(false, this.selectedUnsequenceFiles);
        }
    }

    @Override
    public boolean equalsOtherTask(AbstractCompactionTask otherTask) {
        if (!(otherTask instanceof CrossSpaceCompactionTask)) {
            return false;
        }
        CrossSpaceCompactionTask otherCrossCompactionTask = (CrossSpaceCompactionTask)otherTask;
        return this.selectedSequenceFiles.equals(otherCrossCompactionTask.selectedSequenceFiles) && this.selectedUnsequenceFiles.equals(otherCrossCompactionTask.selectedUnsequenceFiles) && this.performer.getClass().isInstance(otherCrossCompactionTask.performer);
    }

    private void releaseAllLocks() {
        for (TsFileResource tsFileResource : this.holdWriteLockList) {
            tsFileResource.writeUnlock();
        }
        this.holdWriteLockList.clear();
    }

    public List<TsFileResource> getSelectedSequenceFiles() {
        return this.selectedSequenceFiles;
    }

    @Override
    public List<TsFileResource> getAllSourceTsFiles() {
        ArrayList<TsFileResource> allRelatedFiles = new ArrayList<TsFileResource>();
        allRelatedFiles.addAll(this.selectedSequenceFiles);
        allRelatedFiles.addAll(this.selectedUnsequenceFiles);
        return allRelatedFiles;
    }

    public List<TsFileResource> getSelectedUnsequenceFiles() {
        return this.selectedUnsequenceFiles;
    }

    public String toString() {
        return this.storageGroupName + "-" + this.dataRegionId + "-" + this.timePartition + " task seq files are " + this.selectedSequenceFiles.toString() + " , unseq files are " + this.selectedUnsequenceFiles.toString();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof CrossSpaceCompactionTask)) {
            return false;
        }
        return this.equalsOtherTask((CrossSpaceCompactionTask)other);
    }

    private void lockWrite(List<TsFileResource> tsFileResourceList) {
        for (TsFileResource tsFileResource : tsFileResourceList) {
            tsFileResource.writeLock();
            this.holdWriteLockList.add(tsFileResource);
        }
    }

    @Override
    public long getEstimatedMemoryCost() {
        return this.memoryCost;
    }

    @Override
    public int getProcessedFileNum() {
        return this.selectedSequenceFiles.size() + this.selectedUnsequenceFiles.size();
    }

    @Override
    protected void createSummary() {
        this.summary = this.performer instanceof FastCompactionPerformer ? new FastCompactionTaskSummary() : new CompactionTaskSummary();
    }

    @Override
    public CompactionTaskType getCompactionTaskType() {
        return CompactionTaskType.CROSS;
    }

    @Override
    public long getCompactionConfigVersion() {
        return this.compactionConfigVersion;
    }

    @Override
    public void setCompactionConfigVersion(long compactionConfigVersion) {
        this.compactionConfigVersion = Math.min(this.compactionConfigVersion, compactionConfigVersion);
    }

    @Override
    public long getSelectedFileSize() {
        return (long)(this.selectedSeqFileSize + this.selectedUnseqFileSize);
    }
}

