/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonTokenStream;
import org.apache.iotdb.common.rpc.thrift.Model;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TNodeResource;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.ServerCommandLine;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.concurrent.IoTDBDefaultThreadExceptionHandler;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.PipePluginMeta;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.JMXService;
import org.apache.iotdb.commons.service.RegisterManager;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.commons.trigger.exception.TriggerManagementException;
import org.apache.iotdb.commons.trigger.service.TriggerExecutableManager;
import org.apache.iotdb.commons.udf.UDFInformation;
import org.apache.iotdb.commons.udf.service.UDFClassLoaderManager;
import org.apache.iotdb.commons.udf.service.UDFExecutableManager;
import org.apache.iotdb.commons.udf.service.UDFManagementService;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRemoveReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRemoveResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRestartReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRestartResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListResp;
import org.apache.iotdb.confignode.rpc.thrift.TNodeVersionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TRuntimeConfiguration;
import org.apache.iotdb.confignode.rpc.thrift.TSystemConfigurationResp;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.db.conf.DataNodeStartupCheck;
import org.apache.iotdb.db.conf.DataNodeSystemPropertiesHandler;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.IoTDBStartCheck;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceDescriptor;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.protocol.thrift.impl.ClientRPCServiceImpl;
import org.apache.iotdb.db.protocol.thrift.impl.DataNodeRegionManager;
import org.apache.iotdb.db.qp.sql.IoTDBSqlParser;
import org.apache.iotdb.db.qp.sql.SqlLexer;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeService;
import org.apache.iotdb.db.queryengine.execution.schedule.DriverScheduler;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeTTLCache;
import org.apache.iotdb.db.queryengine.plan.parser.ASTVisitor;
import org.apache.iotdb.db.queryengine.plan.parser.StatementGenerator;
import org.apache.iotdb.db.queryengine.plan.planner.LogicalPlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.DistributionPlanContext;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.SourceRewriter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.schemaengine.SchemaEngine;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.GeneralRegionAttributeSecurityService;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.service.DataNodeInternalRPCService;
import org.apache.iotdb.db.service.DataNodeMBean;
import org.apache.iotdb.db.service.DataNodeShutdownHook;
import org.apache.iotdb.db.service.MQTTService;
import org.apache.iotdb.db.service.RPCService;
import org.apache.iotdb.db.service.RegionMigrateService;
import org.apache.iotdb.db.service.ResourcesInformationHolder;
import org.apache.iotdb.db.service.RestService;
import org.apache.iotdb.db.service.TemporaryQueryDataFileService;
import org.apache.iotdb.db.service.metrics.DataNodeMetricsHelper;
import org.apache.iotdb.db.service.metrics.IoTDBInternalLocalReporter;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.buffer.CacheHitRatioMonitor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushManager;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessor;
import org.apache.iotdb.db.storageengine.dataregion.wal.WALManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALMode;
import org.apache.iotdb.db.storageengine.rescon.disk.TierManager;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.iotdb.db.trigger.executor.TriggerExecutor;
import org.apache.iotdb.db.trigger.service.TriggerInformationUpdater;
import org.apache.iotdb.db.trigger.service.TriggerManagementService;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.reporter.iotdb.IoTDBInternalReporter;
import org.apache.iotdb.metrics.utils.InternalReporterType;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.udf.api.exception.UDFManagementException;
import org.apache.thrift.TException;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNode
extends ServerCommandLine
implements DataNodeMBean {
    private static final Logger logger = LoggerFactory.getLogger(DataNode.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", ServiceType.DATA_NODE.getJmxName());
    private static final int DEFAULT_RETRY = 200;
    private static final long DEFAULT_RETRY_INTERVAL_IN_MS = config.getJoinClusterRetryIntervalMs();
    private final TEndPoint thisNode = new TEndPoint();
    private final ResourcesInformationHolder resourcesInformationHolder = new ResourcesInformationHolder();
    private final TriggerInformationUpdater triggerInformationUpdater = new TriggerInformationUpdater();
    private static final String REGISTER_INTERRUPTION = "Unexpected interruption when waiting to register to the cluster";
    private boolean schemaRegionConsensusStarted = false;
    private boolean dataRegionConsensusStarted = false;
    private static RegisterManager registerManager = new RegisterManager();

    public DataNode() {
        super("DataNode");
        DataNodeHolder.INSTANCE = this;
    }

    public static void reinitializeStatics() {
        registerManager = new RegisterManager();
        DataNodeSystemPropertiesHandler.getInstance().resetFilePath(config.getSystemDir() + File.separator + "system.properties");
    }

    public static DataNode getInstance() {
        return DataNodeHolder.INSTANCE;
    }

    public static void main(String[] args) {
        logger.info("IoTDB-DataNode environment variables: {}", (Object)IoTDBConfig.getEnvironmentVariables());
        logger.info("IoTDB-DataNode default charset is: {}", (Object)Charset.defaultCharset().displayName());
        DataNode dataNode = new DataNode();
        int returnCode = dataNode.run(args);
        if (returnCode != 0) {
            System.exit(returnCode);
        }
    }

    protected void start() {
        try {
            boolean isFirstStart = this.prepareDataNode();
            if (isFirstStart) {
                logger.info("DataNode is starting for the first time...");
                ConfigNodeInfo.getInstance().updateConfigNodeList(Collections.singletonList(config.getSeedConfigNode()));
            } else {
                logger.info("DataNode is restarting...");
                ConfigNodeInfo.getInstance().loadConfigNodeList();
            }
            this.pullAndCheckSystemConfigurations();
            if (isFirstStart) {
                this.sendRegisterRequestToConfigNode(true);
                IoTDBStartCheck.getInstance().generateOrOverwriteSystemPropertiesFile();
                ConfigNodeInfo.getInstance().storeConfigNodeList();
                this.sendRegisterRequestToConfigNode(false);
            } else {
                this.sendRestartRequestToConfigNode();
            }
            TierManager.getInstance().resetFolders();
            this.active();
            this.setUpMetricService();
            this.setUpRPCService();
            IoTDBStartCheck.getInstance().serializeMutableSystemPropertiesIfNecessary();
            logger.info("IoTDB configuration: {}", (Object)config.getConfigMessage());
            logger.info("Congratulations, IoTDB DataNode is set up successfully. Now, enjoy yourself!");
            if (this.isUsingPipeConsensus()) {
                long dataRegionStartTime = System.currentTimeMillis();
                while (!StorageEngine.getInstance().isReadyForNonReadWriteFunctions()) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        logger.warn("IoTDB DataNode failed to set up.", (Throwable)e);
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                DataRegionConsensusImpl.getInstance().start();
                long dataRegionEndTime = System.currentTimeMillis();
                logger.info("DataRegion consensus start successfully, which takes {} ms.", (Object)(dataRegionEndTime - dataRegionStartTime));
                this.dataRegionConsensusStarted = true;
            }
        }
        catch (IOException | StartupException e) {
            logger.error("Fail to start server", e);
            this.stop();
            System.exit(-1);
        }
    }

    protected void remove(Set<Integer> nodeIds) throws IoTDBException {
        if (nodeIds == null) {
            nodeIds = Collections.singleton(config.getDataNodeId());
        }
        ConfigNodeInfo.getInstance().loadConfigNodeList();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            Set validNodeIds = configNodeClient.getDataNodeConfiguration(-1).getDataNodeConfigurationMap().keySet();
            HashSet<Integer> invalidNodeIds = new HashSet<Integer>(nodeIds);
            invalidNodeIds.removeAll(validNodeIds);
            if (!invalidNodeIds.isEmpty()) {
                logger.info("Cannot remove invalid nodeIds:{}", invalidNodeIds);
                nodeIds.removeAll(invalidNodeIds);
            }
            logger.info("Starting to remove DataNode with nodeIds: {}", nodeIds);
            Set<Integer> finalNodeIds = nodeIds;
            List removeDataNodeLocations = configNodeClient.getDataNodeConfiguration(-1).getDataNodeConfigurationMap().values().stream().map(TDataNodeConfiguration::getLocation).filter(location -> finalNodeIds.contains(location.getDataNodeId())).collect(Collectors.toList());
            if (removeDataNodeLocations.isEmpty()) {
                throw new IoTDBException("Invalid node-id", -1);
            }
            logger.info("Start to remove datanode, removed DataNodes endpoint: {}", removeDataNodeLocations);
            TDataNodeRemoveReq removeReq = new TDataNodeRemoveReq(removeDataNodeLocations);
            TDataNodeRemoveResp removeResp = configNodeClient.removeDataNode(removeReq);
            logger.info("Submit Remove DataNodes result {} ", (Object)removeResp);
            if (removeResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new IoTDBException(removeResp.getStatus().toString(), removeResp.getStatus().getCode());
            }
            logger.info("Submit remove-datanode request successfully, but the process may fail. more details are shown in the logs of confignode-leader and removed-datanode, and after the process of removing datanode ends successfully, you are supposed to delete directory and data of the removed-datanode manually");
        }
        catch (ClientManagerException | TException e) {
            throw new IoTDBException("Failed removing datanode", e, -1);
        }
    }

    private boolean prepareDataNode() throws StartupException, IOException {
        long startTime = System.currentTimeMillis();
        IoTDBStartCheck.checkOldSystemConfig();
        this.thisNode.setIp(config.getInternalAddress());
        this.thisNode.setPort(config.getInternalPort());
        DataNodeStartupCheck checks = new DataNodeStartupCheck("datanode", config);
        checks.startUpCheck();
        long endTime = System.currentTimeMillis();
        logger.info("The DataNode is prepared successfully, which takes {} ms", (Object)(endTime - startTime));
        return DataNodeSystemPropertiesHandler.getInstance().isFirstStart();
    }

    private void pullAndCheckSystemConfigurations() throws StartupException {
        logger.info("Pulling system configurations from the ConfigNode-leader...");
        long startTime = System.currentTimeMillis();
        int retry = 200;
        TSystemConfigurationResp configurationResp = null;
        while (retry > 0) {
            try (ConfigNodeClient configNodeClient = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                configurationResp = configNodeClient.getSystemConfiguration();
                break;
            }
            catch (ClientManagerException | TException e) {
                logger.warn("Cannot pull system configurations from ConfigNode-leader", e);
                --retry;
                try {
                    Thread.sleep(DEFAULT_RETRY_INTERVAL_IN_MS);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    logger.warn(REGISTER_INTERRUPTION, (Throwable)e2);
                    retry = -1;
                }
            }
        }
        if (configurationResp == null || !configurationResp.isSetStatus() || configurationResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            logger.error("Cannot pull system configurations from ConfigNode-leader after {} retries.", (Object)200);
            throw new StartupException("Cannot pull system configurations from ConfigNode-leader. Please check whether the dn_seed_config_node in iotdb-system.properties is correct or alive.");
        }
        IoTDBDescriptor.getInstance().loadGlobalConfig(configurationResp.globalConfig);
        IoTDBDescriptor.getInstance().loadRatisConfig(configurationResp.ratisConfig);
        IoTDBDescriptor.getInstance().loadCQConfig(configurationResp.cqConfig);
        CommonDescriptor.getInstance().loadGlobalConfig(configurationResp.globalConfig);
        if (!IoTDBStartCheck.getInstance().checkConsensusProtocolExists(TConsensusGroupType.DataRegion)) {
            config.setDataRegionConsensusProtocolClass(configurationResp.globalConfig.getDataRegionConsensusProtocolClass());
        }
        if (!IoTDBStartCheck.getInstance().checkConsensusProtocolExists(TConsensusGroupType.SchemaRegion)) {
            config.setSchemaRegionConsensusProtocolClass(configurationResp.globalConfig.getSchemaRegionConsensusProtocolClass());
        }
        try {
            IoTDBStartCheck.getInstance().checkSystemConfig();
            IoTDBStartCheck.getInstance().checkDirectory();
            if (!config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensus")) {
                IoTDBDescriptor.getInstance().reclaimConsensusMemory();
            }
        }
        catch (Exception e) {
            throw new StartupException(e.getMessage());
        }
        long endTime = System.currentTimeMillis();
        logger.info("Successfully pull system configurations from ConfigNode-leader, which takes {} ms", (Object)(endTime - startTime));
    }

    private void storeRuntimeConfigurations(List<TConfigNodeLocation> configNodeLocations, TRuntimeConfiguration runtimeConfiguration) throws StartupException {
        ArrayList<TEndPoint> configNodeList = new ArrayList<TEndPoint>();
        for (TConfigNodeLocation configNodeLocation : configNodeLocations) {
            configNodeList.add(configNodeLocation.getInternalEndPoint());
        }
        ConfigNodeInfo.getInstance().updateConfigNodeList(configNodeList);
        ClusterTemplateManager.getInstance().updateTemplateSetInfo(runtimeConfiguration.getTemplateInfo());
        this.getUDFInformationList(runtimeConfiguration.getAllUDFInformation());
        this.getTriggerInformationList(runtimeConfiguration.getAllTriggerInformation());
        this.getPipeInformationList(runtimeConfiguration.getAllPipeInformation());
        this.initTTLInformation(runtimeConfiguration.getAllTTLInformation());
        String clusterId = runtimeConfiguration.getClusterId();
        this.storeClusterID(clusterId);
        DataNodeTableCache.getInstance().init(runtimeConfiguration.getTableInfo());
    }

    private void sendRegisterRequestToConfigNode(boolean isPreCheck) throws StartupException, IOException {
        logger.info("Sending register request to ConfigNode-leader...");
        long startTime = System.currentTimeMillis();
        int retry = 200;
        TDataNodeRegisterReq req = new TDataNodeRegisterReq();
        req.setPreCheck(isPreCheck);
        req.setDataNodeConfiguration(this.generateDataNodeConfiguration());
        req.setClusterName(config.getClusterName());
        req.setVersionInfo(new TNodeVersionInfo(IoTDBConstant.VERSION, IoTDBConstant.BUILD_INFO));
        TDataNodeRegisterResp dataNodeRegisterResp = null;
        while (retry > 0) {
            try (ConfigNodeClient configNodeClient = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                dataNodeRegisterResp = configNodeClient.registerDataNode(req);
                break;
            }
            catch (ClientManagerException | TException e) {
                logger.warn("Cannot register to the cluster, because: {}", (Object)e.getMessage());
                --retry;
                try {
                    Thread.sleep(DEFAULT_RETRY_INTERVAL_IN_MS);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    logger.warn(REGISTER_INTERRUPTION, (Throwable)e2);
                    retry = -1;
                }
            }
        }
        if (dataNodeRegisterResp == null) {
            logger.error("Cannot register into cluster after {} retries.", (Object)200);
            throw new StartupException("Cannot register into the cluster. Please check whether the dn_seed_config_node in iotdb-system.properties is correct or alive.");
        }
        if (dataNodeRegisterResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            if (isPreCheck) {
                logger.info("Successfully pass the precheck, will do the formal registration soon.");
                return;
            }
        } else {
            logger.error(dataNodeRegisterResp.getStatus().getMessage());
            throw new StartupException("Cannot register to the cluster.");
        }
        int dataNodeID = dataNodeRegisterResp.getDataNodeId();
        config.setDataNodeId(dataNodeID);
        IoTDBStartCheck.getInstance().serializeDataNodeId(dataNodeID);
        this.storeRuntimeConfigurations(dataNodeRegisterResp.getConfigNodeList(), dataNodeRegisterResp.getRuntimeConfiguration());
        long endTime = System.currentTimeMillis();
        logger.info("Successfully register to the cluster: {} , which takes {} ms.", (Object)config.getClusterName(), (Object)(endTime - startTime));
    }

    private void makeRegionsCorrect(List<TRegionReplicaSet> correctRegions) {
        List<ConsensusGroupId> dataNodeConsensusGroupIds = correctRegions.stream().map(TRegionReplicaSet::getRegionId).map(ConsensusGroupId.Factory::createFromTConsensusGroupId).collect(Collectors.toList());
        this.removeInvalidDataRegions(dataNodeConsensusGroupIds);
        this.removeInvalidSchemaRegions(dataNodeConsensusGroupIds);
        this.prepareToResetDataRegionPeerList(correctRegions);
    }

    private void removeInvalidDataRegions(List<ConsensusGroupId> dataNodeConsensusGroupIds) {
        Map<String, List<DataRegionId>> localDataRegionInfo = StorageEngine.getInstance().getLocalDataRegionInfo();
        List<String> allLocalFilesFolders = TierManager.getInstance().getAllLocalFilesFolders();
        localDataRegionInfo.forEach((database, dataRegionIds) -> {
            for (DataRegionId dataRegionId : dataRegionIds) {
                if (dataNodeConsensusGroupIds.contains(dataRegionId)) continue;
                this.removeDataDirRegion((String)database, dataRegionId, allLocalFilesFolders);
            }
        });
    }

    private void removeInvalidSchemaRegions(List<ConsensusGroupId> schemaConsensusGroupIds) {
        Map<String, List<SchemaRegionId>> localSchemaRegionInfo = SchemaEngine.getLocalSchemaRegionInfo();
        localSchemaRegionInfo.forEach((database, schemaRegionIds) -> {
            for (SchemaRegionId schemaRegionId : schemaRegionIds) {
                if (schemaConsensusGroupIds.contains(schemaRegionId)) continue;
                this.removeInvalidSchemaDir((String)database, schemaRegionId);
            }
        });
    }

    private void removeDataDirRegion(String database, DataRegionId dataRegionId, List<String> fileFolders) {
        fileFolders.forEach(folder -> {
            String regionDir = folder + File.separator + database + File.separator + dataRegionId.getId();
            this.removeDir(new File(regionDir));
        });
    }

    private void removeInvalidSchemaDir(String database, SchemaRegionId schemaRegionId) {
        String systemSchemaDir = config.getSystemDir() + File.separator + database + File.separator + schemaRegionId.getId();
        this.removeDir(new File(systemSchemaDir));
    }

    private void removeDir(File regionDir) {
        if (regionDir.exists()) {
            FileUtils.deleteDirectoryAndEmptyParent((File)regionDir);
            logger.info("delete {} succeed.", (Object)regionDir.getAbsolutePath());
        } else {
            logger.info("delete {} failed, because it does not exist.", (Object)regionDir.getAbsolutePath());
        }
    }

    private void prepareToResetDataRegionPeerList(List<TRegionReplicaSet> correctedRegions) {
        HashMap correctPeerListForDataRegion = new HashMap();
        HashMap correctPeerListForSchemaRegion = new HashMap();
        for (TRegionReplicaSet regionReplicaSet : correctedRegions) {
            ConsensusGroupId consensusGroupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)regionReplicaSet.regionId);
            ArrayList<Peer> peerList = new ArrayList<Peer>();
            if (consensusGroupId.getType() == TConsensusGroupType.DataRegion) {
                for (TDataNodeLocation dataNodeLocation : regionReplicaSet.getDataNodeLocations()) {
                    peerList.add(new Peer(consensusGroupId, dataNodeLocation.getDataNodeId(), dataNodeLocation.getDataRegionConsensusEndPoint()));
                }
                correctPeerListForDataRegion.put(consensusGroupId, peerList);
                continue;
            }
            if (consensusGroupId.getType() != TConsensusGroupType.SchemaRegion) continue;
            for (TDataNodeLocation dataNodeLocation : regionReplicaSet.getDataNodeLocations()) {
                peerList.add(new Peer(consensusGroupId, dataNodeLocation.getDataNodeId(), dataNodeLocation.getSchemaRegionConsensusEndPoint()));
            }
            correctPeerListForSchemaRegion.put(consensusGroupId, peerList);
        }
        DataRegionConsensusImpl.getInstance().recordCorrectPeerListBeforeStarting(correctPeerListForDataRegion);
        SchemaRegionConsensusImpl.getInstance().recordCorrectPeerListBeforeStarting(correctPeerListForSchemaRegion);
    }

    private void sendRestartRequestToConfigNode() throws StartupException {
        logger.info("Sending restart request to ConfigNode-leader...");
        long startTime = System.currentTimeMillis();
        int retry = 200;
        TDataNodeRestartReq req = new TDataNodeRestartReq();
        req.setClusterName(config.getClusterName() == null ? "defaultCluster" : config.getClusterName());
        req.setDataNodeConfiguration(this.generateDataNodeConfiguration());
        req.setVersionInfo(new TNodeVersionInfo(IoTDBConstant.VERSION, IoTDBConstant.BUILD_INFO));
        req.setClusterId(config.getClusterId());
        TDataNodeRestartResp dataNodeRestartResp = null;
        while (retry > 0) {
            try (ConfigNodeClient configNodeClient = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                dataNodeRestartResp = configNodeClient.restartDataNode(req);
                break;
            }
            catch (ClientManagerException | TException e) {
                logger.warn("Cannot send restart request to the ConfigNode-leader, because: {}", (Object)e.getMessage());
                --retry;
                try {
                    Thread.sleep(DEFAULT_RETRY_INTERVAL_IN_MS);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    logger.warn(REGISTER_INTERRUPTION, (Throwable)e2);
                    retry = -1;
                }
            }
        }
        if (dataNodeRestartResp == null) {
            logger.error("Cannot send restart DataNode request to ConfigNode-leader after {} retries.", (Object)200);
            throw new StartupException("Cannot send restart DataNode request to ConfigNode-leader. Please check whether the dn_seed_config_node in iotdb-system.properties is correct or alive.");
        }
        if (dataNodeRestartResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new StartupException(dataNodeRestartResp.getStatus().getMessage());
        }
        this.storeRuntimeConfigurations(dataNodeRestartResp.getConfigNodeList(), dataNodeRestartResp.getRuntimeConfiguration());
        long endTime = System.currentTimeMillis();
        logger.info("Restart request to cluster: {} is accepted, which takes {} ms.", (Object)config.getClusterName(), (Object)(endTime - startTime));
        this.makeRegionsCorrect(dataNodeRestartResp.getCorrectConsensusGroups());
    }

    private void prepareResources() throws StartupException {
        this.prepareUDFResources();
        this.prepareTriggerResources();
        this.preparePipeResources();
    }

    private void active() throws StartupException {
        try {
            this.processPid();
            this.setUp();
        }
        catch (StartupException e) {
            logger.error("Meet error while starting up.", (Throwable)e);
            throw new StartupException("Error in activating IoTDB DataNode.");
        }
        logger.info("IoTDB DataNode has started.");
        try {
            long startTime = System.currentTimeMillis();
            SchemaRegionConsensusImpl.getInstance().start();
            long schemaRegionEndTime = System.currentTimeMillis();
            logger.info("SchemaRegion consensus start successfully, which takes {} ms.", (Object)(schemaRegionEndTime - startTime));
            this.schemaRegionConsensusStarted = true;
            if (!this.isUsingPipeConsensus()) {
                DataRegionConsensusImpl.getInstance().start();
                long dataRegionEndTime = System.currentTimeMillis();
                logger.info("DataRegion consensus start successfully, which takes {} ms.", (Object)(dataRegionEndTime - schemaRegionEndTime));
                this.dataRegionConsensusStarted = true;
            }
        }
        catch (IOException e) {
            throw new StartupException((Throwable)e);
        }
    }

    void processPid() {
        String pidFile = System.getProperty("iotdb-pidfile");
        if (pidFile != null) {
            new File(pidFile).deleteOnExit();
        }
    }

    private void setUp() throws StartupException {
        logger.info("Setting up IoTDB DataNode...");
        registerManager.register((IService)new JMXService());
        JMXService.registerMBean((Object)DataNode.getInstance(), (String)this.mbeanName);
        this.prepareResources();
        Runtime.getRuntime().addShutdownHook(new DataNodeShutdownHook(DataNode.generateDataNodeLocation()));
        this.setUncaughtExceptionHandler();
        logger.info("Recover the schema...");
        this.initSchemaEngine();
        this.classLoader();
        registerManager.register((IService)FlushManager.getInstance());
        registerManager.register((IService)CacheHitRatioMonitor.getInstance());
        if (config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
            config.setWalMode(WALMode.DISABLE);
        }
        registerManager.register((IService)WALManager.getInstance());
        registerManager.register((IService)CompactionScheduleTaskManager.getInstance());
        registerManager.register((IService)StorageEngine.getInstance());
        registerManager.register((IService)MPPDataExchangeService.getInstance());
        registerManager.register((IService)DriverScheduler.getInstance());
        this.registerUdfServices();
        logger.info("IoTDB DataNode is setting up, some databases may not be ready now, please wait several seconds...");
        long startTime = System.currentTimeMillis();
        while (!StorageEngine.getInstance().isReadyForReadAndWrite()) {
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warn("IoTDB DataNode failed to set up.", (Throwable)e);
                Thread.currentThread().interrupt();
                return;
            }
        }
        long endTime = System.currentTimeMillis();
        logger.info("Wait for all databases ready, which takes {} ms.", (Object)(endTime - startTime));
        DataNodeRegionManager.getInstance().init();
        registerManager.register((IService)RegionMigrateService.getInstance());
        registerManager.register((IService)CompactionTaskManager.getInstance());
        registerManager.register((IService)SubscriptionAgent.runtime());
        registerManager.register((IService)PipeDataNodeAgent.runtime());
        registerManager.register((IService)GeneralRegionAttributeSecurityService.getInstance());
    }

    private void setUpRPCService() throws StartupException {
        registerManager.register((IService)DataNodeInternalRPCService.getInstance());
        IoTDBDescriptor.getInstance().getConfig().setRpcImplClassName(ClientRPCServiceImpl.class.getName());
        if (config.isEnableRpcService()) {
            registerManager.register((IService)RPCService.getInstance());
        }
        this.initProtocols();
    }

    private void setUpMetricService() throws StartupException {
        MetricConfigDescriptor.getInstance().getMetricConfig().setNodeId(config.getDataNodeId());
        registerManager.register((IService)MetricService.getInstance());
        if (MetricConfigDescriptor.getInstance().getMetricConfig().getInternalReportType().equals((Object)InternalReporterType.IOTDB)) {
            MetricService.getInstance().updateInternalReporter((IoTDBInternalReporter)new IoTDBInternalLocalReporter());
        }
        MetricService.getInstance().startInternalReporter();
        DataNodeMetricsHelper.bind();
    }

    public static TDataNodeLocation generateDataNodeLocation() {
        TDataNodeLocation location = new TDataNodeLocation();
        location.setDataNodeId(config.getDataNodeId());
        location.setClientRpcEndPoint(new TEndPoint(config.getRpcAddress(), config.getRpcPort()));
        location.setInternalEndPoint(new TEndPoint(config.getInternalAddress(), config.getInternalPort()));
        location.setMPPDataExchangeEndPoint(new TEndPoint(config.getInternalAddress(), config.getMppDataExchangePort()));
        location.setDataRegionConsensusEndPoint(new TEndPoint(config.getInternalAddress(), config.getDataRegionConsensusPort()));
        location.setSchemaRegionConsensusEndPoint(new TEndPoint(config.getInternalAddress(), config.getSchemaRegionConsensusPort()));
        return location;
    }

    public TDataNodeConfiguration generateDataNodeConfiguration() {
        TDataNodeLocation location = DataNode.generateDataNodeLocation();
        TNodeResource resource = new TNodeResource();
        resource.setCpuCoreNum(Runtime.getRuntime().availableProcessors());
        resource.setMaxMemory(Runtime.getRuntime().totalMemory());
        return new TDataNodeConfiguration(location, resource);
    }

    private boolean isUsingPipeConsensus() {
        return config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensusV2");
    }

    private void registerUdfServices() throws StartupException {
        registerManager.register((IService)TemporaryQueryDataFileService.getInstance());
        registerManager.register((IService)UDFClassLoaderManager.setupAndGetInstance((String)config.getUdfDir()));
    }

    private void initUDFRelatedInstance() throws StartupException {
        try {
            UDFExecutableManager.setupAndGetInstance((String)config.getUdfTemporaryLibDir(), (String)config.getUdfDir());
            UDFClassLoaderManager.setupAndGetInstance((String)config.getUdfDir());
        }
        catch (IOException e) {
            throw new StartupException((Throwable)e);
        }
    }

    private void prepareUDFResources() throws StartupException {
        int offset;
        long startTime = System.currentTimeMillis();
        this.initUDFRelatedInstance();
        if (this.resourcesInformationHolder.getUDFInformationList() == null || this.resourcesInformationHolder.getUDFInformationList().isEmpty()) {
            return;
        }
        List<UDFInformation> udfNeedJarList = this.getJarListForUDF();
        for (int index = 0; index < udfNeedJarList.size(); index += offset + 1) {
            ArrayList curList = new ArrayList();
            for (offset = 0; offset < ResourcesInformationHolder.getJarNumOfOneRpc() && index + offset < udfNeedJarList.size(); ++offset) {
                curList.add(udfNeedJarList.get(index + offset));
            }
            this.getJarOfUDFs(curList);
        }
        try {
            for (UDFInformation udfInformation : this.resourcesInformationHolder.getUDFInformationList()) {
                if (!udfInformation.isAvailable()) continue;
                Model model = UDFManagementService.getInstance().checkAndGetModel(udfInformation);
                UDFManagementService.getInstance().doRegister(model, udfInformation);
            }
        }
        catch (Exception e) {
            throw new StartupException((Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        logger.debug("successfully registered all the UDFs, which takes {} ms.", (Object)(endTime - startTime));
        if (logger.isDebugEnabled()) {
            for (UDFInformation udfInformation : UDFManagementService.getInstance().getUDFInformation(Model.TREE)) {
                logger.debug("get tree udf: {}", (Object)udfInformation.getFunctionName());
            }
            for (UDFInformation udfInformation : UDFManagementService.getInstance().getUDFInformation(Model.TABLE)) {
                logger.debug("get table udf: {}", (Object)udfInformation.getFunctionName());
            }
        }
    }

    private void getJarOfUDFs(List<UDFInformation> udfInformationList) throws StartupException {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            List jarNameList = udfInformationList.stream().map(UDFInformation::getJarName).collect(Collectors.toList());
            TGetJarInListResp resp = configNodeClient.getUDFJar(new TGetJarInListReq(jarNameList));
            if (resp.getStatus().getCode() == TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()) {
                throw new StartupException("Failed to get UDF jar from config node.");
            }
            List jarList = resp.getJarList();
            for (int i = 0; i < udfInformationList.size(); ++i) {
                UDFExecutableManager.getInstance().saveToInstallDir((ByteBuffer)jarList.get(i), udfInformationList.get(i).getJarName());
            }
        }
        catch (IOException | ClientManagerException | TException e) {
            throw new StartupException(e);
        }
    }

    private List<UDFInformation> getJarListForUDF() {
        ArrayList<UDFInformation> res = new ArrayList<UDFInformation>();
        for (UDFInformation udfInformation : this.resourcesInformationHolder.getUDFInformationList()) {
            if (!udfInformation.isUsingURI()) continue;
            if (!UDFExecutableManager.getInstance().hasFileUnderInstallDir(udfInformation.getJarName())) {
                res.add(udfInformation);
                continue;
            }
            try {
                if (!UDFExecutableManager.getInstance().isLocalJarConflicted(udfInformation)) continue;
                res.add(udfInformation);
            }
            catch (UDFManagementException e) {
                res.add(udfInformation);
            }
        }
        return res;
    }

    private void getUDFInformationList(List<ByteBuffer> allUDFInformation) {
        if (allUDFInformation != null && !allUDFInformation.isEmpty()) {
            ArrayList<UDFInformation> list = new ArrayList<UDFInformation>();
            for (ByteBuffer UDFInformationByteBuffer : allUDFInformation) {
                list.add(UDFInformation.deserialize((ByteBuffer)UDFInformationByteBuffer));
            }
            this.resourcesInformationHolder.setUDFInformationList(list);
        }
    }

    private void initTriggerRelatedInstance() throws StartupException {
        try {
            TriggerExecutableManager.setupAndGetInstance((String)config.getTriggerTemporaryLibDir(), (String)config.getTriggerDir());
        }
        catch (IOException e) {
            throw new StartupException((Throwable)e);
        }
    }

    private void prepareTriggerResources() throws StartupException {
        int offset;
        long startTime = System.currentTimeMillis();
        this.initTriggerRelatedInstance();
        if (this.resourcesInformationHolder.getTriggerInformationList() == null || this.resourcesInformationHolder.getTriggerInformationList().isEmpty()) {
            return;
        }
        List<TriggerInformation> triggerNeedJarList = this.getJarListForTrigger();
        for (int index = 0; index < triggerNeedJarList.size(); index += offset + 1) {
            ArrayList curList = new ArrayList();
            for (offset = 0; offset < ResourcesInformationHolder.getJarNumOfOneRpc() && index + offset < triggerNeedJarList.size(); ++offset) {
                curList.add(triggerNeedJarList.get(index + offset));
            }
            this.getJarOfTriggers(curList);
        }
        try {
            for (TriggerInformation triggerInformation : this.resourcesInformationHolder.getTriggerInformationList()) {
                TriggerManagementService.getInstance().doRegister(triggerInformation, true);
            }
        }
        catch (Exception e) {
            throw new StartupException((Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            for (TriggerInformation triggerInformation : TriggerManagementService.getInstance().getAllTriggerInformationInTriggerTable()) {
                logger.debug("get trigger: {}", (Object)triggerInformation.getTriggerName());
            }
            for (TriggerExecutor triggerExecutor : TriggerManagementService.getInstance().getAllTriggerExecutors()) {
                logger.debug("get trigger executor: {}", (Object)triggerExecutor.getTriggerInformation().getTriggerName());
            }
        }
        this.triggerInformationUpdater.startTriggerInformationUpdater();
        long endTime = System.currentTimeMillis();
        logger.info("successfully registered all the triggers, which takes {} ms.", (Object)(endTime - startTime));
    }

    private void getJarOfTriggers(List<TriggerInformation> triggerInformationList) throws StartupException {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            List jarNameList = triggerInformationList.stream().map(TriggerInformation::getJarName).collect(Collectors.toList());
            TGetJarInListResp resp = configNodeClient.getTriggerJar(new TGetJarInListReq(jarNameList));
            if (resp.getStatus().getCode() == TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()) {
                throw new StartupException("Failed to get trigger jar from config node.");
            }
            List jarList = resp.getJarList();
            for (int i = 0; i < triggerInformationList.size(); ++i) {
                TriggerExecutableManager.getInstance().saveToInstallDir((ByteBuffer)jarList.get(i), triggerInformationList.get(i).getJarName());
            }
        }
        catch (IOException | ClientManagerException | TException e) {
            throw new StartupException(e);
        }
    }

    private List<TriggerInformation> getJarListForTrigger() {
        ArrayList<TriggerInformation> res = new ArrayList<TriggerInformation>();
        for (TriggerInformation triggerInformation : this.resourcesInformationHolder.getTriggerInformationList()) {
            if (!triggerInformation.isUsingURI()) continue;
            if (!TriggerExecutableManager.getInstance().hasFileUnderInstallDir(triggerInformation.getJarName())) {
                res.add(triggerInformation);
                continue;
            }
            try {
                if (!TriggerManagementService.getInstance().isLocalJarConflicted(triggerInformation)) continue;
                res.add(triggerInformation);
            }
            catch (TriggerManagementException e) {
                res.add(triggerInformation);
            }
        }
        return res;
    }

    private void getTriggerInformationList(List<ByteBuffer> allTriggerInformation) {
        if (allTriggerInformation != null && !allTriggerInformation.isEmpty()) {
            ArrayList<TriggerInformation> list = new ArrayList<TriggerInformation>();
            for (ByteBuffer triggerInformationByteBuffer : allTriggerInformation) {
                list.add(TriggerInformation.deserialize((ByteBuffer)triggerInformationByteBuffer));
            }
            this.resourcesInformationHolder.setTriggerInformationList(list);
        }
    }

    private void preparePipeResources() throws StartupException {
        long startTime = System.currentTimeMillis();
        PipeDataNodeAgent.runtime().preparePipeResources(this.resourcesInformationHolder);
        long endTime = System.currentTimeMillis();
        logger.info("Prepare pipe resources successfully, which takes {} ms.", (Object)(endTime - startTime));
    }

    private void getPipeInformationList(List<ByteBuffer> allPipeInformation) {
        ArrayList<PipePluginMeta> list = new ArrayList<PipePluginMeta>();
        if (allPipeInformation != null) {
            for (ByteBuffer pipeInformationByteBuffer : allPipeInformation) {
                list.add(PipePluginMeta.deserialize((ByteBuffer)pipeInformationByteBuffer));
            }
        }
        this.resourcesInformationHolder.setPipePluginMetaList(list);
    }

    private void initTTLInformation(byte[] allTTLInformation) throws StartupException {
        if (allTTLInformation == null) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.wrap(allTTLInformation);
        int mapSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        for (int i = 0; i < mapSize; ++i) {
            try {
                DataNodeTTLCache.getInstance().setTTLForTree(PathUtils.splitPathToDetachedNodes((String)Objects.requireNonNull(ReadWriteIOUtils.readString((ByteBuffer)buffer))), ReadWriteIOUtils.readLong((ByteBuffer)buffer));
                continue;
            }
            catch (IllegalPathException e) {
                throw new StartupException((Throwable)e);
            }
        }
    }

    private void storeClusterID(String clusterID) throws StartupException {
        try {
            if (config.getClusterId().isEmpty()) {
                config.setClusterId(clusterID);
                IoTDBStartCheck.getInstance().serializeClusterID(clusterID);
            }
        }
        catch (IOException e) {
            throw new StartupException((Throwable)e);
        }
    }

    private void initSchemaEngine() {
        long startTime = System.currentTimeMillis();
        SchemaEngine.getInstance().init();
        long endTime = System.currentTimeMillis();
        logger.info("Recover schema successfully, which takes {} ms.", (Object)(endTime - startTime));
    }

    private void classLoader() {
        try {
            Class.forName(StatementGenerator.class.getName());
            Class.forName(ASTVisitor.class.getName());
            Class.forName(SqlLexer.class.getName());
            Class.forName(CommonTokenStream.class.getName());
            Class.forName(IoTDBSqlParser.class.getName());
            Class.forName(SourceRewriter.class.getName());
            Class.forName(DistributionPlanContext.class.getName());
            Class.forName(LogicalPlanVisitor.class.getName());
            Class.forName(LogicalQueryPlan.class.getName());
            Class.forName(TsFileProcessor.class.getName());
        }
        catch (ClassNotFoundException e) {
            logger.error("load class error: ", (Throwable)e);
        }
    }

    public void deleteDataNodeSystemProperties() {
        DataNodeSystemPropertiesHandler.getInstance().delete();
    }

    public void stop() {
        this.stopTriggerRelatedServices();
        registerManager.deregisterAll();
        JMXService.deregisterMBean((String)this.mbeanName);
        MetricService.getInstance().stop();
        if (this.schemaRegionConsensusStarted) {
            try {
                SchemaRegionConsensusImpl.getInstance().stop();
            }
            catch (Exception e) {
                logger.warn("Exception during SchemaRegionConsensusImpl stopping", (Throwable)e);
            }
        }
        SchemaEngine.getInstance().clear();
        if (this.dataRegionConsensusStarted) {
            try {
                DataRegionConsensusImpl.getInstance().stop();
            }
            catch (Exception e) {
                logger.warn("Exception during DataRegionConsensusImpl stopping", (Throwable)e);
            }
        }
    }

    private void initProtocols() throws StartupException {
        if (config.isEnableMQTTService()) {
            registerManager.register((IService)MQTTService.getInstance());
        }
        if (IoTDBRestServiceDescriptor.getInstance().getConfig().isEnableRestService()) {
            registerManager.register((IService)RestService.getInstance());
        }
        if (PipeConfig.getInstance().getPipeAirGapReceiverEnabled()) {
            registerManager.register((IService)PipeDataNodeAgent.receiver().airGap());
        }
    }

    private void stopTriggerRelatedServices() {
        this.triggerInformationUpdater.stopTriggerInformationUpdater();
    }

    private void setUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new IoTDBDefaultThreadExceptionHandler());
    }

    private static class DataNodeHolder {
        private static DataNode INSTANCE;

        private DataNodeHolder() {
        }
    }
}

