/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.impl.ShowSchemaResult;
import org.apache.tsfile.utils.Binary;

public class ShowDevicesResult
extends ShowSchemaResult
implements IDeviceSchemaInfo {
    private Boolean isAligned;
    private int templateId;
    private Function<String, Binary> attributeProvider;
    private String[] rawNodes = null;

    public ShowDevicesResult(String name, Boolean isAligned, int templateId) {
        super(name);
        this.isAligned = isAligned;
        this.templateId = templateId;
    }

    public ShowDevicesResult(String name, Boolean isAligned, int templateId, String[] rawNodes) {
        super(name);
        this.isAligned = isAligned;
        this.templateId = templateId;
        this.rawNodes = rawNodes;
    }

    @Override
    public Boolean isAligned() {
        return this.isAligned;
    }

    @Override
    public int getTemplateId() {
        return this.templateId;
    }

    public void setAttributeProvider(Function<String, Binary> attributeProvider) {
        this.attributeProvider = attributeProvider;
    }

    @Override
    public Binary getAttributeValue(String attributeKey) {
        return this.attributeProvider.apply(attributeKey);
    }

    @Override
    public String[] getRawNodes() {
        return this.rawNodes;
    }

    @Override
    public PartialPath getPartialPath() {
        return this.rawNodes == null ? super.getPartialPath() : new PartialPath(this.rawNodes);
    }

    public static ShowDevicesResult convertDeviceEntry2ShowDeviceResult(DeviceEntry entry, List<String> attributeColumns) {
        ShowDevicesResult result = new ShowDevicesResult(entry.getDeviceID().toString(), null, -1, (String[])entry.getDeviceID().getSegments());
        HashMap<String, Binary> attributeProviderMap = new HashMap<String, Binary>();
        for (int i = 0; i < attributeColumns.size(); ++i) {
            attributeProviderMap.put(attributeColumns.get(i), entry.getAttributeColumnValues().get(i));
        }
        result.setAttributeProvider(attributeProviderMap::get);
        return result;
    }

    public String toString() {
        return "ShowDevicesResult{name='" + this.path + ", rawNodes = " + Arrays.toString(this.rawNodes) + ", isAligned = " + this.isAligned + ", templateId = " + this.templateId + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShowDevicesResult result = (ShowDevicesResult)o;
        return Objects.equals(this.path, result.path) && this.isAligned == result.isAligned && this.templateId == result.templateId;
    }

    public int hashCode() {
        return Objects.hash(this.path, this.isAligned, this.templateId);
    }
}

