/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.scheduler;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.async.AsyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.consensus.exception.ConsensusGroupNotExistException;
import org.apache.iotdb.consensus.exception.RatisReadUnavailableException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.mpp.FragmentInstanceDispatchException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.execution.executor.RegionExecutionResult;
import org.apache.iotdb.db.queryengine.execution.executor.RegionReadExecutor;
import org.apache.iotdb.db.queryengine.execution.executor.RegionWriteExecutor;
import org.apache.iotdb.db.queryengine.metric.QueryExecutionMetricSet;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableSchemaQuerySuccessfulCallbackVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableSchemaQueryWriteVisitor;
import org.apache.iotdb.db.queryengine.plan.scheduler.AsyncPlanNodeSender;
import org.apache.iotdb.db.queryengine.plan.scheduler.FragInstanceDispatchResult;
import org.apache.iotdb.db.queryengine.plan.scheduler.IFragInstanceDispatcher;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstance;
import org.apache.iotdb.mpp.rpc.thrift.TPlanNode;
import org.apache.iotdb.mpp.rpc.thrift.TSendBatchPlanNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TSendFragmentInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TSendFragmentInstanceResp;
import org.apache.iotdb.mpp.rpc.thrift.TSendSinglePlanNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TSendSinglePlanNodeResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentInstanceDispatcherImpl
implements IFragInstanceDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(FragmentInstanceDispatcherImpl.class);
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private final ExecutorService executor;
    private final ExecutorService writeOperationExecutor;
    private final QueryType type;
    private final MPPQueryContext queryContext;
    private final String localhostIpAddr;
    private final int localhostInternalPort;
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> syncInternalServiceClientManager;
    private final IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> asyncInternalServiceClientManager;
    private static final QueryExecutionMetricSet QUERY_EXECUTION_METRIC_SET = QueryExecutionMetricSet.getInstance();
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();
    private static final String DISPATCH_FAILED = "[DispatchFailed]";
    private static final String UNEXPECTED_ERRORS = "Unexpected errors: ";

    public FragmentInstanceDispatcherImpl(QueryType type, MPPQueryContext queryContext, ExecutorService executor, ExecutorService writeOperationExecutor, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> syncInternalServiceClientManager, IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> asyncInternalServiceClientManager) {
        this.type = type;
        this.queryContext = queryContext;
        this.executor = executor;
        this.writeOperationExecutor = writeOperationExecutor;
        this.syncInternalServiceClientManager = syncInternalServiceClientManager;
        this.asyncInternalServiceClientManager = asyncInternalServiceClientManager;
        this.localhostIpAddr = IoTDBDescriptor.getInstance().getConfig().getInternalAddress();
        this.localhostInternalPort = IoTDBDescriptor.getInstance().getConfig().getInternalPort();
    }

    @Override
    public Future<FragInstanceDispatchResult> dispatch(List<FragmentInstance> instances) {
        if (this.type == QueryType.READ) {
            return this.dispatchRead(instances);
        }
        return this.dispatchWriteAsync(instances);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<FragInstanceDispatchResult> dispatchRead(List<FragmentInstance> instances) {
        long startTime = System.nanoTime();
        for (FragmentInstance instance : instances) {
            try (SetThreadName threadName = new SetThreadName(instance.getId().getFullId());){
                this.dispatchOneInstance(instance);
            }
            catch (FragmentInstanceDispatchException e) {
                ListenableFuture listenableFuture = Futures.immediateFuture((Object)new FragInstanceDispatchResult(e.getFailureStatus()));
                return listenableFuture;
            }
            catch (Throwable t) {
                LOGGER.warn(DISPATCH_FAILED, t);
                ListenableFuture listenableFuture = Futures.immediateFuture((Object)new FragInstanceDispatchResult(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)(UNEXPECTED_ERRORS + t.getMessage()))));
                return listenableFuture;
            }
            finally {
                if (!this.queryContext.isExplainAnalyze()) {
                    instance.getFragment().clearUselessField();
                } else {
                    instance.getFragment().clearTypeProvider();
                }
                long dispatchReadTime = System.nanoTime() - startTime;
                QUERY_EXECUTION_METRIC_SET.recordExecutionCost("dispatch_read", dispatchReadTime);
                this.queryContext.recordDispatchCost(dispatchReadTime);
            }
        }
        return Futures.immediateFuture((Object)new FragInstanceDispatchResult(true));
    }

    private Future<FragInstanceDispatchResult> dispatchWriteSync(List<FragmentInstance> instances) {
        ArrayList<TSStatus> failureStatusList = new ArrayList<TSStatus>();
        for (FragmentInstance instance : instances) {
            try (SetThreadName threadName = new SetThreadName(instance.getId().getFullId());){
                this.dispatchOneInstance(instance);
            }
            catch (FragmentInstanceDispatchException e) {
                TSStatus failureStatus = e.getFailureStatus();
                if (instances.size() == 1) {
                    failureStatusList.add(failureStatus);
                    continue;
                }
                if (failureStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    failureStatusList.addAll(failureStatus.getSubStatus());
                    continue;
                }
                failureStatusList.add(failureStatus);
            }
            catch (Throwable t) {
                LOGGER.warn(DISPATCH_FAILED, t);
                failureStatusList.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)(UNEXPECTED_ERRORS + t.getMessage())));
            }
        }
        if (failureStatusList.isEmpty()) {
            return Futures.immediateFuture((Object)new FragInstanceDispatchResult(true));
        }
        if (instances.size() == 1) {
            return Futures.immediateFuture((Object)new FragInstanceDispatchResult((TSStatus)failureStatusList.get(0)));
        }
        return Futures.immediateFuture((Object)new FragInstanceDispatchResult(RpcUtils.getStatus(failureStatusList)));
    }

    private Future<FragInstanceDispatchResult> dispatchWriteAsync(List<FragmentInstance> instances) {
        AsyncPlanNodeSender asyncPlanNodeSender;
        ArrayList<TSStatus> dataNodeFailureList;
        block20: {
            dataNodeFailureList = new ArrayList<TSStatus>();
            ArrayList<FragmentInstance> localInstances = new ArrayList<FragmentInstance>();
            ArrayList<FragmentInstance> remoteInstances = new ArrayList<FragmentInstance>();
            for (FragmentInstance instance : instances) {
                TEndPoint endPoint = instance.getHostDataNode().getInternalEndPoint();
                if (this.isDispatchedToLocal(endPoint)) {
                    localInstances.add(instance);
                    continue;
                }
                remoteInstances.add(instance);
            }
            asyncPlanNodeSender = new AsyncPlanNodeSender(this.asyncInternalServiceClientManager, remoteInstances);
            asyncPlanNodeSender.sendAll();
            if (!localInstances.isEmpty()) {
                long localScheduleStartTime = System.nanoTime();
                for (FragmentInstance localInstance : localInstances) {
                    try (SetThreadName threadName = new SetThreadName(localInstance.getId().getFullId());){
                        this.dispatchLocally(localInstance);
                    }
                    catch (FragmentInstanceDispatchException e) {
                        dataNodeFailureList.add(e.getFailureStatus());
                    }
                    catch (Throwable t) {
                        LOGGER.warn(DISPATCH_FAILED, t);
                        dataNodeFailureList.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)(UNEXPECTED_ERRORS + t.getMessage())));
                    }
                }
                PERFORMANCE_OVERVIEW_METRICS.recordScheduleLocalCost(System.nanoTime() - localScheduleStartTime);
            }
            try {
                long maxRetryDurationInNs;
                asyncPlanNodeSender.waitUntilCompleted();
                long l = maxRetryDurationInNs = COMMON_CONFIG.getRemoteWriteMaxRetryDurationInMs() > 0L ? COMMON_CONFIG.getRemoteWriteMaxRetryDurationInMs() * 1000000L : 0L;
                if (maxRetryDurationInNs <= 0L || !asyncPlanNodeSender.needRetry()) break block20;
                int retryCount = 0;
                long waitMillis = this.getRetrySleepTime(retryCount);
                long retryStartTime = System.nanoTime();
                while (asyncPlanNodeSender.needRetry()) {
                    ++retryCount;
                    asyncPlanNodeSender.retry();
                    if (asyncPlanNodeSender.needRetry() && System.nanoTime() - retryStartTime + waitMillis * 1000000L < maxRetryDurationInNs) {
                        Thread.sleep(waitMillis);
                        PERFORMANCE_OVERVIEW_METRICS.recordRemoteRetrySleepCost(waitMillis * 1000000L);
                        waitMillis = this.getRetrySleepTime(retryCount);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.error("Interrupted when dispatching write async", (Throwable)e);
                return Futures.immediateFuture((Object)new FragInstanceDispatchResult(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)("Interrupted errors: " + e.getMessage()))));
            }
        }
        dataNodeFailureList.addAll(asyncPlanNodeSender.getFailureStatusList());
        if (dataNodeFailureList.isEmpty()) {
            return Futures.immediateFuture((Object)new FragInstanceDispatchResult(true));
        }
        if (instances.size() == 1) {
            return Futures.immediateFuture((Object)new FragInstanceDispatchResult((TSStatus)dataNodeFailureList.get(0)));
        }
        ArrayList<TSStatus> failureStatusList = new ArrayList<TSStatus>();
        for (TSStatus dataNodeFailure : dataNodeFailureList) {
            if (dataNodeFailure.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                failureStatusList.addAll(dataNodeFailure.getSubStatus());
                continue;
            }
            failureStatusList.add(dataNodeFailure);
        }
        return Futures.immediateFuture((Object)new FragInstanceDispatchResult(RpcUtils.getStatus(failureStatusList)));
    }

    private long getRetrySleepTime(int retryTimes) {
        return Math.min((long)((double)TimeUnit.MILLISECONDS.toMillis(100L) * Math.pow(2.0, retryTimes)), TimeUnit.SECONDS.toMillis(20L));
    }

    private void dispatchOneInstance(FragmentInstance instance) throws FragmentInstanceDispatchException {
        TEndPoint endPoint = instance.getHostDataNode().getInternalEndPoint();
        if (this.isDispatchedToLocal(endPoint)) {
            this.dispatchLocally(instance);
        } else {
            this.dispatchRemote(instance, endPoint);
        }
    }

    private boolean isDispatchedToLocal(TEndPoint endPoint) {
        return this.localhostIpAddr.equals(endPoint.getIp()) && this.localhostInternalPort == endPoint.port;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dispatchRemoteHelper(FragmentInstance instance, TEndPoint endPoint) throws FragmentInstanceDispatchException, TException, ClientManagerException, RatisReadUnavailableException, ConsensusGroupNotExistException {
        try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.syncInternalServiceClientManager.borrowClient((Object)endPoint);){
            switch (instance.getType()) {
                case READ: {
                    TSendFragmentInstanceReq sendFragmentInstanceReq = new TSendFragmentInstanceReq(new TFragmentInstance(instance.serializeToByteBuffer()));
                    if (instance.getExecutorType().isStorageExecutor()) {
                        sendFragmentInstanceReq.setConsensusGroupId(instance.getRegionReplicaSet().getRegionId());
                    }
                    TSendFragmentInstanceResp sendFragmentInstanceResp = client.sendFragmentInstance(sendFragmentInstanceReq);
                    if (!sendFragmentInstanceResp.accepted) {
                        LOGGER.warn(sendFragmentInstanceResp.message);
                        if (sendFragmentInstanceResp.isSetNeedRetry() && sendFragmentInstanceResp.isNeedRetry() && sendFragmentInstanceResp.status != null) {
                            if (sendFragmentInstanceResp.status.getCode() == TSStatusCode.RATIS_READ_UNAVAILABLE.getStatusCode()) {
                                throw new RatisReadUnavailableException(sendFragmentInstanceResp.message);
                            }
                            if (sendFragmentInstanceResp.status.getCode() == TSStatusCode.CONSENSUS_GROUP_NOT_EXIST.getStatusCode()) {
                                throw new ConsensusGroupNotExistException(sendFragmentInstanceResp.message);
                            }
                            if (sendFragmentInstanceResp.status.getCode() != TSStatusCode.TOO_MANY_CONCURRENT_QUERIES_ERROR.getStatusCode()) throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)sendFragmentInstanceResp.message));
                            throw new FragmentInstanceDispatchException(sendFragmentInstanceResp.status);
                        }
                        if (sendFragmentInstanceResp.status == null) throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)sendFragmentInstanceResp.message));
                        throw new FragmentInstanceDispatchException(sendFragmentInstanceResp.status);
                    }
                    if (!Objects.nonNull(sendFragmentInstanceReq.getConsensusGroupId())) return;
                    new TableSchemaQuerySuccessfulCallbackVisitor().processFragment(instance, ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)sendFragmentInstanceReq.getConsensusGroupId()));
                    return;
                }
                case WRITE: {
                    TSendBatchPlanNodeReq sendPlanNodeReq = new TSendBatchPlanNodeReq(Collections.singletonList(new TSendSinglePlanNodeReq(new TPlanNode(instance.getFragment().getPlanNodeTree().serializeToByteBuffer()), instance.getRegionReplicaSet().getRegionId())));
                    TSendSinglePlanNodeResp sendPlanNodeResp = (TSendSinglePlanNodeResp)client.sendBatchPlanNode(sendPlanNodeReq).getResponses().get(0);
                    if (!sendPlanNodeResp.accepted) {
                        if (sendPlanNodeResp.getStatus() == null) {
                            throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_ERROR, (String)sendPlanNodeResp.getMessage()));
                        }
                        if (sendPlanNodeResp.getStatus().getCode() == TSStatusCode.SYSTEM_READ_ONLY.getStatusCode()) throw new FragmentInstanceDispatchException(sendPlanNodeResp.getStatus());
                        LOGGER.warn("Dispatch write failed. status: {}, code: {}, message: {}, node {}", new Object[]{sendPlanNodeResp.status, TSStatusCode.representOf((int)sendPlanNodeResp.status.code), sendPlanNodeResp.message, endPoint});
                        throw new FragmentInstanceDispatchException(sendPlanNodeResp.getStatus());
                    }
                    TSStatus status = sendPlanNodeResp.getStatus();
                    if (status == null || status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) return;
                    throw new FragmentInstanceDispatchException(status);
                }
                default: {
                    throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)String.format("unknown read type [%s]", new Object[]{instance.getType()})));
                }
            }
        }
    }

    private void dispatchRemoteFailed(TEndPoint endPoint, Exception e) throws FragmentInstanceDispatchException {
        LOGGER.warn("can't execute request on node  {} in second try, error msg is {}.", (Object)endPoint, (Object)ExceptionUtils.getRootCause((Throwable)e).toString());
        TSStatus status = new TSStatus();
        status.setCode(TSStatusCode.DISPATCH_ERROR.getStatusCode());
        status.setMessage("can't connect to node " + endPoint);
        this.queryContext.addFailedEndPoint(endPoint);
        throw new FragmentInstanceDispatchException(status);
    }

    private void dispatchRemote(FragmentInstance instance, TEndPoint endPoint) throws FragmentInstanceDispatchException {
        try {
            this.dispatchRemoteHelper(instance, endPoint);
        }
        catch (ClientManagerException | RatisReadUnavailableException | TException e) {
            LOGGER.warn("can't execute request on node {}, error msg is {}, and we try to reconnect this node.", (Object)endPoint, (Object)ExceptionUtils.getRootCause((Throwable)e).toString());
            try {
                this.dispatchRemoteHelper(instance, endPoint);
            }
            catch (ClientManagerException | ConsensusGroupNotExistException | RatisReadUnavailableException | TException e1) {
                this.dispatchRemoteFailed(endPoint, (Exception)e1);
            }
        }
        catch (ConsensusGroupNotExistException e) {
            this.dispatchRemoteFailed(endPoint, (Exception)((Object)e));
        }
    }

    private void dispatchLocally(FragmentInstance instance) throws FragmentInstanceDispatchException {
        ConsensusGroupId groupId = null;
        if (instance.getExecutorType().isStorageExecutor()) {
            try {
                groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)instance.getRegionReplicaSet().getRegionId());
            }
            catch (Throwable t) {
                LOGGER.warn("Deserialize ConsensusGroupId failed. ", t);
                throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)("Deserialize ConsensusGroupId failed: " + t.getMessage())));
            }
        }
        switch (instance.getType()) {
            case READ: {
                RegionExecutionResult executionResult = null;
                if (Objects.nonNull(groupId)) {
                    executionResult = (RegionExecutionResult)new TableSchemaQueryWriteVisitor().processFragment(instance, groupId);
                }
                if (Objects.isNull(executionResult)) {
                    RegionReadExecutor readExecutor = new RegionReadExecutor();
                    RegionExecutionResult regionExecutionResult = executionResult = groupId == null ? readExecutor.execute(instance) : readExecutor.execute(groupId, instance);
                }
                if (!executionResult.isAccepted()) {
                    LOGGER.warn(executionResult.getMessage());
                    if (executionResult.isReadNeedRetry()) {
                        if (executionResult.getStatus() != null && executionResult.getStatus().getCode() == TSStatusCode.TOO_MANY_CONCURRENT_QUERIES_ERROR.getStatusCode()) {
                            throw new FragmentInstanceDispatchException(executionResult.getStatus());
                        }
                        throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.DISPATCH_ERROR, (String)executionResult.getMessage()));
                    }
                    if (executionResult.getStatus() != null) {
                        throw new FragmentInstanceDispatchException(executionResult.getStatus());
                    }
                    throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)executionResult.getMessage()));
                }
                if (!Objects.nonNull(groupId)) break;
                new TableSchemaQuerySuccessfulCallbackVisitor().processFragment(instance, groupId);
                break;
            }
            case WRITE: {
                PlanNode planNode = instance.getFragment().getPlanNodeTree();
                RegionWriteExecutor writeExecutor = new RegionWriteExecutor();
                RegionExecutionResult writeResult = writeExecutor.execute(groupId, planNode);
                if (!writeResult.isAccepted()) {
                    if (writeResult.getStatus() == null) {
                        throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)writeResult.getMessage()));
                    }
                    if (writeResult.getStatus().getCode() != TSStatusCode.SYSTEM_READ_ONLY.getStatusCode()) {
                        LOGGER.warn("write locally failed. TSStatus: {}, message: {}", (Object)writeResult.getStatus(), (Object)writeResult.getMessage());
                    }
                    throw new FragmentInstanceDispatchException(writeResult.getStatus());
                }
                TSStatus status = writeResult.getStatus();
                if (status == null || status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) break;
                throw new FragmentInstanceDispatchException(status);
            }
            default: {
                throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)String.format("unknown read type [%s]", new Object[]{instance.getType()})));
            }
        }
    }

    @Override
    public void abort() {
    }
}

