/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PipeStatement;

public class AlterPipe
extends PipeStatement {
    private final String pipeName;
    private final boolean ifExistsCondition;
    private final Map<String, String> extractorAttributes;
    private final Map<String, String> processorAttributes;
    private final Map<String, String> connectorAttributes;
    private final boolean isReplaceAllExtractorAttributes;
    private final boolean isReplaceAllProcessorAttributes;
    private final boolean isReplaceAllConnectorAttributes;

    public AlterPipe(String pipeName, boolean ifExistsCondition, Map<String, String> extractorAttributes, Map<String, String> processorAttributes, Map<String, String> connectorAttributes, boolean isReplaceAllExtractorAttributes, boolean isReplaceAllProcessorAttributes, boolean isReplaceAllConnectorAttributes) {
        this.pipeName = Objects.requireNonNull(pipeName);
        this.ifExistsCondition = ifExistsCondition;
        this.extractorAttributes = Objects.requireNonNull(extractorAttributes);
        this.processorAttributes = Objects.requireNonNull(processorAttributes);
        this.connectorAttributes = Objects.requireNonNull(connectorAttributes);
        this.isReplaceAllExtractorAttributes = isReplaceAllExtractorAttributes;
        this.isReplaceAllProcessorAttributes = isReplaceAllProcessorAttributes;
        this.isReplaceAllConnectorAttributes = isReplaceAllConnectorAttributes;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public boolean hasIfExistsCondition() {
        return this.ifExistsCondition;
    }

    public Map<String, String> getExtractorAttributes() {
        return this.extractorAttributes;
    }

    public Map<String, String> getProcessorAttributes() {
        return this.processorAttributes;
    }

    public Map<String, String> getConnectorAttributes() {
        return this.connectorAttributes;
    }

    public boolean isReplaceAllExtractorAttributes() {
        return this.isReplaceAllExtractorAttributes;
    }

    public boolean isReplaceAllProcessorAttributes() {
        return this.isReplaceAllProcessorAttributes;
    }

    public boolean isReplaceAllConnectorAttributes() {
        return this.isReplaceAllConnectorAttributes;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAlterPipe(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pipeName, this.ifExistsCondition, this.extractorAttributes, this.processorAttributes, this.connectorAttributes, this.isReplaceAllExtractorAttributes, this.isReplaceAllProcessorAttributes, this.isReplaceAllConnectorAttributes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AlterPipe alterPipe = (AlterPipe)obj;
        return Objects.equals(this.pipeName, alterPipe.pipeName) && Objects.equals(this.ifExistsCondition, alterPipe.ifExistsCondition) && Objects.equals(this.extractorAttributes, alterPipe.extractorAttributes) && Objects.equals(this.processorAttributes, alterPipe.processorAttributes) && Objects.equals(this.connectorAttributes, alterPipe.connectorAttributes) && Objects.equals(this.isReplaceAllExtractorAttributes, alterPipe.isReplaceAllExtractorAttributes) && Objects.equals(this.isReplaceAllProcessorAttributes, alterPipe.isReplaceAllProcessorAttributes) && Objects.equals(this.isReplaceAllConnectorAttributes, alterPipe.isReplaceAllConnectorAttributes);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pipeName", (Object)this.pipeName).add("ifExistsCondition", this.ifExistsCondition).add("extractorAttributes", this.extractorAttributes).add("processorAttributes", this.processorAttributes).add("connectorAttributes", this.connectorAttributes).add("isReplaceAllExtractorAttributes", this.isReplaceAllExtractorAttributes).add("isReplaceAllProcessorAttributes", this.isReplaceAllProcessorAttributes).add("isReplaceAllConnectorAttributes", this.isReplaceAllConnectorAttributes).toString();
    }
}

