/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.security;

import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.security.AccessControl;
import org.apache.iotdb.db.queryengine.plan.relational.security.ITableAuthChecker;
import org.apache.iotdb.db.queryengine.plan.relational.security.TableModelPrivilege;

public class AccessControlImpl
implements AccessControl {
    private final ITableAuthChecker authChecker;

    public AccessControlImpl(ITableAuthChecker authChecker) {
        this.authChecker = authChecker;
    }

    @Override
    public void checkCanCreateDatabase(String userName, String databaseName) {
        this.authChecker.checkDatabasePrivilege(userName, databaseName, TableModelPrivilege.CREATE);
    }

    @Override
    public void checkCanDropDatabase(String userName, String databaseName) {
        this.authChecker.checkDatabasePrivilege(userName, databaseName, TableModelPrivilege.DROP);
    }

    @Override
    public void checkCanAlterDatabase(String userName, String databaseName) {
        this.authChecker.checkDatabasePrivilege(userName, databaseName, TableModelPrivilege.ALTER);
    }

    @Override
    public void checkCanShowOrUseDatabase(String userName, String databaseName) {
        this.authChecker.checkDatabaseVisibility(userName, databaseName);
    }

    @Override
    public void checkCanCreateTable(String userName, QualifiedObjectName tableName) {
        this.authChecker.checkTablePrivilege(userName, tableName, TableModelPrivilege.CREATE);
    }

    @Override
    public void checkCanDropTable(String userName, QualifiedObjectName tableName) {
        this.authChecker.checkTablePrivilege(userName, tableName, TableModelPrivilege.DROP);
    }

    @Override
    public void checkCanAlterTable(String userName, QualifiedObjectName tableName) {
        this.authChecker.checkTablePrivilege(userName, tableName, TableModelPrivilege.ALTER);
    }

    @Override
    public void checkCanInsertIntoTable(String userName, QualifiedObjectName tableName) {
        this.authChecker.checkTablePrivilege(userName, tableName, TableModelPrivilege.INSERT);
    }

    @Override
    public void checkCanSelectFromTable(String userName, QualifiedObjectName tableName) {
        this.authChecker.checkTablePrivilege(userName, tableName, TableModelPrivilege.SELECT);
    }

    @Override
    public void checkCanDeleteFromTable(String userName, QualifiedObjectName tableName) {
        this.authChecker.checkTablePrivilege(userName, tableName, TableModelPrivilege.DELETE);
    }

    @Override
    public void checkCanShowOrDescTable(String userName, QualifiedObjectName tableName) {
        this.authChecker.checkTableVisibility(userName, tableName);
    }

    @Override
    public void checkUserHasMaintainPrivilege(String userName) {
        this.authChecker.checkGlobalPrivilege(userName, TableModelPrivilege.MAINTAIN);
    }
}

