/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.metric.QueryPlanCostMetricSet;
import org.apache.iotdb.db.queryengine.plan.analyze.AnalyzeVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate.ConvertPredicateToTimeFilterVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate.PredicateCombineIntoTableScanChecker;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate.PredicatePushIntoMetadataChecker;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.NonAlignedAlignedDeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Assignments;
import org.apache.iotdb.db.queryengine.plan.relational.planner.EqualityInference;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SortOrder;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolAllocator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolsExtractor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.DeterminismEvaluator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.GlobalTimePredicateExtractVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.IrUtils;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.ReplaceSymbolInExpression;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.DeviceTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FilterNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TreeDeviceViewScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.Cardinality;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.JoinUtils;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PlanOptimizer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.QueryCardinalityUtil;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.Pair;

public class PushPredicateIntoTableScan
implements PlanOptimizer {
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();

    @Override
    public PlanNode optimize(PlanNode plan, PlanOptimizer.Context context) {
        return plan.accept(new Rewriter(context.getQueryContext(), context.getAnalysis(), context.getMetadata(), context.getSymbolAllocator()), new RewriteContext(BooleanLiteral.TRUE_LITERAL));
    }

    public static boolean containsDiffFunction(Expression expression) {
        if (expression instanceof FunctionCall && "diff".equalsIgnoreCase(((FunctionCall)expression).getName().toString())) {
            return true;
        }
        if (!expression.getChildren().isEmpty()) {
            for (Node node : expression.getChildren()) {
                if (!PushPredicateIntoTableScan.containsDiffFunction((Expression)node)) continue;
                return true;
            }
        }
        return false;
    }

    private static class Rewriter
    extends PlanVisitor<PlanNode, RewriteContext> {
        private final MPPQueryContext queryContext;
        private final Analysis analysis;
        private final Metadata metadata;
        private final SymbolAllocator symbolAllocator;
        private final QueryId queryId;

        Rewriter(MPPQueryContext queryContext, Analysis analysis, Metadata metadata, SymbolAllocator symbolAllocator) {
            this.queryContext = queryContext;
            this.analysis = analysis;
            this.metadata = metadata;
            this.symbolAllocator = symbolAllocator;
            this.queryId = queryContext.getQueryId();
        }

        @Override
        public PlanNode visitPlan(PlanNode node, RewriteContext context) {
            PlanNode rewrittenNode = node.clone();
            for (PlanNode child : node.getChildren()) {
                RewriteContext subContext = new RewriteContext();
                PlanNode rewrittenChild = child.accept(this, subContext);
                rewrittenNode.addChild(rewrittenChild);
            }
            if (!BooleanLiteral.TRUE_LITERAL.equals(context.inheritedPredicate)) {
                FilterNode filterNode = new FilterNode(this.queryId.genPlanNodeId(), rewrittenNode, context.inheritedPredicate);
                context.inheritedPredicate = BooleanLiteral.TRUE_LITERAL;
                return filterNode;
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitProject(ProjectNode node, RewriteContext context) {
            for (Expression expression : node.getAssignments().getMap().values()) {
                if (!PushPredicateIntoTableScan.containsDiffFunction(expression)) continue;
                node.setChild(node.getChild().accept(this, new RewriteContext()));
                if (!BooleanLiteral.TRUE_LITERAL.equals(context.inheritedPredicate)) {
                    FilterNode filterNode = new FilterNode(this.queryId.genPlanNodeId(), node, context.inheritedPredicate);
                    context.inheritedPredicate = BooleanLiteral.TRUE_LITERAL;
                    return filterNode;
                }
                return node;
            }
            node.setChild(node.getChild().accept(this, context));
            return node;
        }

        @Override
        public PlanNode visitFilter(FilterNode node, RewriteContext context) {
            Preconditions.checkArgument((node.getPredicate() != null ? 1 : 0) != 0, (Object)"Filter predicate of FilterNode is null");
            Expression predicate = IrUtils.combineConjuncts(node.getPredicate(), context.inheritedPredicate);
            if (PushPredicateIntoTableScan.containsDiffFunction(predicate)) {
                node.setChild(node.getChild().accept(this, new RewriteContext()));
                node.setPredicate(predicate);
                context.inheritedPredicate = BooleanLiteral.TRUE_LITERAL;
                return node;
            }
            PlanNode rewrittenPlan = node.getChild().accept(this, new RewriteContext(predicate));
            if (!(rewrittenPlan instanceof FilterNode)) {
                return rewrittenPlan;
            }
            FilterNode rewrittenFilterNode = (FilterNode)rewrittenPlan;
            if (!rewrittenFilterNode.getPredicate().equals(node.getPredicate()) || node.getChild() != rewrittenFilterNode.getChild()) {
                return rewrittenPlan;
            }
            return node;
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, RewriteContext context) {
            if (node.hasEmptyGroupingSet()) {
                return this.visitPlan((PlanNode)node, context);
            }
            Expression inheritedPredicate = context.inheritedPredicate;
            EqualityInference equalityInference = new EqualityInference(this.metadata, inheritedPredicate);
            ArrayList<Expression> pushdownConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postAggregationConjuncts = new ArrayList<Expression>();
            IrUtils.extractConjuncts(inheritedPredicate).stream().filter(expression -> !DeterminismEvaluator.isDeterministic(expression)).forEach(postAggregationConjuncts::add);
            inheritedPredicate = IrUtils.filterDeterministicConjuncts(inheritedPredicate);
            ImmutableSet groupingKeys = ImmutableSet.copyOf(node.getGroupingKeys());
            EqualityInference.nonInferrableConjuncts(this.metadata, inheritedPredicate).forEach(arg_0 -> Rewriter.lambda$visitAggregation$1(node, postAggregationConjuncts, equalityInference, (Set)groupingKeys, pushdownConjuncts, arg_0));
            EqualityInference.EqualityPartition equalityPartition = equalityInference.generateEqualitiesPartitionedBy((Set<Symbol>)groupingKeys);
            pushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postAggregationConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postAggregationConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            context.inheritedPredicate = IrUtils.combineConjuncts(pushdownConjuncts);
            SingleChildProcessNode output = AggregationNode.builderFrom(node).setSource(node.getChild().accept(this, context)).setPreGroupedSymbols((List<Symbol>)ImmutableList.of()).build();
            if (!postAggregationConjuncts.isEmpty()) {
                output = new FilterNode(this.queryId.genPlanNodeId(), output, IrUtils.combineConjuncts(postAggregationConjuncts));
            }
            return output;
        }

        @Override
        public PlanNode visitDeviceTableScan(DeviceTableScanNode tableScanNode, RewriteContext context) {
            if (BooleanLiteral.TRUE_LITERAL.equals(context.inheritedPredicate)) {
                this.getDeviceEntriesWithDataPartitions(tableScanNode, Collections.emptyList(), null);
                return tableScanNode;
            }
            return this.combineFilterAndScan(tableScanNode, context.inheritedPredicate);
        }

        public PlanNode combineFilterAndScan(DeviceTableScanNode tableScanNode, Expression predicate) {
            List<Expression> expressions;
            SplitExpression splitExpression = this.splitPredicate(tableScanNode, predicate);
            if (!splitExpression.getExpressionsCanPushDown().isEmpty()) {
                expressions = splitExpression.getExpressionsCanPushDown();
                Expression pushDownPredicate = expressions.size() == 1 ? expressions.get(0) : new LogicalExpression(LogicalExpression.Operator.AND, expressions);
                Pair<Expression, Boolean> resultPair = GlobalTimePredicateExtractVisitor.extractGlobalTimeFilter(pushDownPredicate, splitExpression.getTimeColumnName());
                if (resultPair.left != null) {
                    tableScanNode.setTimePredicate((Expression)resultPair.left);
                }
                if (Boolean.TRUE.equals(resultPair.right)) {
                    if (pushDownPredicate instanceof LogicalExpression && ((LogicalExpression)pushDownPredicate).getTerms().size() == 1) {
                        tableScanNode.setPushDownPredicate(((LogicalExpression)pushDownPredicate).getTerms().get(0));
                    } else {
                        tableScanNode.setPushDownPredicate(pushDownPredicate);
                    }
                }
            } else {
                tableScanNode.setPushDownPredicate(null);
            }
            this.getDeviceEntriesWithDataPartitions(tableScanNode, splitExpression.getMetadataExpressions(), splitExpression.getTimeColumnName());
            if (!splitExpression.getExpressionsCannotPushDown().isEmpty()) {
                expressions = splitExpression.getExpressionsCannotPushDown();
                return new FilterNode(this.queryId.genPlanNodeId(), tableScanNode, expressions.size() == 1 ? expressions.get(0) : new LogicalExpression(LogicalExpression.Operator.AND, expressions));
            }
            return tableScanNode;
        }

        private SplitExpression splitPredicate(DeviceTableScanNode node, Expression predicate) {
            HashSet<String> idOrAttributeColumnNames = new HashSet<String>(node.getAssignments().size());
            HashSet<String> measurementColumnNames = new HashSet<String>(node.getAssignments().size());
            String timeColumnName = null;
            for (Map.Entry<Symbol, ColumnSchema> entry : node.getAssignments().entrySet()) {
                Symbol columnSymbol = entry.getKey();
                ColumnSchema columnSchema = entry.getValue();
                if (TsTableColumnCategory.TIME.equals((Object)columnSchema.getColumnCategory())) {
                    measurementColumnNames.add(columnSymbol.getName());
                    timeColumnName = columnSymbol.getName();
                    continue;
                }
                if (TsTableColumnCategory.FIELD.equals((Object)columnSchema.getColumnCategory())) {
                    measurementColumnNames.add(columnSymbol.getName());
                    continue;
                }
                idOrAttributeColumnNames.add(columnSymbol.getName());
            }
            ArrayList<Expression> metadataExpressions = new ArrayList<Expression>();
            ArrayList<Expression> expressionsCanPushDown = new ArrayList<Expression>();
            ArrayList<Expression> expressionsCannotPushDown = new ArrayList<Expression>();
            if (predicate instanceof LogicalExpression && ((LogicalExpression)predicate).getOperator() == LogicalExpression.Operator.AND) {
                for (Expression expression : ((LogicalExpression)predicate).getTerms()) {
                    if (PredicatePushIntoMetadataChecker.check(idOrAttributeColumnNames, expression)) {
                        metadataExpressions.add(expression);
                        continue;
                    }
                    if (PredicateCombineIntoTableScanChecker.check(measurementColumnNames, expression)) {
                        expressionsCanPushDown.add(expression);
                        continue;
                    }
                    expressionsCannotPushDown.add(expression);
                }
                return new SplitExpression(metadataExpressions, expressionsCanPushDown, expressionsCannotPushDown, timeColumnName);
            }
            if (PredicatePushIntoMetadataChecker.check(idOrAttributeColumnNames, predicate)) {
                metadataExpressions.add(predicate);
            } else if (PredicateCombineIntoTableScanChecker.check(measurementColumnNames, predicate)) {
                expressionsCanPushDown.add(predicate);
            } else {
                expressionsCannotPushDown.add(predicate);
            }
            return new SplitExpression(metadataExpressions, expressionsCanPushDown, expressionsCannotPushDown, timeColumnName);
        }

        private void getDeviceEntriesWithDataPartitions(DeviceTableScanNode tableScanNode, List<Expression> metadataExpressions, String timeColumnName) {
            ArrayList<String> attributeColumns = new ArrayList<String>();
            int attributeIndex = 0;
            for (Map.Entry<Symbol, ColumnSchema> entry : tableScanNode.getAssignments().entrySet()) {
                Symbol columnSymbol = entry.getKey();
                ColumnSchema columnSchema = entry.getValue();
                if (!TsTableColumnCategory.ATTRIBUTE.equals((Object)columnSchema.getColumnCategory())) continue;
                attributeColumns.add(columnSchema.getName());
                tableScanNode.getIdAndAttributeIndexMap().put(columnSymbol, attributeIndex++);
            }
            long startTime = System.nanoTime();
            List<DeviceEntry> deviceEntries = this.metadata.indexScan(tableScanNode.getQualifiedObjectName(), metadataExpressions.stream().map(expression -> ReplaceSymbolInExpression.transform(expression, tableScanNode.getAssignments())).collect(Collectors.toList()), attributeColumns, this.queryContext);
            tableScanNode.setDeviceEntries(deviceEntries);
            if (deviceEntries.stream().anyMatch(deviceEntry -> deviceEntry instanceof NonAlignedAlignedDeviceEntry)) {
                tableScanNode.setContainsNonAlignedDevice();
            }
            long schemaFetchCost = System.nanoTime() - startTime;
            QueryPlanCostMetricSet.getInstance().recordPlanCost("table", "schema_fetcher", schemaFetchCost);
            this.queryContext.setFetchSchemaCost(schemaFetchCost);
            if (deviceEntries.isEmpty()) {
                if (this.analysis.noAggregates() && !this.analysis.hasJoinNode()) {
                    this.analysis.setEmptyDataSource(true);
                    this.analysis.setFinishQueryAfterAnalyze();
                }
            } else {
                Filter timeFilter = tableScanNode.getTimePredicate().map(value -> value.accept(new ConvertPredicateToTimeFilterVisitor(), null)).orElse(null);
                tableScanNode.setTimeFilter(timeFilter);
                startTime = System.nanoTime();
                DataPartition dataPartition = this.fetchDataPartitionByDevices(tableScanNode instanceof TreeDeviceViewScanNode ? ((TreeDeviceViewScanNode)tableScanNode).getTreeDBName() : tableScanNode.getQualifiedObjectName().getDatabaseName(), deviceEntries, timeFilter);
                if (dataPartition.getDataPartitionMap().size() > 1) {
                    throw new IllegalStateException("Table model can only process data only in one database yet!");
                }
                if (dataPartition.getDataPartitionMap().isEmpty()) {
                    if (this.analysis.noAggregates() && !this.analysis.hasJoinNode()) {
                        this.analysis.setEmptyDataSource(true);
                        this.analysis.setFinishQueryAfterAnalyze();
                    }
                } else {
                    this.analysis.upsertDataPartition(dataPartition);
                }
                long fetchPartitionCost = System.nanoTime() - startTime;
                QueryPlanCostMetricSet.getInstance().recordPlanCost("table", "partition_fetcher", fetchPartitionCost);
                this.queryContext.setFetchPartitionCost(fetchPartitionCost);
            }
        }

        @Override
        public PlanNode visitJoin(JoinNode node, RewriteContext context) {
            ImmutableList joinFilter;
            Optional<Expression> newJoinFilter;
            PlanNode rightSource;
            PlanNode leftSource;
            Expression newJoinPredicate;
            Expression postJoinPredicate;
            Expression rightPredicate;
            Expression leftPredicate;
            Expression inheritedPredicate = context.inheritedPredicate != null ? context.inheritedPredicate : BooleanLiteral.TRUE_LITERAL;
            BooleanLiteral leftEffectivePredicate = BooleanLiteral.TRUE_LITERAL;
            BooleanLiteral rightEffectivePredicate = BooleanLiteral.TRUE_LITERAL;
            Expression joinPredicate = JoinUtils.extractJoinPredicate(node);
            switch (node.getJoinType()) {
                case INNER: {
                    JoinUtils.InnerJoinPushDownResult innerJoinPushDownResult = JoinUtils.processInnerJoin(this.metadata, inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeftChild().getOutputSymbols(), node.getRightChild().getOutputSymbols());
                    leftPredicate = innerJoinPushDownResult.getLeftPredicate();
                    rightPredicate = innerJoinPushDownResult.getRightPredicate();
                    postJoinPredicate = innerJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = innerJoinPushDownResult.getJoinPredicate();
                    break;
                }
                case FULL: {
                    leftPredicate = BooleanLiteral.TRUE_LITERAL;
                    rightPredicate = BooleanLiteral.TRUE_LITERAL;
                    postJoinPredicate = inheritedPredicate;
                    newJoinPredicate = joinPredicate;
                    break;
                }
                default: {
                    throw new IllegalStateException("Only support INNER JOIN and FULL OUTER JOIN in current version");
                }
            }
            Assignments.Builder leftProjections = Assignments.builder();
            leftProjections.putAll((Map)node.getLeftChild().getOutputSymbols().stream().collect(ImmutableMap.toImmutableMap(key -> key, Symbol::toSymbolReference)));
            Assignments.Builder rightProjections = Assignments.builder();
            rightProjections.putAll((Map)node.getRightChild().getOutputSymbols().stream().collect(ImmutableMap.toImmutableMap(key -> key, Symbol::toSymbolReference)));
            ArrayList<JoinNode.EquiJoinClause> equiJoinClauses = new ArrayList<JoinNode.EquiJoinClause>();
            ImmutableList.Builder joinFilterBuilder = ImmutableList.builder();
            for (Expression conjunct : IrUtils.extractConjuncts(newJoinPredicate)) {
                if (this.joinEqualityExpressionOnOneColumn(conjunct, node)) {
                    ComparisonExpression equality = (ComparisonExpression)conjunct;
                    boolean alignedComparison = new HashSet<Symbol>(node.getLeftChild().getOutputSymbols()).containsAll(SymbolsExtractor.extractUnique(equality.getLeft()));
                    Expression leftExpression = alignedComparison ? equality.getLeft() : equality.getRight();
                    Expression rightExpression = alignedComparison ? equality.getRight() : equality.getLeft();
                    Symbol leftSymbol = this.symbolForExpression(leftExpression);
                    if (!node.getLeftChild().getOutputSymbols().contains(leftSymbol)) {
                        leftProjections.put(leftSymbol, leftExpression);
                    }
                    Symbol rightSymbol = this.symbolForExpression(rightExpression);
                    if (!node.getRightChild().getOutputSymbols().contains(rightSymbol)) {
                        rightProjections.put(rightSymbol, rightExpression);
                    }
                    equiJoinClauses.add(new JoinNode.EquiJoinClause(leftSymbol, rightSymbol));
                    continue;
                }
                if (node.getJoinType() == JoinNode.JoinType.FULL) {
                    throw new UnsupportedOperationException("Full outer join only support equiJoinClauses");
                }
                joinFilterBuilder.add((Object)conjunct);
            }
            boolean equiJoinClausesUnmodified = ImmutableSet.copyOf(equiJoinClauses).equals((Object)ImmutableSet.copyOf(node.getCriteria()));
            if (!equiJoinClausesUnmodified) {
                leftSource = new ProjectNode(this.queryId.genPlanNodeId(), node.getLeftChild(), leftProjections.build()).accept(this, new RewriteContext(leftPredicate));
                rightSource = new ProjectNode(this.queryId.genPlanNodeId(), node.getRightChild(), rightProjections.build()).accept(this, new RewriteContext(rightPredicate));
            } else {
                leftSource = node.getLeftChild().accept(this, new RewriteContext(leftPredicate));
                rightSource = node.getRightChild().accept(this, new RewriteContext(rightPredicate));
            }
            Cardinality leftCardinality = QueryCardinalityUtil.extractCardinality(leftSource);
            Cardinality rightCardinality = QueryCardinalityUtil.extractCardinality(rightSource);
            if (leftCardinality.isAtMostScalar() || rightCardinality.isAtMostScalar()) {
                equiJoinClauses.forEach(equiJoinClause -> joinFilterBuilder.add((Object)equiJoinClause.toExpression()));
                equiJoinClauses.clear();
            }
            if (BooleanLiteral.TRUE_LITERAL.equals((newJoinFilter = Optional.of(IrUtils.combineConjuncts((Collection<Expression>)(joinFilter = joinFilterBuilder.build())))).get())) {
                newJoinFilter = Optional.empty();
            }
            if (node.getJoinType() == JoinNode.JoinType.INNER && newJoinFilter.isPresent()) {
                postJoinPredicate = IrUtils.combineConjuncts(postJoinPredicate, newJoinFilter.get());
                newJoinFilter = Optional.empty();
            }
            boolean filtersEquivalent = newJoinFilter.isPresent() == node.getFilter().isPresent() && !newJoinFilter.isPresent();
            ProcessNode output = node;
            if (leftSource != node.getLeftChild() || rightSource != node.getRightChild() || !filtersEquivalent || !equiJoinClausesUnmodified) {
                leftSource = new ProjectNode(this.queryContext.getQueryId().genPlanNodeId(), leftSource, leftProjections.build());
                rightSource = new ProjectNode(this.queryContext.getQueryId().genPlanNodeId(), rightSource, rightProjections.build());
                output = new JoinNode(node.getPlanNodeId(), node.getJoinType(), leftSource, rightSource, equiJoinClauses, leftSource.getOutputSymbols(), rightSource.getOutputSymbols(), newJoinFilter, node.isSpillable());
            }
            JoinNode outputJoinNode = output;
            if (!output.isCrossJoin()) {
                this.appendSortNodeForMergeSortJoin(outputJoinNode);
            }
            if (!BooleanLiteral.TRUE_LITERAL.equals(postJoinPredicate)) {
                output = new FilterNode(this.queryContext.getQueryId().genPlanNodeId(), outputJoinNode, postJoinPredicate);
            }
            if (!node.getOutputSymbols().equals(((PlanNode)output).getOutputSymbols())) {
                output = new ProjectNode(this.queryContext.getQueryId().genPlanNodeId(), output, Assignments.identity(node.getOutputSymbols()));
            }
            return output;
        }

        private boolean joinEqualityExpressionOnOneColumn(Expression conjunct, JoinNode node) {
            if (!JoinUtils.joinEqualityExpression(conjunct, node.getLeftChild().getOutputSymbols(), node.getRightChild().getOutputSymbols())) {
                return false;
            }
            ComparisonExpression equality = (ComparisonExpression)conjunct;
            Expression left = equality.getLeft();
            Expression right = equality.getRight();
            return left instanceof SymbolReference && right instanceof SymbolReference;
        }

        private Symbol symbolForExpression(Expression expression) {
            if (expression instanceof SymbolReference) {
                return Symbol.from(expression);
            }
            return this.symbolAllocator.newSymbol(expression, this.analysis.getType(expression));
        }

        private void appendSortNodeForMergeSortJoin(JoinNode joinNode) {
            int size = joinNode.getCriteria().size();
            ArrayList<Symbol> leftOrderBy = new ArrayList<Symbol>(size);
            ArrayList<Symbol> rightOrderBy = new ArrayList<Symbol>(size);
            HashMap<Symbol, SortOrder> leftOrderings = new HashMap<Symbol, SortOrder>(size);
            HashMap<Symbol, SortOrder> rightOrderings = new HashMap<Symbol, SortOrder>(size);
            for (JoinNode.EquiJoinClause equiJoinClause : joinNode.getCriteria()) {
                leftOrderBy.add(equiJoinClause.getLeft());
                leftOrderings.put(equiJoinClause.getLeft(), SortOrder.ASC_NULLS_LAST);
                rightOrderBy.add(equiJoinClause.getRight());
                rightOrderings.put(equiJoinClause.getRight(), SortOrder.ASC_NULLS_LAST);
            }
            OrderingScheme leftOrderingScheme = new OrderingScheme(leftOrderBy, leftOrderings);
            OrderingScheme rightOrderingScheme = new OrderingScheme(rightOrderBy, rightOrderings);
            SortNode leftSortNode = new SortNode(this.queryId.genPlanNodeId(), joinNode.getLeftChild(), leftOrderingScheme, false, false);
            SortNode rightSortNode = new SortNode(this.queryId.genPlanNodeId(), joinNode.getRightChild(), rightOrderingScheme, false, false);
            joinNode.setLeftChild(leftSortNode);
            joinNode.setRightChild(rightSortNode);
        }

        @Override
        public PlanNode visitInsertTablet(InsertTabletNode node, RewriteContext context) {
            return node;
        }

        @Override
        public PlanNode visitRelationalInsertTablet(RelationalInsertTabletNode node, RewriteContext context) {
            return node;
        }

        private DataPartition fetchDataPartitionByDevices(String database, List<DeviceEntry> deviceEntries, Filter globalTimeFilter) {
            Pair<List<TTimePartitionSlot>, Pair<Boolean, Boolean>> res = AnalyzeVisitor.getTimePartitionSlotList(globalTimeFilter, this.queryContext);
            if (((List)res.left).isEmpty() && Boolean.FALSE.equals(((Pair)res.right).left)) {
                return new DataPartition(Collections.emptyMap(), CONFIG.getSeriesPartitionExecutorClass(), CONFIG.getSeriesPartitionSlotNum());
            }
            List<DataPartitionQueryParam> dataPartitionQueryParams = deviceEntries.stream().map(deviceEntry -> new DataPartitionQueryParam(deviceEntry.getDeviceID(), (List)res.left, ((Boolean)((Pair)res.right).left).booleanValue(), ((Boolean)((Pair)res.right).right).booleanValue())).collect(Collectors.toList());
            if (((Boolean)((Pair)res.right).left).booleanValue() || ((Boolean)((Pair)res.right).right).booleanValue()) {
                return this.metadata.getDataPartitionWithUnclosedTimeRange(database, dataPartitionQueryParams);
            }
            return this.metadata.getDataPartition(database, dataPartitionQueryParams);
        }

        private static /* synthetic */ void lambda$visitAggregation$1(AggregationNode node, List postAggregationConjuncts, EqualityInference equalityInference, Set groupingKeys, List pushdownConjuncts, Expression conjunct) {
            if (node.getGroupIdSymbol().isPresent() && SymbolsExtractor.extractUnique(conjunct).contains(node.getGroupIdSymbol().get())) {
                postAggregationConjuncts.add(conjunct);
            } else {
                Expression rewrittenConjunct = equalityInference.rewrite(conjunct, groupingKeys);
                if (rewrittenConjunct != null) {
                    pushdownConjuncts.add(rewrittenConjunct);
                } else {
                    postAggregationConjuncts.add(conjunct);
                }
            }
        }
    }

    private static class RewriteContext {
        Expression inheritedPredicate;

        RewriteContext(Expression inheritedPredicate) {
            this.inheritedPredicate = inheritedPredicate;
        }

        RewriteContext() {
            this.inheritedPredicate = BooleanLiteral.TRUE_LITERAL;
        }
    }

    private static class SplitExpression {
        List<Expression> metadataExpressions;
        List<Expression> expressionsCanPushDown;
        List<Expression> expressionsCannotPushDown;
        @Nullable
        String timeColumnName;

        public SplitExpression(List<Expression> metadataExpressions, List<Expression> expressionsCanPushDown, List<Expression> expressionsCannotPushDown, @Nullable String timeColumnName) {
            this.metadataExpressions = Objects.requireNonNull(metadataExpressions, "metadataExpressions is null");
            this.expressionsCanPushDown = Objects.requireNonNull(expressionsCanPushDown, "expressionsCanPushDown is null");
            this.expressionsCannotPushDown = Objects.requireNonNull(expressionsCannotPushDown, "expressionsCannotPushDown is null");
            this.timeColumnName = timeColumnName;
        }

        public List<Expression> getMetadataExpressions() {
            return this.metadataExpressions;
        }

        public List<Expression> getExpressionsCanPushDown() {
            return this.expressionsCanPushDown;
        }

        public List<Expression> getExpressionsCannotPushDown() {
            return this.expressionsCannotPushDown;
        }

        @Nullable
        public String getTimeColumnName() {
            return this.timeColumnName;
        }
    }
}

