/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.planner.EqualityInference;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolsExtractor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.DeterminismEvaluator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.IrUtils;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;

public class JoinUtils {
    public static final String FULL_JOIN_ONLY_SUPPORT_EQUI_JOIN = "Full outer join only support equiJoinClauses";

    private JoinUtils() {
    }

    static Expression extractJoinPredicate(JoinNode joinNode) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JoinNode.EquiJoinClause equiJoinClause : joinNode.getCriteria()) {
            builder.add((Object)equiJoinClause.toExpression());
        }
        joinNode.getFilter().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return IrUtils.combineConjuncts((Collection<Expression>)builder.build());
    }

    static boolean joinEqualityExpression(Expression expression, Collection<Symbol> leftSymbols, Collection<Symbol> rightSymbols) {
        return JoinUtils.joinComparisonExpression(expression, leftSymbols, rightSymbols, (Set<ComparisonExpression.Operator>)ImmutableSet.of((Object)((Object)ComparisonExpression.Operator.EQUAL)));
    }

    private static boolean joinComparisonExpression(Expression expression, Collection<Symbol> leftSymbols, Collection<Symbol> rightSymbols, Set<ComparisonExpression.Operator> operators) {
        ComparisonExpression comparison;
        if (expression instanceof ComparisonExpression && DeterminismEvaluator.isDeterministic(expression) && operators.contains((Object)(comparison = (ComparisonExpression)expression).getOperator())) {
            Set<Symbol> symbols1 = SymbolsExtractor.extractUnique(comparison.getLeft());
            Set<Symbol> symbols2 = SymbolsExtractor.extractUnique(comparison.getRight());
            if (symbols1.isEmpty() || symbols2.isEmpty()) {
                return false;
            }
            return leftSymbols.containsAll(symbols1) && rightSymbols.containsAll(symbols2) || rightSymbols.containsAll(symbols1) && leftSymbols.containsAll(symbols2);
        }
        return false;
    }

    static JoinNode tryNormalizeToOuterToInnerJoin(JoinNode node, Expression inheritedPredicate) {
        Preconditions.checkArgument((boolean)EnumSet.of(JoinNode.JoinType.INNER, JoinNode.JoinType.RIGHT, JoinNode.JoinType.LEFT, JoinNode.JoinType.FULL).contains((Object)node.getJoinType()), (String)"Unsupported join type: %s", (Object)((Object)node.getJoinType()));
        if (node.getJoinType() == JoinNode.JoinType.INNER) {
            return node;
        }
        if (node.getJoinType() == JoinNode.JoinType.FULL) {
            boolean canConvertToLeftJoin = JoinUtils.canConvertOuterToInner(node.getLeftChild().getOutputSymbols(), inheritedPredicate);
            boolean canConvertToRightJoin = JoinUtils.canConvertOuterToInner(node.getRightChild().getOutputSymbols(), inheritedPredicate);
            if (!canConvertToLeftJoin && !canConvertToRightJoin) {
                return node;
            }
            if (canConvertToLeftJoin && canConvertToRightJoin) {
                return new JoinNode(node.getPlanNodeId(), JoinNode.JoinType.INNER, node.getLeftChild(), node.getRightChild(), node.getCriteria(), node.getLeftOutputSymbols(), node.getRightOutputSymbols(), node.getFilter(), node.isSpillable());
            }
            return new JoinNode(node.getPlanNodeId(), canConvertToLeftJoin ? JoinNode.JoinType.LEFT : JoinNode.JoinType.RIGHT, node.getLeftChild(), node.getRightChild(), node.getCriteria(), node.getLeftOutputSymbols(), node.getRightOutputSymbols(), node.getFilter(), node.isSpillable());
        }
        if (node.getJoinType() == JoinNode.JoinType.LEFT && !JoinUtils.canConvertOuterToInner(node.getRightChild().getOutputSymbols(), inheritedPredicate) || node.getJoinType() == JoinNode.JoinType.RIGHT && !JoinUtils.canConvertOuterToInner(node.getLeftChild().getOutputSymbols(), inheritedPredicate)) {
            return node;
        }
        return new JoinNode(node.getPlanNodeId(), JoinNode.JoinType.INNER, node.getLeftChild(), node.getRightChild(), node.getCriteria(), node.getLeftOutputSymbols(), node.getRightOutputSymbols(), node.getFilter(), node.isSpillable());
    }

    static boolean canConvertOuterToInner(List<Symbol> innerSymbolsForOuterJoin, Expression inheritedPredicate) {
        ImmutableSet innerSymbols = ImmutableSet.copyOf(innerSymbolsForOuterJoin);
        for (Expression conjunct : IrUtils.extractConjuncts(inheritedPredicate)) {
            if (!DeterminismEvaluator.isDeterministic(conjunct)) continue;
            return true;
        }
        return false;
    }

    static InnerJoinPushDownResult processInnerJoin(Metadata metadata, Expression inheritedPredicate, Expression leftEffectivePredicate, Expression rightEffectivePredicate, Expression joinPredicate, Collection<Symbol> leftSymbols, Collection<Symbol> rightSymbols) {
        Preconditions.checkArgument((boolean)leftSymbols.containsAll(SymbolsExtractor.extractUnique(leftEffectivePredicate)), (Object)"leftEffectivePredicate must only contain symbols from leftSymbols");
        Preconditions.checkArgument((boolean)rightSymbols.containsAll(SymbolsExtractor.extractUnique(rightEffectivePredicate)), (Object)"rightEffectivePredicate must only contain symbols from rightSymbols");
        ImmutableList.Builder leftPushDownConjuncts = ImmutableList.builder();
        ImmutableList.Builder rightPushDownConjuncts = ImmutableList.builder();
        ImmutableList.Builder joinConjuncts = ImmutableList.builder();
        IrUtils.extractConjuncts(inheritedPredicate).stream().filter(deterministic -> !DeterminismEvaluator.isDeterministic(deterministic)).forEach(arg_0 -> ((ImmutableList.Builder)joinConjuncts).add(arg_0));
        inheritedPredicate = IrUtils.filterDeterministicConjuncts(inheritedPredicate);
        IrUtils.extractConjuncts(joinPredicate).stream().filter(expression -> !DeterminismEvaluator.isDeterministic(expression)).forEach(arg_0 -> ((ImmutableList.Builder)joinConjuncts).add(arg_0));
        joinPredicate = IrUtils.filterDeterministicConjuncts(joinPredicate);
        leftEffectivePredicate = IrUtils.filterDeterministicConjuncts(leftEffectivePredicate);
        rightEffectivePredicate = IrUtils.filterDeterministicConjuncts(rightEffectivePredicate);
        ImmutableSet leftScope = ImmutableSet.copyOf(leftSymbols);
        ImmutableSet rightScope = ImmutableSet.copyOf(rightSymbols);
        EqualityInference allInference = new EqualityInference(metadata, inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate);
        EqualityInference allInferenceWithoutLeftInferred = new EqualityInference(metadata, inheritedPredicate, rightEffectivePredicate, joinPredicate);
        EqualityInference allInferenceWithoutRightInferred = new EqualityInference(metadata, inheritedPredicate, leftEffectivePredicate, joinPredicate);
        leftPushDownConjuncts.addAll(allInferenceWithoutLeftInferred.generateEqualitiesPartitionedBy((Set<Symbol>)leftScope).getScopeEqualities());
        rightPushDownConjuncts.addAll(allInferenceWithoutRightInferred.generateEqualitiesPartitionedBy((Set<Symbol>)rightScope).getScopeEqualities());
        joinConjuncts.addAll(allInference.generateEqualitiesPartitionedBy((Set<Symbol>)leftScope).getScopeStraddlingEqualities());
        EqualityInference.nonInferrableConjuncts(metadata, inheritedPredicate).forEach(conjunct -> {
            Expression rightRewrittenConjunct;
            Expression leftRewrittenConjunct = allInference.rewrite((Expression)conjunct, (Set<Symbol>)leftScope);
            if (leftRewrittenConjunct != null) {
                leftPushDownConjuncts.add((Object)leftRewrittenConjunct);
            }
            if ((rightRewrittenConjunct = allInference.rewrite((Expression)conjunct, (Set<Symbol>)rightScope)) != null) {
                rightPushDownConjuncts.add((Object)rightRewrittenConjunct);
            }
            if (leftRewrittenConjunct == null && rightRewrittenConjunct == null) {
                joinConjuncts.add(conjunct);
            }
        });
        EqualityInference.nonInferrableConjuncts(metadata, rightEffectivePredicate).map(conjunct -> allInference.rewrite((Expression)conjunct, (Set<Symbol>)leftScope)).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableList.Builder)leftPushDownConjuncts).add(arg_0));
        EqualityInference.nonInferrableConjuncts(metadata, leftEffectivePredicate).map(conjunct -> allInference.rewrite((Expression)conjunct, (Set<Symbol>)rightScope)).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableList.Builder)rightPushDownConjuncts).add(arg_0));
        EqualityInference.nonInferrableConjuncts(metadata, joinPredicate).forEach(conjunct -> {
            Expression rightRewritten;
            Expression leftRewritten = allInference.rewrite((Expression)conjunct, (Set<Symbol>)leftScope);
            if (leftRewritten != null) {
                leftPushDownConjuncts.add((Object)leftRewritten);
            }
            if ((rightRewritten = allInference.rewrite((Expression)conjunct, (Set<Symbol>)rightScope)) != null) {
                rightPushDownConjuncts.add((Object)rightRewritten);
            }
            if (leftRewritten == null && rightRewritten == null) {
                joinConjuncts.add(conjunct);
            }
        });
        return new InnerJoinPushDownResult(IrUtils.combineConjuncts((Collection<Expression>)leftPushDownConjuncts.build()), IrUtils.combineConjuncts((Collection<Expression>)rightPushDownConjuncts.build()), IrUtils.combineConjuncts((Collection<Expression>)joinConjuncts.build()), BooleanLiteral.TRUE_LITERAL);
    }

    static class InnerJoinPushDownResult {
        private final Expression leftPredicate;
        private final Expression rightPredicate;
        private final Expression joinPredicate;
        private final Expression postJoinPredicate;

        public InnerJoinPushDownResult(Expression leftPredicate, Expression rightPredicate, Expression joinPredicate, Expression postJoinPredicate) {
            this.leftPredicate = leftPredicate;
            this.rightPredicate = rightPredicate;
            this.joinPredicate = joinPredicate;
            this.postJoinPredicate = postJoinPredicate;
        }

        public Expression getLeftPredicate() {
            return this.leftPredicate;
        }

        public Expression getRightPredicate() {
            return this.rightPredicate;
        }

        public Expression getJoinPredicate() {
            return this.joinPredicate;
        }

        public Expression getPostJoinPredicate() {
            return this.postJoinPredicate;
        }
    }
}

