/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ResolvedFunction;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class AggregationNode
extends SingleChildProcessNode {
    private final Map<Symbol, Aggregation> aggregations;
    private final GroupingSetDescriptor groupingSets;
    private List<Symbol> preGroupedSymbols;
    private final Step step;
    private final Optional<Symbol> hashSymbol;
    private final Optional<Symbol> groupIdSymbol;
    private final List<Symbol> outputs;

    public static AggregationNode singleAggregation(PlanNodeId id, PlanNode source, Map<Symbol, Aggregation> aggregations, GroupingSetDescriptor groupingSets) {
        return new AggregationNode(id, source, aggregations, groupingSets, (List<Symbol>)ImmutableList.of(), Step.SINGLE, Optional.empty(), Optional.empty());
    }

    public AggregationNode(PlanNodeId id, PlanNode source, Map<Symbol, Aggregation> aggregations, GroupingSetDescriptor groupingSets, List<Symbol> preGroupedSymbols, Step step, Optional<Symbol> hashSymbol, Optional<Symbol> groupIdSymbol) {
        super(id);
        this.child = source;
        this.aggregations = ImmutableMap.copyOf(Objects.requireNonNull(aggregations, "aggregations is null"));
        aggregations.values().forEach(aggregation -> aggregation.verifyArguments(step));
        Objects.requireNonNull(groupingSets, "groupingSets is null");
        groupIdSymbol.ifPresent(symbol -> Preconditions.checkArgument((boolean)groupingSets.getGroupingKeys().contains(symbol), (Object)"Grouping columns does not contain groupId column"));
        this.groupingSets = groupingSets;
        this.groupIdSymbol = Objects.requireNonNull(groupIdSymbol);
        boolean noOrderBy = aggregations.values().stream().map(Aggregation::getOrderingScheme).noneMatch(Optional::isPresent);
        Preconditions.checkArgument((noOrderBy || step == Step.SINGLE ? 1 : 0) != 0, (Object)"ORDER BY does not support distributed aggregation");
        this.step = step;
        this.hashSymbol = hashSymbol;
        Objects.requireNonNull(preGroupedSymbols, "preGroupedSymbols is null");
        Preconditions.checkArgument((preGroupedSymbols.isEmpty() || groupingSets.getGroupingKeys().containsAll(preGroupedSymbols) ? 1 : 0) != 0, (Object)"Pre-grouped symbols must be a subset of the grouping keys");
        this.preGroupedSymbols = ImmutableList.copyOf(preGroupedSymbols);
        ImmutableList.Builder outputs = ImmutableList.builder();
        outputs.addAll(groupingSets.getGroupingKeys());
        hashSymbol.ifPresent(arg_0 -> ((ImmutableList.Builder)outputs).add(arg_0));
        outputs.addAll(aggregations.keySet());
        this.outputs = outputs.build();
    }

    public List<Symbol> getGroupingKeys() {
        return this.groupingSets.getGroupingKeys();
    }

    public GroupingSetDescriptor getGroupingSets() {
        return this.groupingSets;
    }

    public void setPreGroupedSymbols(List<Symbol> preGroupedSymbols) {
        this.preGroupedSymbols = preGroupedSymbols;
    }

    public boolean hasSingleGlobalAggregation() {
        return this.hasEmptyGroupingSet() && this.getGroupingSetCount() == 1;
    }

    public boolean hasDefaultOutput() {
        return this.hasEmptyGroupingSet() && (this.step.isOutputPartial() || this.step == Step.SINGLE);
    }

    public boolean hasEmptyGroupingSet() {
        return !this.groupingSets.getGlobalGroupingSets().isEmpty();
    }

    public boolean hasNonEmptyGroupingSet() {
        return this.groupingSets.getGroupingSetCount() > this.groupingSets.getGlobalGroupingSets().size();
    }

    @Override
    public PlanNode clone() {
        return new AggregationNode(this.id, null, this.aggregations, this.groupingSets, this.preGroupedSymbols, this.step, this.hashSymbol, this.groupIdSymbol);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    public Map<Symbol, Aggregation> getAggregations() {
        return this.aggregations;
    }

    public List<Symbol> getPreGroupedSymbols() {
        return this.preGroupedSymbols;
    }

    public int getGroupingSetCount() {
        return this.groupingSets.getGroupingSetCount();
    }

    public Set<Integer> getGlobalGroupingSets() {
        return this.groupingSets.getGlobalGroupingSets();
    }

    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    public Optional<Symbol> getGroupIdSymbol() {
        return this.groupIdSymbol;
    }

    public Step getStep() {
        return this.step;
    }

    public boolean hasOrderings() {
        return this.aggregations.values().stream().map(Aggregation::getOrderingScheme).anyMatch(Optional::isPresent);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAggregation(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AggregationNode that = (AggregationNode)o;
        return Objects.equals(this.aggregations, that.aggregations) && Objects.equals(this.groupingSets, that.groupingSets) && Objects.equals((Object)this.step, (Object)that.step) && Objects.equals(this.hashSymbol, that.hashSymbol) && Objects.equals(this.groupIdSymbol, that.groupIdSymbol);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.aggregations, this.groupingSets, this.step, this.hashSymbol, this.groupIdSymbol});
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_AGGREGATION_NODE.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.aggregations.size(), (ByteBuffer)byteBuffer);
        this.aggregations.forEach((k, v) -> {
            Symbol.serialize(k, byteBuffer);
            v.serialize(byteBuffer);
        });
        this.groupingSets.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.preGroupedSymbols.size(), (ByteBuffer)byteBuffer);
        for (Symbol preGroupedSymbol : this.preGroupedSymbols) {
            Symbol.serialize(preGroupedSymbol, byteBuffer);
        }
        this.step.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.hashSymbol.isPresent(), (ByteBuffer)byteBuffer);
        if (this.hashSymbol.isPresent()) {
            Symbol.serialize(this.hashSymbol.get(), byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)this.groupIdSymbol.isPresent(), (ByteBuffer)byteBuffer);
        if (this.groupIdSymbol.isPresent()) {
            Symbol.serialize(this.groupIdSymbol.get(), byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_AGGREGATION_NODE.serialize(stream);
        ReadWriteIOUtils.write((int)this.aggregations.size(), (OutputStream)stream);
        for (Map.Entry<Symbol, Aggregation> aggregation : this.aggregations.entrySet()) {
            Symbol.serialize(aggregation.getKey(), stream);
            aggregation.getValue().serialize(stream);
        }
        this.groupingSets.serialize(stream);
        ReadWriteIOUtils.write((int)this.preGroupedSymbols.size(), (OutputStream)stream);
        for (Symbol preGroupedSymbol : this.preGroupedSymbols) {
            Symbol.serialize(preGroupedSymbol, stream);
        }
        this.step.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.hashSymbol.isPresent(), (OutputStream)stream);
        if (this.hashSymbol.isPresent()) {
            Symbol.serialize(this.hashSymbol.get(), stream);
        }
        ReadWriteIOUtils.write((Boolean)this.groupIdSymbol.isPresent(), (OutputStream)stream);
        if (this.groupIdSymbol.isPresent()) {
            Symbol.serialize(this.groupIdSymbol.get(), stream);
        }
    }

    public static AggregationNode deserialize(ByteBuffer byteBuffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        LinkedHashMap<Symbol, Aggregation> aggregations = new LinkedHashMap<Symbol, Aggregation>(size);
        while (size-- > 0) {
            aggregations.put(Symbol.deserialize(byteBuffer), Aggregation.deserialize(byteBuffer));
        }
        GroupingSetDescriptor groupingSetDescriptor = GroupingSetDescriptor.deserialize(byteBuffer);
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Symbol> preGroupedSymbols = new ArrayList<Symbol>(size);
        while (size-- > 0) {
            preGroupedSymbols.add(Symbol.deserialize(byteBuffer));
        }
        Step step = Step.deserialize(byteBuffer);
        Optional<Symbol> hashSymbol = Optional.empty();
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            hashSymbol = Optional.of(Symbol.deserialize(byteBuffer));
        }
        Optional<Symbol> groupIdSymbol = Optional.empty();
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            groupIdSymbol = Optional.of(Symbol.deserialize(byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new AggregationNode(planNodeId, null, aggregations, groupingSetDescriptor, preGroupedSymbols, step, hashSymbol, groupIdSymbol);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return AggregationNode.builderFrom(this).setSource((PlanNode)Iterables.getOnlyElement(newChildren)).build();
    }

    public boolean producesDistinctRows() {
        return this.aggregations.isEmpty() && !this.groupingSets.getGroupingKeys().isEmpty() && this.outputs.size() == this.groupingSets.getGroupingKeys().size() && this.outputs.containsAll(new HashSet<Symbol>(this.groupingSets.getGroupingKeys()));
    }

    public boolean isDecomposable(SessionInfo session, Metadata metadata) {
        boolean hasOrderBy = this.getAggregations().values().stream().map(Aggregation::getOrderingScheme).anyMatch(Optional::isPresent);
        boolean hasDistinct = this.getAggregations().values().stream().anyMatch(Aggregation::isDistinct);
        return !hasOrderBy && !hasDistinct;
    }

    public boolean hasSingleNodeExecutionPreference(SessionInfo session, Metadata metadata) {
        return this.hasEmptyGroupingSet() && !this.hasNonEmptyGroupingSet() || this.hasDefaultOutput() && !this.isDecomposable(session, metadata);
    }

    public boolean isStreamable() {
        return !this.preGroupedSymbols.isEmpty() && this.groupingSets.getGroupingSetCount() == 1 && this.groupingSets.getGlobalGroupingSets().isEmpty();
    }

    public static GroupingSetDescriptor globalAggregation() {
        return AggregationNode.singleGroupingSet((List<Symbol>)ImmutableList.of());
    }

    public static GroupingSetDescriptor singleGroupingSet(List<Symbol> groupingKeys) {
        ImmutableSet globalGroupingSets = groupingKeys.isEmpty() ? ImmutableSet.of((Object)0) : ImmutableSet.of();
        return new GroupingSetDescriptor(groupingKeys, 1, (Set<Integer>)globalGroupingSets);
    }

    public static GroupingSetDescriptor groupingSets(List<Symbol> groupingKeys, int groupingSetCount, Set<Integer> globalGroupingSets) {
        return new GroupingSetDescriptor(groupingKeys, groupingSetCount, globalGroupingSets);
    }

    public static Builder builderFrom(AggregationNode node) {
        return new Builder(node);
    }

    public static enum Step {
        PARTIAL(true, true),
        FINAL(false, false),
        INTERMEDIATE(false, true),
        SINGLE(true, false);

        private final boolean inputRaw;
        private final boolean outputPartial;

        private Step(boolean inputRaw, boolean outputPartial) {
            this.inputRaw = inputRaw;
            this.outputPartial = outputPartial;
        }

        public boolean isInputRaw() {
            return this.inputRaw;
        }

        public boolean isOutputPartial() {
            return this.outputPartial;
        }

        public static Step partialOutput(Step step) {
            if (step.isInputRaw()) {
                return PARTIAL;
            }
            return INTERMEDIATE;
        }

        public static Step partialInput(Step step) {
            if (step.isOutputPartial()) {
                return INTERMEDIATE;
            }
            return FINAL;
        }

        public void serialize(ByteBuffer byteBuffer) {
            ReadWriteIOUtils.write((int)this.ordinal(), (ByteBuffer)byteBuffer);
        }

        public void serialize(DataOutputStream stream) throws IOException {
            ReadWriteIOUtils.write((int)this.ordinal(), (OutputStream)stream);
        }

        public static Step deserialize(ByteBuffer byteBuffer) {
            return Step.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        }
    }

    public static class GroupingSetDescriptor {
        private final List<Symbol> groupingKeys;
        private final int groupingSetCount;
        private final Set<Integer> globalGroupingSets;

        public GroupingSetDescriptor(List<Symbol> groupingKeys, int groupingSetCount, Set<Integer> globalGroupingSets) {
            Objects.requireNonNull(globalGroupingSets, "globalGroupingSets is null");
            Preconditions.checkArgument((groupingSetCount > 0 ? 1 : 0) != 0, (Object)"grouping set count must be larger than 0");
            Preconditions.checkArgument((globalGroupingSets.size() <= groupingSetCount ? 1 : 0) != 0, (Object)"list of empty global grouping sets must be no larger than grouping set count");
            Objects.requireNonNull(groupingKeys, "groupingKeys is null");
            if (groupingKeys.isEmpty()) {
                Preconditions.checkArgument((!globalGroupingSets.isEmpty() ? 1 : 0) != 0, (Object)"no grouping keys implies at least one global grouping set, but none provided");
            }
            this.groupingKeys = ImmutableList.copyOf(groupingKeys);
            this.groupingSetCount = groupingSetCount;
            this.globalGroupingSets = ImmutableSet.copyOf(globalGroupingSets);
        }

        public List<Symbol> getGroupingKeys() {
            return this.groupingKeys;
        }

        public int getGroupingSetCount() {
            return this.groupingSetCount;
        }

        public Set<Integer> getGlobalGroupingSets() {
            return this.globalGroupingSets;
        }

        public void serialize(ByteBuffer byteBuffer) {
            ReadWriteIOUtils.write((int)this.groupingKeys.size(), (ByteBuffer)byteBuffer);
            for (Symbol symbol : this.groupingKeys) {
                Symbol.serialize(symbol, byteBuffer);
            }
            ReadWriteIOUtils.write((int)this.groupingSetCount, (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((int)this.globalGroupingSets.size(), (ByteBuffer)byteBuffer);
            Iterator<Comparable<Symbol>> iterator = this.globalGroupingSets.iterator();
            while (iterator.hasNext()) {
                int globalGroupingSet = (Integer)iterator.next();
                ReadWriteIOUtils.write((int)globalGroupingSet, (ByteBuffer)byteBuffer);
            }
        }

        public void serialize(DataOutputStream stream) throws IOException {
            ReadWriteIOUtils.write((int)this.groupingKeys.size(), (OutputStream)stream);
            for (Symbol symbol : this.groupingKeys) {
                Symbol.serialize(symbol, stream);
            }
            ReadWriteIOUtils.write((int)this.groupingSetCount, (OutputStream)stream);
            ReadWriteIOUtils.write((int)this.globalGroupingSets.size(), (OutputStream)stream);
            Iterator<Comparable<Symbol>> iterator = this.globalGroupingSets.iterator();
            while (iterator.hasNext()) {
                int globalGroupingSet = (Integer)iterator.next();
                ReadWriteIOUtils.write((int)globalGroupingSet, (OutputStream)stream);
            }
        }

        public static GroupingSetDescriptor deserialize(ByteBuffer byteBuffer) {
            int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            ArrayList<Symbol> groupingKeys = new ArrayList<Symbol>(size);
            while (size-- > 0) {
                groupingKeys.add(Symbol.deserialize(byteBuffer));
            }
            int groupingSetCount = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            HashSet<Integer> globalGroupingSets = new HashSet<Integer>(size);
            while (size-- > 0) {
                globalGroupingSets.add(ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
            }
            return new GroupingSetDescriptor(groupingKeys, groupingSetCount, globalGroupingSets);
        }
    }

    public static class Aggregation {
        private final ResolvedFunction resolvedFunction;
        private final List<Expression> arguments;
        private final boolean distinct;
        private final Optional<Symbol> filter;
        private final Optional<OrderingScheme> orderingScheme;
        private final Optional<Symbol> mask;

        public Aggregation(ResolvedFunction resolvedFunction, List<Expression> arguments, boolean distinct, Optional<Symbol> filter, Optional<OrderingScheme> orderingScheme, Optional<Symbol> mask) {
            this.resolvedFunction = Objects.requireNonNull(resolvedFunction, "resolvedFunction is null");
            this.arguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(arguments, "arguments is null"));
            for (Expression argument : arguments) {
                Preconditions.checkArgument((boolean)(argument instanceof SymbolReference), (String)"argument must be symbol: %s", (Object)argument.getClass().getSimpleName());
            }
            this.distinct = distinct;
            this.filter = Objects.requireNonNull(filter, "filter is null");
            this.orderingScheme = Objects.requireNonNull(orderingScheme, "orderingScheme is null");
            this.mask = Objects.requireNonNull(mask, "mask is null");
        }

        public ResolvedFunction getResolvedFunction() {
            return this.resolvedFunction;
        }

        public List<Expression> getArguments() {
            return this.arguments;
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        public Optional<Symbol> getFilter() {
            return this.filter;
        }

        public Optional<OrderingScheme> getOrderingScheme() {
            return this.orderingScheme;
        }

        public Optional<Symbol> getMask() {
            return this.mask;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Aggregation that = (Aggregation)o;
            return this.distinct == that.distinct && Objects.equals(this.resolvedFunction, that.resolvedFunction) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.filter, that.filter) && Objects.equals(this.orderingScheme, that.orderingScheme) && Objects.equals(this.mask, that.mask);
        }

        public int hashCode() {
            return Objects.hash(this.resolvedFunction, this.arguments, this.distinct, this.filter, this.orderingScheme, this.mask);
        }

        void verifyArguments(Step step) {
            int expectedArgumentCount = step == Step.SINGLE || step == Step.PARTIAL ? this.resolvedFunction.getSignature().getArgumentTypes().size() : 1 + (int)this.resolvedFunction.getSignature().getArgumentTypes().stream().filter(FunctionType.class::isInstance).count();
            Preconditions.checkArgument((expectedArgumentCount == this.arguments.size() ? 1 : 0) != 0, (String)"%s aggregation function %s has %s arguments, but %s arguments were provided to function call", (Object)((Object)step), (Object)this.resolvedFunction.getSignature(), (Object)expectedArgumentCount, (Object)this.arguments.size());
        }

        public void serialize(ByteBuffer byteBuffer) {
            this.resolvedFunction.serialize(byteBuffer);
            ReadWriteIOUtils.write((int)this.arguments.size(), (ByteBuffer)byteBuffer);
            for (Expression argument : this.arguments) {
                Expression.serialize(argument, byteBuffer);
            }
            ReadWriteIOUtils.write((Boolean)this.distinct, (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((Boolean)this.filter.isPresent(), (ByteBuffer)byteBuffer);
            this.filter.ifPresent(symbol -> Symbol.serialize(symbol, byteBuffer));
            ReadWriteIOUtils.write((Boolean)this.orderingScheme.isPresent(), (ByteBuffer)byteBuffer);
            this.orderingScheme.ifPresent(scheme -> scheme.serialize(byteBuffer));
            ReadWriteIOUtils.write((Boolean)this.mask.isPresent(), (ByteBuffer)byteBuffer);
            this.mask.ifPresent(symbol -> Symbol.serialize(symbol, byteBuffer));
        }

        public void serialize(DataOutputStream stream) throws IOException {
            this.resolvedFunction.serialize(stream);
            ReadWriteIOUtils.write((int)this.arguments.size(), (OutputStream)stream);
            for (Expression argument : this.arguments) {
                Expression.serialize(argument, stream);
            }
            ReadWriteIOUtils.write((Boolean)this.distinct, (OutputStream)stream);
            ReadWriteIOUtils.write((Boolean)this.filter.isPresent(), (OutputStream)stream);
            if (this.filter.isPresent()) {
                Symbol.serialize(this.filter.get(), stream);
            }
            ReadWriteIOUtils.write((Boolean)this.orderingScheme.isPresent(), (OutputStream)stream);
            if (this.orderingScheme.isPresent()) {
                this.orderingScheme.get().serialize(stream);
            }
            ReadWriteIOUtils.write((Boolean)this.mask.isPresent(), (OutputStream)stream);
            if (this.mask.isPresent()) {
                Symbol.serialize(this.mask.get(), stream);
            }
        }

        public static Aggregation deserialize(ByteBuffer byteBuffer) {
            ResolvedFunction function = ResolvedFunction.deserialize(byteBuffer);
            int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            ArrayList<Expression> arguments = new ArrayList<Expression>(size);
            while (size-- > 0) {
                arguments.add(Expression.deserialize(byteBuffer));
            }
            boolean distinct = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
            Optional<Symbol> filter = Optional.empty();
            if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
                filter = Optional.of(Symbol.deserialize(byteBuffer));
            }
            Optional<OrderingScheme> orderingScheme = Optional.empty();
            if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
                orderingScheme = Optional.of(OrderingScheme.deserialize(byteBuffer));
            }
            Optional<Symbol> mask = Optional.empty();
            if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
                mask = Optional.of(Symbol.deserialize(byteBuffer));
            }
            return new Aggregation(function, arguments, distinct, filter, orderingScheme, mask);
        }
    }

    public static class Builder {
        private PlanNodeId id;
        private PlanNode source;
        private Map<Symbol, Aggregation> aggregations;
        private GroupingSetDescriptor groupingSets;
        private List<Symbol> preGroupedSymbols;
        private Step step;
        private Optional<Symbol> hashSymbol;
        private Optional<Symbol> groupIdSymbol;

        public Builder(AggregationNode node) {
            Objects.requireNonNull(node, "node is null");
            this.id = node.getPlanNodeId();
            this.source = node.getChild();
            this.aggregations = node.getAggregations();
            this.groupingSets = node.getGroupingSets();
            this.preGroupedSymbols = node.getPreGroupedSymbols();
            this.step = node.getStep();
            this.hashSymbol = node.getHashSymbol();
            this.groupIdSymbol = node.getGroupIdSymbol();
        }

        public Builder setId(PlanNodeId id) {
            this.id = Objects.requireNonNull(id, "id is null");
            return this;
        }

        public Builder setSource(PlanNode source) {
            this.source = Objects.requireNonNull(source, "source is null");
            return this;
        }

        public Builder setAggregations(Map<Symbol, Aggregation> aggregations) {
            this.aggregations = Objects.requireNonNull(aggregations, "aggregations is null");
            return this;
        }

        public Builder setGroupingSets(GroupingSetDescriptor groupingSets) {
            this.groupingSets = Objects.requireNonNull(groupingSets, "groupingSets is null");
            return this;
        }

        public Builder setPreGroupedSymbols(List<Symbol> preGroupedSymbols) {
            this.preGroupedSymbols = Objects.requireNonNull(preGroupedSymbols, "preGroupedSymbols is null");
            return this;
        }

        public Builder setStep(Step step) {
            this.step = Objects.requireNonNull(step, "step is null");
            return this;
        }

        public Builder setHashSymbol(Optional<Symbol> hashSymbol) {
            this.hashSymbol = Objects.requireNonNull(hashSymbol, "hashSymbol is null");
            return this;
        }

        public Builder setGroupIdSymbol(Optional<Symbol> groupIdSymbol) {
            this.groupIdSymbol = Objects.requireNonNull(groupIdSymbol, "groupIdSymbol is null");
            return this;
        }

        public AggregationNode build() {
            return new AggregationNode(this.id, this.source, this.aggregations, this.groupingSets, this.preGroupedSymbols, this.step, this.hashSymbol, this.groupIdSymbol);
        }
    }
}

