/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.load.LoadTsFileNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeEnrichedInsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalDeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Field;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.RelationType;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Scope;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableMetadataImpl;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TreeDeviceViewSchema;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Assignments;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlanBuilder;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlannerContext;
import org.apache.iotdb.db.queryengine.plan.relational.planner.QueryPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.planner.RelationPlan;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SubqueryPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolAllocator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolsExtractor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.TranslationMap;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.IrUtils;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.DeviceTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FilterNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.InformationSchemaTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TreeDeviceViewScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AliasedRelation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CoalesceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Delete;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Except;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InsertRow;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InsertRows;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InsertTablet;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Intersect;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Join;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.JoinUsing;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LoadTsFile;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PipeEnriched;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Query;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuerySpecification;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SubqueryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Table;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableSubquery;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Union;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Values;
import org.apache.iotdb.db.queryengine.plan.relational.type.InternalTypeManager;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.tsfile.read.common.type.Type;

public class RelationPlanner
extends AstVisitor<RelationPlan, Void> {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final MPPQueryContext queryContext;
    private final QueryId idAllocator;
    private final Optional<TranslationMap> outerContext;
    private final SessionInfo sessionInfo;
    private final SubqueryPlanner subqueryPlanner;
    private final Map<NodeRef<Node>, RelationPlan> recursiveSubqueries;

    public RelationPlanner(Analysis analysis, SymbolAllocator symbolAllocator, MPPQueryContext queryContext, Optional<TranslationMap> outerContext, SessionInfo sessionInfo, Map<NodeRef<Node>, RelationPlan> recursiveSubqueries) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(queryContext, "queryContext is null");
        Objects.requireNonNull(outerContext, "outerContext is null");
        Objects.requireNonNull(sessionInfo, "session is null");
        Objects.requireNonNull(recursiveSubqueries, "recursiveSubqueries is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.queryContext = queryContext;
        this.idAllocator = queryContext.getQueryId();
        this.outerContext = outerContext;
        this.sessionInfo = sessionInfo;
        this.subqueryPlanner = new SubqueryPlanner(analysis, symbolAllocator, queryContext, outerContext, sessionInfo, recursiveSubqueries);
        this.recursiveSubqueries = recursiveSubqueries;
    }

    @Override
    protected RelationPlan visitQuery(Query node, Void context) {
        return new QueryPlanner(this.analysis, this.symbolAllocator, this.queryContext, this.outerContext, this.sessionInfo, this.recursiveSubqueries).plan(node);
    }

    @Override
    protected RelationPlan visitTable(Table table, Void context) {
        RelationPlan expansion = this.recursiveSubqueries.get(NodeRef.of(table));
        if (expansion != null) {
            return new RelationPlan(expansion.getRoot(), expansion.getScope(), expansion.getFieldMappings(), this.outerContext);
        }
        Scope scope = this.analysis.getScope(table);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        ImmutableMap.Builder symbolToColumnSchema = ImmutableMap.builder();
        Collection<Field> fields = scope.getRelationType().getAllFields();
        QualifiedName qualifiedName = this.analysis.getRelationName(table);
        if (!qualifiedName.getPrefix().isPresent()) {
            throw new IllegalStateException("Table " + table.getName() + " has no prefix!");
        }
        QualifiedObjectName qualifiedObjectName = new QualifiedObjectName(qualifiedName.getPrefix().map(QualifiedName::toString).orElse(null), qualifiedName.getSuffix());
        HashMap<Symbol, Integer> idAndAttributeIndexMap = new HashMap<Symbol, Integer>();
        int idIndex = 0;
        for (Field field : fields) {
            TsTableColumnCategory category = field.getColumnCategory();
            Symbol symbol = this.symbolAllocator.newSymbol(field);
            outputSymbolsBuilder.add((Object)symbol);
            symbolToColumnSchema.put((Object)symbol, (Object)new ColumnSchema(field.getName().orElse(null), field.getType(), field.isHidden(), category));
            if (category != TsTableColumnCategory.TAG) continue;
            idAndAttributeIndexMap.put(symbol, idIndex++);
        }
        ImmutableList outputSymbols = outputSymbolsBuilder.build();
        ImmutableMap tableColumnSchema = symbolToColumnSchema.build();
        this.analysis.addTableSchema(qualifiedObjectName, (Map<Symbol, ColumnSchema>)tableColumnSchema);
        if (this.analysis.getTableHandle(table) instanceof TreeDeviceViewSchema) {
            TreeDeviceViewSchema treeDeviceViewSchema = (TreeDeviceViewSchema)this.analysis.getTableHandle(table);
            return new RelationPlan(new TreeDeviceViewScanNode(this.idAllocator.genPlanNodeId(), qualifiedObjectName, (List<Symbol>)outputSymbols, (Map<Symbol, ColumnSchema>)tableColumnSchema, idAndAttributeIndexMap, treeDeviceViewSchema.getTreeDBName(), treeDeviceViewSchema.getMeasurementColumnNameMap()), scope, (List<Symbol>)outputSymbols, this.outerContext);
        }
        TableScanNode tableScanNode = qualifiedObjectName.getDatabaseName().equals("information_schema") ? new InformationSchemaTableScanNode(this.idAllocator.genPlanNodeId(), qualifiedObjectName, (List<Symbol>)outputSymbols, (Map<Symbol, ColumnSchema>)tableColumnSchema) : new DeviceTableScanNode(this.idAllocator.genPlanNodeId(), qualifiedObjectName, (List<Symbol>)outputSymbols, (Map<Symbol, ColumnSchema>)tableColumnSchema, idAndAttributeIndexMap);
        return new RelationPlan(tableScanNode, scope, (List<Symbol>)outputSymbols, this.outerContext);
    }

    @Override
    protected RelationPlan visitQuerySpecification(QuerySpecification node, Void context) {
        return new QueryPlanner(this.analysis, this.symbolAllocator, this.queryContext, this.outerContext, this.sessionInfo, this.recursiveSubqueries).plan(node);
    }

    @Override
    protected RelationPlan visitNode(Node node, Void context) {
        throw new IllegalStateException("Unsupported node type: " + node.getClass().getName());
    }

    @Override
    protected RelationPlan visitTableSubquery(TableSubquery node, Void context) {
        RelationPlan plan = (RelationPlan)this.process(node.getQuery(), context);
        return new RelationPlan(plan.getRoot(), this.analysis.getScope(node), plan.getFieldMappings(), this.outerContext);
    }

    @Override
    protected RelationPlan visitJoin(Join node, Void context) {
        RelationPlan leftPlan = (RelationPlan)this.process(node.getLeft(), context);
        RelationPlan rightPlan = (RelationPlan)this.process(node.getRight(), context);
        if (node.getCriteria().isPresent() && node.getCriteria().get() instanceof JoinUsing) {
            return this.planJoinUsing(node, leftPlan, rightPlan);
        }
        return this.planJoin(this.analysis.getJoinCriteria(node), node.getType(), this.analysis.getScope(node), leftPlan, rightPlan, this.analysis.getSubqueries(node));
    }

    private RelationPlan planJoinUsing(Join node, RelationPlan left, RelationPlan right) {
        Symbol symbol;
        List<Identifier> joinColumns = ((JoinUsing)node.getCriteria().orElseThrow(() -> new IllegalStateException("JoinUsing criteria is empty"))).getColumns();
        Analysis.JoinUsingAnalysis joinAnalysis = this.analysis.getJoinUsing(node);
        ImmutableList.Builder clauses = ImmutableList.builder();
        HashMap<Identifier, Symbol> leftJoinColumns = new HashMap<Identifier, Symbol>();
        HashMap<Identifier, Symbol> rightJoinColumns = new HashMap<Identifier, Symbol>();
        Assignments.Builder leftCoercions = Assignments.builder();
        Assignments.Builder rightCoercions = Assignments.builder();
        leftCoercions.putIdentities(left.getRoot().getOutputSymbols());
        rightCoercions.putIdentities(right.getRoot().getOutputSymbols());
        for (int i = 0; i < joinColumns.size(); ++i) {
            Identifier identifier = joinColumns.get(i);
            Type type = this.analysis.getType(identifier);
            Symbol leftOutput = this.symbolAllocator.newSymbol(identifier, type);
            int leftField = joinAnalysis.getLeftJoinFields().get(i);
            leftCoercions.put(leftOutput, left.getSymbol(leftField).toSymbolReference());
            leftJoinColumns.put(identifier, leftOutput);
            Symbol rightOutput = this.symbolAllocator.newSymbol(identifier, type);
            int rightField = joinAnalysis.getRightJoinFields().get(i);
            rightCoercions.put(rightOutput, right.getSymbol(rightField).toSymbolReference());
            rightJoinColumns.put(identifier, rightOutput);
            clauses.add((Object)new JoinNode.EquiJoinClause(leftOutput, rightOutput));
        }
        ProjectNode leftCoercion = new ProjectNode(this.queryContext.getQueryId().genPlanNodeId(), left.getRoot(), leftCoercions.build());
        ProjectNode rightCoercion = new ProjectNode(this.queryContext.getQueryId().genPlanNodeId(), right.getRoot(), rightCoercions.build());
        JoinNode join = new JoinNode(this.queryContext.getQueryId().genPlanNodeId(), RelationPlanner.mapJoinType(node.getType()), leftCoercion, rightCoercion, (List<JoinNode.EquiJoinClause>)clauses.build(), leftCoercion.getOutputSymbols(), rightCoercion.getOutputSymbols(), Optional.empty(), Optional.empty());
        Assignments.Builder assignments = Assignments.builder();
        ImmutableList.Builder outputs = ImmutableList.builder();
        for (Identifier column : joinColumns) {
            Symbol output = this.symbolAllocator.newSymbol(column, this.analysis.getType(column));
            outputs.add((Object)output);
            if (node.getType() == Join.Type.INNER) {
                assignments.put(output, ((Symbol)leftJoinColumns.get(column)).toSymbolReference());
                continue;
            }
            if (node.getType() != Join.Type.FULL) continue;
            assignments.put(output, new CoalesceExpression(((Symbol)leftJoinColumns.get(column)).toSymbolReference(), ((Symbol)rightJoinColumns.get(column)).toSymbolReference(), new Expression[0]));
        }
        Iterator<Object> iterator = joinAnalysis.getOtherLeftFields().iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            symbol = left.getFieldMappings().get(field);
            outputs.add((Object)symbol);
            assignments.putIdentity(symbol);
        }
        iterator = joinAnalysis.getOtherRightFields().iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            symbol = right.getFieldMappings().get(field);
            outputs.add((Object)symbol);
            assignments.putIdentity(symbol);
        }
        return new RelationPlan(new ProjectNode(this.queryContext.getQueryId().genPlanNodeId(), join, assignments.build()), this.analysis.getScope(node), (List<Symbol>)outputs.build(), this.outerContext);
    }

    public RelationPlan planJoin(Expression criteria, Join.Type type, Scope scope, RelationPlan leftPlan, RelationPlan rightPlan, Analysis.SubqueryAnalysis subqueries) {
        RelationType left;
        ArrayList<Expression> postInnerJoinConditions;
        ArrayList<Expression> complexJoinExpressions;
        ImmutableList.Builder equiClauses;
        PlanBuilder rightPlanBuilder;
        PlanBuilder leftPlanBuilder;
        ImmutableList outputSymbols;
        block19: {
            outputSymbols = ImmutableList.builder().addAll(leftPlan.getFieldMappings()).addAll(rightPlan.getFieldMappings()).build();
            leftPlanBuilder = PlanBuilder.newPlanBuilder(leftPlan, this.analysis).withScope(scope, (List<Symbol>)outputSymbols);
            rightPlanBuilder = PlanBuilder.newPlanBuilder(rightPlan, this.analysis).withScope(scope, (List<Symbol>)outputSymbols);
            equiClauses = ImmutableList.builder();
            complexJoinExpressions = new ArrayList<Expression>();
            postInnerJoinConditions = new ArrayList<Expression>();
            left = leftPlan.getDescriptor();
            RelationType right = rightPlan.getDescriptor();
            if (type == Join.Type.CROSS || type == Join.Type.IMPLICIT) break block19;
            ArrayList<Expression> leftComparisonExpressions = new ArrayList<Expression>();
            ArrayList rightComparisonExpressions = new ArrayList();
            ArrayList<ComparisonExpression.Operator> joinConditionComparisonOperators = new ArrayList<ComparisonExpression.Operator>();
            for (Expression conjunct : IrUtils.extractPredicates(LogicalExpression.Operator.AND, criteria)) {
                block21: {
                    block20: {
                        if (!RelationPlanner.isEqualComparisonExpression(conjunct) && type != Join.Type.INNER) {
                            complexJoinExpressions.add(conjunct);
                            continue;
                        }
                        Set<QualifiedName> dependencies = SymbolsExtractor.extractNames(conjunct, this.analysis.getColumnReferences());
                        if (dependencies.stream().allMatch(left::canResolve)) break block20;
                        if (!dependencies.stream().allMatch(right::canResolve)) break block21;
                    }
                    complexJoinExpressions.add(conjunct);
                    continue;
                }
                if (conjunct instanceof ComparisonExpression) {
                    Expression firstExpression = ((ComparisonExpression)conjunct).getLeft();
                    Expression secondExpression = ((ComparisonExpression)conjunct).getRight();
                    ComparisonExpression.Operator comparisonOperator = ((ComparisonExpression)conjunct).getOperator();
                    Set<QualifiedName> firstDependencies = SymbolsExtractor.extractNames(firstExpression, this.analysis.getColumnReferences());
                    Set<QualifiedName> secondDependencies = SymbolsExtractor.extractNames(secondExpression, this.analysis.getColumnReferences());
                    if (firstDependencies.stream().allMatch(left::canResolve)) {
                        if (secondDependencies.stream().allMatch(right::canResolve)) {
                            leftComparisonExpressions.add(firstExpression);
                            rightComparisonExpressions.add(secondExpression);
                            joinConditionComparisonOperators.add(comparisonOperator);
                            continue;
                        }
                    }
                    if (firstDependencies.stream().allMatch(right::canResolve)) {
                        if (secondDependencies.stream().allMatch(left::canResolve)) {
                            leftComparisonExpressions.add(secondExpression);
                            rightComparisonExpressions.add(firstExpression);
                            joinConditionComparisonOperators.add(comparisonOperator.flip());
                            continue;
                        }
                    }
                    complexJoinExpressions.add(conjunct);
                    continue;
                }
                complexJoinExpressions.add(conjunct);
            }
            leftPlanBuilder = leftPlanBuilder.appendProjections(leftComparisonExpressions, this.symbolAllocator, this.queryContext);
            rightPlanBuilder = rightPlanBuilder.appendProjections(rightComparisonExpressions, this.symbolAllocator, this.queryContext);
            QueryPlanner.PlanAndMappings leftCoercions = QueryPlanner.coerce(leftPlanBuilder, leftComparisonExpressions, this.analysis, this.idAllocator, this.symbolAllocator);
            leftPlanBuilder = leftCoercions.getSubPlan();
            QueryPlanner.PlanAndMappings rightCoercions = QueryPlanner.coerce(rightPlanBuilder, rightComparisonExpressions, this.analysis, this.idAllocator, this.symbolAllocator);
            rightPlanBuilder = rightCoercions.getSubPlan();
            for (int i = 0; i < leftComparisonExpressions.size(); ++i) {
                if (joinConditionComparisonOperators.get(i) == ComparisonExpression.Operator.EQUAL) {
                    Symbol leftSymbol = leftCoercions.get((Expression)leftComparisonExpressions.get(i));
                    Symbol rightSymbol = rightCoercions.get((Expression)rightComparisonExpressions.get(i));
                    equiClauses.add((Object)new JoinNode.EquiJoinClause(leftSymbol, rightSymbol));
                    continue;
                }
                postInnerJoinConditions.add(new ComparisonExpression((ComparisonExpression.Operator)((Object)joinConditionComparisonOperators.get(i)), leftCoercions.get((Expression)leftComparisonExpressions.get(i)).toSymbolReference(), rightCoercions.get((Expression)rightComparisonExpressions.get(i)).toSymbolReference()));
            }
        }
        PlanNode root = new JoinNode(this.idAllocator.genPlanNodeId(), RelationPlanner.mapJoinType(type), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)equiClauses.build(), leftPlanBuilder.getRoot().getOutputSymbols(), rightPlanBuilder.getRoot().getOutputSymbols(), Optional.empty(), Optional.empty());
        if (type != Join.Type.INNER) {
            for (Expression complexExpression : complexJoinExpressions) {
                Set<QualifiedName> dependencies = SymbolsExtractor.extractNamesNoSubqueries(complexExpression, this.analysis.getColumnReferences());
                if (!dependencies.stream().allMatch(left::canResolve)) continue;
            }
        }
        TranslationMap translationMap = new TranslationMap(Optional.empty(), scope, this.analysis, (List<Symbol>)outputSymbols, new PlannerContext(new TableMetadataImpl(), new InternalTypeManager())).withAdditionalMappings(leftPlanBuilder.getTranslations().getMappings()).withAdditionalMappings(rightPlanBuilder.getTranslations().getMappings());
        if (type != Join.Type.INNER && !complexJoinExpressions.isEmpty()) {
            root = new JoinNode(this.idAllocator.genPlanNodeId(), RelationPlanner.mapJoinType(type), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)equiClauses.build(), leftPlanBuilder.getRoot().getOutputSymbols(), rightPlanBuilder.getRoot().getOutputSymbols(), Optional.of(IrUtils.and(complexJoinExpressions.stream().map(e -> QueryPlanner.coerceIfNecessary(this.analysis, e, translationMap.rewrite((Expression)e))).collect(Collectors.toList()))), Optional.empty());
        }
        if (type == Join.Type.INNER) {
            PlanBuilder rootPlanBuilder = new PlanBuilder(translationMap, root);
            for (Expression expression : complexJoinExpressions) {
                postInnerJoinConditions.add(QueryPlanner.coerceIfNecessary(this.analysis, expression, rootPlanBuilder.rewrite(expression)));
            }
            root = rootPlanBuilder.getRoot();
            if (!postInnerJoinConditions.isEmpty()) {
                Expression postInnerJoinCriteria = IrUtils.and(postInnerJoinConditions);
                root = new FilterNode(this.idAllocator.genPlanNodeId(), root, postInnerJoinCriteria);
            }
        }
        return new RelationPlan(root, scope, (List<Symbol>)outputSymbols, this.outerContext);
    }

    public static JoinNode.JoinType mapJoinType(Join.Type joinType) {
        switch (joinType) {
            case CROSS: 
            case IMPLICIT: 
            case INNER: {
                return JoinNode.JoinType.INNER;
            }
            case LEFT: {
                return JoinNode.JoinType.LEFT;
            }
            case RIGHT: {
                return JoinNode.JoinType.RIGHT;
            }
            case FULL: {
                return JoinNode.JoinType.FULL;
            }
        }
        throw new UnsupportedOperationException((Object)((Object)joinType) + " Join type is not supported");
    }

    private static boolean isEqualComparisonExpression(Expression conjunct) {
        return conjunct instanceof ComparisonExpression && ((ComparisonExpression)conjunct).getOperator() == ComparisonExpression.Operator.EQUAL;
    }

    @Override
    protected RelationPlan visitAliasedRelation(AliasedRelation node, Void context) {
        RelationPlan subPlan = (RelationPlan)this.process(node.getRelation(), context);
        PlanNode root = subPlan.getRoot();
        ImmutableList mappings = subPlan.getFieldMappings();
        if (node.getColumnNames() != null) {
            ImmutableList.Builder newMappings = ImmutableList.builder();
            for (int i = 0; i < subPlan.getDescriptor().getAllFieldCount(); ++i) {
                if (subPlan.getDescriptor().getFieldByIndex(i).isHidden()) continue;
                newMappings.add((Object)subPlan.getFieldMappings().get(i));
            }
            mappings = newMappings.build();
        }
        return new RelationPlan(root, this.analysis.getScope(node), (List<Symbol>)mappings, this.outerContext);
    }

    @Override
    protected RelationPlan visitSubqueryExpression(SubqueryExpression node, Void context) {
        return (RelationPlan)this.process(node.getQuery(), context);
    }

    @Override
    protected RelationPlan visitValues(Values node, Void context) {
        throw new IllegalStateException("Values is not supported in current version.");
    }

    @Override
    protected RelationPlan visitIntersect(Intersect node, Void context) {
        throw new IllegalStateException("Intersect is not supported in current version.");
    }

    @Override
    protected RelationPlan visitUnion(Union node, Void context) {
        throw new IllegalStateException("Union is not supported in current version.");
    }

    @Override
    protected RelationPlan visitExcept(Except node, Void context) {
        throw new IllegalStateException("Except is not supported in current version.");
    }

    @Override
    protected RelationPlan visitInsertTablet(InsertTablet node, Void context) {
        InsertTabletStatement insertTabletStatement = node.getInnerTreeStatement();
        RelationalInsertTabletNode insertNode = new RelationalInsertTabletNode(this.idAllocator.genPlanNodeId(), insertTabletStatement.getDevicePath(), insertTabletStatement.isAligned(), insertTabletStatement.getMeasurements(), insertTabletStatement.getDataTypes(), insertTabletStatement.getMeasurementSchemas(), insertTabletStatement.getTimes(), insertTabletStatement.getBitMaps(), insertTabletStatement.getColumns(), insertTabletStatement.getRowCount(), insertTabletStatement.getColumnCategories());
        insertNode.setFailedMeasurementNumber(insertTabletStatement.getFailedMeasurementNumber());
        if (insertTabletStatement.isSingleDevice()) {
            insertNode.setSingleDevice();
        }
        return new RelationPlan(insertNode, this.analysis.getRootScope(), Collections.emptyList(), this.outerContext);
    }

    @Override
    protected RelationPlan visitInsertRow(InsertRow node, Void context) {
        InsertRowStatement insertRowStatement = node.getInnerTreeStatement();
        RelationalInsertRowNode insertNode = this.fromInsertRowStatement(insertRowStatement);
        return new RelationPlan(insertNode, this.analysis.getRootScope(), Collections.emptyList(), this.outerContext);
    }

    protected RelationalInsertRowNode fromInsertRowStatement(InsertRowStatement insertRowStatement) {
        RelationalInsertRowNode insertNode = new RelationalInsertRowNode(this.idAllocator.genPlanNodeId(), insertRowStatement.getDevicePath(), insertRowStatement.isAligned(), insertRowStatement.getMeasurements(), insertRowStatement.getDataTypes(), insertRowStatement.getTime(), insertRowStatement.getValues(), insertRowStatement.isNeedInferType(), insertRowStatement.getColumnCategories());
        insertNode.setFailedMeasurementNumber(insertRowStatement.getFailedMeasurementNumber());
        insertNode.setMeasurementSchemas(insertRowStatement.getMeasurementSchemas());
        return insertNode;
    }

    @Override
    protected RelationPlan visitInsertRows(InsertRows node, Void context) {
        InsertRowsStatement insertRowsStatement = node.getInnerTreeStatement();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ArrayList<InsertRowNode> insertRowStatements = new ArrayList<InsertRowNode>();
        for (int i = 0; i < insertRowsStatement.getInsertRowStatementList().size(); ++i) {
            indices.add(i);
            insertRowStatements.add(this.fromInsertRowStatement(insertRowsStatement.getInsertRowStatementList().get(i)));
        }
        RelationalInsertRowsNode relationalInsertRowsNode = new RelationalInsertRowsNode(this.idAllocator.genPlanNodeId(), indices, insertRowStatements);
        return new RelationPlan(relationalInsertRowsNode, this.analysis.getRootScope(), Collections.emptyList(), this.outerContext);
    }

    @Override
    protected RelationPlan visitLoadTsFile(LoadTsFile node, Void context) {
        ArrayList<Boolean> isTableModel = new ArrayList<Boolean>();
        for (int i = 0; i < node.getResources().size(); ++i) {
            isTableModel.add(node.getModel().equals("table"));
        }
        return new RelationPlan(new LoadTsFileNode(this.idAllocator.genPlanNodeId(), node.getResources(), isTableModel, node.getDatabase()), this.analysis.getRootScope(), Collections.emptyList(), this.outerContext);
    }

    @Override
    protected RelationPlan visitPipeEnriched(PipeEnriched node, Void context) {
        RelationPlan relationPlan = node.getInnerStatement().accept(this, context);
        if (relationPlan.getRoot() instanceof LoadTsFileNode) {
            return relationPlan;
        }
        if (relationPlan.getRoot() instanceof InsertNode) {
            return new RelationPlan(new PipeEnrichedInsertNode((InsertNode)relationPlan.getRoot()), this.analysis.getRootScope(), Collections.emptyList(), this.outerContext);
        }
        throw new IllegalStateException("Other WritePlanNode is not supported in current version.");
    }

    @Override
    protected RelationPlan visitDelete(Delete node, Void context) {
        return new RelationPlan(new RelationalDeleteDataNode(this.idAllocator.genPlanNodeId(), node), this.analysis.getRootScope(), Collections.emptyList(), this.outerContext);
    }
}

